package fr.ird.observe.dto;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import fr.ird.observe.dto.reference.DataDtoReferenceSupport;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceSupport;
import fr.ird.observe.dto.referential.ReferentialDto;
import io.ultreia.java4all.http.ImmutableClassMapping;
import java.util.Objects;

/**
 * Created by tchemit on 18/07/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class DtoReferenceDefinitionsSupport {

    private ImmutableMap<String, DtoReferenceDefinition> data;
    private ImmutableMap<String, DtoReferenceDefinition> referential;
    private ImmutableSet<Class<? extends ReferentialDto>> referentialTypes;
    private ImmutableSet<Class<? extends DataDto>> dataTypes;
    private ImmutableClassMapping<IdDto, DtoReference> dtoToReferenceClassMapping;


    <D extends DataDto, R extends DataDtoReferenceSupport<D, R>> DtoReferenceDefinition<D, R> getDataDefinition(Class<D> type) {
        Objects.requireNonNull(type, "type can't be null");
        return getDataDefinition(type.getName());
    }

    <D extends DataDto, R extends DataDtoReferenceSupport<D, R>> DtoReferenceDefinition<D, R> getDataDefinition(String type) {
        Objects.requireNonNull(type, "type can't be null");
        type = type.replace("Dto", "").replace("Reference", "");
        DtoReferenceDefinition referenceDefinition = data.get(type);
        Objects.requireNonNull(referenceDefinition, "Can't find definition for " + type);
        //noinspection unchecked
        return referenceDefinition;
    }

    public <D extends ReferentialDto, R extends ReferentialDtoReferenceSupport<D, R>> DtoReferenceDefinition<D, R> getReferentialDefinition(Class<D> type) {
        Objects.requireNonNull(type, "type can't be null");
        return getReferentialDefinition(type.getName());
    }

    <D extends ReferentialDto, R extends ReferentialDtoReferenceSupport<D, R>> DtoReferenceDefinition<D, R> getReferentialDefinition(String type) {
        Objects.requireNonNull(type, "type can't be null");
        type = type.replace("Dto", "").replace("Reference", "");
        DtoReferenceDefinition referenceDefinition = referential.get(type);
        Objects.requireNonNull(referenceDefinition, "Can't find definition for " + type);
        //noinspection unchecked
        return referenceDefinition;
    }

    public ImmutableSet<Class<? extends ReferentialDto>> getReferentialTypes() {
        return referentialTypes;
    }

    ImmutableSet<Class<? extends DataDto>> getDataTypes() {
        return dataTypes;
    }

    public ImmutableClassMapping<IdDto, DtoReference> getDtoToReferenceClassMapping() {
        return dtoToReferenceClassMapping;
    }

    public ImmutableMap<String, DtoReferenceDefinition> getReferential() {
        return referential;
    }

    public void setData(ImmutableMap<String, DtoReferenceDefinition> data) {
        this.data = data;
    }

    public ImmutableMap<String, DtoReferenceDefinition> getData() {
        return data;
    }

    public void setReferential(ImmutableMap<String, DtoReferenceDefinition> referential) {
        this.referential = referential;
    }

    public void setReferentialTypes(ImmutableSet<Class<? extends ReferentialDto>> referentialTypes) {
        this.referentialTypes = referentialTypes;
    }

    public void setDataTypes(ImmutableSet<Class<? extends DataDto>> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public void setDtoToReferenceClassMapping(ImmutableClassMapping<IdDto, DtoReference> dtoToReferenceClassMapping) {
        this.dtoToReferenceClassMapping = dtoToReferenceClassMapping;
    }
}
