package fr.ird.observe.common;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.nuiton.config.ApplicationConfig;

/**
 * Pour mettre du code util commun.
 * <p>
 * Created on 01/09/16.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0
 */
public class ObserveUtil {

    public static Properties loadProperties(Properties sourceProperties, ApplicationConfig config) {

        Properties targetProperties = new Properties();
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String key = (String) entry.getKey();
            String value = (String) entry.getValue();
            String newValue = config.replaceRecursiveOptions(value);
            targetProperties.setProperty(key, newValue);
        }
        return targetProperties;
    }

    public static <C extends Class<?>> List<C> sortTypes(Collection<C> types, Function<Class, String> function, Locale locale) {

        List<C> list = new ArrayList<>(types);
        new ClassComparator<C>(function, locale).sort(list);
        return list;

    }

    private static class ClassComparator<C extends Class<?>> implements Comparator<C> {

        private final Map<Class, String> cache;
        private final Function<Class, String> function;

        private final Collator collator;

        private ClassComparator(Function<Class, String> function, Locale locale) {
            this.cache = new HashMap<>();
            this.function = function;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(Collator.PRIMARY);
        }

        @Override
        public int compare(Class o1, Class o2) {
            String s1 = getValue(o1);
            String s2 = getValue(o2);
            return this.collator.compare(s1, s2);
        }

        String getValue(Class klass) {
            return cache.computeIfAbsent(klass, k -> function.apply(klass));
        }

        public void sort(List<C> list) {
            list.sort(this);
            cache.clear();
        }
    }

}
