package fr.ird.observe.binder;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.IdHelper;
import fr.ird.observe.dto.constants.ReferentialLocale;
import fr.ird.observe.dto.reference.DtoReference;

/**
 * Created by tchemit on 28/08/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class DtoReferenceBinderSupport<D extends IdDto, R extends DtoReference<D, R>> {

    private final Class<D> dtoType;
    private final Class<R> referenceType;
    private final String key;

    public DtoReferenceBinderSupport(Class<D> dtoType, Class<R> referenceType) {
        this.dtoType = dtoType;
        this.referenceType = referenceType;
        this.key = IdHelper.cleanId(dtoType);
    }

    public static String generateBinderName(int defaultPackageNameLength, String binderPackageName, String fqn, String dtoName, boolean referential) {
        String relativeName = fqn.substring(defaultPackageNameLength);
        if (referential) {
            binderPackageName += ".referential.";
            if (relativeName.contains(".longline")) {
                return binderPackageName + "longline." + dtoName + "Binder";
            } else if (relativeName.contains(".seine")) {
                return binderPackageName + "seine." + dtoName + "Binder";
            } else {
                return binderPackageName + "common." + dtoName + "Binder";
            }
        } else {
            binderPackageName += ".data.";
            if (relativeName.startsWith("longline")) {
                return binderPackageName + "longline." + dtoName + "Binder";
            } else {
                return binderPackageName + "seine." + dtoName + "Binder";
            }
        }
    }

    public String getKey() {
        return key;
    }

    public Class<D> getDtoType() {
        return dtoType;
    }

    public Class<R> getReferenceType() {
        return referenceType;
    }

    public abstract R toReference(ReferentialLocale referentialLocale, D dto);

}
