/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.logging;

import fr.inria.gforge.spoon.logging.ReportBuilderImpl;
import fr.inria.gforge.spoon.logging.ReportDao;
import java.io.File;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ReportDaoImpl
implements ReportDao {
    private final File resultFile;

    ReportDaoImpl(File resultFile) {
        this.resultFile = resultFile;
    }

    @Override
    public void save(Map<ReportBuilderImpl.ReportKey, Object> reportsData) {
        try {
            if (!this.resultFile.getParentFile().exists()) {
                this.resultFile.getParentFile().mkdirs();
                this.resultFile.createNewFile();
            }
            this.report(reportsData);
        }
        catch (Exception e) {
            throw new RuntimeException("Error to save result of the plugin", e);
        }
    }

    private void report(Map<ReportBuilderImpl.ReportKey, Object> data) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory bFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = bFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = this.addRoot(doc, data);
        this.addProcessors(doc, root, data);
        this.addElement(doc, root, data, ReportBuilderImpl.ReportKey.INPUT, (String)data.get((Object)ReportBuilderImpl.ReportKey.INPUT));
        this.addElement(doc, root, data, ReportBuilderImpl.ReportKey.OUTPUT, (String)data.get((Object)ReportBuilderImpl.ReportKey.OUTPUT));
        this.addElement(doc, root, data, ReportBuilderImpl.ReportKey.SOURCE_CLASSPATH, (String)data.get((Object)ReportBuilderImpl.ReportKey.SOURCE_CLASSPATH));
        this.addElement(doc, root, data, ReportBuilderImpl.ReportKey.PERFORMANCE, Long.toString((Long)data.get((Object)ReportBuilderImpl.ReportKey.PERFORMANCE)));
        TransformerFactory transfFactory = TransformerFactory.newInstance();
        Transformer transformer = transfFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(this.resultFile.getAbsolutePath());
        transformer.transform(source, result);
    }

    private Element addRoot(Document document, Map<ReportBuilderImpl.ReportKey, Object> reportsData) {
        Element rootElement = document.createElement("project");
        if (reportsData.containsKey((Object)ReportBuilderImpl.ReportKey.PROJECT_NAME)) {
            rootElement.setAttribute("name", (String)reportsData.get((Object)ReportBuilderImpl.ReportKey.PROJECT_NAME));
        }
        document.appendChild(rootElement);
        return rootElement;
    }

    private Element addProcessors(Document document, Element root, Map<ReportBuilderImpl.ReportKey, Object> reportsData) {
        if (reportsData.containsKey((Object)ReportBuilderImpl.ReportKey.PROCESSORS)) {
            String[] tabProcessors;
            Element processors = document.createElement("processors");
            root.appendChild(processors);
            for (String processor : tabProcessors = (String[])reportsData.get((Object)ReportBuilderImpl.ReportKey.PROCESSORS)) {
                Element current = document.createElement("processor");
                current.appendChild(document.createTextNode(processor));
                processors.appendChild(current);
            }
            return processors;
        }
        return null;
    }

    private Element addElement(Document document, Element parent, Map<ReportBuilderImpl.ReportKey, Object> reportsData, ReportBuilderImpl.ReportKey key, String value) {
        if (reportsData.containsKey((Object)key)) {
            Element child = document.createElement(key.name().toLowerCase());
            child.appendChild(document.createTextNode(value));
            parent.appendChild(child);
            return child;
        }
        return null;
    }
}

