/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.configuration;

import fr.inria.gforge.spoon.SpoonMojoGenerate;
import fr.inria.gforge.spoon.configuration.SimpleSpoonConfiguration;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.configuration.XMLSpoonConfiguration;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.util.LogWrapper;
import fr.inria.gforge.spoon.util.XMLLoader;
import java.io.InputStream;

public final class SpoonConfigurationFactory {
    private static final String SPOON_CONFIGURATION_FILENAME = "spoon.xml";

    private SpoonConfigurationFactory() {
    }

    public static SpoonConfigurationBuilder getConfig(SpoonMojoGenerate spoon, ReportBuilder reportBuilder) throws Exception {
        InputStream in = SpoonMojoGenerate.class.getClassLoader().getResourceAsStream(SPOON_CONFIGURATION_FILENAME);
        if (in != null) {
            LogWrapper.info(spoon, "Generate spoon with a spoon.xml file.");
            return new XMLSpoonConfiguration(spoon, reportBuilder, XMLLoader.load(in));
        }
        LogWrapper.info(spoon, "Generate spoon without a spoon.xml file.");
        return new SimpleSpoonConfiguration(spoon, reportBuilder);
    }
}

