/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.configuration;

import fr.inria.gforge.spoon.Spoon;
import fr.inria.gforge.spoon.configuration.SimpleSpoonConfiguration;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.configuration.XMLSpoonConfiguration;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.util.XMLLoader;
import java.io.InputStream;

public final class SpoonConfigurationFactory {
    private static final String SPOON_CONFIGURATION_FILENAME = "spoon.xml";

    private SpoonConfigurationFactory() {
    }

    public static SpoonConfigurationBuilder getConfig(Spoon spoon, ReportBuilder reportBuilder) throws Exception {
        InputStream in = Spoon.class.getClassLoader().getResourceAsStream(SPOON_CONFIGURATION_FILENAME);
        if (in != null) {
            spoon.getLog().info((CharSequence)"Generate spoon with a spoon.xml file.");
            return new XMLSpoonConfiguration(spoon, reportBuilder, XMLLoader.load(in));
        }
        spoon.getLog().info((CharSequence)"Generate spoon without a spoon.xml file.");
        return new SimpleSpoonConfiguration(spoon, reportBuilder);
    }
}

