/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.configuration;

import fr.inria.gforge.spoon.Spoon;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

abstract class AbstractSpoonConfigurationBuilder
implements SpoonConfigurationBuilder {
    protected final List<String> parameters = new LinkedList<String>();
    protected final Spoon spoon;
    protected final ReportBuilder reportBuilder;

    protected AbstractSpoonConfigurationBuilder(Spoon spoon, ReportBuilder reportBuilder) {
        this.spoon = spoon;
        this.reportBuilder = reportBuilder;
        if (this.spoon.getLog().isInfoEnabled()) {
            this.parameters.add("-v");
        }
        if (this.spoon.getLog().isDebugEnabled()) {
            this.parameters.add("--vvv");
        }
    }

    @Override
    public SpoonConfigurationBuilder addInputFolder() {
        String srcDir = this.spoon.getProject().getBuild().getSourceDirectory();
        File srcDirFile = new File(srcDir);
        if (this.spoon.getSrcFolder() != null && this.spoon.getSrcFolder().exists()) {
            this.parameters.add("-i");
            this.parameters.add(this.spoon.getSrcFolder().getAbsolutePath());
            this.reportBuilder.setInput(this.spoon.getSrcFolder().getAbsolutePath());
            return this;
        }
        if (srcDirFile.exists()) {
            this.parameters.add("-i");
            this.parameters.add(srcDir);
            this.reportBuilder.setInput(srcDir);
            return this;
        }
        throw new RuntimeException("No source directory for " + this.spoon.getProject().getName() + " project.");
    }

    @Override
    public SpoonConfigurationBuilder addOutputFolder() {
        if (!this.spoon.getOutFolder().exists()) {
            this.spoon.getOutFolder().mkdirs();
        }
        this.parameters.add("-o");
        this.parameters.add(this.spoon.getOutFolder().getAbsolutePath());
        this.reportBuilder.setOutput(this.spoon.getOutFolder().getAbsolutePath());
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addCompliance() {
        this.parameters.add("--compliance");
        this.parameters.add("7");
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addSourceClasspath() {
        MavenProject project = this.spoon.getProject();
        List compileClasspath = null;
        try {
            compileClasspath = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            String errorMessage = "Cannot get compile classpath elements.";
            this.spoon.getLog().warn((CharSequence)"Cannot get compile classpath elements.");
            throw new RuntimeException("Cannot get compile classpath elements.", e);
        }
        if (compileClasspath.size() > 1) {
            StringBuilder classpath = new StringBuilder();
            for (int i = 1; i < compileClasspath.size(); ++i) {
                Object dependency = compileClasspath.get(i);
                this.spoon.getLog().info((CharSequence)("current dependency: " + dependency));
                classpath.append(dependency + System.getProperty("path.separator"));
            }
            this.spoon.getLog().info((CharSequence)("Source classpath: " + classpath.toString()));
            this.parameters.add("--source-classpath");
            this.parameters.add(classpath.toString());
            this.reportBuilder.setSourceClasspath(classpath.toString());
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addPreserveFormatting() {
        if (this.spoon.isPreserveFormatting()) {
            this.parameters.add("-f");
            this.reportBuilder.setFragmentMode(true);
        }
        this.reportBuilder.setFragmentMode(false);
        return this;
    }

    @Override
    public String[] build() {
        this.spoon.getLog().info((CharSequence)"Running spoon with parameters : ");
        this.spoon.getLog().info((CharSequence)this.parameters.toString());
        return this.parameters.toArray(new String[this.parameters.size()]);
    }

    protected String implode(String[] tabToConcatenate, String pathSeparator) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < tabToConcatenate.length; ++i) {
            buffer.append(tabToConcatenate[i]);
            if (i >= tabToConcatenate.length - 1) continue;
            buffer.append(pathSeparator);
        }
        return buffer.toString();
    }
}

