/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import fr.bmartel.protocol.http.HttpFrame;
import fr.bmartel.protocol.http.states.HttpStates;
import fr.bmartel.speedtest.RepeatWrapper;
import fr.bmartel.speedtest.SpeedTestConst;
import fr.bmartel.speedtest.SpeedTestReport;
import fr.bmartel.speedtest.inter.ISpeedTestListener;
import fr.bmartel.speedtest.inter.ISpeedTestSocket;
import fr.bmartel.speedtest.model.SpeedTestError;
import fr.bmartel.speedtest.model.SpeedTestMode;
import fr.bmartel.speedtest.model.UploadStorageType;
import fr.bmartel.speedtest.utils.RandomGen;
import fr.bmartel.speedtest.utils.SpeedTestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class SpeedTestTask {
    private String mHostname = "";
    private int mPort;
    private URL mProxyUrl;
    private Socket mSocket;
    private long mTimeStart;
    private long mTimeComputeStart;
    private long mTimeEnd;
    private int mUploadTempFileSize;
    private int mUlComputationTempFileSize;
    private int mDownloadTemporaryPacketSize;
    private int mDlComputationTempPacketSize;
    private BigDecimal mDownloadPckSize = BigDecimal.ZERO;
    private InputStream mFtpInputstream;
    private OutputStream mFtpOutputstream;
    private boolean mErrorDispatched;
    private boolean mForceCloseSocket;
    private BigDecimal mUploadFileSize = BigDecimal.ZERO;
    private final ISpeedTestSocket mSocketInterface;
    private final RepeatWrapper mRepeatWrapper;
    private final List<ISpeedTestListener> mListenerList;
    private boolean mReportInterval;
    private ExecutorService mReadExecutorService;
    private ExecutorService mWriteExecutorService;
    private ScheduledExecutorService mReportExecutorService;
    private SpeedTestMode mSpeedTestMode = SpeedTestMode.NONE;

    public SpeedTestTask(ISpeedTestSocket socketInterface, List<ISpeedTestListener> listenerList) {
        this.mSocketInterface = socketInterface;
        this.mRepeatWrapper = this.mSocketInterface.getRepeatWrapper();
        this.mListenerList = listenerList;
        this.initThreadPool();
    }

    private void initThreadPool() {
        this.mReadExecutorService = Executors.newSingleThreadExecutor();
        this.mReportExecutorService = Executors.newScheduledThreadPool(1);
        this.mWriteExecutorService = Executors.newSingleThreadExecutor();
    }

    public void setReportInterval(boolean state) {
        this.mReportInterval = state;
    }

    public boolean setProxy(String proxyUri) {
        try {
            this.mProxyUrl = proxyUri != null ? new URL(proxyUri) : null;
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public void startDownloadRequest(String uri) {
        this.mSpeedTestMode = SpeedTestMode.DOWNLOAD;
        this.mForceCloseSocket = false;
        this.mErrorDispatched = false;
        try {
            URL url = new URL(uri);
            switch (url.getProtocol()) {
                case "http": {
                    String downloadRequest;
                    if (this.mProxyUrl != null) {
                        this.mHostname = this.mProxyUrl.getHost();
                        this.mPort = this.mProxyUrl.getPort() != -1 ? this.mProxyUrl.getPort() : 8080;
                        downloadRequest = "GET " + uri + " HTTP/1.1\r\n" + "Host: " + url.getHost() + "\r\nProxy-Connection: Keep-Alive" + "\r\n\r\n";
                    } else {
                        this.mHostname = url.getHost();
                        this.mPort = url.getPort() != -1 ? url.getPort() : 80;
                        downloadRequest = "GET " + uri + " HTTP/1.1\r\n" + "Host: " + url.getHost() + "\r\n\r\n";
                    }
                    this.writeDownload(downloadRequest.getBytes());
                    break;
                }
                case "ftp": {
                    String userInfo = url.getUserInfo();
                    String user = "anonymous";
                    String pwd = "";
                    if (userInfo != null && userInfo.indexOf(58) != -1) {
                        user = userInfo.substring(0, userInfo.indexOf(58));
                        pwd = userInfo.substring(userInfo.indexOf(58) + 1);
                    }
                    this.startFtpDownload(uri, user, pwd);
                    break;
                }
                default: {
                    SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, SpeedTestError.UNSUPPORTED_PROTOCOL, "unsupported protocol");
                    break;
                }
            }
        }
        catch (MalformedURLException e) {
            SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, SpeedTestError.MALFORMED_URI, e.getMessage());
        }
    }

    public void startUploadRequest(String uri, int fileSizeOctet) {
        this.mSpeedTestMode = SpeedTestMode.UPLOAD;
        this.mForceCloseSocket = false;
        this.mErrorDispatched = false;
        try {
            URL url = new URL(uri);
            switch (url.getProtocol()) {
                case "http": {
                    this.writeUpload(uri, fileSizeOctet);
                    break;
                }
                case "ftp": {
                    this.startFtpUpload(uri, fileSizeOctet);
                    break;
                }
                default: {
                    SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, SpeedTestError.UNSUPPORTED_PROTOCOL, "unsupported protocol");
                    break;
                }
            }
        }
        catch (MalformedURLException e) {
            SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, SpeedTestError.MALFORMED_URI, e.getMessage());
        }
    }

    private void closeExecutors() {
        this.mReadExecutorService.shutdownNow();
        this.mReportExecutorService.shutdownNow();
        this.mWriteExecutorService.shutdownNow();
    }

    public void writeUpload(final String uri, final int fileSizeOctet) {
        try {
            final URL url = new URL(uri);
            if (this.mProxyUrl != null) {
                this.mHostname = this.mProxyUrl.getHost();
                this.mPort = this.mProxyUrl.getPort() != -1 ? this.mProxyUrl.getPort() : 8080;
            } else {
                this.mHostname = url.getHost();
                this.mPort = url.getPort() != -1 ? url.getPort() : 80;
            }
            this.mUploadFileSize = new BigDecimal(fileSizeOctet);
            this.mUploadTempFileSize = 0;
            this.mUlComputationTempFileSize = 0;
            this.mTimeStart = System.currentTimeMillis();
            this.mTimeComputeStart = System.currentTimeMillis();
            this.connectAndExecuteTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (SpeedTestTask.this.mSocket != null && !SpeedTestTask.this.mSocket.isClosed()) {
                        RandomAccessFile uploadFile = null;
                        RandomGen randomGen = new RandomGen();
                        try {
                            byte[] body = new byte[]{};
                            if (SpeedTestTask.this.mSocketInterface.getUploadStorageType() == UploadStorageType.RAM_STORAGE) {
                                body = randomGen.generateRandomArray(fileSizeOctet);
                            } else {
                                uploadFile = randomGen.generateRandomFile(fileSizeOctet);
                                uploadFile.seek(0L);
                            }
                            String head = SpeedTestTask.this.mProxyUrl != null ? "POST " + uri + " HTTP/1.1\r\n" + "Host: " + url.getHost() + "\r\nAccept: " + "*/*\r\nContent-Length: " + fileSizeOctet + "\r\nProxy-Connection: Keep-Alive" + "\r\n\r\n" : "POST " + uri + " HTTP/1.1\r\n" + "Host: " + url.getHost() + "\r\nAccept: " + "*/*\r\nContent-Length: " + fileSizeOctet + "\r\n\r\n";
                            SpeedTestTask.this.mUploadTempFileSize = 0;
                            SpeedTestTask.this.mUlComputationTempFileSize = 0;
                            int uploadChunkSize = SpeedTestTask.this.mSocketInterface.getUploadChunkSize();
                            int step = fileSizeOctet / uploadChunkSize;
                            int remain = fileSizeOctet % uploadChunkSize;
                            if (SpeedTestTask.this.mSocket.getOutputStream() != null) {
                                if (SpeedTestTask.this.writeFlushSocket(head.getBytes()) != 0) {
                                    throw new SocketTimeoutException();
                                }
                                SpeedTestTask.this.mTimeStart = System.currentTimeMillis();
                                SpeedTestTask.this.mTimeComputeStart = System.currentTimeMillis();
                                SpeedTestTask.this.mTimeEnd = 0L;
                                if (SpeedTestTask.this.mRepeatWrapper.isFirstUpload()) {
                                    SpeedTestTask.this.mRepeatWrapper.setFirstUploadRepeat(false);
                                    SpeedTestTask.this.mRepeatWrapper.setStartDate(SpeedTestTask.this.mTimeStart);
                                }
                                if (SpeedTestTask.this.mRepeatWrapper.isRepeatUpload()) {
                                    SpeedTestTask.this.mRepeatWrapper.updatePacketSize(SpeedTestTask.this.mUploadFileSize);
                                }
                                for (int i = 0; i < step; ++i) {
                                    byte[] chunk = SpeedTestUtils.readUploadData(SpeedTestTask.this.mSocketInterface.getUploadStorageType(), body, uploadFile, SpeedTestTask.this.mUploadTempFileSize, uploadChunkSize);
                                    if (SpeedTestTask.this.writeFlushSocket(chunk) != 0) {
                                        throw new SocketTimeoutException();
                                    }
                                    SpeedTestTask.this.mUploadTempFileSize = SpeedTestTask.this.mUploadTempFileSize + uploadChunkSize;
                                    SpeedTestTask.this.mUlComputationTempFileSize = SpeedTestTask.this.mUlComputationTempFileSize + uploadChunkSize;
                                    if (SpeedTestTask.this.mRepeatWrapper.isRepeatUpload()) {
                                        SpeedTestTask.this.mRepeatWrapper.updateTempPacketSize(uploadChunkSize);
                                    }
                                    if (SpeedTestTask.this.mReportInterval) continue;
                                    SpeedTestReport report = SpeedTestTask.this.getReport(SpeedTestMode.UPLOAD);
                                    for (int j = 0; j < SpeedTestTask.this.mListenerList.size(); ++j) {
                                        ((ISpeedTestListener)SpeedTestTask.this.mListenerList.get(j)).onProgress(report.getProgressPercent(), report);
                                    }
                                }
                                byte[] chunk = SpeedTestUtils.readUploadData(SpeedTestTask.this.mSocketInterface.getUploadStorageType(), body, uploadFile, SpeedTestTask.this.mUploadTempFileSize, remain);
                                if (remain != 0 && SpeedTestTask.this.writeFlushSocket(chunk) != 0) {
                                    throw new SocketTimeoutException();
                                }
                                SpeedTestTask.this.mUploadTempFileSize = SpeedTestTask.this.mUploadTempFileSize + remain;
                                SpeedTestTask.this.mUlComputationTempFileSize = SpeedTestTask.this.mUlComputationTempFileSize + remain;
                                if (SpeedTestTask.this.mRepeatWrapper.isRepeatUpload()) {
                                    SpeedTestTask.this.mRepeatWrapper.updateTempPacketSize(remain);
                                }
                                if (!SpeedTestTask.this.mReportInterval) {
                                    SpeedTestReport report = SpeedTestTask.this.getReport(SpeedTestMode.UPLOAD);
                                    for (int j = 0; j < SpeedTestTask.this.mListenerList.size(); ++j) {
                                        ((ISpeedTestListener)SpeedTestTask.this.mListenerList.get(j)).onProgress(SpeedTestConst.PERCENT_MAX.floatValue(), report);
                                    }
                                }
                            }
                        }
                        catch (SocketTimeoutException e) {
                            SpeedTestTask.this.mReportInterval = false;
                            SpeedTestTask.this.mErrorDispatched = true;
                            SpeedTestTask.this.closeSocket();
                            SpeedTestTask.this.closeExecutors();
                            if (!SpeedTestTask.this.mForceCloseSocket) {
                                SpeedTestUtils.dispatchSocketTimeout(SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, "Error occurred while writing to socket");
                            } else {
                                SpeedTestUtils.dispatchError(SpeedTestTask.this.mSocketInterface, SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, e.getMessage());
                            }
                        }
                        catch (IOException e) {
                            SpeedTestTask.this.mReportInterval = false;
                            SpeedTestTask.this.mErrorDispatched = true;
                            SpeedTestTask.this.closeExecutors();
                            SpeedTestUtils.dispatchError(SpeedTestTask.this.mSocketInterface, SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, e.getMessage());
                        }
                        finally {
                            if (uploadFile != null) {
                                try {
                                    uploadFile.close();
                                    randomGen.deleteFile();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
            }, false, fileSizeOctet);
        }
        catch (MalformedURLException e) {
            SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, SpeedTestError.MALFORMED_URI, e.getMessage());
        }
    }

    private void connectAndExecuteTask(final Runnable task, final boolean download, final int uploadSize) {
        block6: {
            if (this.mSocket != null) {
                this.closeSocket();
            }
            try {
                this.mSocket = new Socket();
                if (this.mSocketInterface.getSocketTimeout() != 0 && download) {
                    this.mSocket.setSoTimeout(this.mSocketInterface.getSocketTimeout());
                }
                this.mSocket.setReuseAddress(true);
                this.mSocket.setKeepAlive(true);
                this.mSocket.connect(new InetSocketAddress(this.mHostname, this.mPort));
                if (this.mReadExecutorService == null || this.mReadExecutorService.isShutdown()) {
                    this.mReadExecutorService = Executors.newSingleThreadExecutor();
                }
                this.mReadExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (download) {
                            SpeedTestTask.this.startSocketDownloadTask(SpeedTestTask.this.mHostname);
                        } else {
                            SpeedTestTask.this.startSocketUploadTask(SpeedTestTask.this.mHostname, uploadSize);
                        }
                    }
                });
                if (this.mWriteExecutorService == null || this.mWriteExecutorService.isShutdown()) {
                    this.mWriteExecutorService = Executors.newSingleThreadExecutor();
                }
                this.mWriteExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (task != null) {
                            task.run();
                        }
                    }
                });
            }
            catch (IOException e) {
                if (this.mErrorDispatched) break block6;
                SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, e.getMessage());
            }
        }
    }

    private void startSocketDownloadTask(String hostname) {
        this.mDownloadTemporaryPacketSize = 0;
        this.mDlComputationTempPacketSize = 0;
        try {
            HttpFrame httpFrame = new HttpFrame();
            this.mTimeStart = System.currentTimeMillis();
            this.mTimeComputeStart = System.currentTimeMillis();
            this.mTimeEnd = 0L;
            if (this.mRepeatWrapper.isFirstDownload()) {
                this.mRepeatWrapper.setFirstDownloadRepeat(false);
                this.mRepeatWrapper.setStartDate(this.mTimeStart);
            }
            HttpStates httFrameState = httpFrame.decodeFrame(this.mSocket.getInputStream());
            SpeedTestUtils.checkHttpFrameError(this.mForceCloseSocket, this.mListenerList, httFrameState);
            HttpStates httpHeaderState = httpFrame.parseHeader(this.mSocket.getInputStream());
            SpeedTestUtils.checkHttpHeaderError(this.mForceCloseSocket, this.mListenerList, httpHeaderState);
            if (httpFrame.getStatusCode() == 200 && httpFrame.getReasonPhrase().equalsIgnoreCase("ok")) {
                SpeedTestUtils.checkHttpContentLengthError(this.mForceCloseSocket, this.mListenerList, httpFrame);
                this.mDownloadPckSize = new BigDecimal(httpFrame.getContentLength());
                if (this.mRepeatWrapper.isRepeatDownload()) {
                    this.mRepeatWrapper.updatePacketSize(this.mDownloadPckSize);
                }
                this.downloadReadingLoop();
                this.mTimeEnd = System.currentTimeMillis();
                this.closeSocket();
                this.mReportInterval = false;
                if (!this.mRepeatWrapper.isRepeatDownload()) {
                    this.closeExecutors();
                }
                SpeedTestReport report = this.getReport(SpeedTestMode.DOWNLOAD);
                for (int i = 0; i < this.mListenerList.size(); ++i) {
                    this.mListenerList.get(i).onCompletion(report);
                }
            } else if ((httpFrame.getStatusCode() == 301 || httpFrame.getStatusCode() == 302 || httpFrame.getStatusCode() == 307) && httpFrame.getHeaders().containsKey("location")) {
                String location = (String)httpFrame.getHeaders().get("location");
                if (location.charAt(0) == '/') {
                    this.mReportInterval = false;
                    this.finishTask();
                    this.startDownloadRequest("http://" + hostname + location);
                } else if (location.startsWith("https")) {
                    this.mReportInterval = false;
                    for (int i = 0; i < this.mListenerList.size(); ++i) {
                        this.mListenerList.get(i).onError(SpeedTestError.UNSUPPORTED_PROTOCOL, "unsupported protocol : https");
                    }
                    this.finishTask();
                } else {
                    this.mReportInterval = false;
                    this.finishTask();
                    this.startDownloadRequest(location);
                }
            } else {
                this.mReportInterval = false;
                for (int i = 0; i < this.mListenerList.size(); ++i) {
                    this.mListenerList.get(i).onError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error status code " + httpFrame.getStatusCode());
                }
                this.finishTask();
            }
        }
        catch (SocketTimeoutException e) {
            this.mReportInterval = false;
            SpeedTestUtils.dispatchSocketTimeout(this.mForceCloseSocket, this.mListenerList, e.getMessage());
            this.mTimeEnd = System.currentTimeMillis();
            this.closeSocket();
            this.closeExecutors();
        }
        catch (IOException | InterruptedException e) {
            this.mReportInterval = false;
            this.catchError(e.getMessage());
        }
        this.mErrorDispatched = false;
    }

    private void finishTask() {
        this.closeSocket();
        if (!this.mRepeatWrapper.isRepeatDownload()) {
            this.closeExecutors();
        }
    }

    private void downloadReadingLoop() throws IOException {
        int read;
        byte[] buffer = new byte[65535];
        while ((read = this.mSocket.getInputStream().read(buffer)) != -1) {
            this.mDownloadTemporaryPacketSize += read;
            this.mDlComputationTempPacketSize += read;
            if (this.mRepeatWrapper.isRepeatDownload()) {
                this.mRepeatWrapper.updateTempPacketSize(read);
            }
            if (!this.mReportInterval) {
                SpeedTestReport report = this.getReport(SpeedTestMode.DOWNLOAD);
                for (int i = 0; i < this.mListenerList.size(); ++i) {
                    this.mListenerList.get(i).onProgress(report.getProgressPercent(), report);
                }
            }
            if ((long)this.mDownloadTemporaryPacketSize != this.mDownloadPckSize.longValueExact()) continue;
            break;
        }
    }

    private void startSocketUploadTask(String hostname, int size) {
        block16: {
            try {
                HttpFrame frame = new HttpFrame();
                HttpStates httpStates = frame.parseHttp(this.mSocket.getInputStream());
                if (httpStates == HttpStates.HTTP_FRAME_OK) {
                    if (frame.getStatusCode() == 200 && frame.getReasonPhrase().equalsIgnoreCase("ok")) {
                        this.mTimeEnd = System.currentTimeMillis();
                        this.mReportInterval = false;
                        this.finishTask();
                        SpeedTestReport report = this.getReport(SpeedTestMode.UPLOAD);
                        for (int i = 0; i < this.mListenerList.size(); ++i) {
                            this.mListenerList.get(i).onCompletion(report);
                        }
                    } else if ((frame.getStatusCode() == 301 || frame.getStatusCode() == 302 || frame.getStatusCode() == 307) && frame.getHeaders().containsKey("location")) {
                        String location = (String)frame.getHeaders().get("location");
                        if (location.charAt(0) == '/') {
                            this.mReportInterval = false;
                            this.finishTask();
                            this.startUploadRequest("http://" + hostname + location, size);
                        } else if (location.startsWith("https")) {
                            this.mReportInterval = false;
                            for (int i = 0; i < this.mListenerList.size(); ++i) {
                                this.mListenerList.get(i).onError(SpeedTestError.UNSUPPORTED_PROTOCOL, "unsupported protocol : https");
                            }
                            this.finishTask();
                        } else {
                            this.mReportInterval = false;
                            this.finishTask();
                            this.startUploadRequest(location, size);
                        }
                    } else {
                        this.mReportInterval = false;
                        for (int i = 0; i < this.mListenerList.size(); ++i) {
                            this.mListenerList.get(i).onError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error status code " + frame.getStatusCode());
                        }
                        this.finishTask();
                    }
                    return;
                }
                this.closeSocket();
                if (!this.mErrorDispatched && !this.mForceCloseSocket) {
                    for (int i = 0; i < this.mListenerList.size(); ++i) {
                        this.mListenerList.get(i).onError(SpeedTestError.SOCKET_ERROR, "mSocket error");
                    }
                }
                this.closeExecutors();
            }
            catch (IOException | InterruptedException e) {
                this.mReportInterval = false;
                if (this.mErrorDispatched) break block16;
                this.catchError(e.getMessage());
            }
        }
        this.mErrorDispatched = false;
    }

    private void writeDownload(final byte[] data) {
        this.connectAndExecuteTask(new Runnable(){

            @Override
            public void run() {
                if (SpeedTestTask.this.mSocket != null && !SpeedTestTask.this.mSocket.isClosed()) {
                    try {
                        if (SpeedTestTask.this.mSocket.getOutputStream() != null && SpeedTestTask.this.writeFlushSocket(data) != 0) {
                            throw new SocketTimeoutException();
                        }
                    }
                    catch (SocketTimeoutException e) {
                        SpeedTestUtils.dispatchSocketTimeout(SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, "Error occurred while writing to socket");
                        SpeedTestTask.this.closeSocket();
                        SpeedTestTask.this.closeExecutors();
                    }
                    catch (IOException e) {
                        SpeedTestUtils.dispatchError(SpeedTestTask.this.mSocketInterface, SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, e.getMessage());
                        SpeedTestTask.this.closeExecutors();
                    }
                }
            }
        }, true, 0);
    }

    private void disconnectFtp(FTPClient ftpclient) {
        try {
            if (ftpclient.isConnected()) {
                ftpclient.logout();
                ftpclient.disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int writeFlushSocket(final byte[] data) throws IOException {
        int status;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(new Callable(){

            public Integer call() {
                try {
                    SpeedTestTask.this.mSocket.getOutputStream().write(data);
                    SpeedTestTask.this.mSocket.getOutputStream().flush();
                }
                catch (IOException e) {
                    return -1;
                }
                return 0;
            }
        });
        try {
            status = (Integer)future.get(this.mSocketInterface.getSocketTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            status = -1;
        }
        catch (InterruptedException | ExecutionException e) {
            status = -1;
        }
        executor.shutdownNow();
        return status;
    }

    private void catchError(String errorMessage) {
        this.mTimeEnd = System.currentTimeMillis();
        this.closeSocket();
        this.closeExecutors();
        SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, errorMessage);
    }

    public SpeedTestReport getReport(SpeedTestMode mode) {
        SpeedTestReport report;
        BigDecimal temporaryPacketSize = BigDecimal.ZERO;
        BigDecimal totalPacketSize = BigDecimal.ZERO;
        switch (mode) {
            case DOWNLOAD: {
                temporaryPacketSize = new BigDecimal(this.mDownloadTemporaryPacketSize);
                totalPacketSize = this.mDownloadPckSize;
                break;
            }
            case UPLOAD: {
                temporaryPacketSize = new BigDecimal(this.mUploadTempFileSize);
                totalPacketSize = this.mUploadFileSize;
                break;
            }
        }
        long currentTime = this.mTimeEnd == 0L ? System.currentTimeMillis() : this.mTimeEnd;
        BigDecimal transferRateOps = BigDecimal.ZERO;
        int scale = this.mSocketInterface.getDefaultScale();
        RoundingMode roundingMode = this.mSocketInterface.getDefaultRoundingMode();
        switch (this.mSocketInterface.getComputationMethod()) {
            case MEDIAN_ALL_TIME: {
                if (!this.shallCalculateTransferRate(currentTime) || currentTime - this.mTimeStart == 0L) break;
                transferRateOps = temporaryPacketSize.divide(new BigDecimal(currentTime - this.mTimeStart).divide(SpeedTestConst.MILLIS_DIVIDER, scale, roundingMode), scale, roundingMode);
                break;
            }
            case MEDIAN_INTERVAL: {
                BigDecimal tempPacket;
                BigDecimal bigDecimal = tempPacket = mode == SpeedTestMode.DOWNLOAD ? new BigDecimal(this.mDlComputationTempPacketSize) : new BigDecimal(this.mUlComputationTempFileSize);
                if (this.shallCalculateTransferRate(currentTime) && currentTime - this.mTimeComputeStart != 0L) {
                    transferRateOps = tempPacket.divide(new BigDecimal(currentTime - this.mTimeComputeStart).divide(SpeedTestConst.MILLIS_DIVIDER, scale, roundingMode), scale, roundingMode);
                }
                this.mDlComputationTempPacketSize = 0;
                this.mUlComputationTempFileSize = 0;
                this.mTimeComputeStart = System.currentTimeMillis();
                break;
            }
        }
        BigDecimal transferRateBitps = transferRateOps.multiply(SpeedTestConst.BIT_MULTIPLIER);
        BigDecimal percent = BigDecimal.ZERO;
        if (this.mRepeatWrapper.isRepeat()) {
            report = this.mRepeatWrapper.getRepeatReport(scale, roundingMode, mode, currentTime, transferRateOps);
        } else {
            if (totalPacketSize.compareTo(BigDecimal.ZERO) != 0) {
                percent = temporaryPacketSize.multiply(SpeedTestConst.PERCENT_MAX).divide(totalPacketSize, scale, roundingMode);
            }
            report = new SpeedTestReport(mode, percent.floatValue(), this.mTimeStart, currentTime, temporaryPacketSize.longValueExact(), totalPacketSize.longValueExact(), transferRateOps, transferRateBitps, 1);
        }
        return report;
    }

    private boolean shallCalculateTransferRate(long currentTime) {
        long elapsedTime = currentTime - this.mTimeStart;
        boolean ret = true;
        switch (this.mSpeedTestMode) {
            case DOWNLOAD: {
                ret = elapsedTime > this.mSocketInterface.getDownloadSetupTime();
                break;
            }
            case UPLOAD: {
                ret = elapsedTime > this.mSocketInterface.getUploadSetupTime();
                break;
            }
        }
        return ret;
    }

    private long getFileSize(FTPClient ftpClient, String filePath) throws IOException {
        long fileSize = 0L;
        FTPFile[] files = ftpClient.listFiles(filePath);
        if (files.length == 1 && files[0].isFile()) {
            fileSize = files[0].getSize();
        }
        return fileSize;
    }

    public void startFtpDownload(final String uri, final String user, final String password) {
        this.mSpeedTestMode = SpeedTestMode.DOWNLOAD;
        try {
            final URL url = new URL(uri);
            this.mErrorDispatched = false;
            this.mForceCloseSocket = false;
            if (this.mReadExecutorService == null || this.mReadExecutorService.isShutdown()) {
                this.mReadExecutorService = Executors.newSingleThreadExecutor();
            }
            this.mReadExecutorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FTPClient ftpclient = new FTPClient();
                    try {
                        ftpclient.connect(url.getHost(), url.getPort() != -1 ? url.getPort() : 21);
                        ftpclient.login(user, password);
                        ftpclient.enterLocalPassiveMode();
                        ftpclient.setFileType(2);
                        SpeedTestTask.this.mDownloadTemporaryPacketSize = 0;
                        SpeedTestTask.this.mDlComputationTempPacketSize = 0;
                        SpeedTestTask.this.mTimeStart = System.currentTimeMillis();
                        SpeedTestTask.this.mTimeComputeStart = System.currentTimeMillis();
                        SpeedTestTask.this.mTimeEnd = 0L;
                        if (SpeedTestTask.this.mRepeatWrapper.isFirstDownload()) {
                            SpeedTestTask.this.mRepeatWrapper.setFirstDownloadRepeat(false);
                            SpeedTestTask.this.mRepeatWrapper.setStartDate(SpeedTestTask.this.mTimeStart);
                        }
                        SpeedTestTask.this.mDownloadPckSize = new BigDecimal(SpeedTestTask.this.getFileSize(ftpclient, url.getPath()));
                        if (SpeedTestTask.this.mRepeatWrapper.isRepeatDownload()) {
                            SpeedTestTask.this.mRepeatWrapper.updatePacketSize(SpeedTestTask.this.mDownloadPckSize);
                        }
                        SpeedTestTask.this.mFtpInputstream = ftpclient.retrieveFileStream(url.getPath());
                        if (SpeedTestTask.this.mFtpInputstream != null) {
                            int i;
                            SpeedTestReport report;
                            int read;
                            byte[] bytesArray = new byte[65535];
                            while ((read = SpeedTestTask.this.mFtpInputstream.read(bytesArray)) != -1) {
                                SpeedTestTask.this.mDownloadTemporaryPacketSize = SpeedTestTask.this.mDownloadTemporaryPacketSize + read;
                                SpeedTestTask.this.mDlComputationTempPacketSize = SpeedTestTask.this.mDlComputationTempPacketSize + read;
                                if (SpeedTestTask.this.mRepeatWrapper.isRepeatDownload()) {
                                    SpeedTestTask.this.mRepeatWrapper.updateTempPacketSize(read);
                                }
                                if (!SpeedTestTask.this.mReportInterval) {
                                    report = SpeedTestTask.this.getReport(SpeedTestMode.DOWNLOAD);
                                    for (i = 0; i < SpeedTestTask.this.mListenerList.size(); ++i) {
                                        ((ISpeedTestListener)SpeedTestTask.this.mListenerList.get(i)).onProgress(report.getProgressPercent(), report);
                                    }
                                }
                                if ((long)SpeedTestTask.this.mDownloadTemporaryPacketSize != SpeedTestTask.this.mDownloadPckSize.longValueExact()) continue;
                            }
                            SpeedTestTask.this.mFtpInputstream.close();
                            SpeedTestTask.this.mTimeEnd = System.currentTimeMillis();
                            SpeedTestTask.this.mReportInterval = false;
                            report = SpeedTestTask.this.getReport(SpeedTestMode.DOWNLOAD);
                            for (i = 0; i < SpeedTestTask.this.mListenerList.size(); ++i) {
                                ((ISpeedTestListener)SpeedTestTask.this.mListenerList.get(i)).onCompletion(report);
                            }
                        } else {
                            SpeedTestTask.this.mReportInterval = false;
                            SpeedTestUtils.dispatchError(SpeedTestTask.this.mSocketInterface, SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, "cant create stream from uri " + uri + " with reply code : " + ftpclient.getReplyCode());
                        }
                        if (!SpeedTestTask.this.mRepeatWrapper.isRepeatDownload()) {
                            SpeedTestTask.this.closeExecutors();
                        }
                    }
                    catch (IOException e) {
                        SpeedTestTask.this.mReportInterval = false;
                        SpeedTestTask.this.catchError(e.getMessage());
                    }
                    finally {
                        SpeedTestTask.this.mErrorDispatched = false;
                        SpeedTestTask.this.disconnectFtp(ftpclient);
                    }
                }
            });
        }
        catch (MalformedURLException e) {
            SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, SpeedTestError.MALFORMED_URI, e.getMessage());
        }
    }

    public void startFtpUpload(final String uri, final int fileSizeOctet) {
        this.mSpeedTestMode = SpeedTestMode.UPLOAD;
        this.mUploadFileSize = new BigDecimal(fileSizeOctet);
        this.mForceCloseSocket = false;
        this.mErrorDispatched = false;
        try {
            final URL url = new URL(uri);
            String userInfo = url.getUserInfo();
            String user = "anonymous";
            String pwd = "";
            if (userInfo != null && userInfo.indexOf(58) != -1) {
                user = userInfo.substring(0, userInfo.indexOf(58));
                pwd = userInfo.substring(userInfo.indexOf(58) + 1);
            }
            if (this.mWriteExecutorService == null || this.mWriteExecutorService.isShutdown()) {
                this.mWriteExecutorService = Executors.newSingleThreadExecutor();
            }
            final String finalUser = user;
            final String finalPwd = pwd;
            this.mWriteExecutorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FTPClient ftpClient = new FTPClient();
                    RandomGen randomGen = new RandomGen();
                    RandomAccessFile uploadFile = null;
                    try {
                        ftpClient.connect(url.getHost(), url.getPort() != -1 ? url.getPort() : 21);
                        ftpClient.login(finalUser, finalPwd);
                        ftpClient.enterLocalPassiveMode();
                        ftpClient.setFileType(2);
                        byte[] fileContent = new byte[]{};
                        if (SpeedTestTask.this.mSocketInterface.getUploadStorageType() == UploadStorageType.RAM_STORAGE) {
                            fileContent = randomGen.generateRandomArray(fileSizeOctet);
                        } else {
                            uploadFile = randomGen.generateRandomFile(fileSizeOctet);
                            uploadFile.seek(0L);
                        }
                        SpeedTestTask.this.mFtpOutputstream = ftpClient.storeFileStream(url.getPath());
                        if (SpeedTestTask.this.mFtpOutputstream != null) {
                            SpeedTestTask.this.mUploadTempFileSize = 0;
                            SpeedTestTask.this.mUlComputationTempFileSize = 0;
                            int uploadChunkSize = SpeedTestTask.this.mSocketInterface.getUploadChunkSize();
                            int step = fileSizeOctet / uploadChunkSize;
                            int remain = fileSizeOctet % uploadChunkSize;
                            SpeedTestTask.this.mTimeStart = System.currentTimeMillis();
                            SpeedTestTask.this.mTimeComputeStart = System.currentTimeMillis();
                            SpeedTestTask.this.mTimeEnd = 0L;
                            if (SpeedTestTask.this.mRepeatWrapper.isFirstUpload()) {
                                SpeedTestTask.this.mRepeatWrapper.setFirstUploadRepeat(false);
                                SpeedTestTask.this.mRepeatWrapper.setStartDate(SpeedTestTask.this.mTimeStart);
                            }
                            if (SpeedTestTask.this.mRepeatWrapper.isRepeatUpload()) {
                                SpeedTestTask.this.mRepeatWrapper.updatePacketSize(SpeedTestTask.this.mUploadFileSize);
                            }
                            if (SpeedTestTask.this.mForceCloseSocket) {
                                SpeedTestTask.this.mFtpOutputstream.close();
                                SpeedTestTask.this.mReportInterval = false;
                                if (!SpeedTestTask.this.mRepeatWrapper.isRepeatUpload()) {
                                    SpeedTestTask.this.closeExecutors();
                                }
                                SpeedTestUtils.dispatchError(SpeedTestTask.this.mSocketInterface, SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, "");
                            } else {
                                for (int i = 0; i < step; ++i) {
                                    byte[] chunk = SpeedTestUtils.readUploadData(SpeedTestTask.this.mSocketInterface.getUploadStorageType(), fileContent, uploadFile, SpeedTestTask.this.mUploadTempFileSize, uploadChunkSize);
                                    SpeedTestTask.this.mFtpOutputstream.write(chunk, 0, uploadChunkSize);
                                    SpeedTestTask.this.mUploadTempFileSize = SpeedTestTask.this.mUploadTempFileSize + uploadChunkSize;
                                    SpeedTestTask.this.mUlComputationTempFileSize = SpeedTestTask.this.mUlComputationTempFileSize + uploadChunkSize;
                                    if (SpeedTestTask.this.mRepeatWrapper.isRepeatUpload()) {
                                        SpeedTestTask.this.mRepeatWrapper.updateTempPacketSize(uploadChunkSize);
                                    }
                                    if (SpeedTestTask.this.mReportInterval) continue;
                                    SpeedTestReport report = SpeedTestTask.this.getReport(SpeedTestMode.UPLOAD);
                                    for (int j = 0; j < SpeedTestTask.this.mListenerList.size(); ++j) {
                                        ((ISpeedTestListener)SpeedTestTask.this.mListenerList.get(j)).onProgress(report.getProgressPercent(), report);
                                    }
                                }
                                if (remain != 0) {
                                    byte[] chunk = SpeedTestUtils.readUploadData(SpeedTestTask.this.mSocketInterface.getUploadStorageType(), fileContent, uploadFile, SpeedTestTask.this.mUploadTempFileSize, remain);
                                    SpeedTestTask.this.mFtpOutputstream.write(chunk, 0, remain);
                                    SpeedTestTask.this.mUploadTempFileSize = SpeedTestTask.this.mUploadTempFileSize + remain;
                                    SpeedTestTask.this.mUlComputationTempFileSize = SpeedTestTask.this.mUlComputationTempFileSize + remain;
                                    if (SpeedTestTask.this.mRepeatWrapper.isRepeatUpload()) {
                                        SpeedTestTask.this.mRepeatWrapper.updateTempPacketSize(remain);
                                    }
                                }
                                if (!SpeedTestTask.this.mReportInterval) {
                                    SpeedTestReport report = SpeedTestTask.this.getReport(SpeedTestMode.UPLOAD);
                                    for (int j = 0; j < SpeedTestTask.this.mListenerList.size(); ++j) {
                                        ((ISpeedTestListener)SpeedTestTask.this.mListenerList.get(j)).onProgress(SpeedTestConst.PERCENT_MAX.floatValue(), report);
                                    }
                                }
                                SpeedTestTask.this.mTimeEnd = System.currentTimeMillis();
                                SpeedTestTask.this.mFtpOutputstream.close();
                                SpeedTestTask.this.mReportInterval = false;
                                if (!SpeedTestTask.this.mRepeatWrapper.isRepeatUpload()) {
                                    SpeedTestTask.this.closeExecutors();
                                }
                                SpeedTestReport report = SpeedTestTask.this.getReport(SpeedTestMode.UPLOAD);
                                for (int i = 0; i < SpeedTestTask.this.mListenerList.size(); ++i) {
                                    ((ISpeedTestListener)SpeedTestTask.this.mListenerList.get(i)).onCompletion(report);
                                }
                            }
                        } else {
                            SpeedTestTask.this.mReportInterval = false;
                            SpeedTestUtils.dispatchError(SpeedTestTask.this.mSocketInterface, SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, "cant create stream from uri " + uri + " with reply code : " + ftpClient.getReplyCode());
                        }
                    }
                    catch (SocketTimeoutException e) {
                        SpeedTestTask.this.mReportInterval = false;
                        SpeedTestTask.this.mErrorDispatched = true;
                        if (!SpeedTestTask.this.mForceCloseSocket) {
                            SpeedTestUtils.dispatchSocketTimeout(SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, "Error occurred while writing to socket");
                        } else {
                            SpeedTestUtils.dispatchError(SpeedTestTask.this.mSocketInterface, SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, e.getMessage());
                        }
                        SpeedTestTask.this.closeSocket();
                        SpeedTestTask.this.closeExecutors();
                    }
                    catch (IOException e) {
                        SpeedTestTask.this.mReportInterval = false;
                        SpeedTestTask.this.mErrorDispatched = true;
                        SpeedTestUtils.dispatchError(SpeedTestTask.this.mSocketInterface, SpeedTestTask.this.mForceCloseSocket, SpeedTestTask.this.mListenerList, e.getMessage());
                        SpeedTestTask.this.closeExecutors();
                    }
                    finally {
                        SpeedTestTask.this.mErrorDispatched = false;
                        SpeedTestTask.this.disconnectFtp(ftpClient);
                        if (uploadFile != null) {
                            try {
                                uploadFile.close();
                                randomGen.deleteFile();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            });
        }
        catch (MalformedURLException e) {
            SpeedTestUtils.dispatchError(this.mSocketInterface, this.mForceCloseSocket, this.mListenerList, SpeedTestError.MALFORMED_URI, e.getMessage());
        }
    }

    public void closeSocket() {
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void forceStopTask() {
        this.mForceCloseSocket = true;
        if (this.mFtpInputstream != null) {
            try {
                this.mFtpInputstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mFtpOutputstream != null) {
            try {
                this.mFtpOutputstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void shutdownAndWait() {
        this.closeExecutors();
        try {
            this.mReadExecutorService.awaitTermination(500L, TimeUnit.MILLISECONDS);
            this.mWriteExecutorService.awaitTermination(500L, TimeUnit.MILLISECONDS);
            this.mReportExecutorService.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void renewReportThreadPool() {
        if (this.mReportExecutorService == null || this.mReportExecutorService.isShutdown()) {
            this.mReportExecutorService = Executors.newScheduledThreadPool(1);
        }
    }

    public ScheduledExecutorService getReportThreadPool() {
        return this.mReportExecutorService;
    }

    public boolean isReportInterval() {
        return this.mReportInterval;
    }

    public SpeedTestMode getSpeedTestMode() {
        return this.mSpeedTestMode;
    }
}

