/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.protocol.http.utils;

import fr.bmartel.protocol.http.utils.IByteList;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ListOfBytes
implements IByteList {
    public static final int BLOCK_SIZE = 4095;
    private List<byte[]> classicList = new ArrayList<byte[]>();

    public ListOfBytes() {
    }

    public ListOfBytes(String data) {
        try {
            byte[] dataConvertedToByte = data.getBytes("UTF-8");
            int length = dataConvertedToByte.length;
            if (length > 0) {
                int numberOfBlockToWrite = length % 4095;
                int numberOfBlock = 0;
                numberOfBlock = numberOfBlockToWrite == 0 ? length / 4095 : length / 4095 + 1;
                for (int i = 0; i < numberOfBlock; ++i) {
                    if (i == numberOfBlock - 1) {
                        int size = length - i * 4095;
                        byte[] data1 = new byte[size];
                        System.arraycopy(dataConvertedToByte, i * 4095, data1, 0, size);
                        this.classicList.add(data1);
                        continue;
                    }
                    byte[] data1 = new byte[4095];
                    System.arraycopy(dataConvertedToByte, i * 4095, data1, 0, 4095);
                    this.classicList.add(data1);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] getBytes() {
        int size = 0;
        for (int i = 0; i < this.classicList.size(); ++i) {
            size += this.classicList.get(i).length;
        }
        byte[] ret = new byte[size];
        int tempSize = 0;
        for (int i = 0; i < this.classicList.size(); ++i) {
            System.arraycopy(this.classicList.get(i), 0, ret, tempSize, this.classicList.get(i).length);
            tempSize += this.classicList.get(i).length;
        }
        return ret;
    }

    @Override
    public int add(byte[] data) {
        this.classicList.add(data);
        return this.classicList.size() - 1;
    }

    @Override
    public int getSize() {
        return this.classicList.size();
    }

    public List<byte[]> getList() {
        return this.classicList;
    }

    @Override
    public byte[] get(int index) {
        if (index > 0 && index <= this.classicList.size() - 1) {
            return this.classicList.get(index);
        }
        return null;
    }
}

