/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeySet;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.SessionKeyProvider;
import pro.javacard.gp.TLVUtils;

public class PlaintextKeys
implements SessionKeyProvider {
    private Logger logger = LoggerFactory.getLogger(PlaintextKeys.class);
    private final GPKeySet staticKeys;
    final GPKeySet.Diversification diversifier;
    protected GPKeySet.GPKey master;

    private PlaintextKeys(GPKeySet keys, GPKeySet.Diversification div) {
        this.staticKeys = keys;
        this.diversifier = div;
        this.logger.debug("static keys: {}", (Object)this.staticKeys.toString());
    }

    @Override
    public GPKeySet getSessionKeys(int scp, byte[] kdd, byte[] ... args) throws GPException {
        GPKeySet sessionKeys;
        GPKeySet cardKeys = this.staticKeys;
        if (this.diversifier != GPKeySet.Diversification.NONE) {
            cardKeys = PlaintextKeys.diversify(this.staticKeys, kdd, this.diversifier, scp);
            this.logger.debug("card keys: {}", (Object)cardKeys.toString());
        }
        if (scp == 1) {
            if (args.length != 2) {
                throw new IllegalArgumentException("SCP01 requires host challenge and card challenge");
            }
            sessionKeys = this.deriveSessionKeysSCP01(cardKeys, args[0], args[1]);
        } else if (scp == 2) {
            if (args.length != 1) {
                throw new IllegalArgumentException("SCP02 requires sequence");
            }
            sessionKeys = this.deriveSessionKeysSCP02(cardKeys, args[0], false);
        } else if (scp == 3) {
            if (args.length != 2) {
                throw new IllegalArgumentException("SCP03 requires host challenge and card challenge");
            }
            sessionKeys = this.deriveSessionKeysSCP03(cardKeys, args[0], args[1]);
        } else {
            throw new IllegalArgumentException("Dont know how to handle: " + scp);
        }
        this.logger.debug("session keys: {}", (Object)sessionKeys.toString());
        return sessionKeys;
    }

    public static GPKeySet diversify(GPKeySet keys, byte[] diversification_data, GPKeySet.Diversification mode, int scp) throws GPException {
        try {
            GPKeySet result = new GPKeySet();
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            for (GPData.KeyType v : GPData.KeyType.values()) {
                if (v == GPData.KeyType.RMAC) continue;
                byte[] kv = null;
                if (mode == GPKeySet.Diversification.VISA2) {
                    kv = PlaintextKeys.fillVisa(diversification_data, v);
                } else if (mode == GPKeySet.Diversification.EMV) {
                    kv = PlaintextKeys.fillEmv(diversification_data, v);
                }
                cipher.init(1, keys.getKey(v).getKey(GPKeySet.GPKey.Type.DES3));
                byte[] keybytes = cipher.doFinal(kv);
                GPKeySet.GPKey nk = new GPKeySet.GPKey(keybytes, scp == 3 ? GPKeySet.GPKey.Type.AES : GPKeySet.GPKey.Type.DES3);
                result.setKey(v, nk);
            }
            return result;
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new GPException("Diversification failed.", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Diversification failed.", e);
        }
    }

    public static byte[] fillVisa(byte[] init_update_response, GPData.KeyType key) {
        byte[] data = new byte[16];
        System.arraycopy(init_update_response, 0, data, 0, 2);
        System.arraycopy(init_update_response, 4, data, 2, 4);
        data[6] = -16;
        data[7] = key.getValue();
        System.arraycopy(init_update_response, 0, data, 8, 2);
        System.arraycopy(init_update_response, 4, data, 10, 4);
        data[14] = 15;
        data[15] = key.getValue();
        return data;
    }

    public static byte[] fillVisa2(byte[] init_update_response, GPData.KeyType key) {
        byte[] data = new byte[16];
        System.arraycopy(init_update_response, 0, data, 0, 4);
        System.arraycopy(init_update_response, 8, data, 4, 2);
        data[6] = -16;
        data[7] = 1;
        System.arraycopy(init_update_response, 0, data, 8, 4);
        System.arraycopy(init_update_response, 8, data, 12, 2);
        data[14] = 15;
        data[15] = 1;
        return data;
    }

    public static byte[] fillEmv(byte[] init_update_response, GPData.KeyType key) {
        byte[] data = new byte[16];
        System.arraycopy(init_update_response, 4, data, 0, 6);
        data[6] = -16;
        data[7] = key.getValue();
        System.arraycopy(init_update_response, 4, data, 8, 6);
        data[14] = 15;
        data[15] = key.getValue();
        return data;
    }

    public static PlaintextKeys fromMasterKey(GPKeySet.GPKey master, GPKeySet.Diversification div) {
        GPKeySet ks = new GPKeySet(master);
        PlaintextKeys p = new PlaintextKeys(ks, div);
        p.master = master;
        return p;
    }

    public static PlaintextKeys fromMasterKey(GPKeySet.GPKey master) {
        return PlaintextKeys.fromMasterKey(master, GPKeySet.Diversification.NONE);
    }

    public static PlaintextKeys fromKeySet(GPKeySet ks) {
        return new PlaintextKeys(ks, GPKeySet.Diversification.NONE);
    }

    @Override
    public int getKeysetVersion() {
        return this.staticKeys.getKeyVersion();
    }

    @Override
    public int getKeysetID() {
        return this.staticKeys.getKeyID();
    }

    private GPKeySet deriveSessionKeysSCP01(GPKeySet staticKeys, byte[] host_challenge, byte[] card_challenge) {
        GPKeySet sessionKeys = new GPKeySet();
        byte[] derivationData = new byte[16];
        System.arraycopy(card_challenge, 4, derivationData, 0, 4);
        System.arraycopy(host_challenge, 0, derivationData, 4, 4);
        System.arraycopy(card_challenge, 0, derivationData, 8, 4);
        System.arraycopy(host_challenge, 4, derivationData, 12, 4);
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            for (GPData.KeyType v : GPData.KeyType.values()) {
                if (v == GPData.KeyType.RMAC) continue;
                cipher.init(1, staticKeys.getKeyFor(v));
                GPKeySet.GPKey nk = new GPKeySet.GPKey(cipher.doFinal(derivationData), GPKeySet.GPKey.Type.DES3);
                sessionKeys.setKey(v, nk);
            }
            sessionKeys.setKey(GPData.KeyType.KEK, staticKeys.getKey(GPData.KeyType.KEK));
            return sessionKeys;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Session keys calculation failed.", e);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Session keys calculation failed.", e);
        }
    }

    private GPKeySet deriveSessionKeysSCP02(GPKeySet staticKeys, byte[] sequence, boolean implicitChannel) {
        GPKeySet sessionKeys = new GPKeySet();
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            byte[] derivationData = new byte[16];
            System.arraycopy(sequence, 0, derivationData, 2, 2);
            byte[] constantMAC = new byte[]{1, 1};
            System.arraycopy(constantMAC, 0, derivationData, 0, 2);
            cipher.init(1, staticKeys.getKeyFor(GPData.KeyType.MAC), GPCrypto.iv_null_des);
            GPKeySet.GPKey nk = new GPKeySet.GPKey(cipher.doFinal(derivationData), GPKeySet.GPKey.Type.DES3);
            sessionKeys.setKey(GPData.KeyType.MAC, nk);
            if (implicitChannel) {
                TLVUtils.buffer_increment(derivationData, 2, 2);
            }
            byte[] constantRMAC = new byte[]{1, 2};
            System.arraycopy(constantRMAC, 0, derivationData, 0, 2);
            cipher.init(1, staticKeys.getKeyFor(GPData.KeyType.MAC), GPCrypto.iv_null_des);
            nk = new GPKeySet.GPKey(cipher.doFinal(derivationData), GPKeySet.GPKey.Type.DES3);
            sessionKeys.setKey(GPData.KeyType.RMAC, nk);
            byte[] constantENC = new byte[]{1, -126};
            System.arraycopy(constantENC, 0, derivationData, 0, 2);
            cipher.init(1, staticKeys.getKeyFor(GPData.KeyType.ENC), GPCrypto.iv_null_des);
            nk = new GPKeySet.GPKey(cipher.doFinal(derivationData), GPKeySet.GPKey.Type.DES3);
            sessionKeys.setKey(GPData.KeyType.ENC, nk);
            byte[] constantDEK = new byte[]{1, -127};
            System.arraycopy(constantDEK, 0, derivationData, 0, 2);
            cipher.init(1, staticKeys.getKeyFor(GPData.KeyType.KEK), GPCrypto.iv_null_des);
            nk = new GPKeySet.GPKey(cipher.doFinal(derivationData), GPKeySet.GPKey.Type.DES3);
            sessionKeys.setKey(GPData.KeyType.KEK, nk);
            return sessionKeys;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Session keys calculation failed.", e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Session keys calculation failed.", e);
        }
    }

    private GPKeySet deriveSessionKeysSCP03(GPKeySet staticKeys, byte[] host_challenge, byte[] card_challenge) {
        GPKeySet sessionKeys = new GPKeySet();
        int mac_constant = 6;
        int enc_constant = 4;
        int rmac_constant = 7;
        byte[] context = GPUtils.concatenate(host_challenge, card_challenge);
        byte[] kdf = GPCrypto.scp03_kdf(staticKeys.getKey(GPData.KeyType.MAC), (byte)6, context, 128);
        sessionKeys.setKey(GPData.KeyType.MAC, new GPKeySet.GPKey(kdf, GPKeySet.GPKey.Type.AES));
        kdf = GPCrypto.scp03_kdf(staticKeys.getKey(GPData.KeyType.ENC), (byte)4, context, 128);
        sessionKeys.setKey(GPData.KeyType.ENC, new GPKeySet.GPKey(kdf, GPKeySet.GPKey.Type.AES));
        kdf = GPCrypto.scp03_kdf(staticKeys.getKey(GPData.KeyType.MAC), (byte)7, context, 128);
        sessionKeys.setKey(GPData.KeyType.RMAC, new GPKeySet.GPKey(kdf, GPKeySet.GPKey.Type.AES));
        sessionKeys.setKey(GPData.KeyType.KEK, staticKeys.getKey(GPData.KeyType.KEK));
        return sessionKeys;
    }
}

