/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.AID;
import pro.javacard.gp.CapFile;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeySet;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.PlaintextKeys;
import pro.javacard.gp.SessionKeyProvider;
import pro.javacard.gp.TLVUtils;

public class GlobalPlatform {
    private static Logger logger = LoggerFactory.getLogger(GlobalPlatform.class);
    public static final short SHORT_0 = 0;
    public static final int SCP_ANY = 0;
    public static final int SCP_01_05 = 1;
    public static final int SCP_01_15 = 2;
    public static final int SCP_02_04 = 3;
    public static final int SCP_02_05 = 4;
    public static final int SCP_02_0A = 5;
    public static final int SCP_02_0B = 6;
    public static final int SCP_02_14 = 7;
    public static final int SCP_02_15 = 8;
    public static final int SCP_02_1A = 9;
    public static final int SCP_02_1B = 10;
    public static EnumSet<APDUMode> defaultMode = EnumSet.of(APDUMode.MAC);
    private static final byte CLA_GP = -128;
    private static final byte CLA_MAC = -124;
    private static final byte INS_INITIALIZE_UPDATE = 80;
    private static final byte INS_INSTALL = -26;
    private static final byte INS_LOAD = -24;
    private static final byte INS_DELETE = -28;
    private static final byte INS_GET_STATUS = -14;
    private static final byte INS_SET_STATUS = -16;
    private static final byte INS_PUT_KEY = -40;
    private static final byte INS_STORE_DATA = -30;
    private static final byte INS_GET_DATA = -54;
    public AID sdAID = null;
    GPSpec spec = GPSpec.GP211;
    private int scpMajorVersion = 0;
    private int blockSize = 255;
    private GPKeySet sessionKeys;
    private SCPWrapper wrapper = null;
    private CardChannel channel = null;
    private byte[] diversification_data = null;
    private byte[] cplc = null;
    private GPRegistry registry = null;
    private boolean dirty = true;
    protected boolean strict = true;

    public GlobalPlatform(CardChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("A card session is required");
        }
        this.channel = channel;
    }

    public CardChannel getChannel() {
        return this.channel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream versionfile = GlobalPlatform.class.getResourceAsStream("version.txt");){
            String version = "unknown-development";
            if (versionfile != null) {
                try (BufferedReader vinfo = new BufferedReader(new InputStreamReader(versionfile));){
                    version = vinfo.readLine();
                }
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            return "unknown-error";
        }
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setBlockSize(int size) {
        this.blockSize = size;
    }

    public void setSpec(GPSpec spec) {
        this.spec = spec;
    }

    @Deprecated
    public void imFeelingLucky() throws CardException, GPException {
        this.select(null);
        PlaintextKeys keys = PlaintextKeys.fromMasterKey(GPData.defaultKey, GPKeySet.Diversification.NONE);
        this.openSecureChannel(keys, null, 0, EnumSet.of(APDUMode.MAC));
    }

    protected void giveStrictWarning(String message) throws GPException {
        message = "STRICT WARNING: " + message;
        if (this.strict) {
            throw new GPException(message);
        }
        logger.warn(message);
    }

    public boolean select(AID sdAID) throws GPException, CardException {
        byte[] identify_aid;
        CommandAPDU identify;
        ResponseAPDU identify_resp;
        byte[] identify_data;
        CommandAPDU command = sdAID == null ? new CommandAPDU(0, 164, 4, 0, 256) : new CommandAPDU(0, 164, 4, 0, sdAID.getBytes(), 256);
        ResponseAPDU resp = this.channel.transmit(command);
        if (sdAID == null && resp.getSW() == 27266 && (identify_data = (identify_resp = this.channel.transmit(identify = new CommandAPDU(0, 164, 4, 0, identify_aid = HexUtils.hex2bin("A000000167413000FF"), 256))).getData()).length > 15 && identify_data[14] == 0) {
            this.giveStrictWarning("Unfused JCOP detected");
        }
        if (resp.getSW() == 25219) {
            logger.warn("SELECT ISD returned 6283 - CARD_LOCKED");
        }
        if (resp.getSW() == 36864 || resp.getSW() == 25219) {
            byte[] fci = resp.getData();
            this.parse_select_response(fci);
            return true;
        }
        return false;
    }

    private void parse_select_response(byte[] fci) throws GPException {
        block27: {
            try (ASN1InputStream ais = new ASN1InputStream(fci);){
                if (ais.available() <= 0) break block27;
                DERApplicationSpecific fcidata = (DERApplicationSpecific)ais.readObject();
                if (fcidata.getApplicationTag() == 15) {
                    ASN1Sequence s = ASN1Sequence.getInstance((Object)fcidata.getObject(16));
                    for (ASN1Encodable e : Lists.newArrayList((Iterator)s.iterator())) {
                        ASN1TaggedObject t = DERTaggedObject.getInstance((Object)e);
                        if (t.getTagNo() == 4) {
                            ASN1OctetString isdaid = DEROctetString.getInstance((Object)t.getObject());
                            AID detectedAID = new AID(isdaid.getOctets());
                            if (this.sdAID == null) {
                                logger.debug("Auto-detected ISD AID: " + detectedAID);
                            }
                            if (this.sdAID != null && !detectedAID.equals(this.sdAID)) {
                                this.giveStrictWarning("SD AID in FCI does not match the requested AID!");
                            }
                            this.sdAID = this.sdAID == null ? detectedAID : this.sdAID;
                            continue;
                        }
                        if (t.getTagNo() == 5) {
                            if (t.getObject() instanceof ASN1Sequence) {
                                ASN1Sequence prop = ASN1Sequence.getInstance((Object)t.getObject());
                                for (ASN1Encodable enc : Lists.newArrayList((Iterator)prop.iterator())) {
                                    ASN1Primitive proptag = enc.toASN1Primitive();
                                    if (proptag instanceof DERApplicationSpecific) {
                                        DERApplicationSpecific isddata = (DERApplicationSpecific)proptag;
                                        if (isddata.getApplicationTag() != 19) continue;
                                        this.spec = GPData.get_version_from_card_data(isddata.getEncoded());
                                        logger.debug("Auto-detected GP version: " + (Object)((Object)this.spec));
                                        continue;
                                    }
                                    if (proptag instanceof DERTaggedObject) {
                                        DERTaggedObject tag = (DERTaggedObject)proptag;
                                        if (tag.getTagNo() == 101) {
                                            this.setBlockSize(DEROctetString.getInstance((Object)tag.getObject()));
                                            continue;
                                        }
                                        if (tag.getTagNo() == 110) {
                                            logger.debug("Lifecycle data (ignored): " + HexUtils.bin2hex(tag.getObject().getEncoded()));
                                            continue;
                                        }
                                        logger.info("Unknown/unhandled tag in FCI proprietary data: " + HexUtils.bin2hex(tag.getEncoded()));
                                        continue;
                                    }
                                    throw new GPException("Unknown data from card: " + HexUtils.bin2hex(proptag.getEncoded()));
                                }
                                continue;
                            }
                            if (!(t.getObject() instanceof DERTaggedObject)) continue;
                            DERTaggedObject tag = (DERTaggedObject)t.getObject();
                            if (tag.getTagNo() == 101) {
                                this.setBlockSize(DEROctetString.getInstance((Object)tag.getObject()));
                                continue;
                            }
                            logger.info("Unknown/unhandled tag in FCI proprietary data: " + HexUtils.bin2hex(tag.getEncoded()));
                            continue;
                        }
                        logger.info("Unknown/unhandled tag in FCI: " + HexUtils.bin2hex(t.getEncoded()));
                    }
                    break block27;
                }
                throw new GPException("Unknown data from card: " + HexUtils.bin2hex(fci));
            }
            catch (IOException | ClassCastException e) {
                throw new GPException("Invalid data: " + e.getMessage(), e);
            }
        }
    }

    private void setBlockSize(ASN1OctetString blocksize) {
        int bs = new BigInteger(1, blocksize.getOctets()).intValue();
        if (bs > this.blockSize) {
            logger.debug("Ignoring auto-detected block size that exceeds set maximum: " + bs);
        } else {
            this.blockSize = bs;
            logger.debug("Auto-detected block size: " + this.blockSize);
        }
    }

    @Deprecated
    public void select() throws GPException, CardException {
        if (!this.select(null)) {
            throw new GPException("Could not select security domain!");
        }
    }

    private ResponseAPDU always_transmit(CommandAPDU cmd) throws CardException, GPException {
        if (this.wrapper != null) {
            return this.transmit(cmd);
        }
        return this.channel.transmit(cmd);
    }

    public List<GPKeySet.GPKey> getKeyInfoTemplate() throws CardException, GPException {
        CommandAPDU command = new CommandAPDU(-128, 202, 0, 224, 256);
        ResponseAPDU resp = this.always_transmit(command);
        if (resp.getSW() == 36864) {
            return GPData.get_key_template_list(resp.getData());
        }
        logger.warn("GET DATA(Key Information Template) not supported");
        return GPData.get_key_template_list(null);
    }

    public byte[] fetchCardData() throws CardException, GPException {
        CommandAPDU command = new CommandAPDU(-128, 202, 0, 102, 256);
        ResponseAPDU resp = this.always_transmit(command);
        if (resp.getSW() == 27270) {
            logger.debug("GET DATA(CardData) not supported, Open Platform 2.0.1 card? " + GPUtils.swToString(resp.getSW()));
            return null;
        }
        if (resp.getSW() == 36864) {
            return resp.getData();
        }
        return null;
    }

    public void dumpCardProperties(PrintStream out) throws CardException, GPException {
        List<GPKeySet.GPKey> key_templates = this.getKeyInfoTemplate();
        if (key_templates != null && key_templates.size() > 0) {
            GPData.pretty_print_key_template(key_templates, out);
        }
        out.println("***** GET DATA:");
        CommandAPDU command = new CommandAPDU(-128, 202, 0, 66, 256);
        ResponseAPDU resp = this.channel.transmit(command);
        if (resp.getSW() == 36864) {
            out.println("IIN " + HexUtils.bin2hex(resp.getData()));
        } else {
            out.println("GET DATA(IIN) not supported");
        }
        command = new CommandAPDU(-128, 202, 0, 69, 256);
        resp = this.channel.transmit(command);
        if (resp.getSW() == 36864) {
            out.println("CIN " + HexUtils.bin2hex(resp.getData()));
        } else {
            out.println("GET DATA(CIN) not supported");
        }
        command = new CommandAPDU(-128, 202, 0, 193, 256);
        resp = this.channel.transmit(command);
        if (resp.getSW() == 36864) {
            byte[] ssc = resp.getData();
            out.println("SSC " + HexUtils.bin2hex(TLVUtils.getTLVValueAsBytes(ssc, 0)));
        } else {
            out.println("GET DATA(SSC) not supported");
        }
        out.println("*****");
    }

    public byte[] fetchCPLC() throws CardException, GPException {
        CommandAPDU command = new CommandAPDU(-128, -54, 159, 127, 256);
        ResponseAPDU resp = this.channel.transmit(command);
        if (resp.getSW() == 36864) {
            return resp.getData();
        }
        logger.debug("GET DATA(CPLC) returned SW: " + GPUtils.swToString(resp.getSW()));
        return null;
    }

    public byte[] getCPLC() throws CardException, GPException {
        if (this.cplc == null) {
            this.cplc = this.fetchCPLC();
        }
        return this.cplc;
    }

    public byte[] getDiversificationData() {
        return this.diversification_data;
    }

    public void openSecureChannel(SessionKeyProvider keys, byte[] host_challenge, int scpVersion, EnumSet<APDUMode> securityLevel) throws CardException, GPException {
        CommandAPDU initUpdate;
        ResponseAPDU response;
        int sw;
        if (this.sdAID == null) {
            throw new IllegalStateException("No selected ISD!");
        }
        if (securityLevel.contains((Object)APDUMode.ENC)) {
            securityLevel.add(APDUMode.MAC);
        }
        if (host_challenge == null) {
            host_challenge = new byte[8];
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(host_challenge);
        }
        if ((sw = (response = this.channel.transmit(initUpdate = new CommandAPDU(-128, 80, keys.getKeysetVersion(), keys.getKeysetID(), host_challenge, 256))).getSW()) == 27010 || sw == 27011) {
            throw new GPException(sw, "INITIALIZE UPDATE failed, card LOCKED?");
        }
        GPException.check(response, "INITIALIZE UPDATE failed");
        byte[] update_response = response.getData();
        if (update_response.length != 28 && update_response.length != 29 && update_response.length != 32) {
            throw new GPException("Invalid INITIALIZE UPDATE response length: " + update_response.length);
        }
        int offset = 0;
        this.diversification_data = Arrays.copyOfRange(update_response, 0, 10);
        int keyVersion = update_response[offset += this.diversification_data.length] & 0xFF;
        this.scpMajorVersion = update_response[++offset];
        ++offset;
        int scp_i = -1;
        if (this.scpMajorVersion == 3) {
            scp_i = update_response[offset];
            ++offset;
        }
        byte[] card_challenge = Arrays.copyOfRange(update_response, offset, offset + 8);
        byte[] card_cryptogram = Arrays.copyOfRange(update_response, offset += card_challenge.length, offset + 8);
        offset += card_cryptogram.length;
        logger.debug("Host challenge: " + HexUtils.bin2hex(host_challenge));
        logger.debug("Card challenge: " + HexUtils.bin2hex(card_challenge));
        if (keys.getKeysetVersion() > 0 && keyVersion != keys.getKeysetVersion()) {
            throw new GPException("Key version mismatch: " + keys.getKeysetVersion() + " != " + keyVersion);
        }
        logger.debug("Card reports SCP0" + this.scpMajorVersion + " with version " + keyVersion + " keys");
        if (scpVersion == 0) {
            if (this.scpMajorVersion == 1) {
                scpVersion = 1;
            } else if (this.scpMajorVersion == 2) {
                scpVersion = 8;
            } else if (this.scpMajorVersion == 3) {
                logger.debug("SCP03 i=" + scp_i);
                scpVersion = 3;
            }
        } else if (scpVersion != this.scpMajorVersion) {
            logger.debug("Overriding SCP version: card reports " + this.scpMajorVersion + " but user requested " + scpVersion);
            this.scpMajorVersion = scpVersion;
            if (scpVersion == 1) {
                scpVersion = 1;
            } else if (scpVersion == 2) {
                scpVersion = 8;
            } else {
                logger.debug("error: " + scpVersion);
            }
        }
        if (this.scpMajorVersion == 1 && securityLevel.contains((Object)APDUMode.RMAC)) {
            logger.debug("SCP01 does not support RMAC, removing.");
            securityLevel.remove((Object)APDUMode.RMAC);
        }
        byte[] seq = null;
        if (this.scpMajorVersion == 1) {
            this.sessionKeys = keys.getSessionKeys(this.scpMajorVersion, this.diversification_data, host_challenge, card_challenge);
        } else if (this.scpMajorVersion == 2) {
            seq = Arrays.copyOfRange(update_response, 12, 14);
            this.sessionKeys = keys.getSessionKeys(2, this.diversification_data, new byte[][]{seq});
        } else if (this.scpMajorVersion == 3) {
            if (update_response.length == 32) {
                seq = Arrays.copyOfRange(update_response, 29, 32);
            }
            this.sessionKeys = keys.getSessionKeys(3, this.diversification_data, host_challenge, card_challenge);
        } else {
            throw new GPException("Don't know how to handle SCP version " + this.scpMajorVersion);
        }
        byte[] my_card_cryptogram = null;
        byte[] cntx = GPUtils.concatenate(host_challenge, card_challenge);
        my_card_cryptogram = this.scpMajorVersion == 1 || this.scpMajorVersion == 2 ? GPCrypto.mac_3des_nulliv(this.sessionKeys.getKey(GPData.KeyType.ENC), cntx) : GPCrypto.scp03_kdf(this.sessionKeys.getKey(GPData.KeyType.MAC), (byte)0, cntx, 64);
        if (!Arrays.equals(card_cryptogram, my_card_cryptogram)) {
            this.giveStrictWarning("Card cryptogram invalid!\nCard: " + HexUtils.bin2hex(card_cryptogram) + "\nHost: " + HexUtils.bin2hex(my_card_cryptogram) + "\n!!! DO NOT RE-TRY THE SAME COMMAND/KEYS OR YOU MAY BRICK YOUR CARD !!!");
        } else {
            logger.debug("Verified card cryptogram: " + HexUtils.bin2hex(my_card_cryptogram));
        }
        byte[] host_cryptogram = null;
        if (this.scpMajorVersion == 1 || this.scpMajorVersion == 2) {
            host_cryptogram = GPCrypto.mac_3des_nulliv(this.sessionKeys.getKey(GPData.KeyType.ENC), GPUtils.concatenate(card_challenge, host_challenge));
            this.wrapper = new SCP0102Wrapper(this.sessionKeys, scpVersion, EnumSet.of(APDUMode.MAC), null, null, this.blockSize);
        } else {
            host_cryptogram = GPCrypto.scp03_kdf(this.sessionKeys.getKey(GPData.KeyType.MAC), (byte)1, cntx, 64);
            this.wrapper = new SCP03Wrapper(this.sessionKeys, scpVersion, EnumSet.of(APDUMode.MAC), null, null, this.blockSize);
        }
        logger.debug("Calculated host cryptogram: " + HexUtils.bin2hex(host_cryptogram));
        int P1 = APDUMode.getSetValue(securityLevel);
        CommandAPDU externalAuthenticate = new CommandAPDU(-124, 130, P1, 0, host_cryptogram);
        response = this.transmit(externalAuthenticate);
        GPException.check(response, "External authenticate failed");
        this.wrapper.setSecurityLevel(securityLevel);
        if (this.scpMajorVersion != 3) {
            SCP0102Wrapper w = (SCP0102Wrapper)this.wrapper;
            if (securityLevel.contains((Object)APDUMode.RMAC)) {
                w.setRMACIV(w.getIV());
            }
        }
    }

    public ResponseAPDU transmit(CommandAPDU command) throws CardException, GPException {
        CommandAPDU wc = this.wrapper.wrap(command);
        ResponseAPDU wr = this.channel.transmit(wc);
        return this.wrapper.unwrap(wr);
    }

    public int getSCPVersion() {
        return this.scpMajorVersion;
    }

    public void loadCapFile(CapFile cap) throws CardException, GPException {
        this.loadCapFile(cap, false, false, false, false);
    }

    private void loadCapFile(CapFile cap, boolean includeDebug, boolean separateComponents, boolean loadParam, boolean useHash) throws GPException, CardException {
        byte[] byArray;
        if (this.getRegistry().allAIDs().contains(cap.getPackageAID())) {
            this.giveStrictWarning("Package with AID " + cap.getPackageAID() + " is already present on card");
        }
        byte[] hash = useHash ? cap.getLoadFileDataHash("SHA1", includeDebug) : new byte[]{};
        int len = cap.getCodeLength(includeDebug);
        if (loadParam) {
            byte[] byArray2 = new byte[6];
            byArray2[0] = -17;
            byArray2[1] = 4;
            byArray2[2] = -58;
            byArray2[3] = 2;
            byArray2[4] = (byte)((len & 0xFF00) >> 8);
            byArray = byArray2;
            byArray2[5] = (byte)(len & 0xFF);
        } else {
            byArray = new byte[]{};
        }
        byte[] loadParams = byArray;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(cap.getPackageAID().getLength());
            bo.write(cap.getPackageAID().getBytes());
            bo.write(this.sdAID.getLength());
            bo.write(this.sdAID.getBytes());
            bo.write(hash.length);
            bo.write(hash);
            bo.write(loadParams.length);
            bo.write(loadParams);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU installForLoad = new CommandAPDU(-128, -26, 2, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(installForLoad);
        GPException.check(response, "Install for Load failed");
        List<byte[]> blocks = cap.getLoadBlocks(includeDebug, separateComponents, this.wrapper.getBlockSize());
        for (int i = 0; i < blocks.size(); ++i) {
            CommandAPDU load = new CommandAPDU(-128, -24, i == blocks.size() - 1 ? 128 : 0, (int)((byte)i), blocks.get(i));
            response = this.transmit(load);
            GPException.check(response, "LOAD failed");
        }
        this.dirty = true;
    }

    @Deprecated
    public void installAndMakeSelectable(AID packageAID, AID appletAID, AID instanceAID, byte privileges, byte[] installParams, byte[] installToken) throws GPException, CardException {
        this.installAndMakeSelectable(packageAID, appletAID, instanceAID, GPRegistryEntry.Privileges.fromByte(privileges), installParams, installToken);
    }

    public void installAndMakeSelectable(AID packageAID, AID appletAID, AID instanceAID, GPRegistryEntry.Privileges privileges, byte[] installParams, byte[] installToken) throws GPException, CardException {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        if (this.getRegistry().allAppletAIDs().contains(instanceAID)) {
            this.giveStrictWarning("Instance AID " + instanceAID + " is already present on card");
        }
        if (installParams == null) {
            installParams = new byte[]{-55, 0};
        }
        if (installToken == null) {
            installToken = new byte[]{};
        }
        byte[] privs = privileges.toBytes();
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(packageAID.getLength());
            bo.write(packageAID.getBytes());
            bo.write(appletAID.getLength());
            bo.write(appletAID.getBytes());
            bo.write(instanceAID.getLength());
            bo.write(instanceAID.getBytes());
            bo.write(privs.length);
            bo.write(privs);
            bo.write(installParams.length);
            bo.write(installParams);
            bo.write(installToken.length);
            bo.write(installToken);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU install = new CommandAPDU(-128, -26, 12, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(install);
        GPException.check(response, "Install for Install and make selectable failed");
        this.dirty = true;
    }

    public void storeData(AID aid, byte[] data) throws CardException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(0);
            bo.write(0);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
            bo.write(0);
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU install = new CommandAPDU(-128, -26, 32, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(install);
        GPException.check(response, "Install for personalization failed");
        List<byte[]> blocks = GPUtils.splitArray(data, this.wrapper.getBlockSize());
        for (int i = 0; i < blocks.size(); ++i) {
            CommandAPDU load = new CommandAPDU(-128, -30, i == blocks.size() - 1 ? 128 : 0, (int)((byte)i), blocks.get(i));
            response = this.transmit(load);
            GPException.check(response, "STORE DATA failed");
        }
    }

    public void makeDefaultSelected(AID aid) throws CardException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        GPRegistryEntry.Privileges ds = GPRegistryEntry.Privileges.set(GPRegistryEntry.Privilege.CardReset);
        byte privileges = ds.toByte();
        try {
            bo.write(0);
            bo.write(0);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
            bo.write(1);
            bo.write(privileges);
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU install = new CommandAPDU(-128, -26, 8, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(install);
        GPException.check(response, "Install for make selectable failed");
        this.dirty = true;
    }

    public void lockUnlockApplet(AID app, boolean lock) throws CardException, GPException {
        CommandAPDU cmd = new CommandAPDU(-128, -16, 64, lock ? 128 : 0, app.getBytes());
        ResponseAPDU response = this.transmit(cmd);
        GPException.check(response, "SET STATUS failed");
        this.dirty = true;
    }

    public void setCardStatus(byte status) throws CardException, GPException {
        CommandAPDU cmd = new CommandAPDU(-128, -16, 128, status);
        ResponseAPDU response = this.transmit(cmd);
        GPException.check(response, "SET STATUS failed");
        this.dirty = true;
    }

    public void deleteAID(AID aid, boolean deleteDeps) throws GPException, CardException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(79);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU delete = new CommandAPDU(-128, -28, 0, deleteDeps ? 128 : 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(delete);
        GPException.check(response, "Deletion failed");
        this.dirty = true;
    }

    private byte[] encodeKey(GPKeySet.GPKey key, GPKeySet.GPKey kek, boolean withCheck) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (key.getType() == GPKeySet.GPKey.Type.DES3) {
                baos.write(128);
                baos.write(16);
                Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
                cipher.init(1, kek.getKey());
                baos.write(cipher.doFinal(key.getValue(), 0, 16));
                if (withCheck) {
                    byte[] kcv = GPCrypto.kcv_3des(key);
                    baos.write(kcv.length);
                    baos.write(kcv);
                } else {
                    baos.write(0);
                }
            } else if (key.getType() == GPKeySet.GPKey.Type.AES) {
                baos.write(136);
                baos.write(17);
                byte[] cgram = GPCrypto.scp03_encrypt_key(kek, key);
                baos.write(cgram.length);
                baos.write(cgram);
                byte[] check = GPCrypto.scp03_key_check_value(key);
                baos.write(check.length);
                baos.write(check);
            } else {
                throw new RuntimeException("Don't know how to handle " + (Object)((Object)key.getType()));
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public void putKeys(List<GPKeySet.GPKey> keys, boolean replace) throws GPException, CardException {
        List<GPKeySet.GPKey> tmpl;
        if (keys.size() < 1 || keys.size() > 3) {
            throw new IllegalArgumentException("Can add 1 or up to 3 keys at a time");
        }
        logger.debug("Replace: " + replace);
        for (GPKeySet.GPKey k : keys) {
            logger.debug("PUT KEY:" + k);
        }
        if (keys.size() > 1) {
            for (int i = 1; i < keys.size(); ++i) {
                if (keys.get(i - 1).getID() == keys.get(i).getID() - 1) continue;
                throw new IllegalArgumentException("Key ID-s of multiple keys must be sequential!");
            }
        }
        if ((tmpl = this.getKeyInfoTemplate()).size() > 0) {
            if ((tmpl.get(0).getVersion() < 1 || tmpl.get(0).getVersion() > 127) && replace) {
                this.giveStrictWarning("Trying to replace factory keys, when you need to add new ones? Is this a virgin card? (use --virgin)");
            }
            if (replace && (keys.get(0).getType() != tmpl.get(0).getType() || keys.get(0).getLength() != tmpl.get(0).getLength())) {
                this.giveStrictWarning("Can not replace keys of different type or size: " + (Object)((Object)tmpl.get(0).getType()) + "->" + (Object)((Object)keys.get(0).getType()));
            }
            if (!replace && keys.get(0).getVersion() == tmpl.get(0).getVersion()) {
                throw new IllegalArgumentException("Not adding keys and version matches existing?");
            }
            if (replace && keys.get(0).getVersion() != tmpl.get(0).getVersion()) {
                throw new IllegalArgumentException("Replacing keys and versions don't match existing?");
            }
        } else if (replace) {
            logger.debug("No key template on card but trying to replace. Implying add");
            replace = false;
        }
        int P1 = 0;
        if (replace) {
            P1 = keys.get(0).getVersion();
        }
        int P2 = keys.get(0).getID();
        if (keys.size() > 1) {
            P2 |= 0x80;
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(keys.get(0).getVersion());
            for (GPKeySet.GPKey k : keys) {
                bo.write(this.encodeKey(k, this.sessionKeys.getKey(GPData.KeyType.KEK), true));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CommandAPDU command = new CommandAPDU(-128, -40, P1, P2, bo.toByteArray());
        ResponseAPDU response = this.transmit(command);
        GPException.check(response, "PUT KEY failed");
    }

    public GPRegistry getRegistry() throws GPException, CardException {
        if (this.dirty) {
            this.registry = this.getStatus();
            this.dirty = false;
        }
        return this.registry;
    }

    private byte[] getConcatenatedStatus(GPRegistry reg, int p1, byte[] data) throws CardException, GPException {
        int p2 = reg.tags ? 2 : 0;
        CommandAPDU cmd = new CommandAPDU(-128, -14, p1, p2, data, 256);
        ResponseAPDU response = this.transmit(cmd);
        if (p1 == 128 && response.getSW() == 27270 && p2 == 2) {
            reg.tags = false;
            return this.getConcatenatedStatus(reg, p1, data);
        }
        int sw = response.getSW();
        if (sw != 36864 && sw != 25360) {
            if (sw == 27272) {
                return response.getData();
            }
            logger.warn("GET STATUS failed for " + HexUtils.bin2hex(cmd.getBytes()) + " with " + Integer.toHexString(sw));
            return response.getData();
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(response.getData());
            while (response.getSW() == 25360) {
                cmd = new CommandAPDU(-128, -14, p1, p2 | 1, data, 256);
                response = this.transmit(cmd);
                sw = response.getSW();
                if (sw != 36864 && sw != 25360) {
                    throw new GPException(sw, "GET STATUS failed for " + HexUtils.bin2hex(cmd.getBytes()));
                }
                bo.write(response.getData());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bo.toByteArray();
    }

    private GPRegistry getStatus() throws CardException, GPException {
        GPRegistry registry = new GPRegistry();
        if (this.spec == GPSpec.OP201) {
            registry.tags = false;
        }
        byte[] data = this.getConcatenatedStatus(registry, 128, new byte[]{79, 0});
        registry.parse(128, data, GPRegistryEntry.Kind.IssuerSecurityDomain, this.spec);
        data = this.getConcatenatedStatus(registry, 64, new byte[]{79, 0});
        registry.parse(64, data, GPRegistryEntry.Kind.Application, this.spec);
        data = this.getConcatenatedStatus(registry, 32, new byte[]{79, 0});
        registry.parse(32, data, GPRegistryEntry.Kind.ExecutableLoadFile, this.spec);
        if (this.spec != GPSpec.OP201) {
            data = this.getConcatenatedStatus(registry, 16, new byte[]{79, 0});
            registry.parse(16, data, GPRegistryEntry.Kind.ExecutableLoadFile, this.spec);
        }
        return registry;
    }

    public static abstract class SCPWrapper {
        protected int blockSize = 0;
        protected GPKeySet sessionKeys = null;
        protected boolean mac = false;
        protected boolean enc = false;
        protected boolean rmac = false;

        public void setSecurityLevel(EnumSet<APDUMode> securityLevel) {
            this.mac = securityLevel.contains((Object)APDUMode.MAC);
            this.enc = securityLevel.contains((Object)APDUMode.ENC);
            this.rmac = securityLevel.contains((Object)APDUMode.RMAC);
        }

        protected int getBlockSize() {
            int res = this.blockSize;
            if (this.mac) {
                res -= 8;
            }
            if (this.enc) {
                res -= 8;
            }
            return res;
        }

        protected abstract CommandAPDU wrap(CommandAPDU var1) throws GPException;

        protected abstract ResponseAPDU unwrap(ResponseAPDU var1) throws GPException;
    }

    public static class SCP03Wrapper
    extends SCPWrapper {
        byte[] chaining_value = new byte[16];
        byte[] encryption_counter = new byte[16];

        private SCP03Wrapper(GPKeySet sessionKeys, int scp, EnumSet<APDUMode> securityLevel, byte[] icv, byte[] ricv, int bs) {
            this.sessionKeys = sessionKeys;
            this.blockSize = bs;
            System.arraycopy(GPCrypto.null_bytes_16, 0, this.chaining_value, 0, GPCrypto.null_bytes_16.length);
            System.arraycopy(GPCrypto.null_bytes_16, 0, this.encryption_counter, 0, GPCrypto.null_bytes_16.length);
            this.setSecurityLevel(securityLevel);
        }

        @Override
        protected CommandAPDU wrap(CommandAPDU command) throws GPException {
            byte[] cmd_mac = null;
            try {
                int cla = command.getCLA();
                int lc = command.getNc();
                byte[] data = command.getData();
                if (this.enc) {
                    cla = 132;
                    GPCrypto.buffer_increment(this.encryption_counter);
                    if (command.getData().length > 0) {
                        byte[] d = GPCrypto.pad80(command.getData(), 16);
                        Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
                        c.init(1, this.sessionKeys.getKeyFor(GPData.KeyType.ENC), GPCrypto.iv_null_aes);
                        byte[] iv = c.doFinal(this.encryption_counter);
                        c.init(1, this.sessionKeys.getKeyFor(GPData.KeyType.ENC), new IvParameterSpec(iv));
                        data = c.doFinal(d);
                        lc = data.length;
                    }
                }
                if (this.mac) {
                    cla = 132;
                    lc += 8;
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    bo.write(this.chaining_value);
                    bo.write(cla);
                    bo.write(command.getINS());
                    bo.write(command.getP1());
                    bo.write(command.getP2());
                    bo.write(lc);
                    bo.write(data);
                    byte[] cmac_input = bo.toByteArray();
                    byte[] cmac = GPCrypto.scp03_mac(this.sessionKeys.getKey(GPData.KeyType.MAC), cmac_input, 128);
                    System.arraycopy(cmac, 0, this.chaining_value, 0, this.chaining_value.length);
                    cmd_mac = Arrays.copyOf(cmac, 8);
                }
                ByteArrayOutputStream na = new ByteArrayOutputStream();
                na.write(cla);
                na.write(command.getINS());
                na.write(command.getP1());
                na.write(command.getP2());
                na.write(lc);
                na.write(data);
                if (this.mac) {
                    na.write(cmd_mac);
                }
                byte[] new_apdu = na.toByteArray();
                return new CommandAPDU(new_apdu);
            }
            catch (IOException e) {
                throw new RuntimeException("APDU wrapping failed", e);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IllegalStateException("APDU wrapping failed", e);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                throw new GPException("APDU wrapping failed", e);
            }
        }

        @Override
        protected ResponseAPDU unwrap(ResponseAPDU response) throws GPException {
            return response;
        }
    }

    public static class SCP0102Wrapper
    extends SCPWrapper {
        private byte[] icv = null;
        private byte[] ricv = null;
        private int scp = 0;
        private final ByteArrayOutputStream rMac = new ByteArrayOutputStream();
        private boolean icvEnc = false;
        private boolean preAPDU = false;
        private boolean postAPDU = false;

        private SCP0102Wrapper(GPKeySet sessionKeys, int scp, EnumSet<APDUMode> securityLevel, byte[] icv, byte[] ricv, int bs) {
            this.blockSize = bs;
            this.sessionKeys = sessionKeys;
            this.icv = icv;
            this.ricv = ricv;
            this.setSCPVersion(scp);
            this.setSecurityLevel(securityLevel);
        }

        public void setSCPVersion(int scp) {
            this.scp = 2;
            if (scp < 3) {
                this.scp = 1;
            }
            this.icvEnc = scp == 2 || scp == 7 || scp == 8 || scp == 9 || scp == 10;
            this.preAPDU = scp == 1 || scp == 2 || scp == 3 || scp == 4 || scp == 7 || scp == 8;
            this.postAPDU = scp == 5 || scp == 6 || scp == 9 || scp == 10;
        }

        public byte[] getIV() {
            return this.icv;
        }

        public void setRMACIV(byte[] iv) {
            this.ricv = iv;
        }

        private static byte clearBits(byte b, byte mask) {
            return (byte)(b & ~mask & 0xFF);
        }

        private static byte setBits(byte b, byte mask) {
            return (byte)((b | mask) & 0xFF);
        }

        @Override
        public CommandAPDU wrap(CommandAPDU command) throws GPException {
            try {
                Cipher c;
                int origLc;
                int origCLA;
                if (this.rmac) {
                    this.rMac.reset();
                    this.rMac.write(SCP0102Wrapper.clearBits((byte)command.getCLA(), (byte)7));
                    this.rMac.write(command.getINS());
                    this.rMac.write(command.getP1());
                    this.rMac.write(command.getP2());
                    if (command.getNc() >= 0) {
                        this.rMac.write(command.getNc());
                        this.rMac.write(command.getData());
                    }
                }
                if (!this.mac && !this.enc) {
                    return command;
                }
                int newCLA = origCLA = command.getCLA();
                int origINS = command.getINS();
                int origP1 = command.getP1();
                int origP2 = command.getP2();
                byte[] origData = command.getData();
                int newLc = origLc = command.getNc();
                byte[] newData = null;
                int le = command.getNe();
                ByteArrayOutputStream t = new ByteArrayOutputStream();
                if (origLc > this.getBlockSize()) {
                    throw new IllegalArgumentException("APDU too long for wrapping.");
                }
                if (this.mac) {
                    if (this.icv == null) {
                        this.icv = new byte[8];
                    } else if (this.icvEnc) {
                        c = null;
                        if (this.scp == 1) {
                            c = Cipher.getInstance("DESede/ECB/NoPadding");
                            c.init(1, this.sessionKeys.getKeyFor(GPData.KeyType.MAC));
                        } else {
                            c = Cipher.getInstance("DES/ECB/NoPadding");
                            c.init(1, this.sessionKeys.getKey(GPData.KeyType.MAC).getKey(GPKeySet.GPKey.Type.DES));
                        }
                        this.icv = c.doFinal(this.icv);
                    }
                    if (this.preAPDU) {
                        newCLA = SCP0102Wrapper.setBits((byte)newCLA, (byte)4);
                        newLc += 8;
                    }
                    t.write(newCLA);
                    t.write(origINS);
                    t.write(origP1);
                    t.write(origP2);
                    t.write(newLc);
                    t.write(origData);
                    if (this.scp == 1) {
                        this.icv = GPCrypto.mac_3des(this.sessionKeys.getKey(GPData.KeyType.MAC), t.toByteArray(), this.icv);
                    } else if (this.scp == 2) {
                        this.icv = GPCrypto.mac_des_3des(this.sessionKeys.getKey(GPData.KeyType.MAC), t.toByteArray(), this.icv);
                    }
                    if (this.postAPDU) {
                        newCLA = SCP0102Wrapper.setBits((byte)newCLA, (byte)4);
                        newLc += 8;
                    }
                    t.reset();
                    newData = origData;
                }
                if (this.enc && origLc > 0) {
                    if (this.scp == 1) {
                        t.write(origLc);
                        t.write(origData);
                        if (t.size() % 8 != 0) {
                            byte[] x = GPCrypto.pad80(t.toByteArray(), 8);
                            t.reset();
                            t.write(x);
                        }
                    } else {
                        t.write(GPCrypto.pad80(origData, 8));
                    }
                    newLc += t.size() - origData.length;
                    c = Cipher.getInstance("DESede/CBC/NoPadding");
                    c.init(1, this.sessionKeys.getKeyFor(GPData.KeyType.ENC), GPCrypto.iv_null_des);
                    newData = c.doFinal(t.toByteArray());
                    t.reset();
                }
                t.write(newCLA);
                t.write(origINS);
                t.write(origP1);
                t.write(origP2);
                if (newLc > 0) {
                    t.write(newLc);
                    t.write(newData);
                }
                if (this.mac) {
                    t.write(this.icv);
                }
                if (le > 0) {
                    t.write(le);
                }
                CommandAPDU wrapped = new CommandAPDU(t.toByteArray());
                return wrapped;
            }
            catch (IOException e) {
                throw new RuntimeException("APDU wrapping failed", e);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IllegalStateException("APDU wrapping failed", e);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                throw new GPException("APDU wrapping failed", e);
            }
        }

        @Override
        public ResponseAPDU unwrap(ResponseAPDU response) throws GPException {
            if (this.rmac) {
                if (response.getData().length < 8) {
                    throw new RuntimeException("Wrong response length (too short).");
                }
                int respLen = response.getData().length - 8;
                this.rMac.write(respLen);
                this.rMac.write(response.getData(), 0, respLen);
                this.rMac.write(response.getSW1());
                this.rMac.write(response.getSW2());
                this.ricv = GPCrypto.mac_des_3des(this.sessionKeys.getKey(GPData.KeyType.RMAC), GPCrypto.pad80(this.rMac.toByteArray(), 8), this.ricv);
                byte[] actualMac = new byte[8];
                System.arraycopy(response.getData(), respLen, actualMac, 0, 8);
                if (!Arrays.equals(this.ricv, actualMac)) {
                    throw new GPException("RMAC invalid.");
                }
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write(response.getBytes(), 0, respLen);
                o.write(response.getSW1());
                o.write(response.getSW2());
                response = new ResponseAPDU(o.toByteArray());
            }
            return response;
        }
    }

    public static enum GPSpec {
        OP201,
        GP211,
        GP22;

    }

    public static enum APDUMode {
        CLR(0),
        MAC(1),
        ENC(2),
        RMAC(16);

        private final int value;

        private APDUMode(int value) {
            this.value = value;
        }

        public static int getSetValue(EnumSet<APDUMode> s) {
            int v = 0;
            for (APDUMode m : s) {
                v |= m.value;
            }
            return v;
        }
    }
}

