/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.AID;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPRegistryEntryApp;
import pro.javacard.gp.GPRegistryEntryPkg;
import pro.javacard.gp.GlobalPlatform;

public class GPRegistry
implements Iterable<GPRegistryEntry> {
    private static Logger logger = LoggerFactory.getLogger(GPRegistry.class);
    boolean tags = true;
    LinkedHashMap<AID, GPRegistryEntry> entries = new LinkedHashMap();

    public void add(GPRegistryEntry entry) {
        GPRegistryEntry existing;
        GPRegistryEntryApp app;
        if (entry instanceof GPRegistryEntryApp && (app = (GPRegistryEntryApp)entry).getPrivileges().has(GPRegistryEntry.Privilege.SecurityDomain) && entry.getType() == GPRegistryEntry.Kind.Application) {
            entry.setType(GPRegistryEntry.Kind.SecurityDomain);
        }
        if ((existing = this.entries.get(entry.getAID())) != null && existing.getType() != entry.getType()) {
            return;
        }
        this.entries.put(entry.getAID(), entry);
    }

    @Override
    public Iterator<GPRegistryEntry> iterator() {
        return this.entries.values().iterator();
    }

    public List<GPRegistryEntryPkg> allPackages() {
        ArrayList<GPRegistryEntryPkg> res = new ArrayList<GPRegistryEntryPkg>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isPackage()) continue;
            res.add((GPRegistryEntryPkg)e);
        }
        return res;
    }

    public List<AID> allPackageAIDs() {
        ArrayList<AID> res = new ArrayList<AID>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isPackage()) continue;
            res.add(e.getAID());
        }
        return res;
    }

    public List<AID> allAppletAIDs() {
        ArrayList<AID> res = new ArrayList<AID>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isApplet()) continue;
            res.add(e.getAID());
        }
        return res;
    }

    public List<AID> allAIDs() {
        ArrayList<AID> res = new ArrayList<AID>();
        for (GPRegistryEntry e : this.entries.values()) {
            res.add(e.getAID());
        }
        return res;
    }

    public List<GPRegistryEntryApp> allApplets() {
        ArrayList<GPRegistryEntryApp> res = new ArrayList<GPRegistryEntryApp>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isApplet()) continue;
            res.add((GPRegistryEntryApp)e);
        }
        return res;
    }

    public AID getDefaultSelectedAID() {
        for (GPRegistryEntryApp e : this.allApplets()) {
            if (!e.getPrivileges().has(GPRegistryEntry.Privilege.CardReset)) continue;
            return e.getAID();
        }
        return null;
    }

    public AID getDefaultSelectedPackageAID() {
        AID defaultAID = this.getDefaultSelectedAID();
        if (defaultAID != null) {
            for (GPRegistryEntryPkg e : this.allPackages()) {
                if (!e.getModules().contains(defaultAID)) continue;
                return e.getAID();
            }
            for (GPRegistryEntryPkg e : this.allPackages()) {
                if (!defaultAID.toString().startsWith(e.getAID().toString())) continue;
                return e.getAID();
            }
        }
        return null;
    }

    public GPRegistryEntryApp getISD() {
        for (GPRegistryEntryApp a : this.allApplets()) {
            if (a.getType() != GPRegistryEntry.Kind.IssuerSecurityDomain) continue;
            return a;
        }
        return null;
    }

    private void populate_legacy(int p1, byte[] data, GPRegistryEntry.Kind type, GlobalPlatform.GPSpec spec) throws GPDataException {
        int offset = 0;
        try {
            while (offset < data.length) {
                int len = data[offset++];
                AID aid = new AID(data, offset, len);
                offset += len;
                int lifecycle = data[offset++] & 0xFF;
                byte privileges = data[offset++];
                if (type == GPRegistryEntry.Kind.IssuerSecurityDomain || type == GPRegistryEntry.Kind.Application) {
                    GPRegistryEntryApp app = new GPRegistryEntryApp();
                    app.setType(type);
                    app.setAID(aid);
                    app.setPrivileges(GPRegistryEntry.Privileges.fromByte(privileges));
                    app.setLifeCycle(lifecycle);
                    this.add(app);
                    continue;
                }
                if (type != GPRegistryEntry.Kind.ExecutableLoadFile) continue;
                if (privileges != 0) {
                    throw new GPDataException("Privileges of Load File is not 0x00");
                }
                GPRegistryEntryPkg pkg = new GPRegistryEntryPkg();
                pkg.setAID(aid);
                pkg.setLifeCycle(lifecycle);
                pkg.setType(type);
                if (spec != GlobalPlatform.GPSpec.OP201 && p1 != 32) {
                    int num = data[offset++];
                    for (int i = 0; i < num; ++i) {
                        len = data[offset++] & 0xFF;
                        aid = new AID(data, offset, len);
                        offset += len;
                        pkg.addModule(aid);
                    }
                }
                this.add(pkg);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GPDataException("Invalid response to GET STATUS", e);
        }
    }

    private void populate_tags(byte[] data, GPRegistryEntry.Kind type) throws GPDataException {
        try (ASN1InputStream ais = new ASN1InputStream(data);){
            while (ais.available() > 0) {
                DERApplicationSpecific registry_data = (DERApplicationSpecific)ais.readObject();
                if (registry_data.getApplicationTag() == 3) {
                    GPRegistryEntryApp app = new GPRegistryEntryApp();
                    GPRegistryEntryPkg pkg = new GPRegistryEntryPkg();
                    ASN1Sequence seq = (ASN1Sequence)registry_data.getObject(16);
                    for (ASN1Encodable p : Lists.newArrayList((Iterator)seq.iterator())) {
                        ASN1OctetString lc;
                        if (p instanceof DERApplicationSpecific) {
                            AID a;
                            ASN1ApplicationSpecific entry = DERApplicationSpecific.getInstance((Object)p);
                            if (entry.getApplicationTag() == 15) {
                                AID aid = new AID(entry.getContents());
                                app.setAID(aid);
                                pkg.setAID(aid);
                                continue;
                            }
                            if (entry.getApplicationTag() == 5) {
                                GPRegistryEntry.Privileges privs = GPRegistryEntry.Privileges.fromBytes(entry.getContents());
                                app.setPrivileges(privs);
                                continue;
                            }
                            if (entry.getApplicationTag() == 4) {
                                a = new AID(entry.getContents());
                                app.setLoadFile(a);
                                continue;
                            }
                            if (entry.getApplicationTag() == 12) {
                                a = new AID(entry.getContents());
                                app.setDomain(a);
                                pkg.setDomain(a);
                                continue;
                            }
                            if (entry.getApplicationTag() == 14) {
                                pkg.setVersion(entry.getContents());
                                continue;
                            }
                            logger.warn("Unknown tag: " + HexUtils.bin2hex(entry.getEncoded()));
                            continue;
                        }
                        if (!(p instanceof DERTaggedObject)) continue;
                        ASN1TaggedObject tag = DERTaggedObject.getInstance((Object)p);
                        if (tag.getTagNo() == 112) {
                            lc = DEROctetString.getInstance((ASN1TaggedObject)tag, (boolean)false);
                            app.setLifeCycle(lc.getOctets()[0] & 0xFF);
                            pkg.setLifeCycle(lc.getOctets()[0] & 0xFF);
                            continue;
                        }
                        if (tag.getTagNo() == 4) {
                            lc = DEROctetString.getInstance((ASN1TaggedObject)tag, (boolean)false);
                            AID a = new AID(lc.getOctets());
                            pkg.addModule(a);
                            continue;
                        }
                        logger.warn("Unknown data: " + HexUtils.bin2hex(tag.getEncoded()));
                    }
                    if (type == GPRegistryEntry.Kind.ExecutableLoadFile) {
                        pkg.setType(type);
                        this.add(pkg);
                        continue;
                    }
                    app.setType(type);
                    this.add(app);
                    continue;
                }
                throw new GPDataException("Invalid tag", registry_data.getEncoded());
            }
        }
        catch (IOException e) {
            throw new GPDataException("Invalid data", e);
        }
    }

    public void parse(int p1, byte[] data, GPRegistryEntry.Kind type, GlobalPlatform.GPSpec spec) throws GPDataException {
        if (this.tags) {
            this.populate_tags(data, type);
        } else {
            this.populate_legacy(p1, data, type, spec);
        }
    }
}

