/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.security.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;

public class GPKeySet {
    private HashMap<GPData.KeyType, GPKey> keys = new HashMap();
    private int keyVersion = 0;
    private int keyID = 0;

    public GPKey getKey(GPData.KeyType type) {
        return this.keys.get((Object)type);
    }

    public Map<GPData.KeyType, GPKey> getKeys() {
        return new HashMap<GPData.KeyType, GPKey>(this.keys);
    }

    public Key getKeyFor(GPData.KeyType type) {
        return this.keys.get((Object)type).getKey();
    }

    public int getVersion() {
        return this.keyVersion;
    }

    public GPKeySet() {
    }

    public GPKeySet(GPKey master) {
        this.keys.put(GPData.KeyType.ENC, master);
        this.keys.put(GPData.KeyType.MAC, master);
        this.keys.put(GPData.KeyType.KEK, master);
    }

    public GPKeySet(GPKey enc, GPKey mac, GPKey kek) {
        this.keys.put(GPData.KeyType.ENC, enc);
        this.keys.put(GPData.KeyType.MAC, mac);
        this.keys.put(GPData.KeyType.KEK, kek);
    }

    public void setKey(GPData.KeyType type, GPKey k) {
        this.keys.put(type, k);
    }

    public String toString() {
        String s = "\nENC: " + this.getKey(GPData.KeyType.ENC);
        s = s + "\nMAC: " + this.getKey(GPData.KeyType.MAC);
        s = s + "\nKEK: " + this.getKey(GPData.KeyType.KEK);
        return s;
    }

    public int getKeyID() {
        return this.keyID;
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public void setKeyID(int keyID) {
        this.keyID = keyID;
    }

    public void setKeyVersion(int keyVersion) {
        this.keyVersion = keyVersion;
    }

    private static byte[] enlarge(byte[] key, int length) {
        if (length == 24) {
            byte[] key24 = new byte[24];
            System.arraycopy(key, 0, key24, 0, 16);
            System.arraycopy(key, 0, key24, 16, 8);
            return key24;
        }
        byte[] key8 = new byte[8];
        System.arraycopy(key, 0, key8, 0, 8);
        return key8;
    }

    public static enum Diversification {
        NONE,
        VISA2,
        EMV;

    }

    public static final class GPKey {
        private int version = 0;
        private int id = 0;
        private int length = -1;
        private final Type type;
        private byte[] value = null;

        public int getID() {
            return this.id;
        }

        public int getVersion() {
            return this.version;
        }

        public byte[] getValue() {
            return this.value;
        }

        public int getLength() {
            return this.length;
        }

        public Type getType() {
            return this.type;
        }

        public GPKey(int version, int id, GPKey ref) {
            this.version = version;
            this.id = id;
            this.type = ref.getType();
            this.length = ref.getLength();
            this.value = new byte[ref.getLength()];
            System.arraycopy(ref.getValue(), 0, this.value, 0, ref.getLength());
        }

        public GPKey(int version, int id, int length, int type) {
            this.version = version;
            this.id = id;
            this.length = length;
            if (type == 128 || type == 129) {
                this.type = Type.DES3;
            } else if (type == 136) {
                this.type = Type.AES;
            } else {
                throw new IllegalArgumentException(this.getClass().getName() + " currently only supports 3DES and AES keys");
            }
        }

        public GPKey(byte[] v, Type type) {
            if (v.length != 16 && v.length != 24 && v.length != 32) {
                throw new IllegalArgumentException("A valid key should be 16/24/32 bytes long");
            }
            this.value = Arrays.copyOf(v, v.length);
            this.length = v.length;
            this.type = type;
            this.id = 0;
            this.version = 0;
        }

        public Key getKey(Type type) {
            if (type == Type.DES) {
                return new SecretKeySpec(GPKeySet.enlarge(this.value, 8), "DES");
            }
            if (type == Type.DES3) {
                return new SecretKeySpec(GPKeySet.enlarge(this.value, 24), "DESede");
            }
            if (type == Type.AES) {
                return new SecretKeySpec(this.value, "AES");
            }
            throw new IllegalArgumentException("Don't know how to handle " + (Object)((Object)type) + " yet");
        }

        public Key getKey() {
            return this.getKey(this.type);
        }

        public String toString() {
            return "Ver:" + this.version + " ID:" + this.id + " Type:" + (Object)((Object)this.type) + " Len:" + this.length + " Value:" + HexUtils.bin2hex(this.value) + " KCV: " + HexUtils.bin2hex(this.getKCV());
        }

        public String toStringKey() {
            return (Object)((Object)this.type) + ":" + HexUtils.bin2hex(this.value);
        }

        public byte[] getKCV() {
            if (this.type == Type.DES3) {
                return GPCrypto.kcv_3des(this);
            }
            if (this.type == Type.AES) {
                return GPCrypto.scp03_key_check_value(this);
            }
            return new byte[0];
        }

        public static enum Type {
            ANY,
            DES,
            DES3,
            AES;

        }
    }
}

