/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pro.javacard.gp.AID;
import pro.javacard.gp.GPUtils;

public class CapFile {
    public static final String[] componentNames = new String[]{"Header", "Directory", "Import", "Applet", "Class", "Method", "StaticField", "Export", "ConstantPool", "RefLocation", "Descriptor", "Debug"};
    private final HashMap<String, byte[]> capComponents = new HashMap();
    private String packageName = null;
    private AID packageAID = null;
    private byte major_version = 0;
    private byte minor_version = 0;
    private final List<AID> appletAIDs = new ArrayList<AID>();
    private final List<byte[]> dapBlocks = new ArrayList<byte[]>();
    private final List<byte[]> loadTokens = new ArrayList<byte[]>();
    private final List<byte[]> installTokens = new ArrayList<byte[]>();
    private Manifest manifest = null;

    public CapFile(InputStream in) throws IOException {
        this(in, null);
    }

    private CapFile(InputStream in, String packageName) throws IOException {
        byte[] contents;
        String fullName;
        ZipInputStream zip = new ZipInputStream(in);
        Map<String, byte[]> entries = this.getEntries(zip);
        if (packageName != null) {
            packageName = packageName.replace('.', '/') + "/javacard/";
        } else {
            Iterator<String> it = entries.keySet().iterator();
            String lookFor = "Header.cap";
            while (it.hasNext()) {
                String s = it.next();
                if (!s.endsWith(lookFor)) continue;
                packageName = s.substring(0, s.lastIndexOf(lookFor));
                break;
            }
        }
        byte[] mf = entries.remove("META-INF/MANIFEST.MF");
        if (mf != null) {
            String[] mfi = new ByteArrayInputStream(mf);
            this.manifest = new Manifest((InputStream)mfi);
        }
        if (packageName == null) {
            throw new RuntimeException("Could not figure out the package name of the applet!");
        }
        this.packageName = packageName.substring(0, packageName.lastIndexOf("/javacard/")).replace('/', '.');
        for (String name : componentNames) {
            fullName = packageName + name + ".cap";
            contents = entries.get(fullName);
            this.capComponents.put(name, contents);
        }
        ArrayList<List<byte[]>> tables = new ArrayList<List<byte[]>>();
        tables.add(this.dapBlocks);
        tables.add(this.loadTokens);
        tables.add(this.installTokens);
        String[] names = new String[]{"dap", "lt", "it"};
        for (int i = 0; i < names.length; ++i) {
            int index = 0;
            while ((contents = entries.get(fullName = "meta-inf/" + packageName.replace('/', '-') + names[i] + (index + 1))) != null) {
                ((List)tables.get(i)).add(contents);
                ++index;
            }
        }
        zip.close();
        in.close();
        byte[] header = this.capComponents.get("Header");
        this.major_version = header[10];
        this.minor_version = header[11];
        this.packageAID = new AID(header, 13, header[12]);
        byte[] applet = this.capComponents.get("Applet");
        if (applet != null) {
            int offset = 4;
            for (int j = 0; j < (applet[3] & 0xFF); ++j) {
                byte len = applet[offset++];
                this.appletAIDs.add(new AID(applet, offset, len));
                offset += len + 2;
            }
        }
    }

    private Map<String, byte[]> getEntries(ZipInputStream in) throws IOException {
        ZipEntry entry;
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        while ((entry = in.getNextEntry()) != null) {
            int c;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((c = in.read(buf)) > 0) {
                bos.write(buf, 0, c);
            }
            result.put(entry.getName(), bos.toByteArray());
        }
        return result;
    }

    public AID getPackageAID() {
        return this.packageAID;
    }

    public List<AID> getAppletAIDs() {
        ArrayList<AID> result = new ArrayList<AID>();
        result.addAll(this.appletAIDs);
        return result;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getCodeLength(boolean includeDebug) {
        int result = 0;
        for (String name : componentNames) {
            byte[] data;
            if (!includeDebug && (name.equals("Debug") || name.equals("Descriptor")) || (data = this.capComponents.get(name)) == null) continue;
            result += data.length;
        }
        return result;
    }

    private byte[] createHeader(boolean includeDebug) {
        int len = this.getCodeLength(includeDebug);
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(-60);
        if (len < 128) {
            bo.write((byte)len);
        } else if (len <= 255) {
            bo.write(-127);
            bo.write((byte)len);
        } else if (len <= 65535) {
            bo.write(-126);
            bo.write((byte)((len & 0xFF00) >> 8));
            bo.write((byte)(len & 0xFF));
        } else {
            bo.write(-125);
            bo.write((byte)((len & 0xFF0000) >> 16));
            bo.write((byte)((len & 0xFF00) >> 8));
            bo.write((byte)(len & 0xFF));
        }
        return bo.toByteArray();
    }

    public List<byte[]> getLoadBlocks(boolean includeDebug, boolean separateComponents, int blockSize) {
        List<byte[]> blocks = new ArrayList<byte[]>();
        if (!separateComponents) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            try {
                bo.write(this.createHeader(includeDebug));
                bo.write(this.getRawCode(includeDebug));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            blocks = GPUtils.splitArray(bo.toByteArray(), blockSize);
        } else {
            for (String name : componentNames) {
                byte[] currentComponent;
                if (!includeDebug && (name.equals("Debug") || name.equals("Descriptor")) || (currentComponent = this.capComponents.get(name)) == null) continue;
                if (name.equals("Header")) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    try {
                        bo.write(this.createHeader(includeDebug));
                        bo.write(currentComponent);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                    currentComponent = bo.toByteArray();
                }
                blocks = GPUtils.splitArray(currentComponent, blockSize);
            }
        }
        return blocks;
    }

    private byte[] getRawCode(boolean includeDebug) {
        byte[] result = new byte[this.getCodeLength(includeDebug)];
        int offset = 0;
        for (String name : componentNames) {
            byte[] currentComponent;
            if (!includeDebug && (name.equals("Debug") || name.equals("Descriptor")) || (currentComponent = this.capComponents.get(name)) == null) continue;
            System.arraycopy(currentComponent, 0, result, offset, currentComponent.length);
            offset += currentComponent.length;
        }
        return result;
    }

    public byte[] getLoadFileDataHash(String hash, boolean includeDebug) {
        try {
            return MessageDigest.getInstance(hash).digest(this.getRawCode(includeDebug));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not possible", e);
        }
    }

    public void dump(PrintStream out) {
        if (this.manifest != null) {
            String hexaid;
            int i;
            Attributes mains = this.manifest.getMainAttributes();
            Map<String, Attributes> ent = this.manifest.getEntries();
            if (ent.keySet().size() > 1) {
                throw new IllegalArgumentException("Too many elments in CAP");
            }
            Attributes caps = ent.get(ent.keySet().toArray()[0]);
            String jdk_name = mains.getValue("Created-By");
            String cap_version = caps.getValue("Java-Card-CAP-File-Version");
            String cap_creation_time = caps.getValue("Java-Card-CAP-Creation-Time");
            String converter_version = caps.getValue("Java-Card-Converter-Version");
            String converter_provider = caps.getValue("Java-Card-Converter-Provider");
            String package_name = caps.getValue("Java-Card-Package-Name");
            String package_version = caps.getValue("Java-Card-Package-Version");
            String package_aid = caps.getValue("Java-Card-Package-AID");
            int num_applets = 0;
            int num_imports = 0;
            for (Object e : caps.keySet()) {
                Attributes.Name an = (Attributes.Name)e;
                String s = an.toString();
                if (s.startsWith("Java-Card-Applet-") && s.endsWith("-Name")) {
                    ++num_applets;
                    continue;
                }
                if (!s.startsWith("Java-Card-Imported-Package-") || !s.endsWith("-AID")) continue;
                ++num_imports;
            }
            out.println("CAP file (v" + cap_version + ") generated on " + cap_creation_time);
            out.println("By " + converter_provider + " converter " + converter_version + " with JDK " + jdk_name);
            String hexpkgaid = HexUtils.bin2hex(HexUtils.stringToBin(package_aid));
            out.println("Package: " + package_name + " v" + package_version + " with AID " + hexpkgaid);
            for (i = 1; i <= num_applets; ++i) {
                String applet_name = caps.getValue("Java-Card-Applet-" + i + "-Name");
                String applet_aid = caps.getValue("Java-Card-Applet-" + i + "-AID");
                hexaid = HexUtils.bin2hex(HexUtils.stringToBin(applet_aid));
                out.println("Applet: " + applet_name + " with AID " + hexaid);
            }
            for (i = 1; i <= num_imports; ++i) {
                String import_aid = caps.getValue("Java-Card-Imported-Package-" + i + "-AID");
                String import_version = caps.getValue("Java-Card-Imported-Package-" + i + "-Version");
                hexaid = HexUtils.bin2hex(HexUtils.stringToBin(import_aid));
                out.println("Import: " + hexaid + " v" + import_version);
            }
        } else {
            String pkg_version = this.major_version + "." + this.minor_version;
            out.println("No manifest in CAP. Information from Header and Applet components:");
            out.println("Package: " + this.packageName + " v" + pkg_version + " with AID " + this.packageAID);
            for (AID applet : this.appletAIDs) {
                out.println("Applet: AID " + applet);
            }
        }
        out.println("Total code size: " + this.getCodeLength(false) + " bytes (" + this.getCodeLength(true) + " with debug)");
        out.println("SHA256 (code): " + HexUtils.bin2hex(this.getLoadFileDataHash("SHA-256", false)));
        out.println("SHA1   (code): " + HexUtils.bin2hex(this.getLoadFileDataHash("SHA-1", false)));
    }
}

