/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;
import pro.javacard.gp.AID;
import pro.javacard.gp.GPKeySet;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.PlaintextKeys;

public class ArgMatchers {
    public static ValueConverter<AID> aid() {
        return new AIDMatcher();
    }

    public static ValueConverter<GPKeySet.GPKey> key() {
        return new KeyMatcher();
    }

    public static ValueConverter<GlobalPlatform.APDUMode> mode() {
        return new APDUModeMatcher();
    }

    public static ValueConverter<PlaintextKeys> keyset() {
        return new KeySetMatcher();
    }

    public static ValueConverter<byte[]> hex() {
        return new HexStringMatcher();
    }

    public static class HexStringMatcher
    implements ValueConverter<byte[]> {
        public Class<byte[]> valueType() {
            return byte[].class;
        }

        public String valuePattern() {
            return null;
        }

        public byte[] convert(String arg0) {
            try {
                return HexUtils.stringToBin(arg0);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConversionException(arg0 + " is not a valid hex string!");
            }
        }
    }

    public static class KeySetMatcher
    implements ValueConverter<PlaintextKeys> {
        public Class<PlaintextKeys> valueType() {
            return PlaintextKeys.class;
        }

        public String valuePattern() {
            return null;
        }

        public PlaintextKeys convert(String arg0) {
            try {
                GPKeySet.GPKey m = null;
                GPKeySet.Diversification d = GPKeySet.Diversification.NONE;
                String in = arg0.trim().toLowerCase();
                if (in.startsWith("emv:")) {
                    m = new GPKeySet.GPKey(HexUtils.hex2bin(in.substring("emv:".length())), GPKeySet.GPKey.Type.DES3);
                    d = GPKeySet.Diversification.EMV;
                } else if (in.startsWith("visa2:")) {
                    m = new GPKeySet.GPKey(HexUtils.hex2bin(in.substring("visa2:".length())), GPKeySet.GPKey.Type.DES3);
                    d = GPKeySet.Diversification.VISA2;
                } else {
                    m = in.startsWith("aes:") ? new GPKeySet.GPKey(HexUtils.hex2bin(in.substring("aes:".length())), GPKeySet.GPKey.Type.AES) : new GPKeySet.GPKey(HexUtils.hex2bin(in), GPKeySet.GPKey.Type.DES3);
                }
                return PlaintextKeys.fromMasterKey(m, d);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConversionException(arg0 + " is not a valid master key indicator!");
            }
        }
    }

    public static class APDUModeMatcher
    implements ValueConverter<GlobalPlatform.APDUMode> {
        public Class<GlobalPlatform.APDUMode> valueType() {
            return GlobalPlatform.APDUMode.class;
        }

        public String valuePattern() {
            return null;
        }

        public GlobalPlatform.APDUMode convert(String arg0) {
            try {
                return GlobalPlatform.APDUMode.valueOf(arg0.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ValueConversionException(arg0 + " is not an APDU mode!");
            }
        }
    }

    public static class KeyMatcher
    implements ValueConverter<GPKeySet.GPKey> {
        public Class<GPKeySet.GPKey> valueType() {
            return GPKeySet.GPKey.class;
        }

        public String valuePattern() {
            return null;
        }

        public GPKeySet.GPKey convert(String arg0) {
            try {
                String s = arg0.toLowerCase();
                if (s.startsWith("aes:")) {
                    return new GPKeySet.GPKey(HexUtils.hex2bin(s.substring("aes:".length())), GPKeySet.GPKey.Type.AES);
                }
                if (s.startsWith("3des:")) {
                    return new GPKeySet.GPKey(HexUtils.hex2bin(s.substring("3des:".length())), GPKeySet.GPKey.Type.DES3);
                }
                return new GPKeySet.GPKey(HexUtils.hex2bin(arg0), GPKeySet.GPKey.Type.DES3);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConversionException(arg0 + " is not a valid key!");
            }
        }
    }

    public static class AIDMatcher
    implements ValueConverter<AID> {
        public Class<AID> valueType() {
            return AID.class;
        }

        public String valuePattern() {
            return null;
        }

        public AID convert(String arg0) {
            try {
                return new AID(arg0);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConversionException(arg0 + " is not a valid AID!");
            }
        }
    }
}

