/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.util.Arrays;

public class AID {
    private byte[] aidBytes = null;

    public AID(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public AID(String str) {
        this(HexUtils.hex2bin(str));
    }

    public AID(byte[] bytes, int offset, int length) throws IllegalArgumentException {
        if (length < 5 || length > 16) {
            throw new IllegalArgumentException("AID's are between 5 and 16 bytes, not " + Integer.toHexString(length));
        }
        this.aidBytes = new byte[length];
        System.arraycopy(bytes, offset, this.aidBytes, 0, length);
    }

    public byte[] getBytes() {
        return this.aidBytes;
    }

    public int getLength() {
        return this.aidBytes.length;
    }

    public String toString() {
        return HexUtils.bin2hex(this.aidBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.aidBytes);
    }

    public boolean equals(Object o) {
        if (o instanceof AID) {
            return Arrays.equals(((AID)o).aidBytes, this.aidBytes);
        }
        return false;
    }
}

