/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.remote.JSONMessagePipe;
import apdu4j.remote.RemoteTerminal;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteTerminalThread
implements Runnable,
JSONMessagePipe {
    private static Logger logger = LoggerFactory.getLogger(RemoteTerminalThread.class);
    private BlockingQueue<Map<String, Object>> toThread;
    private BlockingQueue<Map<String, Object>> fromThread;
    protected String session;
    private long timeout_minutes = 3L;
    protected RemoteTerminal terminal;

    void setQueues(BlockingQueue<Map<String, Object>> in, BlockingQueue<Map<String, Object>> out) {
        this.toThread = in;
        this.fromThread = out;
        this.terminal = new RemoteTerminal(this);
    }

    void setTimeout(long minutes) {
        this.timeout_minutes = minutes;
    }

    void setSession(String session) {
        this.session = session;
    }

    @Override
    public void send(Map<String, Object> msg) throws IOException {
        logger.trace("sending: {}", (Object)new JSONObject(msg).toJSONString());
        if (!this.fromThread.offer(msg)) {
            throw new IOException("Output queue is full");
        }
    }

    @Override
    public Map<String, Object> recv() throws IOException {
        logger.trace("receiving ...");
        try {
            Map<String, Object> msg = this.toThread.poll(this.timeout_minutes, TimeUnit.MINUTES);
            if (msg == null) {
                logger.warn("Timeout");
                throw new IOException("Timeout");
            }
            logger.trace("received: {}", (Object)new JSONObject(msg).toJSONString());
            return msg;
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted", (Throwable)e);
            throw new IOException("Interrupted", e);
        }
    }

    @Override
    public abstract void run();

    @Override
    public void close() {
    }
}

