/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.HexUtils;
import apdu4j.remote.JSONCardTerminal;
import apdu4j.remote.JSONMessagePipe;
import apdu4j.remote.JSONProtocol;
import java.io.IOException;
import java.util.Map;
import javax.smartcardio.CardTerminal;

public class RemoteTerminal {
    private final JSONMessagePipe pipe;
    private final CardTerminal terminal;
    public String lang = "en";

    public RemoteTerminal(JSONMessagePipe pipe) {
        this.pipe = pipe;
        this.terminal = new JSONCardTerminal(pipe);
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public Map<String, Object> start() throws IOException {
        Map<String, Object> m = this.pipe.recv();
        if (m.containsKey("cmd") && m.get("cmd").equals("START")) {
            if (m.containsKey("lang") && m.get("lang").toString().matches("\\p{Lower}{2}")) {
                this.lang = (String)m.get("lang");
            }
            return m;
        }
        throw new IOException("Invalid START message");
    }

    public void statusMessage(String text) throws IOException {
        Map<String, Object> m = JSONProtocol.cmd("message");
        m.put("text", text);
        this.pipe.send(m);
        if (!JSONProtocol.check(m, this.pipe.recv())) {
            throw new IOException("Could not display status");
        }
    }

    public Button dialog(String message) throws IOException, UserCancelExcption {
        Map<String, Object> m = JSONProtocol.cmd("dialog");
        m.put("text", message);
        this.pipe.send(m);
        Map<String, Object> r = this.pipe.recv();
        if (!JSONProtocol.check(m, r) || !r.containsKey("button")) {
            throw new IOException("Unknown button pressed");
        }
        return Button.valueOf(((String)r.get("button")).toUpperCase());
    }

    public String input(String message) throws IOException, UserCancelExcption {
        Map<String, Object> m = JSONProtocol.cmd("input");
        m.put("text", message);
        this.pipe.send(m);
        Map<String, Object> r = this.pipe.recv();
        if (!JSONProtocol.check(m, r) || !r.containsKey("value")) {
            throw new IOException("No value");
        }
        return (String)r.get("value");
    }

    public int select(String message, Map<Integer, String> choices) throws IOException, UserCancelExcption {
        Map<String, Object> m = JSONProtocol.cmd("select");
        for (Map.Entry<Integer, String> e : choices.entrySet()) {
            m.put(e.getKey().toString(), e.getValue());
        }
        m.put("text", message);
        this.pipe.send(m);
        Map<String, Object> r = this.pipe.recv();
        if (!JSONProtocol.check(m, r) || !r.containsKey("value")) {
            throw new IOException("No value");
        }
        try {
            return Integer.valueOf((String)r.get("value"));
        }
        catch (NumberFormatException e) {
            throw new IOException("Choice was not numeric", e);
        }
    }

    public Button decrypt(String message, byte[] apdu) throws IOException, UserCancelExcption {
        Map<String, Object> m = JSONProtocol.cmd("decrypt");
        m.put("text", message);
        m.put("bytes", HexUtils.bin2hex(apdu));
        this.pipe.send(m);
        Map<String, Object> r = this.pipe.recv();
        if (JSONProtocol.check(m, r)) {
            return Button.valueOf(((String)r.get("button")).toUpperCase());
        }
        throw new IOException("Unknown button pressed");
    }

    public boolean verifyPIN(int p2, String text) throws IOException, UserCancelExcption {
        Map<String, Object> m = JSONProtocol.cmd("verify");
        m.put("p2", p2);
        m.put("text", text);
        this.pipe.send(m);
        return JSONProtocol.check(m, this.pipe.recv());
    }

    public void stop(String message) {
        try {
            Map<String, Object> m = JSONProtocol.cmd("stop");
            m.put("text", message);
            this.pipe.send(m);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    public void close() {
        this.pipe.close();
    }

    public static enum Button {
        RED,
        GREEN,
        YELLOW;

    }

    public static class UserCancelExcption
    extends Exception {
        public UserCancelExcption(String message) {
            super(message);
        }
    }
}

