/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.APDUReplayProvider;
import apdu4j.HexUtils;
import apdu4j.LoggingCardTerminal;
import apdu4j.TerminalManager;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.crypto.Cipher;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.TerminalFactory;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import pro.javacard.gp.AID;
import pro.javacard.gp.ArgMatchers;
import pro.javacard.gp.CapFile;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeySet;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPRegistryEntryApp;
import pro.javacard.gp.GPRegistryEntryPkg;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.PlaintextKeys;

public final class GPTool {
    private static final String OPT_APDU = "apdu";
    private static final String OPT_APPLET = "applet";
    private static final String OPT_BS = "bs";
    private static final String OPT_CAP = "cap";
    private static final String OPT_CREATE = "create";
    private static final String OPT_DEBUG = "debug";
    private static final String OPT_DEFAULT = "default";
    private static final String OPT_DELETE = "delete";
    private static final String OPT_DOMAIN = "domain";
    private static final String OPT_DUMP = "dump";
    private static final String OPT_EMV = "emv";
    private static final String OPT_FORCE = "force";
    private static final String OPT_INFO = "info";
    private static final String OPT_INITIALIZED = "initialized";
    private static final String OPT_INSTALL = "install";
    private static final String OPT_KCV = "kcv";
    private static final String OPT_KEY = "key";
    private static final String OPT_KEY_ENC = "key-enc";
    private static final String OPT_KEY_ID = "keyid";
    private static final String OPT_KEY_KEK = "key-kek";
    private static final String OPT_KEY_MAC = "key-mac";
    private static final String OPT_KEY_VERSION = "keyver";
    private static final String OPT_LIST = "list";
    private static final String OPT_LIST_PRIVS = "list-privs";
    private static final String OPT_LOAD = "load";
    private static final String OPT_LOCK = "lock";
    private static final String OPT_LOCK_APPLET = "lock-applet";
    private static final String OPT_LOCK_CARD = "lock-card";
    private static final String OPT_MAKE_DEFAULT = "make-default";
    private static final String OPT_NEW_KEY_VERSION = "new-keyver";
    private static final String OPT_OP201 = "op201";
    private static final String OPT_PACKAGE = "package";
    private static final String OPT_PARAMS = "params";
    private static final String OPT_PKG = "pkg";
    private static final String OPT_PRIVS = "privs";
    private static final String OPT_READER = "reader";
    private static final String OPT_RELAX = "relax";
    private static final String OPT_REPLAY = "replay";
    private static final String OPT_SC_MODE = "mode";
    private static final String OPT_SCP = "scp";
    private static final String OPT_SDAID = "sdaid";
    private static final String OPT_SECURE_APDU = "secure-apdu";
    private static final String OPT_SECURED = "secured";
    private static final String OPT_STORE_DATA = "store-data";
    private static final String OPT_TERMINALS = "terminals";
    private static final String OPT_TERMINATE = "terminate";
    private static final String OPT_UNINSTALL = "uninstall";
    private static final String OPT_UNLOCK = "unlock";
    private static final String OPT_UNLOCK_APPLET = "unlock-applet";
    private static final String OPT_UNLOCK_CARD = "unlock-card";
    private static final String OPT_VERBOSE = "verbose";
    private static final String OPT_VERSION = "version";
    private static final String OPT_VIRGIN = "virgin";
    private static final String OPT_VISA2 = "visa2";

    private static OptionSet parseArguments(String[] argv) throws IOException {
        OptionSet args = null;
        OptionParser parser = new OptionParser();
        parser.acceptsAll(Arrays.asList("V", OPT_VERSION), "Show information about the program");
        parser.acceptsAll(Arrays.asList("h", "help"), "Shows this help string").forHelp();
        parser.acceptsAll(Arrays.asList("d", OPT_DEBUG), "Show PC/SC and APDU trace");
        parser.acceptsAll(Arrays.asList("v", OPT_VERBOSE), "Be verbose about operations");
        parser.acceptsAll(Arrays.asList("r", OPT_READER), "Use specific reader").withRequiredArg();
        parser.acceptsAll(Arrays.asList("l", OPT_LIST), "List the contents of the card");
        parser.acceptsAll(Arrays.asList("i", OPT_INFO), "Show information");
        parser.acceptsAll(Arrays.asList("a", OPT_APDU), "Send raw APDU (hex)").withRequiredArg().withValuesConvertedBy(ArgMatchers.hex());
        parser.acceptsAll(Arrays.asList("s", OPT_SECURE_APDU), "Send raw APDU (hex) via SCP").withRequiredArg().withValuesConvertedBy(ArgMatchers.hex());
        parser.acceptsAll(Arrays.asList("f", OPT_FORCE), "Force operation");
        parser.accepts(OPT_DUMP, "Dump APDU communication to <File>").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_REPLAY, "Replay APDU responses from <File>").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_RELAX, "Relaxed error checking");
        parser.accepts(OPT_TERMINALS, "Use PC/SC provider from <jar:class>").withRequiredArg();
        parser.accepts(OPT_CAP, "Use a CAP file as source").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_LOAD, "Load a CAP file").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_INSTALL, "Install applet(s) from CAP").withOptionalArg().ofType(File.class);
        parser.accepts(OPT_PARAMS, "Installation parameters").withRequiredArg().withValuesConvertedBy(ArgMatchers.hex());
        parser.accepts(OPT_PRIVS, "Specify privileges for installation").withRequiredArg();
        parser.accepts(OPT_LIST_PRIVS, "List known privileges");
        parser.accepts(OPT_UNINSTALL, "Uninstall applet/package").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_DEFAULT, "Indicate Default Selected privilege");
        parser.accepts(OPT_TERMINATE, "Indicate Card Lock+Terminate privilege");
        parser.accepts(OPT_DOMAIN, "Create supplementary security domain").withRequiredArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_LOCK_APPLET, "Lock specified applet").withRequiredArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_UNLOCK_APPLET, "Unlock specified applet").withRequiredArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_LOCK_CARD, "Lock card");
        parser.accepts(OPT_UNLOCK_CARD, "Unlock card");
        parser.accepts(OPT_SECURED, "Transition SD to SECURED state").withOptionalArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_INITIALIZED, "Transition SD to INITIALIZED state").withOptionalArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_STORE_DATA, "STORE DATA to applet").withRequiredArg().withValuesConvertedBy(ArgMatchers.hex());
        parser.accepts(OPT_MAKE_DEFAULT, "Make AID the default").withRequiredArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_DELETE, "Delete applet/package").withOptionalArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_CREATE, "Create new instance of an applet").withRequiredArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_APPLET, "Applet AID").withRequiredArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.acceptsAll(Arrays.asList(OPT_PKG, OPT_PACKAGE), "Package AID").withRequiredArg().withValuesConvertedBy(ArgMatchers.aid());
        parser.accepts(OPT_KEY, "Specify card (master) key").withRequiredArg().withValuesConvertedBy(ArgMatchers.key());
        parser.accepts(OPT_KCV, "Specify key check value").withRequiredArg().withValuesConvertedBy(ArgMatchers.hex());
        parser.accepts(OPT_KEY_MAC, "Specify MAC key").withRequiredArg().withValuesConvertedBy(ArgMatchers.key());
        parser.accepts(OPT_KEY_ENC, "Specify ENC key").withRequiredArg().withValuesConvertedBy(ArgMatchers.key());
        parser.accepts(OPT_KEY_KEK, "Specify KEK key").withRequiredArg().withValuesConvertedBy(ArgMatchers.key());
        parser.accepts(OPT_EMV, "Use EMV diversification");
        parser.accepts(OPT_VISA2, "Use VISA2 diversification");
        parser.accepts(OPT_KEY_ID, "Specify key ID").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_KEY_VERSION, "Specify key version").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_LOCK, "Set new key").withRequiredArg().withValuesConvertedBy(ArgMatchers.keyset());
        parser.accepts(OPT_UNLOCK, "Set default key");
        parser.accepts(OPT_SCP, "Force the use of SCP0X").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_NEW_KEY_VERSION, "key version for the new key").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_VIRGIN, "Card has virgin keys");
        parser.accepts(OPT_SC_MODE, "Secure channel to use (mac/enc/clr)").withRequiredArg().withValuesConvertedBy(ArgMatchers.mode());
        parser.accepts(OPT_BS, "maximum APDU payload size").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_OP201, "Enable OpenPlatform 2.0.1 mode");
        parser.accepts(OPT_SDAID, "ISD AID").withRequiredArg().withValuesConvertedBy(ArgMatchers.aid());
        try {
            args = parser.parse(argv);
        }
        catch (OptionException e) {
            if (e.getCause() != null) {
                System.err.println(e.getMessage() + ": " + e.getCause().getMessage());
            } else {
                System.err.println(e.getMessage());
            }
            System.err.println();
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (args.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        PlaintextKeys keys;
        Object given;
        OptionSet args = GPTool.parseArguments(argv);
        if (args.has(OPT_VERBOSE)) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", OPT_DEBUG);
            System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
            System.setProperty("org.slf4j.simpleLogger.showShortLogName", "true");
            System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "warn");
        }
        if (args.has(OPT_VERSION) || args.has(OPT_VERBOSE) || args.has(OPT_DEBUG) || args.has(OPT_INFO)) {
            String version = GlobalPlatform.getVersion();
            version = version + "\nRunning on " + System.getProperty("os.name");
            version = version + " " + System.getProperty("os.version");
            version = version + " " + System.getProperty("os.arch");
            version = version + ", Java " + System.getProperty("java.version");
            version = version + " by " + System.getProperty("java.vendor");
            System.out.println("GlobalPlatformPro " + version);
            if (Cipher.getMaxAllowedKeyLength("AES") == 128) {
                System.out.println("Unlimited crypto policy is NOT installed!");
            }
        }
        GPKeySet.Diversification div = GPKeySet.Diversification.NONE;
        if (args.has(OPT_VISA2)) {
            div = GPKeySet.Diversification.VISA2;
        } else if (args.has(OPT_EMV)) {
            div = GPKeySet.Diversification.EMV;
        }
        if (args.has(OPT_KEY) || args.has(OPT_KEY_MAC) || args.has(OPT_KEY_ENC) || args.has(OPT_KEY_KEK)) {
            GPKeySet ks;
            if (args.has(OPT_KEY)) {
                GPKeySet.GPKey k = (GPKeySet.GPKey)args.valueOf(OPT_KEY);
                if (args.has(OPT_KCV)) {
                    byte[] expected;
                    given = (byte[])args.valueOf(OPT_KCV);
                    if (k.getType() == GPKeySet.GPKey.Type.DES3) {
                        expected = GPCrypto.kcv_3des(k);
                    } else if (k.getType() == GPKeySet.GPKey.Type.AES) {
                        expected = GPCrypto.scp03_key_check_value(k);
                    } else {
                        GPTool.fail("Don't know how to compute KCV for " + (Object)((Object)k.getType()));
                        return;
                    }
                    if (!Arrays.equals((byte[])given, expected)) {
                        GPTool.fail("KCV does not match, expected " + HexUtils.bin2hex(expected) + " but given " + HexUtils.bin2hex((byte[])given));
                    }
                }
                ks = new GPKeySet(k);
            } else {
                System.out.println("ATTENTION: Overriding default keys ...");
                ks = new GPKeySet(GPData.defaultKey);
                if (args.has(OPT_KEY_MAC)) {
                    ks.setKey(GPData.KeyType.MAC, (GPKeySet.GPKey)args.valueOf(OPT_KEY_MAC));
                }
                if (args.has(OPT_KEY_ENC)) {
                    ks.setKey(GPData.KeyType.ENC, (GPKeySet.GPKey)args.valueOf(OPT_KEY_ENC));
                }
                if (args.has(OPT_KEY_KEK)) {
                    ks.setKey(GPData.KeyType.KEK, (GPKeySet.GPKey)args.valueOf(OPT_KEY_KEK));
                }
            }
            if (args.has(OPT_KEY_ID)) {
                ks.setKeyID((Integer)args.valueOf(OPT_KEY_ID));
            }
            if (args.has(OPT_KEY_VERSION)) {
                ks.setKeyVersion((Integer)args.valueOf(OPT_KEY_VERSION));
            }
            keys = PlaintextKeys.fromKeySet(ks);
        } else {
            keys = PlaintextKeys.fromMasterKey(GPData.defaultKey, div);
        }
        CapFile cap = null;
        if (args.has(OPT_CAP)) {
            File capfile = (File)args.valueOf(OPT_CAP);
            cap = new CapFile(new FileInputStream(capfile));
            if (args.has(OPT_VERBOSE) || args.has(OPT_INFO)) {
                System.out.println("**** CAP info of " + capfile.getName());
                cap.dump(System.out);
            }
        }
        if (args.has(OPT_LIST_PRIVS)) {
            System.out.println("# Known privileges:");
            System.out.println(Joiner.on((String)"\n").join((Object[])GPRegistryEntry.Privilege.values()));
        }
        try {
            List<CardTerminal> do_readers;
            TerminalFactory tf;
            if (args.has(OPT_REPLAY)) {
                File f = (File)args.valueOf(OPT_REPLAY);
                tf = TerminalFactory.getInstance("PC/SC", (Object)new FileInputStream(f), new APDUReplayProvider());
            } else {
                tf = TerminalManager.getTerminalFactory((String)args.valueOf(OPT_TERMINALS));
            }
            CardTerminals terminals = tf.terminals();
            if (args.has(OPT_DEBUG)) {
                System.out.println("# Detected readers from " + tf.getProvider().getName());
                given = terminals.list().iterator();
                while (given.hasNext()) {
                    CardTerminal term = (CardTerminal)given.next();
                    System.out.println((term.isCardPresent() ? "[*] " : "[ ] ") + term.getName());
                }
            }
            if (args.has(OPT_READER) || System.getenv("GP_READER") != null) {
                CardTerminal t;
                String reader = System.getenv("GP_READER");
                if (args.has(OPT_READER)) {
                    reader = (String)args.valueOf(OPT_READER);
                }
                if ((t = terminals.getTerminal(reader)) == null) {
                    GPTool.fail("Reader \"" + reader + "\" not found.");
                }
                do_readers = Arrays.asList(t);
            } else {
                do_readers = terminals.list(CardTerminals.State.CARD_PRESENT);
            }
            if (do_readers.size() == 0) {
                GPTool.fail("No smart card readers with a card found");
            }
            for (CardTerminal reader : do_readers) {
                if (do_readers.size() > 1) {
                    System.out.println("# " + reader.getName());
                }
                if (args.has(OPT_DEBUG)) {
                    FileOutputStream o = null;
                    if (args.has(OPT_DUMP)) {
                        File f = (File)args.valueOf(OPT_DUMP);
                        o = new FileOutputStream(f);
                    }
                    reader = LoggingCardTerminal.getInstance(reader, o);
                }
                Card card = null;
                try {
                    Object instanceAID;
                    AID appletAID;
                    AID packageAID;
                    GPRegistryEntry.Privileges privs;
                    CapFile instcap;
                    File capfile;
                    try {
                        card = reader.connect("*");
                        card.beginExclusive();
                    }
                    catch (CardException e) {
                        System.err.println("Could not connect to " + reader.getName() + ": " + TerminalManager.getExceptionMessage(e));
                        if (card == null) continue;
                        card.endExclusive();
                        card.disconnect(true);
                        card = null;
                        continue;
                    }
                    GlobalPlatform gp = new GlobalPlatform(card.getBasicChannel());
                    if (args.has(OPT_OP201)) {
                        gp.setSpec(GlobalPlatform.GPSpec.OP201);
                    }
                    gp.setStrict(!args.has(OPT_RELAX));
                    if (args.has(OPT_BS)) {
                        gp.setBlockSize((Integer)args.valueOf(OPT_BS));
                    }
                    if (args.has(OPT_INFO) || args.has(OPT_VERBOSE)) {
                        System.out.println("Reader: " + reader.getName());
                        System.out.println("ATR: " + HexUtils.bin2hex(card.getATR().getBytes()));
                        System.out.println("More information about your card:");
                        System.out.println("    http://smartcard-atr.appspot.com/parse?ATR=" + HexUtils.bin2hex(card.getATR().getBytes()));
                        System.out.println();
                    }
                    if (args.has(OPT_APDU)) {
                        for (Object s : args.valuesOf(OPT_APDU)) {
                            CommandAPDU c = new CommandAPDU((byte[])s);
                            card.getBasicChannel().transmit(c);
                        }
                    }
                    gp.select((AID)args.valueOf(OPT_SDAID));
                    if (args.has(OPT_INFO)) {
                        System.out.println("***** Card info:");
                        GPData.print_card_info(gp);
                    }
                    if (!GPTool.needsAuthentication(args)) continue;
                    Object mode = GlobalPlatform.defaultMode.clone();
                    if (args.has(OPT_SC_MODE)) {
                        ((AbstractCollection)mode).clear();
                        ((AbstractCollection)mode).add((GlobalPlatform.APDUMode)((Object)args.valueOf(OPT_SC_MODE)));
                    }
                    int scp_version = 0;
                    if (args.has(OPT_SCP)) {
                        scp_version = (Integer)args.valueOf(OPT_SCP);
                    }
                    gp.openSecureChannel(keys, null, scp_version, (EnumSet<GlobalPlatform.APDUMode>)mode);
                    if (args.has(OPT_SECURE_APDU)) {
                        for (Object s : args.valuesOf(OPT_SECURE_APDU)) {
                            CommandAPDU c = new CommandAPDU((byte[])s);
                            gp.transmit(c);
                        }
                    }
                    if (args.has(OPT_DELETE)) {
                        GPRegistry reg = gp.getRegistry();
                        if (args.has(OPT_DEFAULT) && reg.getDefaultSelectedAID() != null) {
                            if (reg.getDefaultSelectedPackageAID() != null) {
                                gp.deleteAID(reg.getDefaultSelectedPackageAID(), true);
                            } else {
                                System.err.println("Could not identify default selected application!");
                            }
                        }
                        List aids = args.valuesOf(OPT_DELETE);
                        for (AID aid : aids) {
                            try {
                                gp.deleteAID(aid, reg.allPackageAIDs().contains(aid) || args.has(OPT_FORCE));
                            }
                            catch (GPException e) {
                                if (!gp.getRegistry().allAIDs().contains(aid)) {
                                    System.err.println("Could not delete AID (not present on card): " + aid);
                                    continue;
                                }
                                System.err.println("Could not delete AID: " + aid);
                                if (e.sw == 27013) {
                                    System.err.println("Deletion not allowed. Some app still active?");
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                    if (args.has(OPT_UNINSTALL)) {
                        capfile = (File)args.valueOf(OPT_UNINSTALL);
                        instcap = new CapFile(new FileInputStream(capfile));
                        AID aid = instcap.getPackageAID();
                        if (!gp.getRegistry().allAIDs().contains(aid)) {
                            System.out.println(aid + " is not present on card!");
                        } else {
                            gp.deleteAID(aid, true);
                            System.out.println(aid + " deleted.");
                        }
                    }
                    if (args.has(OPT_LOAD)) {
                        capfile = (File)args.valueOf(OPT_LOAD);
                        CapFile loadcap = new CapFile(new FileInputStream(capfile));
                        if (args.has(OPT_VERBOSE)) {
                            loadcap.dump(System.out);
                        }
                        try {
                            gp.loadCapFile(loadcap);
                        }
                        catch (GPException e) {
                            if (e.sw == 27013) {
                                System.err.println("Applet loading failed. Are you sure the CAP file target is compatible with your card?");
                            }
                            throw e;
                        }
                    }
                    if (args.has(OPT_INSTALL)) {
                        capfile = (File)args.valueOf(OPT_INSTALL);
                        instcap = new CapFile(new FileInputStream(capfile));
                        if (args.has(OPT_VERBOSE)) {
                            instcap.dump(System.out);
                        }
                        if (instcap.getAppletAIDs().size() == 0) {
                            GPTool.fail("No applets in CAP, use --load instead");
                        }
                        if (instcap.getAppletAIDs().size() > 1) {
                            GPTool.fail("CAP contains more than one applet, create instances manually with --load and --create");
                        }
                        GPRegistry reg = gp.getRegistry();
                        privs = GPTool.getInstPrivs(args);
                        if (args.has(OPT_FORCE) && reg.getDefaultSelectedAID() != null && privs.has(GPRegistryEntry.Privilege.CardReset)) {
                            gp.deleteAID(reg.getDefaultSelectedAID(), false);
                        }
                        if (args.has(OPT_FORCE) && reg.allPackageAIDs().contains(instcap.getPackageAID())) {
                            gp.deleteAID(instcap.getPackageAID(), true);
                        }
                        try {
                            gp.loadCapFile(instcap);
                            System.err.println("CAP loaded");
                        }
                        catch (GPException e) {
                            if (e.sw == 27013 || e.sw == 27264) {
                                System.err.println("Applet loading failed. Are you sure the CAP file (JC version, packages) is compatible with your card?");
                            }
                            throw e;
                        }
                        AID appaid = instcap.getAppletAIDs().get(0);
                        if (args.has(OPT_APPLET)) {
                            appaid = (AID)args.valueOf(OPT_APPLET);
                        }
                        if (args.has(OPT_CREATE)) {
                            appaid = (AID)args.valueOf(OPT_CREATE);
                        }
                        if (gp.getRegistry().allAIDs().contains(appaid)) {
                            System.err.println("WARNING: Applet " + appaid + " already present on card");
                        }
                        gp.installAndMakeSelectable(instcap.getPackageAID(), appaid, null, privs, GPTool.getInstParams(args), null);
                    }
                    if (args.has(OPT_CREATE)) {
                        packageAID = null;
                        appletAID = null;
                        if (cap != null) {
                            packageAID = cap.getPackageAID();
                            if (cap.getAppletAIDs().size() != 1) {
                                throw new IllegalArgumentException("There should be only one applet in CAP. Use --applet instead.");
                            }
                            appletAID = cap.getAppletAIDs().get(0);
                        }
                        if (args.has(OPT_PACKAGE)) {
                            packageAID = (AID)args.valueOf(OPT_PACKAGE);
                        }
                        if (args.has(OPT_APPLET)) {
                            appletAID = (AID)args.valueOf(OPT_APPLET);
                        }
                        if (packageAID == null || appletAID == null) {
                            throw new IllegalArgumentException("Need --package and --applet or --cap");
                        }
                        instanceAID = (AID)args.valueOf(OPT_CREATE);
                        gp.installAndMakeSelectable(packageAID, appletAID, (AID)instanceAID, GPTool.getInstPrivs(args), GPTool.getInstParams(args), null);
                    }
                    if (args.has(OPT_DOMAIN)) {
                        packageAID = new AID("A0000001515350");
                        appletAID = new AID("A000000151535041");
                        if (args.has(OPT_PACKAGE) && args.has(OPT_APPLET)) {
                            packageAID = (AID)args.valueOf(OPT_PACKAGE);
                            appletAID = (AID)args.valueOf(OPT_APPLET);
                        } else {
                            System.out.println("Note: using default AID-s for SSD: " + appletAID + " from " + packageAID);
                        }
                        instanceAID = (AID)args.valueOf(OPT_DOMAIN);
                        privs = GPTool.getInstPrivs(args);
                        privs.add(GPRegistryEntry.Privilege.SecurityDomain);
                        gp.installAndMakeSelectable(packageAID, appletAID, (AID)instanceAID, privs, null, null);
                    }
                    if (args.has(OPT_STORE_DATA)) {
                        if (args.has(OPT_APPLET)) {
                            gp.storeData((AID)args.valueOf(OPT_APPLET), (byte[])args.valueOf(OPT_STORE_DATA));
                        } else {
                            System.err.println("Must specify target application with -applet");
                        }
                    }
                    if (args.has(OPT_LOCK_CARD)) {
                        gp.setCardStatus((byte)127);
                    }
                    if (args.has(OPT_UNLOCK_CARD)) {
                        gp.setCardStatus((byte)15);
                    }
                    if (args.has(OPT_INITIALIZED)) {
                        gp.setCardStatus((byte)7);
                    }
                    if (args.has(OPT_SECURED)) {
                        gp.setCardStatus((byte)15);
                    }
                    if (args.has(OPT_LOCK_APPLET)) {
                        gp.lockUnlockApplet((AID)args.valueOf(OPT_LOCK_APPLET), true);
                    }
                    if (args.has(OPT_UNLOCK_APPLET)) {
                        gp.lockUnlockApplet((AID)args.valueOf(OPT_UNLOCK_APPLET), false);
                    }
                    if (args.has(OPT_LIST)) {
                        String tab = "     ";
                        GPRegistry reg = gp.getRegistry();
                        System.out.println("# Mode: " + (Object)((Object)gp.spec));
                        for (GPRegistryEntry e : reg) {
                            AID aid = e.getAID();
                            System.out.print(e.getType().toShortString() + ": " + HexUtils.bin2hex(aid.getBytes()) + " (" + e.getLifeCycleString() + ")");
                            if (e.getType() != GPRegistryEntry.Kind.IssuerSecurityDomain && args.has(OPT_VERBOSE)) {
                                System.out.println(" (" + GPUtils.byteArrayToReadableString(aid.getBytes()) + ")");
                            } else {
                                System.out.println();
                            }
                            if (e.getDomain() != null) {
                                System.out.println(tab + "Parent:  " + e.getDomain());
                            }
                            if (e.getType() == GPRegistryEntry.Kind.ExecutableLoadFile) {
                                GPRegistryEntryPkg pkg = (GPRegistryEntryPkg)e;
                                if (pkg.getVersion() != null) {
                                    System.out.println(tab + "Version: " + pkg.getVersionString());
                                }
                                for (AID a : pkg.getModules()) {
                                    System.out.print(tab + "Applet:  " + HexUtils.bin2hex(a.getBytes()));
                                    if (args.has(OPT_VERBOSE)) {
                                        System.out.println(" (" + GPUtils.byteArrayToReadableString(a.getBytes()) + ")");
                                        continue;
                                    }
                                    System.out.println();
                                }
                            } else {
                                GPRegistryEntryApp app = (GPRegistryEntryApp)e;
                                if (app.getLoadFile() != null) {
                                    System.out.println(tab + "From:    " + app.getLoadFile());
                                }
                                if (!app.getPrivileges().isEmpty()) {
                                    System.out.println(tab + "Privs:   " + app.getPrivileges());
                                }
                            }
                            System.out.println();
                        }
                    }
                    if (args.has(OPT_UNLOCK)) {
                        ArrayList<GPKeySet.GPKey> newkeys = new ArrayList<GPKeySet.GPKey>();
                        List<GPKeySet.GPKey> current = gp.getKeyInfoTemplate();
                        if (current.size() != 3) {
                            throw new GPException("Template has bad length!");
                        }
                        GPKeySet.GPKey new_key = new GPKeySet.GPKey(GPData.defaultKeyBytes, gp.getSCPVersion() == 3 ? GPKeySet.GPKey.Type.AES : GPKeySet.GPKey.Type.DES3);
                        newkeys.add(new GPKeySet.GPKey(1, current.get(0).getID(), new_key));
                        newkeys.add(new GPKeySet.GPKey(1, current.get(1).getID(), new_key));
                        newkeys.add(new GPKeySet.GPKey(1, current.get(2).getID(), new_key));
                        if (args.has(OPT_VIRGIN)) {
                            gp.putKeys(newkeys, false);
                        } else {
                            gp.putKeys(newkeys, true);
                        }
                        System.out.println("Default " + new_key.toStringKey() + " set as master key.");
                    }
                    if (args.has(OPT_LOCK)) {
                        PlaintextKeys newkey = (PlaintextKeys)args.valueOf(OPT_LOCK);
                        GPKeySet newkeys = new GPKeySet(newkey.master);
                        if (newkey.diversifier != GPKeySet.Diversification.NONE) {
                            newkeys = PlaintextKeys.diversify(newkeys, gp.getDiversificationData(), newkey.diversifier, gp.getSCPVersion());
                        }
                        int new_version = 1;
                        if (args.has(OPT_NEW_KEY_VERSION)) {
                            new_version = (Integer)args.valueOf(OPT_NEW_KEY_VERSION);
                        }
                        ArrayList<GPKeySet.GPKey> updatekeys = new ArrayList<GPKeySet.GPKey>();
                        updatekeys.add(new GPKeySet.GPKey(new_version, 1, newkeys.getKey(GPData.KeyType.ENC)));
                        updatekeys.add(new GPKeySet.GPKey(new_version, 2, newkeys.getKey(GPData.KeyType.MAC)));
                        updatekeys.add(new GPKeySet.GPKey(new_version, 3, newkeys.getKey(GPData.KeyType.KEK)));
                        if (args.has(OPT_VIRGIN)) {
                            gp.putKeys(updatekeys, false);
                        } else {
                            gp.putKeys(updatekeys, true);
                        }
                        System.out.println("Card locked with: " + newkey.master.toStringKey());
                        if (newkey.diversifier != GPKeySet.Diversification.NONE) {
                            System.out.println("Remember to use " + newkey.diversifier.name() + " diversification!");
                        }
                        System.out.println("Write this down, DO NOT FORGET/LOSE IT!");
                    }
                    if (!args.has(OPT_MAKE_DEFAULT)) continue;
                    gp.makeDefaultSelected((AID)args.valueOf(OPT_MAKE_DEFAULT));
                }
                catch (GPException e) {
                    if (args.has(OPT_VERBOSE)) {
                        e.printStackTrace(System.err);
                    }
                    if (args.has(OPT_RELAX)) continue;
                    GPTool.fail(e.getMessage());
                }
                catch (CardException e) {}
                continue;
                finally {
                    if (card == null) continue;
                    card.endExclusive();
                    card.disconnect(true);
                    card = null;
                }
            }
        }
        catch (CardException e) {
            if (TerminalManager.getExceptionMessage(e) != null) {
                System.out.println("PC/SC failure: " + TerminalManager.getExceptionMessage(e));
            }
            e.printStackTrace();
            GPTool.fail("CardException, terminating");
        }
        System.exit(0);
    }

    private static GPRegistryEntry.Privileges getInstPrivs(OptionSet args) {
        GPRegistryEntry.Privileges privs = new GPRegistryEntry.Privileges();
        if (args.has(OPT_PRIVS)) {
            GPTool.addPrivs(privs, (String)args.valueOf(OPT_PRIVS));
        }
        if (args.has(OPT_DEFAULT)) {
            privs.add(GPRegistryEntry.Privilege.CardReset);
        }
        if (args.has(OPT_TERMINATE)) {
            privs.add(GPRegistryEntry.Privilege.CardLock);
            privs.add(GPRegistryEntry.Privilege.CardTerminate);
        }
        return privs;
    }

    private static GPRegistryEntry.Privileges addPrivs(GPRegistryEntry.Privileges privs, String v) {
        String[] parts;
        for (String s : parts = v.split(",")) {
            boolean found = false;
            for (GPRegistryEntry.Privilege p : GPRegistryEntry.Privilege.values()) {
                if (!s.trim().equalsIgnoreCase(p.name())) continue;
                found = true;
                privs.add(p);
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Unknown privilege: " + s.trim());
        }
        return privs;
    }

    private static byte[] getInstParams(OptionSet args) {
        byte[] params = null;
        if (args.has(OPT_PARAMS) && (params = (byte[])args.valueOf(OPT_PARAMS))[0] != -55) {
            byte[] newparams = new byte[params.length + 2];
            newparams[0] = -55;
            newparams[1] = (byte)params.length;
            System.arraycopy(params, 0, newparams, 2, params.length);
            params = newparams;
        }
        return params;
    }

    private static boolean needsAuthentication(OptionSet args) {
        if (args.has(OPT_LIST) || args.has(OPT_LOAD) || args.has(OPT_INSTALL)) {
            return true;
        }
        if (args.has(OPT_DELETE) || args.has(OPT_CREATE)) {
            return true;
        }
        if (args.has(OPT_LOCK) || args.has(OPT_UNLOCK) || args.has(OPT_MAKE_DEFAULT)) {
            return true;
        }
        if (args.has(OPT_UNINSTALL) || args.has(OPT_SECURE_APDU) || args.has(OPT_DOMAIN)) {
            return true;
        }
        if (args.has(OPT_LOCK_CARD) || args.has(OPT_UNLOCK_CARD) || args.has(OPT_LOCK_APPLET) || args.has(OPT_UNLOCK_APPLET)) {
            return true;
        }
        return args.has(OPT_STORE_DATA) || args.has(OPT_INITIALIZED) || args.has(OPT_SECURED);
    }

    private static void fail(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

