/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.smartcardio.CardException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERApplicationSpecific;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeySet;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.TLVUtils;

public final class GPData {
    public static final byte[] defaultKeyBytes = new byte[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    public static final GPKeySet.GPKey defaultKey = new GPKeySet.GPKey(defaultKeyBytes, GPKeySet.GPKey.Type.DES3);
    public static final byte readyStatus = 1;
    public static final byte initializedStatus = 7;
    public static final byte securedStatus = 15;
    public static final byte lockedStatus = 127;
    public static final byte terminatedStatus = -1;
    @Deprecated
    public static final byte defaultSelectedPriv = 4;
    @Deprecated
    public static final byte cardLockPriv = 16;
    @Deprecated
    public static final byte cardTerminatePriv = 8;
    @Deprecated
    public static final byte securityDomainPriv = -128;

    public static String get_key_type_coding_string(int type) {
        if (0 <= type && type <= 127) {
            return "Reserved for private use";
        }
        if (128 == type) {
            return "DES - mode (ECB/CBC) implicitly known";
        }
        if (129 == type) {
            return "Reserved (Triple DES)";
        }
        if (130 == type) {
            return "Triple DES in CBC mode";
        }
        if (131 == type) {
            return "DES in ECB mode";
        }
        if (132 == type) {
            return "DES in CBC mode";
        }
        if (133 == type) {
            return "Pre-Shared Key for Transport Layer Security";
        }
        if (136 == type) {
            return "AES (16, 24, or 32 long keys)";
        }
        if (144 == type) {
            return "HMAC-SHA1 - length of HMAC is implicitly known";
        }
        if (145 == type) {
            return "MAC-SHA1-160 - length of HMAC is 160 bits";
        }
        if (type == 134 || type == 135 || 137 <= type && type <= 143 || 146 <= type && type <= 159) {
            return "RFU (asymmetric algorithms)";
        }
        if (160 == type) {
            return "RSA Public Key - public exponent e component (clear text)";
        }
        if (161 == type) {
            return "RSA Public Key - modulus N component (clear text)";
        }
        if (162 == type) {
            return "RSA Private Key - modulus N component";
        }
        if (163 == type) {
            return "RSA Private Key - private exponent d component";
        }
        if (164 == type) {
            return "RSA Private Key - Chinese Remainder P component";
        }
        if (165 == type) {
            return "RSA Private Key - Chinese Remainder Q component";
        }
        if (166 == type) {
            return "RSA Private Key - Chinese Remainder PQ component";
        }
        if (167 == type) {
            return "RSA Private Key - Chinese Remainder DP1 component";
        }
        if (168 == type) {
            return "RSA Private Key - Chinese Remainder DQ1 component";
        }
        if (169 <= type && type <= 254) {
            return "RFU (asymmetric algorithms)";
        }
        if (255 == type) {
            return "Extended Format";
        }
        return "UNKNOWN";
    }

    public static void pretty_print_key_template(List<GPKeySet.GPKey> list, PrintStream out) {
        boolean factory_keys = false;
        out.flush();
        for (GPKeySet.GPKey k : list) {
            out.println("VER:" + k.getVersion() + " ID:" + k.getID() + " TYPE:" + (Object)((Object)k.getType()) + " LEN:" + k.getLength());
            if (k.getVersion() != 0 && k.getVersion() != 255) continue;
            factory_keys = true;
        }
        if (factory_keys) {
            out.println("Key version suggests factory keys");
        }
        out.flush();
    }

    public static List<GPKeySet.GPKey> get_key_template_list(byte[] data) throws GPException {
        ArrayList<GPKeySet.GPKey> r = new ArrayList<GPKeySet.GPKey>();
        try (ASN1InputStream ais = new ASN1InputStream(data);){
            while (ais.available() > 0) {
                DERApplicationSpecific keys = (DERApplicationSpecific)ais.readObject();
                ASN1Sequence seq = (ASN1Sequence)keys.getObject(16);
                for (ASN1Encodable p : Lists.newArrayList((Iterator)seq.iterator())) {
                    DERApplicationSpecific key = (DERApplicationSpecific)p.toASN1Primitive();
                    byte[] tmpl = key.getContents();
                    if (tmpl.length < 4) {
                        throw new GPDataException("Key info template shorter than 4 bytes", tmpl);
                    }
                    int id = tmpl[0] & 0xFF;
                    int version = tmpl[1] & 0xFF;
                    int type = tmpl[2] & 0xFF;
                    int length = tmpl[3] & 0xFF;
                    if (type == 255) {
                        throw new GPDataException("Extended key template not yet supported", tmpl);
                    }
                    r.add(new GPKeySet.GPKey(version, id, length, type));
                }
            }
        }
        catch (IOException | ClassCastException e) {
            throw new GPDataException("Could not parse key template: " + e.getMessage(), e);
        }
        return r;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GlobalPlatform.GPSpec get_version_from_card_data(byte[] data) throws GPException {
        try (ASN1InputStream ais = new ASN1InputStream(data);){
            DERApplicationSpecific tag;
            block28: {
                if (ais.available() <= 0) return GlobalPlatform.GPSpec.GP211;
                DERApplicationSpecific card_data = (DERApplicationSpecific)ais.readObject();
                ASN1Sequence seq = (ASN1Sequence)card_data.getObject(16);
                Iterator iterator = Lists.newArrayList((Iterator)seq.iterator()).iterator();
                while (iterator.hasNext()) {
                    ASN1Encodable p = (ASN1Encodable)iterator.next();
                    if (p instanceof ASN1ObjectIdentifier) {
                        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)p;
                        if (oid.toString().equalsIgnoreCase("1.2.840.114283.1")) continue;
                        throw new GPDataException("Invalid CardRecognitionData: " + oid.toString());
                    }
                    if (!(p instanceof DERApplicationSpecific)) throw new GPDataException("Invalid type in card data", p.toASN1Primitive().getEncoded());
                    tag = (DERApplicationSpecific)p;
                    int n = tag.getApplicationTag();
                    if (n != 0) {
                        continue;
                    }
                    break block28;
                }
                return GlobalPlatform.GPSpec.GP211;
            }
            String oid = ASN1ObjectIdentifier.getInstance((Object)tag.getObject()).toString();
            if (oid.equalsIgnoreCase("1.2.840.114283.2.2.1.1")) {
                GlobalPlatform.GPSpec gPSpec = GlobalPlatform.GPSpec.GP211;
                return gPSpec;
            }
            if (oid.equalsIgnoreCase("1.2.840.114283.2.2.2")) {
                GlobalPlatform.GPSpec gPSpec = GlobalPlatform.GPSpec.GP22;
                return gPSpec;
            }
            if (!oid.equals("1.2.840.114283.2.2.2.1")) throw new GPDataException("Invalid GP version OID: " + oid);
            GlobalPlatform.GPSpec gPSpec = GlobalPlatform.GPSpec.GP22;
            return gPSpec;
        }
        catch (IOException | ClassCastException e) {
            throw new GPDataException("Invalid data: " + e.getMessage());
        }
    }

    public static void pretty_print_card_data(byte[] data, PrintStream out) {
        if (data == null) {
            out.println("NO CARD DATA");
            return;
        }
        try {
            int offset = 0;
            offset = TLVUtils.skipTagAndLength(data, offset, (byte)115);
            while (offset < data.length) {
                int tag = TLVUtils.getTLVTag(data, offset);
                if (tag == 6) {
                    String oid = ASN1ObjectIdentifier.fromByteArray((byte[])TLVUtils.getTLVAsBytes(data, offset)).toString();
                    if (oid.equals("1.2.840.114283.1")) {
                        out.println("GlobalPlatform card");
                    }
                } else if (tag == 96) {
                    out.println("Version: " + GPData.gp_version_from_tlv(data, offset));
                } else if (tag == 99) {
                    out.println("TAG3: " + ASN1ObjectIdentifier.fromByteArray((byte[])TLVUtils.getTLVValueAsBytes(data, offset)));
                } else if (tag == 100) {
                    out.println("SCP version: " + GPData.gp_scp_version_from_tlv(data, offset));
                } else if (tag == 101) {
                    out.println("TAG5: " + ASN1ObjectIdentifier.fromByteArray((byte[])TLVUtils.getTLVValueAsBytes(data, offset)));
                } else if (tag == 102) {
                    out.println("TAG6: " + ASN1ObjectIdentifier.fromByteArray((byte[])TLVUtils.getTLVValueAsBytes(data, offset)));
                } else {
                    out.println("Unknown tag: " + Integer.toHexString(tag));
                }
                offset = TLVUtils.skipAnyTag(data, offset);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String gp_version_from_tlv(byte[] data, int offset) {
        try {
            String oid = ASN1ObjectIdentifier.fromByteArray((byte[])TLVUtils.getTLVValueAsBytes(data, offset)).toString();
            if (oid.startsWith("1.2.840.114283.2")) {
                return oid.substring("1.2.840.114283.2.".length());
            }
            return "unknown";
        }
        catch (IOException e) {
            return "error";
        }
    }

    static String gp_scp_version_from_tlv(byte[] data, int offset) {
        try {
            String oid = ASN1ObjectIdentifier.fromByteArray((byte[])TLVUtils.getTLVValueAsBytes(data, offset)).toString();
            if (oid.startsWith("1.2.840.114283.4")) {
                String[] p = oid.substring("1.2.840.114283.4.".length()).split("\\.");
                return "SCP_0" + p[0] + "_" + String.format("%02x", Integer.valueOf(p[1]));
            }
            return "unknown";
        }
        catch (IOException e) {
            return "error";
        }
    }

    public static void get_global_platform_version(byte[] data) {
        int offset = 0;
        offset = TLVUtils.skipTagAndLength(data, offset, (byte)102);
        offset = TLVUtils.skipTagAndLength(data, offset, (byte)115);
        offset = TLVUtils.findTag(data, offset, (byte)96);
    }

    public static void pretty_print_cplc(byte[] data, PrintStream out) {
        if (data == null) {
            out.println("NO CPLC");
            return;
        }
        CPLC cplc = new CPLC(data);
        out.println(cplc);
    }

    public static void print_card_info(GlobalPlatform gp) throws CardException, GPException {
        GPData.pretty_print_cplc(gp.getCPLC(), System.out);
        System.out.println("***** CARD DATA");
        byte[] card_data = gp.fetchCardData();
        GPData.pretty_print_card_data(card_data, System.out);
        System.out.println("***** KEY INFO");
        GPData.pretty_print_key_template(gp.getKeyInfoTemplate(), System.out);
    }

    public static void main(String[] args) throws Exception {
        GPData.get_version_from_card_data(HexUtils.hex2bin("734A06072A864886FC6B01600C060A2A864886FC6B02020101630906072A864886FC6B03640B06092A864886FC6B040215650B06092B8510864864020103660C060A2B060104012A026E0102"));
    }

    public static final class CPLC {
        private HashMap<Field, byte[]> values = null;

        public CPLC(byte[] data) {
            if (data == null || data.length < 3 || data[2] != 42) {
                throw new IllegalArgumentException("CPLC must be 0x2A bytes long");
            }
            int offset = 3;
            this.values = new HashMap();
            this.values.put(Field.ICFabricator, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICType, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.OperatingSystemID, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.OperatingSystemReleaseDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.OperatingSystemReleaseLevel, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICFabricationDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICSerialNumber, Arrays.copyOfRange(data, offset, offset + 4));
            offset = (short)(offset + 4);
            this.values.put(Field.ICBatchIdentifier, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICModuleFabricator, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICModulePackagingDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICCManufacturer, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICEmbeddingDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPrePersonalizer, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPrePersonalizationEquipmentDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPrePersonalizationEquipmentID, Arrays.copyOfRange(data, offset, offset + 4));
            offset = (short)(offset + 4);
            this.values.put(Field.ICPersonalizer, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPersonalizationDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPersonalizationEquipmentID, Arrays.copyOfRange(data, offset, offset + 4));
            offset = (short)(offset + 4);
        }

        public String toString() {
            String s = "Card CPLC:";
            for (Field f : Field.values()) {
                s = s + "\n" + f.name() + ": " + HexUtils.bin2hex(this.values.get((Object)f));
            }
            return s;
        }

        public static enum Field {
            ICFabricator,
            ICType,
            OperatingSystemID,
            OperatingSystemReleaseDate,
            OperatingSystemReleaseLevel,
            ICFabricationDate,
            ICSerialNumber,
            ICBatchIdentifier,
            ICModuleFabricator,
            ICModulePackagingDate,
            ICCManufacturer,
            ICEmbeddingDate,
            ICPrePersonalizer,
            ICPrePersonalizationEquipmentDate,
            ICPrePersonalizationEquipmentID,
            ICPersonalizer,
            ICPersonalizationDate,
            ICPersonalizationEquipmentID;

        }
    }

    public static enum KeyType {
        ENC(1),
        MAC(2),
        KEK(3),
        RMAC(4);

        private final int value;

        private KeyType(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)(this.value & 0xFF);
        }
    }
}

