/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class JavaCard
extends Task {
    private String master_jckit_path = null;
    private Vector<JCCap> packages = new Vector();
    private static final char[] LOWER_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static String hexAID(byte[] aid) {
        StringBuffer hexaid = new StringBuffer();
        for (byte b : aid) {
            hexaid.append(String.format("0x%02X", b));
            hexaid.append(":");
        }
        String hex = hexaid.toString();
        return hex.substring(0, hex.length() - 1);
    }

    public void setJCKit(String msg) {
        this.master_jckit_path = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaCardKit detectSDK(String path) {
        JavaCardKit detected = new JavaCardKit();
        if (path == null || path.trim() == "") {
            return detected;
        }
        String real_path = path.replaceFirst("^~", System.getProperty("user.home"));
        if (!new File(real_path).exists()) {
            this.log("JavaCard SDK folder " + path + " does not exist!", 1);
            return detected;
        }
        detected.path = real_path;
        if (Paths.get(detected.path, "lib", "tools.jar").toFile().exists()) {
            this.log("JavaCard 3.x SDK detected in " + detected.path, 3);
            detected.version = JC.V3;
        } else if (Paths.get(detected.path, "lib", "api21.jar").toFile().exists()) {
            detected.version = JC.V212;
            this.log("JavaCard 2.1.x SDK detected in " + detected.path, 3);
        } else if (Paths.get(detected.path, "lib", "converter.jar").toFile().exists()) {
            File api = Paths.get(detected.path, "lib", "api.jar").toFile();
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(api));){
                while (true) {
                    ZipEntry entry;
                    if ((entry = zip.getNextEntry()) == null) {
                    }
                    if (!entry.getName().equals("javacardx/apdu/ExtendedLength.class")) continue;
                    detected.version = JC.V222;
                    this.log("JavaCard 2.2.2 SDK detected in " + detected.path, 3);
                }
            }
            catch (IOException e) {
                this.log("Could not parse api.jar", 4);
            }
            finally {
                if (detected.version == JC.NONE) {
                    detected.version = JC.V221;
                    this.log("JavaCard 2.x SDK detected in " + detected.path, 3);
                }
            }
        } else {
            this.log("Could not detect a JavaCard SDK in " + Paths.get(path, new String[0]).toAbsolutePath(), 1);
        }
        return detected;
    }

    public JCCap createCap() {
        JCCap pkg = new JCCap();
        this.packages.add(pkg);
        return pkg;
    }

    public void execute() {
        for (JCCap p : this.packages) {
            p.execute();
        }
    }

    private static java.nio.file.Path mktemp() {
        try {
            java.nio.file.Path p = Files.createTempDirectory("jccpro", new FileAttribute[0]);
            return p;
        }
        catch (IOException e) {
            throw new RuntimeException("Can not make temporary folder", e);
        }
    }

    private static void rmminusrf(java.nio.file.Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeHexString(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = LOWER_HEX[(0xF0 & data[i]) >>> 4];
            out[j++] = LOWER_HEX[0xF & data[i]];
        }
        return new String(out);
    }

    public static byte[] decodeHexString(String str) {
        char[] data = str.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters: " + str);
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Character.digit(data[j], 16) << 4;
            f |= Character.digit(data[++j], 16);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static byte[] stringToBin(String s) {
        s = s.toLowerCase().replaceAll(" ", "").replaceAll(":", "");
        s = s.replaceAll("0x", "").replaceAll("\n", "").replaceAll("\t", "");
        s = s.replaceAll(";", "");
        return JavaCard.decodeHexString(s);
    }

    public class JCImport {
        String exps = null;
        String jar = null;

        public void setExps(String msg) {
            this.exps = msg;
        }

        public void setJar(String msg) {
            this.jar = msg;
        }
    }

    public class JCCap
    extends Task {
        private JavaCardKit jckit = null;
        private String classes_path = null;
        private String sources_path = null;
        private String package_name = null;
        private byte[] package_aid = null;
        private String package_version = null;
        private Vector<JCApplet> raw_applets = new Vector();
        private Vector<JCImport> raw_imports = new Vector();
        private String output_cap = null;
        private String output_exp = null;
        private String output_jca = null;
        private String jckit_path = null;
        private boolean verify = true;
        private boolean debug = false;
        private boolean ints = false;
        private List<java.nio.file.Path> temporary = new ArrayList<java.nio.file.Path>();

        public void setJCKit(String msg) {
            this.jckit_path = msg;
        }

        public void setOutput(String msg) {
            this.output_cap = msg;
        }

        public void setExport(String msg) {
            this.output_exp = msg;
        }

        public void setJca(String msg) {
            this.output_jca = msg;
        }

        public void setPackage(String msg) {
            this.package_name = msg;
        }

        public void setClasses(String msg) {
            this.classes_path = msg;
        }

        public void setVersion(String msg) {
            this.package_version = msg;
        }

        public void setSources(String arg) {
            this.sources_path = arg;
        }

        public void setVerify(boolean arg) {
            this.verify = arg;
        }

        public void setDebug(boolean arg) {
            this.debug = arg;
        }

        public void setInts(boolean arg) {
            this.ints = arg;
        }

        public void setAID(String msg) {
            try {
                this.package_aid = JavaCard.stringToBin(msg);
                if (this.package_aid.length < 5 || this.package_aid.length > 16) {
                    throw new BuildException("Package AID must be between 5 and 16 bytes: " + this.package_aid.length);
                }
            }
            catch (IllegalArgumentException e) {
                throw new BuildException("Not a correct package AID: " + e.getMessage());
            }
        }

        public JCApplet createApplet() {
            JCApplet applet = new JCApplet();
            this.raw_applets.add(applet);
            return applet;
        }

        public JCImport createImport() {
            JCImport imp = new JCImport();
            this.raw_imports.add(imp);
            return imp;
        }

        private void check() {
            JavaCardKit env = JavaCard.this.detectSDK(System.getenv("JC_HOME"));
            JavaCardKit prop = JavaCard.this.detectSDK(this.getProject().getProperty("jc.home"));
            JavaCardKit master = JavaCard.this.detectSDK(JavaCard.this.master_jckit_path);
            JavaCardKit current = JavaCard.this.detectSDK(this.jckit_path);
            if (current.version == JC.NONE && master.version == JC.NONE && env.version == JC.NONE && prop.version == JC.NONE) {
                throw new HelpingBuildException("Must specify usable JavaCard SDK path in build.xml or set JC_HOME or jc.home");
            }
            this.jckit = current.version == JC.NONE ? (prop.version != JC.NONE ? prop : (master.version == JC.NONE && env.version != JC.NONE ? env : master)) : (prop.version != JC.NONE ? prop : current);
            if (this.jckit == null || this.jckit.version == JC.NONE) {
                throw new HelpingBuildException("No usable JavaCard SDK referenced");
            }
            this.log("INFO: using JavaCard " + (Object)((Object)this.jckit.version) + " SDK in " + this.jckit.path, 2);
            if (this.sources_path == null && this.classes_path == null) {
                throw new HelpingBuildException("Must specify sources or classes");
            }
            if (this.package_version == null) {
                this.package_version = "0.0";
            } else if (!this.package_version.matches("^[0-9].[0-9]$")) {
                throw new HelpingBuildException("Incorrect package version: " + this.package_version);
            }
            int applet_counter = 0;
            for (JCApplet a : this.raw_applets) {
                ++applet_counter;
                if (a.klass == null) {
                    throw new HelpingBuildException("Applet class is missing");
                }
                if (this.package_name != null) {
                    if (!a.klass.contains(".")) {
                        a.klass = this.package_name + "." + a.klass;
                    } else if (!a.klass.startsWith(this.package_name)) {
                        throw new HelpingBuildException("Applet class " + a.klass + " is not in package " + this.package_name);
                    }
                } else {
                    String pkgname = a.klass.substring(0, a.klass.lastIndexOf("."));
                    this.log("Setting package name to " + pkgname, 2);
                    this.package_name = pkgname;
                }
                if (this.package_aid != null) {
                    if (a.aid != null) {
                        if (Arrays.equals(Arrays.copyOf(this.package_aid, 5), Arrays.copyOf(a.aid, 5))) continue;
                        throw new HelpingBuildException("Package RID does not match Applet RID");
                    }
                    JCApplet.access$302(a, Arrays.copyOf(this.package_aid, this.package_aid.length + 1));
                    ((JCApplet)a).aid[this.package_aid.length] = (byte)applet_counter;
                    this.log("INFO: generated applet AID: " + JavaCard.hexAID(a.aid) + " for " + a.klass, 2);
                    continue;
                }
                if (a.aid != null) {
                    this.package_aid = Arrays.copyOf(a.aid, 5);
                    continue;
                }
                throw new HelpingBuildException("Both package AID and applet AID are missing!");
            }
            if (this.package_aid == null) {
                throw new HelpingBuildException("Must specify package AID");
            }
            if (this.output_cap == null) {
                throw new HelpingBuildException("Must specify output file");
            }
            this.log("Building CAP with " + applet_counter + " applet" + (applet_counter > 1 ? "s" : "") + " from package " + this.package_name, 2);
            for (JCApplet app : this.raw_applets) {
                this.log(app.klass + " " + JavaCard.encodeHexString(app.aid), 2);
            }
        }

        private void compile() {
            File tmp;
            Javac j = new Javac();
            j.setProject(this.getProject());
            j.setTaskName("compile");
            j.setSrcdir(new Path(this.getProject(), this.sources_path));
            if (this.classes_path != null) {
                tmp = this.getProject().resolveFile(this.classes_path);
                if (!tmp.exists()) {
                    tmp.mkdir();
                }
            } else {
                java.nio.file.Path p = JavaCard.mktemp();
                this.temporary.add(p);
                tmp = p.toFile();
                this.classes_path = tmp.getAbsolutePath();
            }
            j.setDestdir(tmp);
            j.setDebug(true);
            if (this.jckit.version == JC.V212) {
                j.setTarget("1.1");
                j.setSource("1.1");
                j.setDebug(true);
            } else if (this.jckit.version == JC.V221) {
                j.setTarget("1.2");
                j.setSource("1.2");
            } else {
                j.setTarget("1.5");
                j.setSource("1.5");
            }
            j.setIncludeantruntime(false);
            j.createCompilerArg().setValue("-Xlint");
            j.createCompilerArg().setValue("-Xlint:-options");
            j.createCompilerArg().setValue("-Xlint:-serial");
            j.setFailonerror(true);
            j.setFork(true);
            Path cp = j.createClasspath();
            String api = null;
            api = this.jckit.version == JC.V3 ? Paths.get(this.jckit.path, "lib", "api_classic.jar").toAbsolutePath().toString() : (this.jckit.version == JC.V212 ? Paths.get(this.jckit.path, "lib", "api21.jar").toAbsolutePath().toString() : Paths.get(this.jckit.path, "lib", "api.jar").toAbsolutePath().toString());
            cp.append(new Path(this.getProject(), api));
            for (JCImport i : this.raw_imports) {
                cp.append(new Path(this.getProject(), i.jar));
            }
            j.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            block36: {
                this.check();
                try {
                    void var8_14;
                    Path jarpath;
                    if (this.sources_path != null) {
                        this.compile();
                    }
                    Java j = new Java((Task)this);
                    Path cp = j.createClasspath();
                    File jar = null;
                    if (this.jckit.version == JC.V3) {
                        jar = Paths.get(this.jckit.path, "lib", "tools.jar").toFile();
                        jarpath = new Path(this.getProject());
                        jarpath.setLocation(jar);
                        cp.append(jarpath);
                    } else {
                        jar = Paths.get(this.jckit.path, "lib", "converter.jar").toFile();
                        jarpath = new Path(this.getProject());
                        jarpath.setLocation(jar);
                        cp.append(jarpath);
                        jar = Paths.get(this.jckit.path, "lib", "offcardverifier.jar").toFile();
                        jarpath = new Path(this.getProject());
                        jarpath.setLocation(jar);
                        cp.append(jarpath);
                    }
                    java.nio.file.Path p = JavaCard.mktemp();
                    this.temporary.add(p);
                    File applet_folder = p.toFile();
                    j.createArg().setLine("-classdir '" + this.classes_path + "'");
                    j.createArg().setLine("-d '" + applet_folder.getAbsolutePath() + "'");
                    ArrayList<String> exps = new ArrayList<String>();
                    if (this.jckit.version == JC.V212) {
                        exps.add(Paths.get(this.jckit.path, "api21_export_files").toString());
                    } else {
                        exps.add(Paths.get(this.jckit.path, "api_export_files").toString());
                    }
                    for (JCImport jCImport : this.raw_imports) {
                        exps.add(Paths.get(jCImport.exps, new String[0]).toAbsolutePath().toString());
                    }
                    StringBuilder expstringbuilder = new StringBuilder();
                    for (String string : exps) {
                        expstringbuilder.append(File.pathSeparatorChar);
                        expstringbuilder.append(string);
                    }
                    j.createArg().setLine("-exportpath '" + expstringbuilder.toString() + "'");
                    j.createArg().setLine("-verbose");
                    j.createArg().setLine("-nobanner");
                    if (this.debug) {
                        j.createArg().setLine("-debug");
                    }
                    if (!this.verify) {
                        j.createArg().setLine("-noverify");
                    }
                    if (this.jckit.version == JC.V3) {
                        j.createArg().setLine("-useproxyclass");
                    }
                    if (this.ints) {
                        j.createArg().setLine("-i");
                    }
                    String string = "CAP";
                    if (this.output_exp != null) {
                        String string2 = string + " EXP";
                    }
                    if (this.output_jca != null) {
                        void var8_12;
                        String string3 = (String)var8_12 + " JCA";
                    }
                    j.createArg().setLine("-out " + (String)var8_14);
                    for (JCApplet app : this.raw_applets) {
                        j.createArg().setLine("-applet " + JavaCard.hexAID(app.aid) + " " + app.klass);
                    }
                    j.createArg().setLine(this.package_name + " " + JavaCard.hexAID(this.package_aid) + " " + this.package_version);
                    if (this.jckit.version == JC.V3) {
                        j.setClassname("com.sun.javacard.converter.Main");
                        Environment.Variable variable = new Environment.Variable();
                        variable.setKey("jc.home");
                        variable.setValue(this.jckit.path);
                        j.addSysproperty(variable);
                    } else {
                        j.setClassname("com.sun.javacard.converter.Converter");
                    }
                    j.setFailonerror(true);
                    j.setFork(true);
                    this.log("cmdline: " + j.getCommandLine(), 3);
                    j.execute();
                    if (this.output_cap != null || this.output_exp != null || this.output_jca != null) {
                        void var9_21;
                        String string4 = this.package_name;
                        if (string4.lastIndexOf(".") != -1) {
                            String string5 = string4.substring(string4.lastIndexOf(".") + 1);
                        }
                        java.nio.file.Path jcsrc = applet_folder.toPath().resolve(this.package_name.replace(".", File.separator)).resolve("javacard");
                        java.nio.file.Path path = jcsrc.resolve((String)var9_21 + ".cap");
                        java.nio.file.Path exp = jcsrc.resolve((String)var9_21 + ".exp");
                        java.nio.file.Path jca = jcsrc.resolve((String)var9_21 + ".jca");
                        try {
                            if (!path.toFile().exists()) {
                                throw new BuildException("Can not find CAP in " + jcsrc);
                            }
                            File opf = this.getProject().resolveFile(this.output_cap);
                            Files.copy(path, opf.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            this.log("CAP saved to " + opf.getAbsolutePath(), 2);
                            if (this.output_exp != null) {
                                this.setTaskName("export");
                                if (!exp.toFile().exists()) {
                                    throw new BuildException("Can not find EXP in " + jcsrc);
                                }
                                opf = this.getProject().resolveFile(this.output_exp);
                                java.nio.file.Path exp_path = opf.toPath().resolve(this.package_name.replace(".", File.separator)).resolve("javacard");
                                if (!exp_path.toFile().exists() && !exp_path.toFile().mkdirs()) {
                                    throw new HelpingBuildException("Can not make path for EXP output: " + opf.getAbsolutePath());
                                }
                                Files.copy(exp, exp_path.resolve(exp.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                                this.log("EXP saved to " + exp_path.resolve(exp.getFileName()), 2);
                                Jar jarz = new Jar();
                                jarz.setProject(this.getProject());
                                jarz.setTaskName("export");
                                jarz.setBasedir(this.getProject().resolveFile(this.classes_path));
                                jarz.setDestFile(opf.toPath().resolve((String)var9_21 + ".jar").toFile());
                                jarz.execute();
                            }
                            if (this.output_jca != null) {
                                this.setTaskName("jca");
                                if (!jca.toFile().exists()) {
                                    throw new BuildException("Can not find JCA in " + jcsrc);
                                }
                                opf = this.getProject().resolveFile(this.output_jca);
                                Files.copy(jca, opf.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                this.log("JCA saved to " + opf.getAbsolutePath(), 2);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new BuildException("Can not copy output CAP, EXP or JCA", (Throwable)e);
                        }
                    }
                    if (!this.verify) break block36;
                    this.setTaskName("verify");
                    j = new Java((Task)this);
                    j.setClasspath(cp);
                    j.setClassname("com.sun.javacard.offcardverifier.Verifier");
                    final ArrayList arrayList = new ArrayList();
                    try {
                        for (String string6 : exps) {
                            Files.walkFileTree(Paths.get(string6, new String[0]), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                                @Override
                                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                                    if (file.toString().endsWith(".exp")) {
                                        arrayList.add(file.toAbsolutePath().toString());
                                    }
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        this.log("Could not find .exp files: " + e.getMessage(), 0);
                        for (java.nio.file.Path p2 : this.temporary) {
                            if (!p2.toFile().exists()) continue;
                            JavaCard.rmminusrf(p2);
                        }
                        return;
                    }
                    j.createArg().setLine("-nobanner");
                    for (String string7 : arrayList) {
                        j.createArg().setLine("'" + string7 + "'");
                    }
                    j.createArg().setLine("'" + this.getProject().resolveFile(this.output_cap).toString() + "'");
                    j.setFailonerror(true);
                    j.setFork(true);
                    this.log("cmdline: " + j.getCommandLine(), 3);
                    j.execute();
                }
                finally {
                    for (java.nio.file.Path p : this.temporary) {
                        if (!p.toFile().exists()) continue;
                        JavaCard.rmminusrf(p);
                    }
                }
            }
        }
    }

    public class HelpingBuildException
    extends BuildException {
        public HelpingBuildException(String msg) {
            super(msg + "\n\nPLEASE READ https://github.com/martinpaljak/ant-javacard#syntax");
        }
    }

    public class JCApplet {
        private String klass = null;
        private byte[] aid = null;

        public void setClass(String msg) {
            this.klass = msg;
        }

        public void setAID(String msg) {
            try {
                this.aid = JavaCard.stringToBin(msg);
                if (this.aid.length < 5 || this.aid.length > 16) {
                    throw new BuildException("Applet AID must be between 5 and 16 bytes: " + this.aid.length);
                }
            }
            catch (IllegalArgumentException e) {
                throw new BuildException("Not a correct applet AID: " + e.getMessage());
            }
        }

        static /* synthetic */ byte[] access$302(JCApplet x0, byte[] x1) {
            x0.aid = x1;
            return x1;
        }
    }

    private class JavaCardKit {
        JC version = JC.NONE;
        String path = null;

        private JavaCardKit() {
        }
    }

    private static enum JC {
        NONE,
        V212,
        V221,
        V222,
        V3;


        public String toString() {
            if (this.equals((Object)V3)) {
                return "v3.x";
            }
            if (this.equals((Object)V222)) {
                return "v2.2.2";
            }
            if (this.equals((Object)V221)) {
                return "v2.2.1";
            }
            if (this.equals((Object)V212)) {
                return "v2.1.x";
            }
            return "unknown";
        }
    }
}

