/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.HexUtils;
import apdu4j.remote.JSONMessagePipe;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketTransport
implements JSONMessagePipe {
    private static Logger logger = LoggerFactory.getLogger(SocketTransport.class);
    private final Socket socket;
    private final ByteBuffer length = ByteBuffer.allocate(4);

    public SocketTransport(Socket s) {
        this.socket = s;
        this.length.order(ByteOrder.BIG_ENDIAN);
    }

    public static SocketTransport connect_insecure(InetSocketAddress address) throws IOException {
        return SocketTransport.connect(address, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyManagerFactory get_key_manager_factory(String pkcs12path, String pkcs12pass) throws IOException {
        try (FileInputStream fin = new FileInputStream(pkcs12path);){
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(fin, pkcs12pass.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, pkcs12pass.toCharArray());
            KeyManagerFactory keyManagerFactory = kmf;
            return keyManagerFactory;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IOException("Could not load client key!", e);
        }
    }

    protected static SSLSocketFactory get_ssl_socket_factory(KeyManagerFactory kmf, X509Certificate pinnedcert) throws IOException {
        try {
            KeyManager[] kmfs;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = kmfs = kmf == null ? null : kmf.getKeyManagers();
            if (pinnedcert != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
                KeyStore ks = null;
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, null);
                ks.setCertificateEntry("pinned", pinnedcert);
                tmf.init(ks);
                sc.init(kmfs, tmf.getTrustManagers(), new SecureRandom());
            } else {
                sc.init(kmfs, trustAllCerts, new SecureRandom());
            }
            return sc.getSocketFactory();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException("Could not connect", e);
        }
    }

    protected static SSLSocketFactory get_ssl_socket_factory(X509Certificate pinnedcert) throws IOException {
        return SocketTransport.get_ssl_socket_factory(null, pinnedcert);
    }

    public static SocketTransport connect(InetSocketAddress address, X509Certificate pinnedcert) throws IOException {
        SSLSocketFactory factory = SocketTransport.get_ssl_socket_factory(pinnedcert);
        Socket s = factory.createSocket(address.getHostString(), address.getPort());
        return new SocketTransport(s);
    }

    public static ServerSocket make_server(int port, String pkcs12Path, String pkcs12Pass) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        try (FileInputStream in = new FileInputStream(pkcs12Path);){
            ServerSocket serverSocket = SocketTransport.make_server(port, in, pkcs12Pass);
            return serverSocket;
        }
    }

    private static ServerSocket make_server(int port, InputStream pkcs12stream, String pkcs12Pass) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(pkcs12stream, pkcs12Pass.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, pkcs12Pass.toCharArray());
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(kmf.getKeyManagers(), null, null);
        return sc.getServerSocketFactory().createServerSocket(port);
    }

    @Override
    public synchronized void send(Map<String, Object> msg) throws IOException {
        JSONObject obj = new JSONObject();
        obj.putAll(msg);
        byte[] data = obj.toJSONString().getBytes(Charset.forName("UTF-8"));
        this.socket.getOutputStream().write(this.length.putInt(0, data.length).array());
        this.socket.getOutputStream().write(data);
        logger.debug("> ({}) {}", (Object)HexUtils.bin2hex(this.length.array()), (Object)obj.toJSONString());
    }

    @Override
    public synchronized Map<String, Object> recv() throws IOException {
        JSONObject obj;
        if (this.socket.isClosed()) {
            throw new IOException("Connection closed");
        }
        this.length.putInt(0, 0);
        if (this.socket.getInputStream().read(this.length.array()) != this.length.capacity()) {
            throw new IOException("Failed to read data length");
        }
        int len = this.length.getInt(0);
        if (len == 0) {
            throw new IOException("Failed to read data (length)");
        }
        if (len > 1024) {
            throw new IOException("Bad message length > 1024");
        }
        byte[] data = new byte[len];
        int readlen = this.socket.getInputStream().read(data);
        if (readlen != len) {
            throw new IOException("Read " + readlen + " instead of " + len);
        }
        try {
            obj = (JSONObject)JSONValue.parseWithException((String)new String(data, "UTF-8"));
        }
        catch (ParseException e) {
            throw new IOException("Could not parse JSON", e);
        }
        logger.debug("< ({}) {}", (Object)HexUtils.bin2hex(this.length.array()), (Object)obj.toJSONString());
        return obj;
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            logger.trace("Could not close socket", (Throwable)e);
        }
    }
}

