/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.remote.JSONMessagePipe;
import apdu4j.remote.SocketTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocketFactory;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPTransport
implements JSONMessagePipe {
    private static Logger logger = LoggerFactory.getLogger(HTTPTransport.class);
    private final URL u;
    HttpURLConnection c = null;
    private SSLSocketFactory f = null;

    private HTTPTransport(URL url) {
        this.u = url;
    }

    public static HTTPTransport open(URL u, X509Certificate pinned, KeyManagerFactory kmf) throws IOException {
        HTTPTransport t = new HTTPTransport(u);
        t.f = SocketTransport.get_ssl_socket_factory(kmf, pinned);
        return t;
    }

    private HttpURLConnection connect() throws IOException {
        this.c = (HttpURLConnection)this.u.openConnection();
        this.c.setDoOutput(true);
        this.c.setDoInput(true);
        this.c.setRequestProperty("Content-Type", "application/json");
        this.c.setRequestProperty("Accept", "application/json");
        this.c.setRequestMethod("POST");
        if (this.c instanceof HttpsURLConnection && this.f != null) {
            HttpsURLConnection https = (HttpsURLConnection)this.c;
            https.setSSLSocketFactory(this.f);
        }
        return this.c;
    }

    @Override
    public synchronized void send(Map<String, Object> msg) throws IOException {
        this.c = this.connect();
        JSONObject obj = new JSONObject(msg);
        logger.trace("SEND: {}", (Object)obj.toJSONString());
        byte[] data = obj.toJSONString().getBytes(Charset.forName("UTF-8"));
        try (OutputStream out = this.c.getOutputStream();){
            out.write(data);
        }
    }

    @Override
    public synchronized Map<String, Object> recv() throws IOException {
        HashMap<String, Object> r;
        block16: {
            r = new HashMap<String, Object>();
            if (this.c.getResponseCode() == 200) {
                try (InputStream in = this.c.getInputStream();){
                    byte[] response = new byte[this.c.getContentLength()];
                    int len = in.read(response);
                    if (len != this.c.getContentLength()) {
                        logger.trace("Read {} instead of {}", (Object)len, (Object)this.c.getContentLength());
                        throw new IOException("Read only " + len + " bytes instead of " + this.c.getContentLength());
                    }
                    try {
                        JSONObject obj = (JSONObject)JSONValue.parseWithException((String)new String(response, "UTF-8"));
                        logger.trace("RECV: {}", (Object)obj.toJSONString());
                        r.putAll((Map<String, Object>)obj);
                        break block16;
                    }
                    catch (ParseException e) {
                        throw new IOException("Could not parse JSON", e);
                    }
                }
            }
            logger.trace("Got response code {}", (Object)this.c.getResponseCode());
            throw new IOException("Got response code " + this.c.getResponseCode());
        }
        return r;
    }

    @Override
    public void close() {
        if (this.c != null) {
            this.c.disconnect();
        }
    }
}

