/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import apdu4j.HexUtils;
import apdu4j.TerminalManager;
import java.io.Console;
import java.io.IOException;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.util.ASN1Dump;

public class Shell {
    boolean running = true;
    final Console c = System.console();
    Card card;

    public Shell(Card c) {
        this.card = c;
    }

    void run() {
        while (this.running) {
            String s = this.c.readLine("apdu4j> ", new Object[0]);
            if (s == null || s.trim().length() == 0) {
                System.out.println("Exiting ...");
                return;
            }
            String[] parts = s.split(" ");
            String cmd = parts[0];
            if (cmd.equalsIgnoreCase("q") || cmd.equalsIgnoreCase("exit") || cmd.equalsIgnoreCase("quit")) {
                this.running = false;
                continue;
            }
            try {
                byte[] apdu;
                try {
                    apdu = HexUtils.stringToBin(s);
                    System.out.println("# " + HexUtils.bin2hex(apdu));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Invalid input: " + s);
                    continue;
                }
                ResponseAPDU r = this.card.getBasicChannel().transmit(new CommandAPDU(apdu));
                System.out.println(HexUtils.bin2hex(r.getBytes()));
                try {
                    ASN1InputStream ais = new ASN1InputStream(r.getData());
                    Throwable throwable = null;
                    try {
                        if (ais.available() <= 0) continue;
                        ASN1Primitive d = ais.readObject();
                        String txt = ASN1Dump.dumpAsString((Object)d, (boolean)true);
                        System.out.println(txt);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ais == null) continue;
                        if (throwable != null) {
                            try {
                                ais.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ais.close();
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (CardException e) {
                System.out.println(TerminalManager.getExceptionMessage(e));
            }
        }
    }
}

