/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import apdu4j.HexUtils;
import apdu4j.LoggingCardTerminal;
import apdu4j.PinPadTerminal;
import apdu4j.Shell;
import apdu4j.TerminalManager;
import apdu4j.remote.CmdlineRemoteTerminal;
import apdu4j.remote.HTTPTransport;
import apdu4j.remote.JSONMessagePipe;
import apdu4j.remote.RemoteTerminalServer;
import apdu4j.remote.SocketTransport;
import apdu4j.remote.TestServer;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import jnasmartcardio.Smartcardio;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class SCTool {
    private static final String CMD_LIST = "list";
    private static final String CMD_APDU = "apdu";
    private static final String OPT_SHELL = "shell";
    private static final String OPT_PROVIDER = "provider";
    private static final String OPT_READER = "reader";
    private static final String OPT_ALL = "all";
    private static final String OPT_VERBOSE = "verbose";
    private static final String OPT_DEBUG = "debug";
    private static final String OPT_VERSION = "version";
    private static final String OPT_ERROR = "error";
    private static final String OPT_DUMP = "dump";
    private static final String OPT_REPLAY = "replay";
    private static final String OPT_HELP = "help";
    private static final String OPT_SUN = "sun";
    private static final String OPT_T0 = "t0";
    private static final String OPT_T1 = "t1";
    private static final String OPT_EXCLUSIVE = "exclusive";
    private static final String OPT_CONNECT = "connect";
    private static final String OPT_PINNED = "pinned";
    private static final String OPT_P12 = "p12";
    private static final String OPT_WAIT = "wait";
    private static final String OPT_NO_GET_RESPONSE = "no-get-response";
    private static final String OPT_LIB = "lib";
    private static final String OPT_WEB = "web";
    private static final String OPT_PROVIDERS = "P";
    private static final String OPT_TEST_SERVER = "testserver";
    private static boolean verbose = false;

    private static OptionSet parseOptions(String[] argv) throws IOException {
        OptionSet args = null;
        OptionParser parser = new OptionParser();
        parser.acceptsAll(Arrays.asList("l", CMD_LIST), "list readers");
        parser.acceptsAll(Arrays.asList("p", OPT_PROVIDER), "specify provider").withRequiredArg();
        parser.acceptsAll(Arrays.asList("v", OPT_VERBOSE), "be verbose");
        parser.acceptsAll(Arrays.asList("d", OPT_DEBUG), "show debug");
        parser.acceptsAll(Arrays.asList("e", OPT_ERROR), "fail if not 0x9000");
        parser.acceptsAll(Arrays.asList("h", OPT_HELP), "show help");
        parser.acceptsAll(Arrays.asList("r", OPT_READER), "use reader").withRequiredArg();
        parser.acceptsAll(Arrays.asList("a", CMD_APDU), "send APDU").withRequiredArg();
        parser.acceptsAll(Arrays.asList("w", OPT_WEB), "open ATR in web");
        parser.acceptsAll(Arrays.asList("V", OPT_VERSION), "show version information");
        parser.acceptsAll(Arrays.asList("s", OPT_SHELL), "start shell");
        parser.accepts(OPT_DUMP, "save dump to file").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_REPLAY, "replay command from dump").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_SUN, "load SunPCSC");
        parser.accepts(OPT_CONNECT, "connect to URL or host:port").withRequiredArg();
        parser.accepts(OPT_P12, "path:pass of client PKCS#12").withRequiredArg();
        parser.accepts(OPT_PINNED, "require certificate").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_PROVIDERS, "list providers");
        parser.accepts(OPT_ALL, "process all readers");
        parser.accepts(OPT_WAIT, "wait for card insertion");
        parser.accepts(OPT_T0, "use T=0");
        parser.accepts(OPT_T1, "use T=1");
        parser.accepts(OPT_EXCLUSIVE, "use EXCLUSIVE mode (JNA only)");
        parser.accepts(OPT_TEST_SERVER, "run a test server on port 10000").withRequiredArg();
        parser.accepts(OPT_NO_GET_RESPONSE, "don't use GET RESPONSE with SunPCSC");
        parser.accepts(OPT_LIB, "use specific PC/SC lib with SunPCSC").withRequiredArg();
        try {
            args = parser.parse(argv);
            for (String s : parser.recognizedOptions().keySet()) {
                args.valuesOf(s);
            }
        }
        catch (OptionException e) {
            if (e.getCause() != null) {
                System.err.println(e.getMessage() + ": " + e.getCause().getMessage());
            } else {
                System.err.println(e.getMessage());
            }
            System.err.println();
            SCTool.help_and_exit(parser, System.err);
        }
        if (args.has(OPT_HELP)) {
            SCTool.help_and_exit(parser, System.out);
        }
        return args;
    }

    public static void main(String[] argv) throws Exception {
        Provider[] providers;
        OptionSet args = SCTool.parseOptions(argv);
        if (args.has(OPT_VERBOSE)) {
            verbose = true;
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", OPT_DEBUG);
            if (args.has(OPT_DEBUG)) {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "trace");
            }
            System.setProperty("org.slf4j.simpleLogger.showThreadName", "true");
            System.setProperty("org.slf4j.simpleLogger.showShortLogName", "true");
            System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "warn");
        }
        if (args.has(OPT_VERSION)) {
            String version = "apdu4j " + SCTool.getVersion();
            version = version + "\nRunning on " + System.getProperty("os.name");
            version = version + " " + System.getProperty("os.version");
            version = version + " " + System.getProperty("os.arch");
            version = version + ", Java " + System.getProperty("java.version");
            version = version + " by " + System.getProperty("java.vendor");
            System.out.println(version);
        }
        if (args.has(OPT_TEST_SERVER)) {
            RemoteTerminalServer srv = new RemoteTerminalServer(TestServer.class);
            srv.start(SCTool.string2socket((String)args.valueOf(OPT_TEST_SERVER)));
            System.out.println("Hit ctrl-c to quit");
            while (true) {
                Thread.sleep(5000L);
                srv.gc(System.currentTimeMillis() - 300000L);
            }
        }
        Security.addProvider(new Smartcardio());
        if (args.has(OPT_PROVIDERS) && (providers = Security.getProviders("TerminalFactory.PC/SC")) != null) {
            System.out.println("Existing TerminalFactory providers:");
            for (Provider provider : providers) {
                System.out.println(provider.getName() + " v" + provider.getVersion() + " (" + provider.getInfo() + ")");
            }
        }
        TerminalManager.fixPlatformPaths();
        if (args.has(OPT_NO_GET_RESPONSE)) {
            System.setProperty("sun.security.smartcardio.t0GetResponse", "false");
            System.setProperty("sun.security.smartcardio.t1GetResponse", "false");
        }
        if (args.has(OPT_LIB)) {
            System.setProperty("sun.security.smartcardio.library", (String)args.valueOf(OPT_LIB));
        }
        CardTerminals terminals = null;
        try {
            TerminalFactory tf = args.has(OPT_PROVIDER) ? TerminalManager.getTerminalFactory((String)args.valueOf(OPT_PROVIDER)) : (args.has(OPT_SUN) ? TerminalManager.getTerminalFactory("sun.security.smartcardio.SunPCSC") : TerminalManager.getTerminalFactory("jnasmartcardio.Smartcardio"));
            if (verbose) {
                System.out.println("# Using " + tf.getProvider().getClass().getCanonicalName() + " - " + tf.getProvider());
                if (System.getProperty("sun.security.smartcardio.library") != null) {
                    System.out.println("# sun.security.smartcardio.library=" + System.getProperty("sun.security.smartcardio.library"));
                }
            }
            terminals = tf.terminals();
        }
        catch (Smartcardio.EstablishContextException e) {
            String msg = TerminalManager.getExceptionMessage(e);
            System.err.println("No readers: " + msg);
            System.exit(1);
        }
        List<Object> do_readers = new ArrayList();
        try {
            if (args.has(CMD_LIST)) {
                List<CardTerminal> terms = terminals.list();
                if (verbose) {
                    System.out.println("# Found " + terms.size() + " terminal" + (terms.size() == 1 ? "" : "s"));
                }
                if (terms.size() == 0) {
                    System.err.println("No readers found");
                    System.exit(1);
                }
                for (CardTerminal t : terms) {
                    String vmd = " ";
                    if (verbose) {
                        try (PinPadTerminal pp = PinPadTerminal.getInstance(t);){
                            pp.probe();
                            vmd = vmd + "[";
                            vmd = vmd + (pp.canVerify() ? "V" : " ");
                            vmd = vmd + (pp.canModify() ? "M" : " ");
                            vmd = vmd + (pp.hasDisplay() ? "D" : " ");
                            vmd = vmd + "] ";
                        }
                        catch (CardException e) {
                            vmd = " [EEE] ";
                        }
                    }
                    String present = t.isCardPresent() ? "[*]" : "[ ]";
                    System.out.println(present + vmd + t.getName());
                    if (!args.has(OPT_VERBOSE) || !t.isCardPresent()) continue;
                    try {
                        Card c = t.connect("DIRECT");
                        String atr = HexUtils.bin2hex(c.getATR().getBytes()).toUpperCase();
                        c.disconnect(false);
                        System.out.println("          " + atr);
                        if (!args.has(OPT_WEB)) continue;
                        String url = "http://smartcard-atr.appspot.com/parse?ATR=" + atr;
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(new URI(url + "&from=apdu4j"));
                            continue;
                        }
                        System.out.println("          " + url);
                    }
                    catch (CardException e) {
                        System.out.println("          " + TerminalManager.getExceptionMessage(e));
                    }
                }
            }
            if (args.has(OPT_READER)) {
                String reader = (String)args.valueOf(OPT_READER);
                CardTerminal cardTerminal = terminals.getTerminal(reader);
                if (cardTerminal == null) {
                    System.err.println("Reader \"" + reader + "\" not found.");
                    System.exit(1);
                }
                do_readers = Arrays.asList(cardTerminal);
            } else {
                do_readers = terminals.list(CardTerminals.State.CARD_PRESENT);
                if (do_readers.size() == 0 && !args.has(CMD_LIST)) {
                    List<CardTerminal> empty = terminals.list(CardTerminals.State.CARD_ABSENT);
                    if (empty.size() == 1 && args.has(OPT_WAIT)) {
                        CardTerminal cardTerminal = empty.get(0);
                        System.out.println("Please enter a card into " + cardTerminal.getName());
                        if (!empty.get(0).waitForCardPresent(30000L)) {
                            System.out.println("Timeout.");
                        } else {
                            do_readers = Arrays.asList(cardTerminal);
                        }
                    } else {
                        System.err.println("No reader with a card found!");
                        System.exit(1);
                    }
                }
            }
        }
        catch (CardException e) {
            String string = TerminalManager.getExceptionMessage(e);
            if (string.equals("SCARD_E_NO_READERS_AVAILABLE")) {
                System.err.println("No reader with a card found!");
                System.exit(1);
            }
            System.out.println("Could not list readers: " + string);
        }
        for (CardTerminal cardTerminal : do_readers) {
            if (do_readers.size() > 1 || args.has(OPT_VERBOSE)) {
                System.out.println("# " + cardTerminal.getName());
            }
            try {
                SCTool.work(cardTerminal, args);
            }
            catch (CardException e) {
                if (TerminalManager.getExceptionMessage(e) == "SCARD_E_SHARING_VIOLATION") continue;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void work(CardTerminal reader, OptionSet args) throws CardException {
        block30: {
            if (!reader.isCardPresent()) {
                System.out.println("No card in " + reader.getName());
                return;
            }
            if (args.has(OPT_VERBOSE)) {
                FileOutputStream o = null;
                if (args.has(OPT_DUMP)) {
                    try {
                        o = new FileOutputStream((File)args.valueOf(OPT_DUMP));
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Can not dump to " + args.valueOf(OPT_DUMP));
                    }
                }
                reader = LoggingCardTerminal.getInstance(reader, o);
            }
            boolean transact = true;
            String protocol = args.has(OPT_T0) ? "T=0" : (args.has(OPT_T1) ? "T=1" : "*");
            if (args.has(OPT_EXCLUSIVE)) {
                protocol = "EXCLUSIVE;" + protocol;
            } else if (System.getProperty("os.name").toLowerCase().contains("windows") && args.has(OPT_CONNECT)) {
                transact = false;
                protocol = "EXCLUSIVE;" + protocol;
            }
            if (args.has(CMD_APDU) || args.has(OPT_SHELL)) {
                Card c = null;
                try {
                    c = reader.connect(protocol);
                    if (args.has(CMD_APDU)) {
                        for (Object s : args.valuesOf(CMD_APDU)) {
                            CommandAPDU a = new CommandAPDU(HexUtils.stringToBin((String)s));
                            ResponseAPDU r = c.getBasicChannel().transmit(a);
                            if (!args.has(OPT_ERROR) || r.getSW() == 36864) continue;
                            System.out.println("Card returned " + String.format("%04X", r.getSW()) + ", exiting!");
                            return;
                        }
                        break block30;
                    }
                    Shell s = new Shell(c);
                    s.run();
                    return;
                }
                catch (CardException e) {
                    if (TerminalManager.getExceptionMessage(e) != null) {
                        System.out.println("PC/SC failure: " + TerminalManager.getExceptionMessage(e));
                        return;
                    }
                    throw e;
                }
                finally {
                    if (c != null) {
                        c.disconnect(true);
                    }
                }
            }
            if (args.has(OPT_CONNECT)) {
                String remote = (String)args.valueOf(OPT_CONNECT);
                JSONMessagePipe transport = null;
                KeyManagerFactory kmf = null;
                X509Certificate pinnedcert = null;
                try {
                    if (args.has(OPT_P12)) {
                        String[] pathpass = args.valueOf(OPT_P12).toString().split(":");
                        if (pathpass.length != 2) {
                            throw new IllegalArgumentException("Must be path:password!");
                        }
                        kmf = SocketTransport.get_key_manager_factory(pathpass[0], pathpass[1]);
                    }
                    if (args.has(OPT_PINNED)) {
                        pinnedcert = SCTool.certFromPEM(((File)args.valueOf(OPT_PINNED)).getPath());
                    }
                    transport = remote.startsWith("http://") || remote.startsWith("https://") ? HTTPTransport.open(new URL(remote), pinnedcert, kmf) : SocketTransport.connect(SCTool.string2socket(remote), null);
                    CmdlineRemoteTerminal c = new CmdlineRemoteTerminal(transport, reader);
                    c.forceProtocol(protocol);
                    c.transact(transact);
                    c.run();
                }
                catch (IOException e) {
                    System.err.println("Communication error: " + e.getMessage());
                }
                finally {
                    if (transport != null) {
                        transport.close();
                    }
                }
            }
        }
    }

    private static void help_and_exit(OptionParser parser, PrintStream o) throws IOException {
        System.err.println("# apdu4j command line utility\n");
        parser.printHelpOn((OutputStream)o);
        System.exit(1);
    }

    private static X509Certificate certFromPEM(String path) throws IOException {
        try {
            String pem = new String(Files.readAllBytes(Paths.get(path, new String[0])));
            String[] lines = pem.split("\n");
            CharSequence[] b64 = Arrays.copyOfRange(lines, 1, lines.length - 1);
            byte[] bytes = Base64.getDecoder().decode(String.join((CharSequence)"", b64));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes));
            return cert;
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
    }

    public static String getVersion() {
        String version = "unknown-development";
        try (InputStream versionfile = SCTool.class.getResourceAsStream("version.txt");){
            if (versionfile != null) {
                BufferedReader vinfo = new BufferedReader(new InputStreamReader(versionfile));
                version = vinfo.readLine();
            }
        }
        catch (IOException e) {
            version = "unknown-error";
        }
        return version;
    }

    private static InetSocketAddress string2socket(String s) {
        String[] hostport = s.split(":");
        if (hostport.length != 2) {
            throw new IllegalArgumentException("Can connect to host:port pairs!");
        }
        return new InetSocketAddress(hostport[0], (int)Integer.valueOf(hostport[1]));
    }
}

