/*
 * Decompiled with CFR 0.152.
 */
package foundation.metaplex.solana.programs;

import com.funkatronics.kborsh.BorshEncoder;
import foundation.metaplex.rpc.serializers.PublicKeyAs32ByteSerializer;
import foundation.metaplex.solana.programs.Program;
import foundation.metaplex.solana.transactions.AccountMeta;
import foundation.metaplex.solana.transactions.TransactionInstruction;
import foundation.metaplex.solanapublickeys.PublicKey;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lfoundation/metaplex/solana/programs/SystemProgram;", "Lfoundation/metaplex/solana/programs/Program;", "()V", "PROGRAM_ID", "Lfoundation/metaplex/solanapublickeys/PublicKey;", "getPROGRAM_ID", "()Lfoundation/metaplex/solanapublickeys/PublicKey;", "PROGRAM_INDEX_CREATE_ACCOUNT", "", "PROGRAM_INDEX_TRANSFER", "createAccount", "Lfoundation/metaplex/solana/transactions/TransactionInstruction;", "fromPublicKey", "newAccountPublickey", "lamports", "", "space", "programId", "transfer", "toPublickKey", "solana"})
public final class SystemProgram
extends Program {
    @NotNull
    public static final SystemProgram INSTANCE = new SystemProgram();
    @NotNull
    private static final PublicKey PROGRAM_ID = new PublicKey("11111111111111111111111111111111");
    public static final int PROGRAM_INDEX_CREATE_ACCOUNT = 0;
    public static final int PROGRAM_INDEX_TRANSFER = 2;

    private SystemProgram() {
    }

    @NotNull
    public final PublicKey getPROGRAM_ID() {
        return PROGRAM_ID;
    }

    @JvmStatic
    @NotNull
    public static final TransactionInstruction transfer(@NotNull PublicKey fromPublicKey, @NotNull PublicKey toPublickKey, long lamports) {
        Intrinsics.checkNotNullParameter((Object)fromPublicKey, (String)"fromPublicKey");
        Intrinsics.checkNotNullParameter((Object)toPublickKey, (String)"toPublickKey");
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(fromPublicKey, true, true));
        keys.add(new AccountMeta(toPublickKey, false, true));
        BorshEncoder data = new BorshEncoder();
        data.encodeInt(2);
        data.encodeLong(lamports);
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, (List<AccountMeta>)keys, data.getBorshEncodedBytes());
    }

    @NotNull
    public final TransactionInstruction createAccount(@NotNull PublicKey fromPublicKey, @NotNull PublicKey newAccountPublickey, long lamports, long space, @NotNull PublicKey programId) {
        Intrinsics.checkNotNullParameter((Object)fromPublicKey, (String)"fromPublicKey");
        Intrinsics.checkNotNullParameter((Object)newAccountPublickey, (String)"newAccountPublickey");
        Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(fromPublicKey, true, true));
        keys.add(new AccountMeta(newAccountPublickey, true, true));
        BorshEncoder data = new BorshEncoder();
        data.encodeInt(0);
        data.encodeLong(lamports);
        data.encodeLong(space);
        data.encodeSerializableValue((SerializationStrategy)PublicKeyAs32ByteSerializer.INSTANCE, (Object)programId);
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, (List<AccountMeta>)keys, data.getBorshEncodedBytes());
    }
}

