/*
 * Decompiled with CFR 0.152.
 */
package foundation.metaplex.amount;

import foundation.metaplex.amount.Amount;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0002\u0006\u0007B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lfoundation/metaplex/amount/AmountErrors;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "AmountMismatchError", "UnexpectedAmountError", "Lfoundation/metaplex/amount/AmountErrors$AmountMismatchError;", "Lfoundation/metaplex/amount/AmountErrors$UnexpectedAmountError;", "amount"})
public abstract class AmountErrors
extends Exception {
    private AmountErrors(String message) {
        super(message);
    }

    public /* synthetic */ AmountErrors(String message, DefaultConstructorMarker $constructor_marker) {
        this(message);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0011\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J9\u0010\u0010\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lfoundation/metaplex/amount/AmountErrors$AmountMismatchError;", "Lfoundation/metaplex/amount/AmountErrors;", "left", "Lfoundation/metaplex/amount/Amount;", "right", "operation", "", "(Lfoundation/metaplex/amount/Amount;Lfoundation/metaplex/amount/Amount;Ljava/lang/String;)V", "getLeft", "()Lfoundation/metaplex/amount/Amount;", "getOperation", "()Ljava/lang/String;", "getRight", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "amount"})
    public static final class AmountMismatchError
    extends AmountErrors {
        @NotNull
        private final Amount<?, ?> left;
        @NotNull
        private final Amount<?, ?> right;
        @Nullable
        private final String operation;

        public AmountMismatchError(@NotNull Amount<?, ?> left, @NotNull Amount<?, ?> right, @Nullable String operation) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            super("The SDK tried to execute an operation[" + operation + "] on two amounts of different types: [" + left.getIdentifier() + " with " + left.getDecimals() + " decimals] and [" + right.getIdentifier() + " with " + right.getDecimals() + " decimals]. Provide both amounts in the same type to perform this operation.", (DefaultConstructorMarker)null);
            this.left = left;
            this.right = right;
            this.operation = operation;
        }

        @NotNull
        public final Amount<?, ?> getLeft() {
            return this.left;
        }

        @NotNull
        public final Amount<?, ?> getRight() {
            return this.right;
        }

        @Nullable
        public final String getOperation() {
            return this.operation;
        }

        @NotNull
        public final Amount<?, ?> component1() {
            return this.left;
        }

        @NotNull
        public final Amount<?, ?> component2() {
            return this.right;
        }

        @Nullable
        public final String component3() {
            return this.operation;
        }

        @NotNull
        public final AmountMismatchError copy(@NotNull Amount<?, ?> left, @NotNull Amount<?, ?> right, @Nullable String operation) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            return new AmountMismatchError(left, right, operation);
        }

        public static /* synthetic */ AmountMismatchError copy$default(AmountMismatchError amountMismatchError, Amount amount, Amount amount2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                amount = amountMismatchError.left;
            }
            if ((n & 2) != 0) {
                amount2 = amountMismatchError.right;
            }
            if ((n & 4) != 0) {
                string = amountMismatchError.operation;
            }
            return amountMismatchError.copy(amount, amount2, string);
        }

        @Override
        @NotNull
        public String toString() {
            return "AmountMismatchError(left=" + this.left + ", right=" + this.right + ", operation=" + this.operation + ")";
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            result = result * 31 + (this.operation == null ? 0 : this.operation.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AmountMismatchError)) {
                return false;
            }
            AmountMismatchError amountMismatchError = (AmountMismatchError)other;
            if (!Intrinsics.areEqual(this.left, amountMismatchError.left)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.right, amountMismatchError.right)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.operation, (Object)amountMismatchError.operation);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\r\u0010\u0012\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\r\u0010\u0013\u001a\u00060\bj\u0002`\tH\u00c6\u0003J7\u0010\u0014\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0002"}, d2={"Lfoundation/metaplex/amount/AmountErrors$UnexpectedAmountError;", "Lfoundation/metaplex/amount/AmountErrors;", "amount", "Lfoundation/metaplex/amount/Amount;", "expectedIdentifier", "", "Lfoundation/metaplex/amount/AmountIdentifier;", "expectedDecimals", "", "Lfoundation/metaplex/amount/AmountDecimals;", "(Lfoundation/metaplex/amount/Amount;Ljava/lang/String;I)V", "getAmount", "()Lfoundation/metaplex/amount/Amount;", "getExpectedDecimals", "()I", "getExpectedIdentifier", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString"})
    public static final class UnexpectedAmountError
    extends AmountErrors {
        @NotNull
        private final Amount<?, ?> amount;
        @NotNull
        private final String expectedIdentifier;
        private final int expectedDecimals;

        public UnexpectedAmountError(@NotNull Amount<?, ?> amount, @NotNull String expectedIdentifier, int expectedDecimals) {
            Intrinsics.checkNotNullParameter(amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)expectedIdentifier, (String)"expectedIdentifier");
            super("Expected amount of type [" + expectedIdentifier + " with " + expectedDecimals + " decimals] but got [" + amount.getIdentifier() + " with " + amount.getDecimals() + " decimals]. Ensure the provided Amount is of the expected type.", (DefaultConstructorMarker)null);
            this.amount = amount;
            this.expectedIdentifier = expectedIdentifier;
            this.expectedDecimals = expectedDecimals;
        }

        @NotNull
        public final Amount<?, ?> getAmount() {
            return this.amount;
        }

        @NotNull
        public final String getExpectedIdentifier() {
            return this.expectedIdentifier;
        }

        public final int getExpectedDecimals() {
            return this.expectedDecimals;
        }

        @NotNull
        public final Amount<?, ?> component1() {
            return this.amount;
        }

        @NotNull
        public final String component2() {
            return this.expectedIdentifier;
        }

        public final int component3() {
            return this.expectedDecimals;
        }

        @NotNull
        public final UnexpectedAmountError copy(@NotNull Amount<?, ?> amount, @NotNull String expectedIdentifier, int expectedDecimals) {
            Intrinsics.checkNotNullParameter(amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)expectedIdentifier, (String)"expectedIdentifier");
            return new UnexpectedAmountError(amount, expectedIdentifier, expectedDecimals);
        }

        public static /* synthetic */ UnexpectedAmountError copy$default(UnexpectedAmountError unexpectedAmountError, Amount amount, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                amount = unexpectedAmountError.amount;
            }
            if ((n2 & 2) != 0) {
                string = unexpectedAmountError.expectedIdentifier;
            }
            if ((n2 & 4) != 0) {
                n = unexpectedAmountError.expectedDecimals;
            }
            return unexpectedAmountError.copy(amount, string, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "UnexpectedAmountError(amount=" + this.amount + ", expectedIdentifier=" + this.expectedIdentifier + ", expectedDecimals=" + this.expectedDecimals + ")";
        }

        public int hashCode() {
            int result = this.amount.hashCode();
            result = result * 31 + this.expectedIdentifier.hashCode();
            result = result * 31 + Integer.hashCode(this.expectedDecimals);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnexpectedAmountError)) {
                return false;
            }
            UnexpectedAmountError unexpectedAmountError = (UnexpectedAmountError)other;
            if (!Intrinsics.areEqual(this.amount, unexpectedAmountError.amount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expectedIdentifier, (Object)unexpectedAmountError.expectedIdentifier)) {
                return false;
            }
            return this.expectedDecimals == unexpectedAmountError.expectedDecimals;
        }
    }
}

