/*
 * Decompiled with CFR 0.152.
 */
package foundation.metaplex.amount;

import com.ionspin.kotlin.bignum.BigNumber;
import com.ionspin.kotlin.bignum.integer.BigInteger;
import foundation.metaplex.amount.Amount;
import foundation.metaplex.amount.AmountErrors;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u001aB\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\u001aV\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\u001a\u0016\u0010\f\u001a\u00020\r2\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u001a'\u0010\u000e\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0010\u001aG\u0010\u0011\u001a\u00020\u0012\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\u0006\u0010\u0014\u001a\u0002H\u00022\u0006\u0010\u0015\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u0016\u001a2\u0010\u0017\u001a\u00020\u00122\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0019\u001a\u00020\u00122\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u001aJ\u0010\u001b\u001a\u00020\u0006\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\u001aK\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u0002H\u00022\u0006\u0010\u0015\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u001f\u001aK\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u0002H\u00022\u0006\u0010\u0015\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010 \u001aK\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\u0014\u001a\u0002H\u00022\u0006\u0010\u0015\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\"\u001aK\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0014\u001a\u0002H\u00022\u0006\u0010\u0015\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010%\u001a'\u0010&\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0010\u001aJ\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010(\u001a\u00020\u001e\u001aJ\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010(\u001a\u00020)\u001aG\u0010*\u001a\u00020+\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\u0006\u0010\u0014\u001a\u0002H\u00022\u0006\u0010\u0015\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010,\u001ab\u0010-\u001a\u00020+\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0016\b\u0002\u0010.\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u0001\u001aJ\u0010/\u001a\u00020+\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\u001aJ\u00100\u001a\u00020+\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\u001aJ\u00101\u001a\u00020+\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\u001aJ\u00102\u001a\u00020+\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\u001a\u0016\u00103\u001a\u00020+2\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u001a\u0016\u00104\u001a\u00020+2\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u001a\u0016\u00105\u001a\u00020+2\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u001a\u001e\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`72\u0006\u00106\u001a\u00020\u001e\u001a\u001e\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`72\u0006\u00106\u001a\u00020\u0006\u001a\u001e\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`72\u0006\u00106\u001a\u00020!\u001aJ\u00108\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u00109\u001a\u00020\u001e\u001aJ\u00108\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u00109\u001a\u00020)\u001aA\u0010:\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00030\u0001j\b\u0012\u0004\u0012\u0002H\u0003`;\"\f\b\u0000\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0006\u0010<\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010=\u001a&\u0010>\u001a\u00020+2\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0001\u001a\u001e\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`72\u0006\u0010?\u001a\u00020\r\u001a\u001e\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`72\u0006\u0010?\u001a\u00020\u0006\u001aV\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\u001aS\u0010A\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0006\u0010B\u001a\u00020\r2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u0001H\u00022\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u0001H\u0003\u00a2\u0006\u0002\u0010C\u001aS\u0010A\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\f\b\u0000\u0010\u0002*\u00060\u0004j\u0002`\u0005\"\f\b\u0001\u0010\u0003*\u00060\u0006j\u0002`\u00072\u0006\u0010B\u001a\u00020\u00062\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u0001H\u00022\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u0001H\u0003\u00a2\u0006\u0002\u0010D*\n\u0010E\"\u00020\u00062\u00020\u0006*\n\u0010F\"\u00020\u00042\u00020\u0004*(\u0010G\u001a\u0004\b\u0000\u0010\u0003\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00030\u0001*\"\u0010H\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0001\u00a8\u0006\u0013"}, d2={"absoluteAmount", "Lfoundation/metaplex/amount/Amount;", "I", "D", "", "Lfoundation/metaplex/amount/AmountIdentifier;", "", "Lfoundation/metaplex/amount/AmountDecimals;", "value", "addAmounts", "left", "right", "amountToNumber", "", "amountToString", "maxDecimals", "(Lfoundation/metaplex/amount/Amount;Ljava/lang/Integer;)Ljava/lang/String;", "assertAmount", "", "amount", "identifier", "decimals", "(Lfoundation/metaplex/amount/Amount;Ljava/lang/String;I)V", "assertSameAmounts", "operation", "assertSolAmount", "actual", "compareAmounts", "createAmount", "basisPoints", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "(Lcom/ionspin/kotlin/bignum/integer/BigInteger;Ljava/lang/String;I)Lfoundation/metaplex/amount/Amount;", "(ILjava/lang/String;I)Lfoundation/metaplex/amount/Amount;", "", "(JLjava/lang/String;I)Lfoundation/metaplex/amount/Amount;", "createAmountFromDecimals", "decimalAmount", "(DLjava/lang/String;I)Lfoundation/metaplex/amount/Amount;", "displayAmount", "divideAmount", "divisor", "", "isAmount", "", "(Lfoundation/metaplex/amount/Amount;Ljava/lang/String;I)Z", "isEqualToAmount", "tolerance", "isGreaterThanAmount", "isGreaterThanOrEqualToAmount", "isLessThanAmount", "isLessThanOrEqualToAmount", "isNegativeAmount", "isPositiveAmount", "isZeroAmount", "lamports", "Lfoundation/metaplex/amount/SolAmount;", "multiplyAmount", "multiplier", "percentAmount", "Lfoundation/metaplex/amount/PercentAmount;", "percent", "(DI)Lfoundation/metaplex/amount/Amount;", "sameAmounts", "sol", "subtractAmounts", "tokenAmount", "tokens", "(DLjava/lang/String;Ljava/lang/Integer;)Lfoundation/metaplex/amount/Amount;", "(ILjava/lang/String;Ljava/lang/Integer;)Lfoundation/metaplex/amount/Amount;", "AmountDecimals", "AmountIdentifier", "PercentAmount", "SolAmount"})
public final class AmountKt {
    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> createAmount(@NotNull BigInteger basisPoints, @NotNull I identifier, D decimals) {
        Intrinsics.checkNotNullParameter((Object)basisPoints, (String)"basisPoints");
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        return new Amount<I, D>(basisPoints, identifier, decimals);
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> createAmount(int basisPoints, @NotNull I identifier, D decimals) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        return AmountKt.createAmount(new BigInteger(basisPoints), identifier, decimals);
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> createAmount(long basisPoints, @NotNull I identifier, D decimals) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        return AmountKt.createAmount(new BigInteger(basisPoints), identifier, decimals);
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> createAmountFromDecimals(double decimalAmount, @NotNull I identifier, D decimals) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        Amount<I, D> exponentAmount = AmountKt.createAmount((BigInteger)BigNumber.Creator.DefaultImpls.tryFromDouble$default((BigNumber.Creator)((BigNumber.Creator)BigInteger.Companion), (double)Math.pow(10.0, decimals), (boolean)false, (int)2, null), identifier, decimals);
        return AmountKt.multiplyAmount(exponentAmount, decimalAmount);
    }

    @NotNull
    public static final <D extends Integer> Amount<String, D> percentAmount(double percent, D decimals) {
        return AmountKt.createAmountFromDecimals(percent, "%", decimals);
    }

    public static /* synthetic */ Amount percentAmount$default(double d, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return AmountKt.percentAmount(d, n.intValue());
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> tokenAmount(double tokens, @Nullable I identifier, @Nullable D decimals) {
        Object object = identifier;
        if (object == null) {
            object = "splToken";
        }
        D d = decimals;
        return AmountKt.createAmountFromDecimals(tokens, object, d != null ? d.intValue() : 0);
    }

    public static /* synthetic */ Amount tokenAmount$default(double d, String string, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return AmountKt.tokenAmount(d, string, n);
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> tokenAmount(int tokens, @Nullable I identifier, @Nullable D decimals) {
        double d = tokens;
        Object object = identifier;
        if (object == null) {
            object = "splToken";
        }
        D d2 = decimals;
        return AmountKt.tokenAmount(d, object, Integer.valueOf(d2 != null ? d2.intValue() : 0));
    }

    public static /* synthetic */ Amount tokenAmount$default(int n, String string, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return AmountKt.tokenAmount(n, string, n2);
    }

    @NotNull
    public static final Amount<String, Integer> lamports(@NotNull BigInteger lamports) {
        Intrinsics.checkNotNullParameter((Object)lamports, (String)"lamports");
        return AmountKt.createAmount(lamports, "SOL", 9);
    }

    @NotNull
    public static final Amount<String, Integer> lamports(int lamports) {
        return AmountKt.createAmount(new BigInteger(lamports), "SOL", 9);
    }

    @NotNull
    public static final Amount<String, Integer> lamports(long lamports) {
        return AmountKt.createAmount(new BigInteger(lamports), "SOL", 9);
    }

    @NotNull
    public static final Amount<String, Integer> sol(int sol) {
        return AmountKt.sol((double)sol);
    }

    @NotNull
    public static final Amount<String, Integer> sol(double sol) {
        return AmountKt.createAmountFromDecimals(sol, "SOL", 9);
    }

    public static final boolean sameAmounts(@NotNull Amount<?, ?> left, @NotNull Amount<?, ?> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return AmountKt.isAmount(left, right.getIdentifier(), right.getDecimals());
    }

    public static final <I extends String, D extends Integer> boolean isAmount(@NotNull Amount<?, ?> amount, @NotNull I identifier, D decimals) {
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        return Intrinsics.areEqual(amount.getIdentifier(), identifier) && amount.getDecimals() == decimals;
    }

    public static final <I extends String, D extends Integer> void assertAmount(@NotNull Amount<?, ?> amount, @NotNull I identifier, D decimals) {
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        if (!AmountKt.isAmount(amount, identifier, decimals)) {
            throw new AmountErrors.UnexpectedAmountError(amount, identifier, decimals);
        }
    }

    public static final void assertSolAmount(@NotNull Amount<?, ?> actual) {
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        AmountKt.assertAmount(actual, "SOL", 9);
    }

    public static final void assertSameAmounts(@NotNull Amount<?, ?> left, @NotNull Amount<?, ?> right, @Nullable String operation) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (!AmountKt.sameAmounts(left, right)) {
            throw new AmountErrors.AmountMismatchError(left, right, operation);
        }
    }

    public static /* synthetic */ void assertSameAmounts$default(Amount amount, Amount amount2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        AmountKt.assertSameAmounts(amount, amount2, string);
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> addAmounts(@NotNull Amount<I, D> left, @NotNull Amount<I, D> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        AmountKt.assertSameAmounts(left, right, "add");
        return new Amount<I, D>((BigInteger)left.getBasisPoints().plus((BigNumber)right.getBasisPoints()), left.getIdentifier(), left.getDecimals());
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> subtractAmounts(@NotNull Amount<I, D> left, @NotNull Amount<I, D> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        AmountKt.assertSameAmounts(left, right, "subtract");
        return new Amount<I, D>((BigInteger)left.getBasisPoints().minus((BigNumber)right.getBasisPoints()), left.getIdentifier(), left.getDecimals());
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> multiplyAmount(@NotNull Amount<I, D> left, @NotNull Number multiplier) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)multiplier, (String)"multiplier");
        String[] stringArray = new String[]{"."};
        List list = StringsKt.split$default((CharSequence)String.valueOf(multiplier.doubleValue()), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String units = (String)list.get(0);
        String decimals = (String)list.get(1);
        String multiplierBasisPointsString = units + decimals;
        BigInteger multiplierBasisPoints = (BigInteger)BigNumber.Creator.DefaultImpls.parseString$default((BigNumber.Creator)((BigNumber.Creator)BigInteger.Companion), (String)multiplierBasisPointsString, (int)0, (int)2, null);
        BigInteger multiplierExponents = new BigInteger(10).pow(new BigInteger(decimals.length()));
        return new Amount<I, D>((BigInteger)((BigInteger)left.getBasisPoints().times((BigNumber)multiplierBasisPoints)).div((BigNumber)multiplierExponents), left.getIdentifier(), left.getDecimals());
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> multiplyAmount(@NotNull Amount<I, D> left, @NotNull BigInteger multiplier) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)multiplier, (String)"multiplier");
        return new Amount<I, D>((BigInteger)left.getBasisPoints().times((BigNumber)multiplier), left.getIdentifier(), left.getDecimals());
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> divideAmount(@NotNull Amount<I, D> left, @NotNull BigInteger divisor) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        return new Amount<I, D>((BigInteger)left.getBasisPoints().div((BigNumber)divisor), left.getIdentifier(), left.getDecimals());
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> divideAmount(@NotNull Amount<I, D> left, @NotNull Number divisor) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        BigInteger divisorBasisPoints = BigInteger.Companion.tryFromDouble(divisor.doubleValue(), true);
        return new Amount<I, D>((BigInteger)left.getBasisPoints().div((BigNumber)divisorBasisPoints), left.getIdentifier(), left.getDecimals());
    }

    @NotNull
    public static final <I extends String, D extends Integer> Amount<I, D> absoluteAmount(@NotNull Amount<I, D> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        BigInteger x = value.getBasisPoints();
        return new Amount<I, D>(x.compareTo((Object)BigInteger.Companion.getZERO()) < 0 ? x.unaryMinus() : x, value.getIdentifier(), value.getDecimals());
    }

    public static final <I extends String, D extends Integer> int compareAmounts(@NotNull Amount<I, D> left, @NotNull Amount<I, D> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        AmountKt.assertSameAmounts(left, right, "compare");
        return left.getBasisPoints().compareTo((Object)right.getBasisPoints()) > 0 ? 1 : (left.getBasisPoints().compareTo((Object)right.getBasisPoints()) < 0 ? -1 : 0);
    }

    public static final <I extends String, D extends Integer> boolean isEqualToAmount(@NotNull Amount<I, D> left, @NotNull Amount<I, D> right, @Nullable Amount<I, D> tolerance) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        Amount<I, D> delta = AmountKt.absoluteAmount(AmountKt.subtractAmounts(left, right));
        Amount<I, D> amount = tolerance;
        if (amount == null) {
            amount = AmountKt.createAmount(BigInteger.Companion.getZERO(), left.getIdentifier(), left.getDecimals());
        }
        Amount<I, D> toleranceOrDefault = amount;
        AmountKt.assertSameAmounts(left, right, "isEqualToAmount");
        AmountKt.assertSameAmounts(left, toleranceOrDefault, "isEqualToAmount");
        return AmountKt.isLessThanOrEqualToAmount(delta, toleranceOrDefault);
    }

    public static /* synthetic */ boolean isEqualToAmount$default(Amount amount, Amount amount2, Amount amount3, int n, Object object) {
        if ((n & 4) != 0) {
            amount3 = null;
        }
        return AmountKt.isEqualToAmount(amount, amount2, amount3);
    }

    public static final <I extends String, D extends Integer> boolean isLessThanAmount(@NotNull Amount<I, D> left, @NotNull Amount<I, D> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return AmountKt.compareAmounts(left, right) < 0;
    }

    public static final <I extends String, D extends Integer> boolean isLessThanOrEqualToAmount(@NotNull Amount<I, D> left, @NotNull Amount<I, D> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return AmountKt.compareAmounts(left, right) <= 0;
    }

    public static final <I extends String, D extends Integer> boolean isGreaterThanAmount(@NotNull Amount<I, D> left, @NotNull Amount<I, D> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return AmountKt.compareAmounts(left, right) > 0;
    }

    public static final <I extends String, D extends Integer> boolean isGreaterThanOrEqualToAmount(@NotNull Amount<I, D> left, @NotNull Amount<I, D> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return AmountKt.compareAmounts(left, right) >= 0;
    }

    public static final boolean isZeroAmount(@NotNull Amount<?, ?> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return Intrinsics.areEqual((Object)value.getBasisPoints(), (Object)BigInteger.Companion.getZERO());
    }

    public static final boolean isPositiveAmount(@NotNull Amount<?, ?> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return value.getBasisPoints().compareTo((Object)BigInteger.Companion.getZERO()) >= 0;
    }

    public static final boolean isNegativeAmount(@NotNull Amount<?, ?> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return value.getBasisPoints().compareTo((Object)BigInteger.Companion.getZERO()) < 0;
    }

    @NotNull
    public static final String amountToString(@NotNull Amount<?, ?> value, @Nullable Integer maxDecimals) {
        String decimals;
        String units;
        String sign;
        block1: {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String text = value.getBasisPoints().toString();
            if (value.getDecimals() == false) {
                return text;
            }
            sign = StringsKt.startsWith$default((CharSequence)text, (char)'-', (boolean)false, (int)2, null) ? "-" : "";
            text = StringsKt.replace$default((String)text, (String)"-", (String)"", (boolean)false, (int)4, null);
            text = StringsKt.padStart((String)text, (int)(value.getDecimals() + true), (char)'0');
            String string = text.substring(0, text.length() - value.getDecimals());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            units = string;
            decimals = null;
            String string2 = text.substring(text.length() - value.getDecimals());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            decimals = string2;
            Integer n = maxDecimals;
            if (n == null) break block1;
            int it = ((Number)n).intValue();
            boolean bl = false;
            String string3 = decimals.substring(0, it);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            decimals = string3;
        }
        return sign + units + "." + decimals;
    }

    public static /* synthetic */ String amountToString$default(Amount amount, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return AmountKt.amountToString(amount, n);
    }

    public static final double amountToNumber(@NotNull Amount<?, ?> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return Double.parseDouble(AmountKt.amountToString$default(value, null, 2, null));
    }

    @NotNull
    public static final String displayAmount(@NotNull Amount<?, ?> value, @Nullable Integer maxDecimals) {
        String string;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        String amountAsString = AmountKt.amountToString(value, maxDecimals);
        Object obj = value.getIdentifier();
        if (Intrinsics.areEqual(obj, (Object)"%")) {
            string = amountAsString + "%";
        } else if (Intrinsics.areEqual(obj, (Object)"splToken")) {
            string = Math.abs(Double.parseDouble(amountAsString)) == 1.0 ? amountAsString + " Token" : amountAsString + " Tokens";
        } else if (StringsKt.startsWith$default(value.getIdentifier(), (String)"splToken.", (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'.'};
            String identifier = (String)StringsKt.split$default((CharSequence)((CharSequence)value.getIdentifier()), (char[])cArray, (boolean)false, (int)0, (int)6, null).get(1);
            string = identifier + " " + amountAsString;
        } else {
            string = value.getIdentifier() + " " + amountAsString;
        }
        return string;
    }

    public static /* synthetic */ String displayAmount$default(Amount amount, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return AmountKt.displayAmount(amount, n);
    }
}

