/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ContextThemeWrapper;
import android.text.TextUtils;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayer;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.Locale;

public class JCUtils {
    public static String stringForTime(int timeMs) {
        if (timeMs <= 0 || timeMs >= 86400000) {
            return "00:00";
        }
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        StringBuilder stringBuilder = new StringBuilder();
        Formatter mFormatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hours > 0) {
            return mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 1;
    }

    public static Activity scanForActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return JCUtils.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public static AppCompatActivity getAppCompActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof AppCompatActivity) {
            return (AppCompatActivity)context;
        }
        if (context instanceof ContextThemeWrapper) {
            return JCUtils.getAppCompActivity(((ContextThemeWrapper)context).getBaseContext());
        }
        return null;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static void saveProgress(Context context, String url, int progress) {
        if (!JCVideoPlayer.SAVE_PROGRESS) {
            return;
        }
        SharedPreferences spn = context.getSharedPreferences("JCVD_PROGRESS", 0);
        SharedPreferences.Editor editor = spn.edit();
        editor.putInt(url, progress);
        editor.apply();
    }

    public static int getSavedProgress(Context context, String url) {
        if (!JCVideoPlayer.SAVE_PROGRESS) {
            return 0;
        }
        SharedPreferences spn = context.getSharedPreferences("JCVD_PROGRESS", 0);
        return spn.getInt(url, 0);
    }

    public static void clearSavedProgress(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            SharedPreferences spn = context.getSharedPreferences("JCVD_PROGRESS", 0);
            spn.edit().clear().apply();
        } else {
            SharedPreferences spn = context.getSharedPreferences("JCVD_PROGRESS", 0);
            spn.edit().putInt(url, 0).apply();
        }
    }

    public static String getCurrentUrlFromMap(LinkedHashMap<String, String> map, int index) {
        if (map.size() == 1) {
            return JCUtils.getValueFromLinkedMap(map, index);
        }
        return JCUtils.getValueFromLinkedMap(map, index);
    }

    public static String getValueFromLinkedMap(LinkedHashMap<String, String> map, int index) {
        int currentIndex = 0;
        for (String key : map.keySet()) {
            if (currentIndex == index) {
                return map.get(key);
            }
            ++currentIndex;
        }
        return null;
    }

    public static String getKeyFromLinkedMap(LinkedHashMap<String, String> map, int index) {
        int currentIndex = 0;
        for (String key : map.keySet()) {
            if (currentIndex == index) {
                return key.toString();
            }
            ++currentIndex;
        }
        return null;
    }
}

