/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import fm.jiecao.jcvideoplayer_lib.JCResizeTextureView;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayerManager;
import java.lang.reflect.Method;
import java.util.Map;

public class JCMediaManager
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnVideoSizeChangedListener {
    public static String TAG = "JieCaoVideoPlayer";
    private static JCMediaManager JCMediaManager;
    public static JCResizeTextureView textureView;
    public static SurfaceTexture savedSurfaceTexture;
    public MediaPlayer mediaPlayer = new MediaPlayer();
    public static String CURRENT_PLAYING_URL;
    public static boolean CURRENT_PLING_LOOP;
    public static Map<String, String> MAP_HEADER_DATA;
    public int currentVideoWidth = 0;
    public int currentVideoHeight = 0;
    public static final int HANDLER_PREPARE = 0;
    public static final int HANDLER_RELEASE = 2;
    HandlerThread mMediaHandlerThread = new HandlerThread(TAG);
    MediaHandler mMediaHandler;
    Handler mainThreadHandler;

    public static JCMediaManager instance() {
        if (JCMediaManager == null) {
            JCMediaManager = new JCMediaManager();
        }
        return JCMediaManager;
    }

    public JCMediaManager() {
        this.mMediaHandlerThread.start();
        this.mMediaHandler = new MediaHandler(this.mMediaHandlerThread.getLooper());
        this.mainThreadHandler = new Handler();
    }

    public Point getVideoSize() {
        if (this.currentVideoWidth != 0 && this.currentVideoHeight != 0) {
            return new Point(this.currentVideoWidth, this.currentVideoHeight);
        }
        return null;
    }

    public void prepare() {
        this.releaseMediaPlayer();
        Message msg = new Message();
        msg.what = 0;
        this.mMediaHandler.sendMessage(msg);
    }

    public void releaseMediaPlayer() {
        Message msg = new Message();
        msg.what = 2;
        this.mMediaHandler.sendMessage(msg);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int i, int i1) {
        Log.i((String)TAG, (String)("onSurfaceTextureAvailable [" + ((Object)((Object)JCVideoPlayerManager.getCurrentJcvd())).hashCode() + "] "));
        if (savedSurfaceTexture == null) {
            savedSurfaceTexture = surfaceTexture;
            this.prepare();
        } else {
            textureView.setSurfaceTexture(savedSurfaceTexture);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int i, int i1) {
        Log.i((String)TAG, (String)("onSurfaceTextureSizeChanged [" + ((Object)((Object)JCVideoPlayerManager.getCurrentJcvd())).hashCode() + "] "));
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return savedSurfaceTexture == null;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public void onPrepared(MediaPlayer mp) {
        this.mediaPlayer.start();
    }

    public void onCompletion(MediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JCVideoPlayerManager.getCurrentJcvd() != null) {
                    JCVideoPlayerManager.getCurrentJcvd().onAutoCompletion();
                }
            }
        });
    }

    public void onBufferingUpdate(MediaPlayer mp, final int percent) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JCVideoPlayerManager.getCurrentJcvd() != null) {
                    JCVideoPlayerManager.getCurrentJcvd().setBufferProgress(percent);
                }
            }
        });
    }

    public void onSeekComplete(MediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JCVideoPlayerManager.getCurrentJcvd() != null) {
                    JCVideoPlayerManager.getCurrentJcvd().onSeekComplete();
                }
            }
        });
    }

    public boolean onError(MediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JCVideoPlayerManager.getCurrentJcvd() != null) {
                    JCVideoPlayerManager.getCurrentJcvd().onError(what, extra);
                }
            }
        });
        return true;
    }

    public boolean onInfo(MediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JCVideoPlayerManager.getCurrentJcvd() != null) {
                    JCVideoPlayerManager.getCurrentJcvd().onInfo(what, extra);
                }
            }
        });
        return false;
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        this.currentVideoWidth = width;
        this.currentVideoHeight = height;
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JCVideoPlayerManager.getCurrentJcvd() != null) {
                    JCVideoPlayerManager.getCurrentJcvd().onVideoSizeChanged();
                }
            }
        });
    }

    public class MediaHandler
    extends Handler {
        public MediaHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    try {
                        JCMediaManager.this.currentVideoWidth = 0;
                        JCMediaManager.this.currentVideoHeight = 0;
                        JCMediaManager.this.mediaPlayer.release();
                        JCMediaManager.this.mediaPlayer = new MediaPlayer();
                        JCMediaManager.this.mediaPlayer.setAudioStreamType(3);
                        JCMediaManager.this.mediaPlayer.setLooping(CURRENT_PLING_LOOP);
                        JCMediaManager.this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)JCMediaManager.this);
                        JCMediaManager.this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)JCMediaManager.this);
                        JCMediaManager.this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)JCMediaManager.this);
                        JCMediaManager.this.mediaPlayer.setScreenOnWhilePlaying(true);
                        JCMediaManager.this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)JCMediaManager.this);
                        JCMediaManager.this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)JCMediaManager.this);
                        JCMediaManager.this.mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)JCMediaManager.this);
                        JCMediaManager.this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)JCMediaManager.this);
                        Class<MediaPlayer> clazz = MediaPlayer.class;
                        Method method = clazz.getDeclaredMethod("setDataSource", String.class, Map.class);
                        method.invoke((Object)JCMediaManager.this.mediaPlayer, CURRENT_PLAYING_URL, MAP_HEADER_DATA);
                        JCMediaManager.this.mediaPlayer.prepareAsync();
                        JCMediaManager.this.mediaPlayer.setSurface(new Surface(savedSurfaceTexture));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    JCMediaManager.this.mediaPlayer.release();
                }
            }
        }
    }
}

