/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.content.ContentResolver;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.media.AudioManager;
import android.os.Handler;
import android.provider.Settings;
import android.support.v7.app.ActionBar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.JCResizeTextureView;
import fm.jiecao.jcvideoplayer_lib.JCUserAction;
import fm.jiecao.jcvideoplayer_lib.JCUtils;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayerManager;
import fm.jiecao.jcvideoplayer_lib.R;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class JCVideoPlayer
extends FrameLayout
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
View.OnTouchListener {
    public static final String TAG = "JieCaoVideoPlayer";
    public static boolean ACTION_BAR_EXIST = true;
    public static boolean TOOL_BAR_EXIST = true;
    public static int FULLSCREEN_ORIENTATION = 4;
    public static int NORMAL_ORIENTATION = 1;
    public static boolean SAVE_PROGRESS = true;
    public static boolean WIFI_TIP_DIALOG_SHOWED = false;
    public static final int FULLSCREEN_ID = 33797;
    public static final int TINY_ID = 33798;
    public static final int THRESHOLD = 80;
    public static final int FULL_SCREEN_NORMAL_DELAY = 300;
    public static long CLICK_QUIT_FULLSCREEN_TIME = 0L;
    public static final int SCREEN_LAYOUT_NORMAL = 0;
    public static final int SCREEN_LAYOUT_LIST = 1;
    public static final int SCREEN_WINDOW_FULLSCREEN = 2;
    public static final int SCREEN_WINDOW_TINY = 3;
    public static final int CURRENT_STATE_NORMAL = 0;
    public static final int CURRENT_STATE_PREPARING = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_PLAYING_BUFFERING_START = 3;
    public static final int CURRENT_STATE_PAUSE = 5;
    public static final int CURRENT_STATE_AUTO_COMPLETE = 6;
    public static final int CURRENT_STATE_ERROR = 7;
    public static int BACKUP_PLAYING_BUFFERING_STATE = -1;
    public int currentState = -1;
    public int currentScreen = -1;
    public boolean loop = false;
    public Map<String, String> headData;
    public String url = "";
    public Object[] objects = null;
    public int seekToInAdvance = 0;
    public ImageView startButton;
    public SeekBar progressBar;
    public ImageView fullscreenButton;
    public TextView currentTimeTextView;
    public TextView totalTimeTextView;
    public ViewGroup textureViewContainer;
    public ViewGroup topContainer;
    public ViewGroup bottomContainer;
    protected static JCUserAction JC_USER_EVENT;
    protected static Timer UPDATE_PROGRESS_TIMER;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected AudioManager mAudioManager;
    protected Handler mHandler;
    protected ProgressTimerTask mProgressTimerTask;
    protected boolean mTouchingProgressBar;
    protected float mDownX;
    protected float mDownY;
    protected boolean mChangeVolume;
    protected boolean mChangePosition;
    protected boolean mChangeBrightness;
    protected int mGestureDownPosition;
    protected int mGestureDownVolume;
    protected float mGestureDownBrightness;
    protected int mSeekTimePosition;
    public int widthRatio = 16;
    public int heightRatio = 9;
    public static long lastAutoFullscreenTime;
    public static AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener;

    public JCVideoPlayer(Context context) {
        super(context);
        this.init(context);
    }

    public JCVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void init(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.startButton = (ImageView)this.findViewById(R.id.start);
        this.fullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.progressBar = (SeekBar)this.findViewById(R.id.bottom_seek_progress);
        this.currentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.totalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.bottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.textureViewContainer = (ViewGroup)this.findViewById(R.id.surface_container);
        this.topContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.startButton.setOnClickListener((View.OnClickListener)this);
        this.fullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.bottomContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.mScreenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mHandler = new Handler();
    }

    public void setUp(String url, int screen, Object ... objects) {
        if (!TextUtils.isEmpty((CharSequence)this.url) && TextUtils.equals((CharSequence)this.url, (CharSequence)url)) {
            return;
        }
        this.url = url;
        this.objects = objects;
        this.currentScreen = screen;
        this.headData = null;
        this.setUiWitStateAndScreen(0);
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start) {
            Log.i((String)TAG, (String)("onClick start [" + ((Object)((Object)this)).hashCode() + "] "));
            if (TextUtils.isEmpty((CharSequence)this.url)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.currentState == 0 || this.currentState == 7) {
                if (!(this.url.startsWith("file") || JCUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
                    this.showWifiDialog();
                    return;
                }
                this.prepareMediaPlayer();
                this.onEvent(this.currentState != 7 ? 0 : 1);
            } else if (this.currentState == 2) {
                this.onEvent(3);
                Log.d((String)TAG, (String)("pauseVideo [" + ((Object)((Object)this)).hashCode() + "] "));
                JCMediaManager.instance().mediaPlayer.pause();
                this.setUiWitStateAndScreen(5);
            } else if (this.currentState == 5) {
                this.onEvent(4);
                JCMediaManager.instance().mediaPlayer.start();
                this.setUiWitStateAndScreen(2);
            } else if (this.currentState == 6) {
                this.onEvent(2);
                this.prepareMediaPlayer();
            }
        } else if (i == R.id.fullscreen) {
            Log.i((String)TAG, (String)("onClick fullscreen [" + ((Object)((Object)this)).hashCode() + "] "));
            if (this.currentState == 6) {
                return;
            }
            if (this.currentScreen == 2) {
                JCVideoPlayer.backPress();
            } else {
                Log.d((String)TAG, (String)("toFullscreenActivity [" + ((Object)((Object)this)).hashCode() + "] "));
                this.onEvent(7);
                this.startWindowFullscreen();
            }
        } else if (i == R.id.surface_container && this.currentState == 7) {
            Log.i((String)TAG, (String)("onClick surfaceContainer State=Error [" + ((Object)((Object)this)).hashCode() + "] "));
            this.prepareMediaPlayer();
        }
    }

    public void prepareMediaPlayer() {
        JCVideoPlayerManager.completeAll();
        Log.d((String)TAG, (String)("prepareMediaPlayer [" + ((Object)((Object)this)).hashCode() + "] "));
        this.initTextureView();
        this.addTextureView();
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.requestAudioFocus(onAudioFocusChangeListener, 3, 2);
        JCUtils.scanForActivity(this.getContext()).getWindow().addFlags(128);
        JCMediaManager.CURRENT_PLAYING_URL = this.url;
        JCMediaManager.CURRENT_PLING_LOOP = this.loop;
        JCMediaManager.MAP_HEADER_DATA = this.headData;
        this.setUiWitStateAndScreen(1);
        JCVideoPlayerManager.setFirstFloor(this);
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionDown [" + ((Object)((Object)this)).hashCode() + "] "));
                    this.mTouchingProgressBar = true;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mChangeVolume = false;
                    this.mChangePosition = false;
                    this.mChangeBrightness = false;
                    break;
                }
                case 2: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionMove [" + ((Object)((Object)this)).hashCode() + "] "));
                    float deltaX = x - this.mDownX;
                    float deltaY = y - this.mDownY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if (!(this.currentScreen != 2 || this.mChangePosition || this.mChangeVolume || this.mChangeBrightness || !(absDeltaX > 80.0f) && !(absDeltaY > 80.0f))) {
                        this.cancelProgressTimer();
                        if (absDeltaX >= 80.0f) {
                            if (this.currentState != 7) {
                                this.mChangePosition = true;
                                this.mGestureDownPosition = this.getCurrentPositionWhenPlaying();
                            }
                        } else if (this.mDownX < (float)this.mScreenWidth * 0.5f) {
                            this.mChangeBrightness = true;
                            try {
                                this.mGestureDownBrightness = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness");
                                System.out.println("\u5f53\u524d\u4eae\u5ea6 " + this.mGestureDownBrightness);
                            }
                            catch (Settings.SettingNotFoundException e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.mChangeVolume = true;
                            this.mGestureDownVolume = this.mAudioManager.getStreamVolume(3);
                        }
                    }
                    if (this.mChangePosition) {
                        int totalTimeDuration = this.getDuration();
                        this.mSeekTimePosition = (int)((float)this.mGestureDownPosition + deltaX * (float)totalTimeDuration / (float)this.mScreenWidth);
                        if (this.mSeekTimePosition > totalTimeDuration) {
                            this.mSeekTimePosition = totalTimeDuration;
                        }
                        String seekTime = JCUtils.stringForTime(this.mSeekTimePosition);
                        String totalTime = JCUtils.stringForTime(totalTimeDuration);
                        this.showProgressDialog(deltaX, seekTime, this.mSeekTimePosition, totalTime, totalTimeDuration);
                    }
                    if (this.mChangeVolume) {
                        deltaY = -deltaY;
                        int max = this.mAudioManager.getStreamMaxVolume(3);
                        int deltaV = (int)((float)max * deltaY * 3.0f / (float)this.mScreenHeight);
                        this.mAudioManager.setStreamVolume(3, this.mGestureDownVolume + deltaV, 0);
                        int volumePercent = (int)((float)(this.mGestureDownVolume * 100 / max) + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                        this.showVolumeDialog(-deltaY, volumePercent);
                        System.out.println("percentfdsfdsf : " + volumePercent + " " + deltaY);
                    }
                    if (!this.mChangeBrightness) break;
                    deltaY = -deltaY;
                    int deltaV = (int)(255.0f * deltaY * 3.0f / (float)this.mScreenHeight);
                    WindowManager.LayoutParams params = JCUtils.getAppCompActivity(this.getContext()).getWindow().getAttributes();
                    params.screenBrightness = (this.mGestureDownBrightness + (float)deltaV) / 255.0f >= 1.0f ? 1.0f : ((this.mGestureDownBrightness + (float)deltaV) / 255.0f <= 0.0f ? 0.01f : (this.mGestureDownBrightness + (float)deltaV) / 255.0f);
                    JCUtils.getAppCompActivity(this.getContext()).getWindow().setAttributes(params);
                    int brightnessPercent = (int)(this.mGestureDownBrightness * 100.0f / 255.0f + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                    System.out.println("percentfdsfdsf : " + brightnessPercent + " " + deltaY + " " + this.mGestureDownBrightness);
                    this.showBrightnessDialog(brightnessPercent);
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionUp [" + ((Object)((Object)this)).hashCode() + "] "));
                    this.mTouchingProgressBar = false;
                    this.dismissProgressDialog();
                    this.dismissVolumeDialog();
                    this.dismissBrightnessDialog();
                    if (this.mChangePosition) {
                        this.onEvent(12);
                        JCMediaManager.instance().mediaPlayer.seekTo(this.mSeekTimePosition);
                        int duration = this.getDuration();
                        int progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.progressBar.setProgress(progress);
                    }
                    if (this.mChangeVolume) {
                        this.onEvent(11);
                    }
                    this.startProgressTimer();
                }
            }
        }
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.currentScreen == 2 || this.currentScreen == 3) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (this.widthRatio != 0 && this.heightRatio != 0) {
            int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int specHeight = (int)((float)specWidth * (float)this.heightRatio / (float)this.widthRatio);
            this.setMeasuredDimension(specWidth, specHeight);
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)specWidth, (int)0x40000000);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)specHeight, (int)0x40000000);
            this.getChildAt(0).measure(childWidthMeasureSpec, childHeightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void initTextureView() {
        this.removeTextureView();
        JCMediaManager.textureView = new JCResizeTextureView(this.getContext());
        JCMediaManager.textureView.setSurfaceTextureListener(JCMediaManager.instance());
    }

    public void addTextureView() {
        Log.d((String)TAG, (String)("addTextureView [" + ((Object)((Object)this)).hashCode() + "] "));
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.textureViewContainer.addView((View)JCMediaManager.textureView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void removeTextureView() {
        JCMediaManager.savedSurfaceTexture = null;
        if (JCMediaManager.textureView != null && JCMediaManager.textureView.getParent() != null) {
            ((ViewGroup)JCMediaManager.textureView.getParent()).removeView((View)JCMediaManager.textureView);
        }
    }

    public void setUiWitStateAndScreen(int state) {
        this.currentState = state;
        switch (this.currentState) {
            case 0: {
                this.cancelProgressTimer();
                if (!this.isCurrentJcvd()) break;
                JCMediaManager.instance().releaseMediaPlayer();
                break;
            }
            case 1: {
                this.resetProgressAndTime();
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.startProgressTimer();
                break;
            }
            case 7: {
                this.cancelProgressTimer();
                break;
            }
            case 6: {
                this.cancelProgressTimer();
                this.progressBar.setProgress(100);
                this.currentTimeTextView.setText(this.totalTimeTextView.getText());
            }
        }
    }

    public void startProgressTimer() {
        this.cancelProgressTimer();
        UPDATE_PROGRESS_TIMER = new Timer();
        this.mProgressTimerTask = new ProgressTimerTask();
        UPDATE_PROGRESS_TIMER.schedule((TimerTask)this.mProgressTimerTask, 0L, 300L);
    }

    public void cancelProgressTimer() {
        if (UPDATE_PROGRESS_TIMER != null) {
            UPDATE_PROGRESS_TIMER.cancel();
        }
        if (this.mProgressTimerTask != null) {
            this.mProgressTimerTask.cancel();
        }
    }

    public void onPrepared() {
        Log.i((String)TAG, (String)("onPrepared  [" + ((Object)((Object)this)).hashCode() + "] "));
        if (this.currentState != 1) {
            return;
        }
        if (this.seekToInAdvance != 0) {
            JCMediaManager.instance().mediaPlayer.seekTo(this.seekToInAdvance);
            this.seekToInAdvance = 0;
        } else {
            int position = JCUtils.getSavedProgress(this.getContext(), this.url);
            if (position != 0) {
                JCMediaManager.instance().mediaPlayer.seekTo(position);
            }
        }
        this.startProgressTimer();
        this.setUiWitStateAndScreen(2);
    }

    public void clearFullscreenLayout() {
        ViewGroup vp = (ViewGroup)JCUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View oldF = vp.findViewById(33797);
        View oldT = vp.findViewById(33798);
        if (oldF != null) {
            vp.removeView(oldF);
        }
        if (oldT != null) {
            vp.removeView(oldT);
        }
        JCVideoPlayer.showSupportActionBar(this.getContext());
    }

    public void onAutoCompletion() {
        Runtime.getRuntime().gc();
        Log.i((String)TAG, (String)("onAutoCompletion  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(6);
        this.dismissVolumeDialog();
        this.dismissProgressDialog();
        this.dismissBrightnessDialog();
        this.cancelProgressTimer();
        this.setUiWitStateAndScreen(6);
        if (this.currentScreen == 2) {
            JCVideoPlayer.backPress();
        }
        JCUtils.saveProgress(this.getContext(), this.url, 0);
        JCMediaManager.savedSurfaceTexture = null;
    }

    public void onCompletion() {
        Log.i((String)TAG, (String)("onCompletion  [" + ((Object)((Object)this)).hashCode() + "] "));
        if (this.currentState == 2 || this.currentState == 5) {
            int position = this.getCurrentPositionWhenPlaying();
            JCUtils.saveProgress(this.getContext(), this.url, position);
        }
        this.cancelProgressTimer();
        this.setUiWitStateAndScreen(0);
        this.textureViewContainer.removeView((View)JCMediaManager.textureView);
        JCMediaManager.instance().currentVideoWidth = 0;
        JCMediaManager.instance().currentVideoHeight = 0;
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
        JCUtils.scanForActivity(this.getContext()).getWindow().clearFlags(128);
        this.clearFullscreenLayout();
        JCUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(NORMAL_ORIENTATION);
        JCMediaManager.savedSurfaceTexture = null;
    }

    public void playOnThisJcvd() {
        Log.i((String)TAG, (String)("playOnThisJcvd  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = JCVideoPlayerManager.getSecondFloor().currentState;
        this.clearFloatScreen();
        this.setUiWitStateAndScreen(this.currentState);
        this.addTextureView();
    }

    public void clearFloatScreen() {
        JCUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(NORMAL_ORIENTATION);
        JCVideoPlayer.showSupportActionBar(this.getContext());
        JCVideoPlayer secJcvd = JCVideoPlayerManager.getCurrentJcvd();
        secJcvd.textureViewContainer.removeView((View)JCMediaManager.textureView);
        ViewGroup vp = (ViewGroup)JCUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        vp.removeView((View)secJcvd);
        JCVideoPlayerManager.setSecondFloor(null);
    }

    public void autoFullscreen(float x) {
        if (this.isCurrentJcvd() && this.currentState == 2 && this.currentScreen != 2 && this.currentScreen != 3) {
            if (x > 0.0f) {
                JCUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(0);
            } else {
                JCUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(8);
            }
            this.startWindowFullscreen();
        }
    }

    public void autoQuitFullscreen() {
        if (System.currentTimeMillis() - lastAutoFullscreenTime > 2000L && this.isCurrentJcvd() && this.currentState == 2 && this.currentScreen == 2) {
            lastAutoFullscreenTime = System.currentTimeMillis();
            JCVideoPlayer.backPress();
        }
    }

    public void onSeekComplete() {
    }

    public void onError(int what, int extra) {
        Log.e((String)TAG, (String)("onError " + what + " - " + extra + " [" + ((Object)((Object)this)).hashCode() + "] "));
        if (what != 38 && what != -38) {
            this.setUiWitStateAndScreen(7);
            if (this.isCurrentJcvd()) {
                JCMediaManager.instance().releaseMediaPlayer();
            }
        }
    }

    public void onInfo(int what, int extra) {
        Log.d((String)TAG, (String)("onInfo what - " + what + " extra - " + extra));
        if (what == 701) {
            if (this.currentState == 3) {
                return;
            }
            BACKUP_PLAYING_BUFFERING_STATE = this.currentState;
            this.setUiWitStateAndScreen(3);
            Log.d((String)TAG, (String)"MEDIA_INFO_BUFFERING_START");
        } else if (what == 702) {
            if (BACKUP_PLAYING_BUFFERING_STATE != -1) {
                this.setUiWitStateAndScreen(BACKUP_PLAYING_BUFFERING_STATE);
                BACKUP_PLAYING_BUFFERING_STATE = -1;
            }
            Log.d((String)TAG, (String)"MEDIA_INFO_BUFFERING_END");
        }
    }

    public void onVideoSizeChanged() {
        Log.i((String)TAG, (String)("onVideoSizeChanged  [" + ((Object)((Object)this)).hashCode() + "] "));
        JCMediaManager.textureView.setVideoSize(JCMediaManager.instance().getVideoSize());
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("bottomProgress onStartTrackingTouch [" + ((Object)((Object)this)).hashCode() + "] "));
        this.cancelProgressTimer();
        for (ViewParent vpdown = this.getParent(); vpdown != null; vpdown = vpdown.getParent()) {
            vpdown.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("bottomProgress onStopTrackingTouch [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(5);
        this.startProgressTimer();
        for (ViewParent vpup = this.getParent(); vpup != null; vpup = vpup.getParent()) {
            vpup.requestDisallowInterceptTouchEvent(false);
        }
        if (this.currentState != 2 && this.currentState != 5) {
            return;
        }
        int time = seekBar.getProgress() * this.getDuration() / 100;
        JCMediaManager.instance().mediaPlayer.seekTo(time);
        Log.i((String)TAG, (String)("seekTo " + time + " [" + ((Object)((Object)this)).hashCode() + "] "));
    }

    public static boolean backPress() {
        Log.i((String)TAG, (String)"backPress");
        if (System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 300L) {
            return false;
        }
        if (JCVideoPlayerManager.getSecondFloor() != null) {
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            JCVideoPlayer jcVideoPlayer = JCVideoPlayerManager.getSecondFloor();
            jcVideoPlayer.onEvent(jcVideoPlayer.currentScreen == 2 ? 8 : 10);
            JCVideoPlayerManager.getFirstFloor().playOnThisJcvd();
            return true;
        }
        if (JCVideoPlayerManager.getFirstFloor() != null && (JCVideoPlayerManager.getFirstFloor().currentScreen == 2 || JCVideoPlayerManager.getFirstFloor().currentScreen == 3)) {
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            JCVideoPlayerManager.getCurrentJcvd().currentState = 0;
            JCVideoPlayerManager.getFirstFloor().clearFloatScreen();
            JCMediaManager.instance().releaseMediaPlayer();
            JCVideoPlayerManager.setFirstFloor(null);
            return true;
        }
        return false;
    }

    public void startWindowFullscreen() {
        Log.i((String)TAG, (String)("startWindowFullscreen  [" + ((Object)((Object)this)).hashCode() + "] "));
        JCVideoPlayer.hideSupportActionBar(this.getContext());
        JCUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(FULLSCREEN_ORIENTATION);
        ViewGroup vp = (ViewGroup)JCUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(33797);
        if (old != null) {
            vp.removeView(old);
        }
        this.textureViewContainer.removeView((View)JCMediaManager.textureView);
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(Context.class);
            JCVideoPlayer jcVideoPlayer = (JCVideoPlayer)((Object)constructor.newInstance(this.getContext()));
            jcVideoPlayer.setId(33797);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            vp.addView((View)jcVideoPlayer, (ViewGroup.LayoutParams)lp);
            jcVideoPlayer.setUp(this.url, 2, this.objects);
            jcVideoPlayer.setUiWitStateAndScreen(this.currentState);
            jcVideoPlayer.addTextureView();
            JCVideoPlayerManager.setSecondFloor(jcVideoPlayer);
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startWindowTiny() {
        Log.i((String)TAG, (String)("startWindowTiny  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(9);
        if (this.currentState == 0 || this.currentState == 7) {
            return;
        }
        ViewGroup vp = (ViewGroup)JCUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(33798);
        if (old != null) {
            vp.removeView(old);
        }
        this.textureViewContainer.removeView((View)JCMediaManager.textureView);
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(Context.class);
            JCVideoPlayer jcVideoPlayer = (JCVideoPlayer)((Object)constructor.newInstance(this.getContext()));
            jcVideoPlayer.setId(33798);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(400, 400);
            lp.gravity = 85;
            vp.addView((View)jcVideoPlayer, (ViewGroup.LayoutParams)lp);
            jcVideoPlayer.setUp(this.url, 3, this.objects);
            jcVideoPlayer.setUiWitStateAndScreen(this.currentState);
            jcVideoPlayer.addTextureView();
            JCVideoPlayerManager.setSecondFloor(jcVideoPlayer);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCurrentPositionWhenPlaying() {
        int position = 0;
        if (JCMediaManager.instance().mediaPlayer == null) {
            return position;
        }
        if (this.currentState == 2 || this.currentState == 5 || this.currentState == 3) {
            try {
                position = JCMediaManager.instance().mediaPlayer.getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return position;
            }
        }
        return position;
    }

    public int getDuration() {
        int duration = 0;
        if (JCMediaManager.instance().mediaPlayer == null) {
            return duration;
        }
        try {
            duration = JCMediaManager.instance().mediaPlayer.getDuration();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    public void setProgressAndText() {
        int position = this.getCurrentPositionWhenPlaying();
        int duration = this.getDuration();
        int progress = position * 100 / (duration == 0 ? 1 : duration);
        if (!this.mTouchingProgressBar && progress != 0) {
            this.progressBar.setProgress(progress);
        }
        if (position != 0) {
            this.currentTimeTextView.setText((CharSequence)JCUtils.stringForTime(position));
        }
        this.totalTimeTextView.setText((CharSequence)JCUtils.stringForTime(duration));
    }

    public void setBufferProgress(int bufferProgress) {
        if (bufferProgress != 0) {
            this.progressBar.setSecondaryProgress(bufferProgress);
        }
    }

    public void resetProgressAndTime() {
        this.progressBar.setProgress(0);
        this.progressBar.setSecondaryProgress(0);
        this.currentTimeTextView.setText((CharSequence)JCUtils.stringForTime(0));
        this.totalTimeTextView.setText((CharSequence)JCUtils.stringForTime(0));
    }

    public void release() {
        if (!(!this.url.equals(JCMediaManager.CURRENT_PLAYING_URL) || System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME <= 300L || JCVideoPlayerManager.getSecondFloor() != null && JCVideoPlayerManager.getSecondFloor().currentScreen == 2 || JCVideoPlayerManager.getSecondFloor() == null && JCVideoPlayerManager.getFirstFloor() != null && JCVideoPlayerManager.getFirstFloor().currentScreen == 2)) {
            Log.d((String)TAG, (String)("release [" + ((Object)((Object)this)).hashCode() + "]"));
            JCVideoPlayer.releaseAllVideos();
        }
    }

    public boolean isCurrentJcvd() {
        return JCVideoPlayerManager.getCurrentJcvd() != null && JCVideoPlayerManager.getCurrentJcvd() == this;
    }

    public static void releaseAllVideos() {
        if (System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME > 300L) {
            Log.d((String)TAG, (String)"releaseAllVideos");
            JCVideoPlayerManager.completeAll();
            JCMediaManager.instance().releaseMediaPlayer();
        }
    }

    public static void setJcUserAction(JCUserAction jcUserEvent) {
        JC_USER_EVENT = jcUserEvent;
    }

    public void onEvent(int type) {
        if (JC_USER_EVENT != null && this.isCurrentJcvd()) {
            JC_USER_EVENT.onEvent(type, this.url, this.currentScreen, this.objects);
        }
    }

    public static void startFullscreen(Context context, Class _class, String url, Object ... objects) {
        JCVideoPlayer.hideSupportActionBar(context);
        JCUtils.getAppCompActivity(context).setRequestedOrientation(FULLSCREEN_ORIENTATION);
        ViewGroup vp = (ViewGroup)JCUtils.scanForActivity(context).findViewById(0x1020002);
        View old = vp.findViewById(33797);
        if (old != null) {
            vp.removeView(old);
        }
        try {
            Constructor constructor = _class.getConstructor(Context.class);
            JCVideoPlayer jcVideoPlayer = (JCVideoPlayer)((Object)constructor.newInstance(context));
            jcVideoPlayer.setId(33797);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            vp.addView((View)jcVideoPlayer, (ViewGroup.LayoutParams)lp);
            jcVideoPlayer.setUp(url, 2, objects);
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            jcVideoPlayer.startButton.performClick();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hideSupportActionBar(Context context) {
        ActionBar ab;
        if (ACTION_BAR_EXIST && (ab = JCUtils.getAppCompActivity(context).getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.hide();
        }
        if (TOOL_BAR_EXIST) {
            JCUtils.getAppCompActivity(context).getWindow().setFlags(1024, 1024);
        }
    }

    public static void showSupportActionBar(Context context) {
        ActionBar ab;
        if (ACTION_BAR_EXIST && (ab = JCUtils.getAppCompActivity(context).getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.show();
        }
        if (TOOL_BAR_EXIST) {
            JCUtils.getAppCompActivity(context).getWindow().clearFlags(1024);
        }
    }

    public static void clearSavedProgress(Context context, String url) {
        JCUtils.clearSavedProgress(context, url);
    }

    public void showWifiDialog() {
    }

    public void showProgressDialog(float deltaX, String seekTime, int seekTimePosition, String totalTime, int totalTimeDuration) {
    }

    public void dismissProgressDialog() {
    }

    public void showVolumeDialog(float deltaY, int volumePercent) {
    }

    public void dismissVolumeDialog() {
    }

    public void showBrightnessDialog(int brightnessPercent) {
    }

    public void dismissBrightnessDialog() {
    }

    public abstract int getLayoutId();

    static {
        lastAutoFullscreenTime = 0L;
        onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case 1: {
                        break;
                    }
                    case -1: {
                        JCVideoPlayer.releaseAllVideos();
                        Log.d((String)JCVideoPlayer.TAG, (String)("AUDIOFOCUS_LOSS [" + this.hashCode() + "]"));
                        break;
                    }
                    case -2: {
                        try {
                            if (JCMediaManager.instance().mediaPlayer != null && JCMediaManager.instance().mediaPlayer.isPlaying()) {
                                JCMediaManager.instance().mediaPlayer.pause();
                            }
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                        Log.d((String)JCVideoPlayer.TAG, (String)("AUDIOFOCUS_LOSS_TRANSIENT [" + this.hashCode() + "]"));
                        break;
                    }
                }
            }
        };
    }

    public static class JCAutoFullscreenListener
    implements SensorEventListener {
        public void onSensorChanged(SensorEvent event) {
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            if ((x > -15.0f && x < -10.0f || x < 15.0f && x > 10.0f) && (double)Math.abs(y) < 1.5 && System.currentTimeMillis() - lastAutoFullscreenTime > 2000L) {
                if (JCVideoPlayerManager.getCurrentJcvd() != null) {
                    JCVideoPlayerManager.getCurrentJcvd().autoFullscreen(x);
                }
                lastAutoFullscreenTime = System.currentTimeMillis();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    public class ProgressTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (JCVideoPlayer.this.currentState == 2 || JCVideoPlayer.this.currentState == 5 || JCVideoPlayer.this.currentState == 3) {
                JCVideoPlayer.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        JCVideoPlayer.this.setProgressAndText();
                    }
                });
            }
        }
    }
}

