/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.os.Handler;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import fm.jiecao.jcvideoplayer_lib.JCBuriedPoint;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.JCMediaPlayerListener;
import fm.jiecao.jcvideoplayer_lib.JCResizeTextureView;
import fm.jiecao.jcvideoplayer_lib.JCUtils;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayerManager;
import fm.jiecao.jcvideoplayer_lib.R;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class JCVideoPlayer
extends FrameLayout
implements JCMediaPlayerListener,
View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
View.OnTouchListener,
TextureView.SurfaceTextureListener {
    public static final String TAG = "JieCaoVideoPlayer";
    public static final int FULLSCREEN_ID = 33797;
    public static final int TINY_ID = 33798;
    public static final int THRESHOLD = 80;
    public static final int FULL_SCREEN_NORMAL_DELAY = 500;
    public static boolean WIFI_TIP_DIALOG_SHOWED = false;
    public static long CLICK_QUIT_FULLSCREEN_TIME = 0L;
    public static final int SCREEN_LAYOUT_LIST = 0;
    public static final int SCREEN_WINDOW_FULLSCREEN = 1;
    public static final int SCREEN_WINDOW_TINY = 2;
    public static final int SCREEN_LAYOUT_DETAIL = 3;
    public static final int CURRENT_STATE_NORMAL = 0;
    public static final int CURRENT_STATE_PREPAREING = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_PLAYING_BUFFERING_START = 3;
    public static final int CURRENT_STATE_PAUSE = 5;
    public static final int CURRENT_STATE_AUTO_COMPLETE = 6;
    public static final int CURRENT_STATE_ERROR = 7;
    public int currentState = -1;
    public int currentScreen = -1;
    public String url = null;
    public Object[] objects = null;
    public boolean looping = false;
    public Map<String, String> mapHeadData = new HashMap<String, String>();
    public int seekToInAdvance = -1;
    public ImageView startButton;
    public SeekBar progressBar;
    public ImageView fullscreenButton;
    public TextView currentTimeTextView;
    public TextView totalTimeTextView;
    public ViewGroup textureViewContainer;
    public ViewGroup topContainer;
    public ViewGroup bottomContainer;
    public Surface surface;
    protected static JCBuriedPoint JC_BURIED_POINT;
    protected static Timer UPDATE_PROGRESS_TIMER;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected AudioManager mAudioManager;
    protected Handler mHandler;
    protected ProgressTimerTask mProgressTimerTask;
    protected int mBackUpBufferState = -1;
    protected boolean mTouchingProgressBar;
    protected float mDownX;
    protected float mDownY;
    protected boolean mChangeVolume;
    protected boolean mChangePosition;
    protected int mDownPosition;
    protected int mGestureDownVolume;
    protected int mSeekTimePosition;
    private static AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener;
    private static boolean ACTIONBAR_STATUS;

    public JCVideoPlayer(Context context) {
        super(context);
        this.init(context);
    }

    public JCVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    protected void init(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.startButton = (ImageView)this.findViewById(R.id.start);
        this.fullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.progressBar = (SeekBar)this.findViewById(R.id.progress);
        this.currentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.totalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.bottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.textureViewContainer = (RelativeLayout)this.findViewById(R.id.surface_container);
        this.topContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.startButton.setOnClickListener((View.OnClickListener)this);
        this.fullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.bottomContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.mScreenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mHandler = new Handler();
    }

    public boolean setUp(String url, int screen, Object ... objects) {
        if (System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 500L) {
            return false;
        }
        this.currentState = 0;
        this.url = url;
        this.objects = objects;
        this.currentScreen = screen;
        this.setUiWitStateAndScreen(0);
        return true;
    }

    public boolean setUp(String url, int screen, Map<String, String> mapHeadData, Object ... objects) {
        if (this.setUp(url, screen, objects)) {
            this.mapHeadData.clear();
            this.mapHeadData.putAll(mapHeadData);
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start) {
            Log.i((String)TAG, (String)("onClick start [" + this.hashCode() + "] "));
            if (TextUtils.isEmpty((CharSequence)this.url)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.currentState == 0 || this.currentState == 7) {
                if (!(this.url.startsWith("file") || JCUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
                    this.showWifiDialog();
                    return;
                }
                this.prepareVideo();
                this.onEvent(this.currentState != 7 ? 0 : 1);
            } else if (this.currentState == 2) {
                this.onEvent(3);
                Log.d((String)TAG, (String)("pauseVideo [" + this.hashCode() + "] "));
                JCMediaManager.instance().mediaPlayer.pause();
                this.setUiWitStateAndScreen(5);
            } else if (this.currentState == 5) {
                this.onEvent(4);
                JCMediaManager.instance().mediaPlayer.start();
                this.setUiWitStateAndScreen(2);
            } else if (this.currentState == 6) {
                this.onEvent(2);
                this.prepareVideo();
            }
        } else if (i == R.id.fullscreen) {
            Log.i((String)TAG, (String)("onClick fullscreen [" + this.hashCode() + "] "));
            if (this.currentState == 6) {
                return;
            }
            if (this.currentScreen == 1) {
                JCVideoPlayer.backPress();
            } else {
                Log.d((String)TAG, (String)("toFullscreenActivity [" + this.hashCode() + "] "));
                this.onEvent(7);
                this.startWindowFullscreen();
            }
        } else if (i == R.id.surface_container && this.currentState == 7) {
            Log.i((String)TAG, (String)("onClick surfaceContainer State=Error [" + this.hashCode() + "] "));
            this.prepareVideo();
        }
    }

    protected void prepareVideo() {
        Log.d((String)TAG, (String)("prepareVideo [" + this.hashCode() + "] "));
        if (JCVideoPlayerManager.listener() != null) {
            JCVideoPlayerManager.listener().onCompletion();
        }
        JCVideoPlayerManager.setListener(this);
        this.addTextureView();
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.requestAudioFocus(onAudioFocusChangeListener, 3, 2);
        JCUtils.scanForActivity(this.getContext()).getWindow().addFlags(128);
        JCMediaManager.instance().prepare(this.url, this.mapHeadData, this.looping);
        this.setUiWitStateAndScreen(1);
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionDown [" + this.hashCode() + "] "));
                    this.mTouchingProgressBar = true;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mChangeVolume = false;
                    this.mChangePosition = false;
                    break;
                }
                case 2: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionMove [" + this.hashCode() + "] "));
                    float deltaX = x - this.mDownX;
                    float deltaY = y - this.mDownY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if (this.currentScreen == 1 && !this.mChangePosition && !this.mChangeVolume && (absDeltaX > 80.0f || absDeltaY > 80.0f)) {
                        this.cancelProgressTimer();
                        if (absDeltaX >= 80.0f) {
                            this.mChangePosition = true;
                            this.mDownPosition = this.getCurrentPositionWhenPlaying();
                        } else {
                            this.mChangeVolume = true;
                            this.mGestureDownVolume = this.mAudioManager.getStreamVolume(3);
                        }
                    }
                    if (this.mChangePosition) {
                        int totalTimeDuration = this.getDuration();
                        this.mSeekTimePosition = (int)((float)this.mDownPosition + deltaX * (float)totalTimeDuration / (float)this.mScreenWidth);
                        if (this.mSeekTimePosition > totalTimeDuration) {
                            this.mSeekTimePosition = totalTimeDuration;
                        }
                        String seekTime = JCUtils.stringForTime(this.mSeekTimePosition);
                        String totalTime = JCUtils.stringForTime(totalTimeDuration);
                        this.showProgressDialog(deltaX, seekTime, this.mSeekTimePosition, totalTime, totalTimeDuration);
                    }
                    if (!this.mChangeVolume) break;
                    deltaY = -deltaY;
                    int max = this.mAudioManager.getStreamMaxVolume(3);
                    int deltaV = (int)((float)max * deltaY * 3.0f / (float)this.mScreenHeight);
                    this.mAudioManager.setStreamVolume(3, this.mGestureDownVolume + deltaV, 0);
                    int volumePercent = (int)((float)(this.mGestureDownVolume * 100 / max) + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                    this.showVolumDialog(-deltaY, volumePercent);
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionUp [" + this.hashCode() + "] "));
                    this.mTouchingProgressBar = false;
                    this.dismissProgressDialog();
                    this.dismissVolumDialog();
                    if (this.mChangePosition) {
                        this.onEvent(12);
                        JCMediaManager.instance().mediaPlayer.seekTo((long)this.mSeekTimePosition);
                        int duration = this.getDuration();
                        int progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.progressBar.setProgress(progress);
                    }
                    if (this.mChangeVolume) {
                        this.onEvent(11);
                    }
                    this.startProgressTimer();
                }
            }
        }
        return false;
    }

    public void addTextureView() {
        Log.d((String)TAG, (String)("addTextureView [" + this.hashCode() + "] "));
        if (this.textureViewContainer.getChildCount() > 0) {
            this.textureViewContainer.removeAllViews();
        }
        JCMediaManager.textureView = null;
        JCMediaManager.textureView = new JCResizeTextureView(this.getContext());
        JCMediaManager.textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.textureViewContainer.addView((View)JCMediaManager.textureView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setUiWitStateAndScreen(int state) {
        this.currentState = state;
        switch (this.currentState) {
            case 0: {
                if (!this.isCurrentMediaListener()) break;
                this.cancelProgressTimer();
                JCMediaManager.instance().releaseMediaPlayer();
                break;
            }
            case 1: {
                this.resetProgressAndTime();
                break;
            }
            case 2: {
                this.startProgressTimer();
                break;
            }
            case 5: {
                this.startProgressTimer();
                break;
            }
            case 7: {
                if (!this.isCurrentMediaListener()) break;
                JCMediaManager.instance().releaseMediaPlayer();
                break;
            }
            case 6: {
                this.cancelProgressTimer();
                this.progressBar.setProgress(100);
                this.currentTimeTextView.setText(this.totalTimeTextView.getText());
            }
        }
    }

    protected void startProgressTimer() {
        this.cancelProgressTimer();
        UPDATE_PROGRESS_TIMER = new Timer();
        this.mProgressTimerTask = new ProgressTimerTask();
        UPDATE_PROGRESS_TIMER.schedule((TimerTask)this.mProgressTimerTask, 0L, 300L);
    }

    protected void cancelProgressTimer() {
        if (UPDATE_PROGRESS_TIMER != null) {
            UPDATE_PROGRESS_TIMER.cancel();
        }
        if (this.mProgressTimerTask != null) {
            this.mProgressTimerTask.cancel();
        }
    }

    @Override
    public void onPrepared() {
        Log.i((String)TAG, (String)("onPrepared  [" + this.hashCode() + "] "));
        if (this.currentState != 1) {
            return;
        }
        JCMediaManager.instance().mediaPlayer.start();
        if (this.seekToInAdvance != -1) {
            JCMediaManager.instance().mediaPlayer.seekTo((long)this.seekToInAdvance);
            this.seekToInAdvance = -1;
        }
        this.startProgressTimer();
        this.setUiWitStateAndScreen(2);
    }

    public void clearFullscreenLayout() {
        ViewGroup vp = (ViewGroup)((Activity)this.getContext()).findViewById(0x1020002);
        View oldF = vp.findViewById(33797);
        View oldT = vp.findViewById(33798);
        if (oldF != null) {
            vp.removeView(oldF);
        }
        if (oldT != null) {
            vp.removeView(oldT);
        }
        JCVideoPlayer.showSupportActionBar(this.getContext());
    }

    @Override
    public void onAutoCompletion() {
        Log.i((String)TAG, (String)("onAutoCompletion  [" + this.hashCode() + "] "));
        this.onEvent(6);
        this.setUiWitStateAndScreen(6);
        if (this.textureViewContainer.getChildCount() > 0) {
            this.textureViewContainer.removeAllViews();
        }
        JCVideoPlayerManager.setLastListener(null);
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
        JCUtils.scanForActivity(this.getContext()).getWindow().clearFlags(128);
        this.clearFullscreenLayout();
    }

    @Override
    public void onCompletion() {
        Log.i((String)TAG, (String)("onCompletion  [" + this.hashCode() + "] "));
        this.setUiWitStateAndScreen(0);
        if (this.textureViewContainer.getChildCount() > 0) {
            this.textureViewContainer.removeAllViews();
        }
        JCVideoPlayerManager.setListener(null);
        JCMediaManager.instance().currentVideoWidth = 0;
        JCMediaManager.instance().currentVideoHeight = 0;
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
        JCUtils.scanForActivity(this.getContext()).getWindow().clearFlags(128);
        this.clearFullscreenLayout();
    }

    @Override
    public boolean goToOtherListener() {
        Log.i((String)TAG, (String)("goToOtherListener  [" + this.hashCode() + "] "));
        if (this.currentScreen == 1 || this.currentScreen == 2) {
            this.onEvent(this.currentScreen == 1 ? 8 : 10);
            if (JCVideoPlayerManager.lastListener() == null) {
                JCVideoPlayerManager.listener().onCompletion();
                JCVideoPlayer.showSupportActionBar(this.getContext());
                return true;
            }
            ViewGroup vp = (ViewGroup)((Activity)this.getContext()).findViewById(0x1020002);
            vp.removeView((View)this);
            JCVideoPlayerManager.setListener(JCVideoPlayerManager.lastListener());
            JCVideoPlayerManager.setLastListener(null);
            JCMediaManager.instance().lastState = this.currentState;
            JCVideoPlayerManager.listener().goBackThisListener();
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public void onBufferingUpdate(int percent) {
        if (this.currentState != 0 && this.currentState != 1) {
            Log.v((String)TAG, (String)("onBufferingUpdate " + percent + " [" + this.hashCode() + "] "));
            this.setTextAndProgress(percent);
        }
    }

    @Override
    public void onSeekComplete() {
    }

    @Override
    public void onError(int what, int extra) {
        Log.e((String)TAG, (String)("onError " + what + " - " + extra + " [" + this.hashCode() + "] "));
        if (what != 38 && what != -38) {
            this.setUiWitStateAndScreen(7);
        }
    }

    @Override
    public void onInfo(int what, int extra) {
        Log.d((String)TAG, (String)("onInfo what - " + what + " extra - " + extra));
        if (what == 701) {
            this.mBackUpBufferState = this.currentState;
            this.setUiWitStateAndScreen(3);
            Log.d((String)TAG, (String)"MEDIA_INFO_BUFFERING_START");
        } else if (what == 702) {
            if (this.mBackUpBufferState != -1) {
                this.setUiWitStateAndScreen(this.mBackUpBufferState);
                this.mBackUpBufferState = -1;
            }
            Log.d((String)TAG, (String)"MEDIA_INFO_BUFFERING_END");
        }
    }

    @Override
    public void onVideoSizeChanged() {
        Log.i((String)TAG, (String)("onVideoSizeChanged  [" + this.hashCode() + "] "));
        int mVideoWidth = JCMediaManager.instance().currentVideoWidth;
        int mVideoHeight = JCMediaManager.instance().currentVideoHeight;
        if (mVideoWidth != 0 && mVideoHeight != 0) {
            JCMediaManager.textureView.requestLayout();
        }
    }

    @Override
    public void goBackThisListener() {
        Log.i((String)TAG, (String)("goBackThisListener  [" + this.hashCode() + "] "));
        this.currentState = JCMediaManager.instance().lastState;
        this.setUiWitStateAndScreen(this.currentState);
        this.addTextureView();
        JCVideoPlayer.showSupportActionBar(this.getContext());
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Log.i((String)TAG, (String)("onSurfaceTextureAvailable [" + this.hashCode() + "] "));
        this.surface = new Surface(surface);
        JCMediaManager.instance().setDisplay(this.surface);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        surface.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("bottomProgress onStartTrackingTouch [" + this.hashCode() + "] "));
        this.cancelProgressTimer();
        for (ViewParent vpdown = this.getParent(); vpdown != null; vpdown = vpdown.getParent()) {
            vpdown.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("bottomProgress onStopTrackingTouch [" + this.hashCode() + "] "));
        this.onEvent(5);
        this.startProgressTimer();
        for (ViewParent vpup = this.getParent(); vpup != null; vpup = vpup.getParent()) {
            vpup.requestDisallowInterceptTouchEvent(false);
        }
        if (this.currentState != 2 && this.currentState != 5) {
            return;
        }
        int time = seekBar.getProgress() * this.getDuration() / 100;
        JCMediaManager.instance().mediaPlayer.seekTo((long)time);
        Log.i((String)TAG, (String)("seekTo " + time + " [" + this.hashCode() + "] "));
    }

    public static boolean backPress() {
        Log.i((String)TAG, (String)"backPress");
        if (JCVideoPlayerManager.listener() != null) {
            return JCVideoPlayerManager.listener().goToOtherListener();
        }
        return false;
    }

    private void startWindowFullscreen() {
        Log.i((String)TAG, (String)("startWindowFullscreen  [" + this.hashCode() + "] "));
        JCVideoPlayer.hideSupportActionBar(this.getContext());
        ViewGroup vp = (ViewGroup)((Activity)this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(33797);
        if (old != null) {
            vp.removeView(old);
        }
        if (this.textureViewContainer.getChildCount() > 0) {
            this.textureViewContainer.removeAllViews();
        }
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Context.class);
            JCVideoPlayer jcVideoPlayer = (JCVideoPlayer)constructor.newInstance(this.getContext());
            jcVideoPlayer.setId(33797);
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            int w = wm.getDefaultDisplay().getWidth();
            int h = wm.getDefaultDisplay().getHeight();
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(h, w);
            lp.setMargins((w - h) / 2, -(w - h) / 2, 0, 0);
            vp.addView((View)jcVideoPlayer, (ViewGroup.LayoutParams)lp);
            jcVideoPlayer.setUp(this.url, 1, this.objects);
            jcVideoPlayer.setUiWitStateAndScreen(this.currentState);
            jcVideoPlayer.addTextureView();
            jcVideoPlayer.setRotation(90.0f);
            JCVideoPlayerManager.setLastListener(this);
            JCVideoPlayerManager.setListener(jcVideoPlayer);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startWindowTiny() {
        Log.i((String)TAG, (String)("startWindowTiny  [" + this.hashCode() + "] "));
        this.onEvent(9);
        ViewGroup vp = (ViewGroup)((Activity)this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(33798);
        if (old != null) {
            vp.removeView(old);
        }
        if (this.textureViewContainer.getChildCount() > 0) {
            this.textureViewContainer.removeAllViews();
        }
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Context.class);
            JCVideoPlayer mJcVideoPlayer = (JCVideoPlayer)constructor.newInstance(this.getContext());
            mJcVideoPlayer.setId(33798);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(400, 400);
            lp.gravity = 85;
            vp.addView((View)mJcVideoPlayer, (ViewGroup.LayoutParams)lp);
            mJcVideoPlayer.setUp(this.url, 2, this.objects);
            mJcVideoPlayer.setUiWitStateAndScreen(this.currentState);
            mJcVideoPlayer.addTextureView();
            JCVideoPlayerManager.setLastListener(this);
            JCVideoPlayerManager.setListener(mJcVideoPlayer);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getCurrentPositionWhenPlaying() {
        int position = 0;
        if (this.currentState == 2 || this.currentState == 5) {
            try {
                position = (int)JCMediaManager.instance().mediaPlayer.getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return position;
            }
        }
        return position;
    }

    protected int getDuration() {
        int duration = 0;
        try {
            duration = (int)JCMediaManager.instance().mediaPlayer.getDuration();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    protected void setTextAndProgress(int secProgress) {
        int position = this.getCurrentPositionWhenPlaying();
        int duration = this.getDuration();
        int progress = position * 100 / (duration == 0 ? 1 : duration);
        this.setProgressAndTime(progress, secProgress, position, duration);
    }

    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        if (!this.mTouchingProgressBar && progress != 0) {
            this.progressBar.setProgress(progress);
        }
        if (secProgress > 95) {
            secProgress = 100;
        }
        if (secProgress != 0) {
            this.progressBar.setSecondaryProgress(secProgress);
        }
        this.currentTimeTextView.setText((CharSequence)JCUtils.stringForTime(currentTime));
        this.totalTimeTextView.setText((CharSequence)JCUtils.stringForTime(totalTime));
    }

    protected void resetProgressAndTime() {
        this.progressBar.setProgress(0);
        this.progressBar.setSecondaryProgress(0);
        this.currentTimeTextView.setText((CharSequence)JCUtils.stringForTime(0));
        this.totalTimeTextView.setText((CharSequence)JCUtils.stringForTime(0));
    }

    public void release() {
        if (this.isCurrentMediaListener() && System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME > 500L) {
            Log.d((String)TAG, (String)("release [" + this.hashCode() + "]"));
            JCVideoPlayer.releaseAllVideos();
        }
    }

    protected boolean isCurrentMediaListener() {
        return JCVideoPlayerManager.listener() != null && JCVideoPlayerManager.listener() == this;
    }

    public static void releaseAllVideos() {
        Log.d((String)TAG, (String)"releaseAllVideos");
        if (JCVideoPlayerManager.listener() != null) {
            JCVideoPlayerManager.listener().onCompletion();
        }
        if (JCVideoPlayerManager.lastListener() != null) {
            JCVideoPlayerManager.lastListener().onCompletion();
        }
        JCMediaManager.instance().releaseMediaPlayer();
    }

    public static void setJcBuriedPoint(JCBuriedPoint jcBuriedPoint) {
        JC_BURIED_POINT = jcBuriedPoint;
    }

    public void onEvent(int type) {
        if (JC_BURIED_POINT != null && this.isCurrentMediaListener()) {
            JC_BURIED_POINT.onEvent(type, this.url, this.currentScreen, this.objects);
        }
    }

    public static void startFullscreen(Context context, Class _class, String url, Object ... objects) {
        JCVideoPlayer.hideSupportActionBar(context);
        ViewGroup vp = (ViewGroup)((AppCompatActivity)context).findViewById(0x1020002);
        View old = vp.findViewById(33797);
        if (old != null) {
            vp.removeView(old);
        }
        try {
            Constructor constructor = _class.getConstructor(Context.class);
            JCVideoPlayer jcVideoPlayer = (JCVideoPlayer)constructor.newInstance(context);
            jcVideoPlayer.setId(33797);
            WindowManager wm = (WindowManager)context.getSystemService("window");
            int w = wm.getDefaultDisplay().getWidth();
            int h = wm.getDefaultDisplay().getHeight();
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(h, w);
            lp.setMargins((w - h) / 2, -(w - h) / 2, 0, 0);
            vp.addView((View)jcVideoPlayer, (ViewGroup.LayoutParams)lp);
            jcVideoPlayer.setUp(url, 1, objects);
            jcVideoPlayer.addTextureView();
            jcVideoPlayer.setRotation(90.0f);
            jcVideoPlayer.startButton.performClick();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void hideSupportActionBar(Context context) {
        ActionBar ab = ((AppCompatActivity)context).getSupportActionBar();
        if (ab != null && (ACTIONBAR_STATUS = ab.isShowing())) {
            ((AppCompatActivity)context).getWindow().setFlags(1024, 1024);
            ab.setShowHideAnimationEnabled(false);
            ab.hide();
        }
    }

    private static void showSupportActionBar(Context context) {
        ((AppCompatActivity)context).getWindow().clearFlags(1024);
        ActionBar ab = ((AppCompatActivity)context).getSupportActionBar();
        if (ab != null && ACTIONBAR_STATUS) {
            ab.setShowHideAnimationEnabled(false);
            ab.show();
        }
    }

    public void showWifiDialog() {
    }

    protected void showProgressDialog(float deltaX, String seekTime, int seekTimePosition, String totalTime, int totalTimeDuration) {
    }

    protected void dismissProgressDialog() {
    }

    protected void showVolumDialog(float deltaY, int volumePercent) {
    }

    protected void dismissVolumDialog() {
    }

    public abstract int getLayoutId();

    static {
        onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case 1: {
                        break;
                    }
                    case -1: {
                        JCVideoPlayer.releaseAllVideos();
                        Log.d((String)JCVideoPlayer.TAG, (String)("AUDIOFOCUS_LOSS [" + this.hashCode() + "]"));
                        break;
                    }
                    case -2: {
                        if (JCMediaManager.instance().mediaPlayer.isPlaying()) {
                            JCMediaManager.instance().mediaPlayer.pause();
                        }
                        Log.d((String)JCVideoPlayer.TAG, (String)("AUDIOFOCUS_LOSS_TRANSIENT [" + this.hashCode() + "]"));
                        break;
                    }
                }
            }
        };
        ACTIONBAR_STATUS = false;
    }

    protected class ProgressTimerTask
    extends TimerTask {
        protected ProgressTimerTask() {
        }

        @Override
        public void run() {
            if (JCVideoPlayer.this.currentState == 2 || JCVideoPlayer.this.currentState == 5) {
                int position = JCVideoPlayer.this.getCurrentPositionWhenPlaying();
                int duration = JCVideoPlayer.this.getDuration();
                Log.v((String)JCVideoPlayer.TAG, (String)("onProgressUpdate " + position + "/" + duration + " [" + this.hashCode() + "] "));
                JCVideoPlayer.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        JCVideoPlayer.this.setTextAndProgress(0);
                    }
                });
            }
        }
    }
}

