/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.content.Context;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;

public class JCResizeTextureView
extends TextureView {
    public JCResizeTextureView(Context context) {
        super(context);
    }

    public JCResizeTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int videoWidth = JCMediaManager.instance().currentVideoWidth;
        int videoHeight = JCMediaManager.instance().currentVideoHeight;
        int width = JCResizeTextureView.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
        int height = JCResizeTextureView.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
        if (videoWidth > 0 && videoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (videoWidth * height < width * videoHeight) {
                    width = height * videoWidth / videoHeight;
                } else if (videoWidth * height > width * videoHeight) {
                    height = width * videoHeight / videoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * videoHeight / videoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * videoWidth / videoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = videoWidth;
                height = videoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * videoWidth / videoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * videoHeight / videoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }
}

