/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import fm.jiecao.jcvideoplayer_lib.JCBuriedPointStandard;
import fm.jiecao.jcvideoplayer_lib.JCUtils;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayer;
import fm.jiecao.jcvideoplayer_lib.R;
import java.util.Timer;
import java.util.TimerTask;

public class JCVideoPlayerStandard
extends JCVideoPlayer {
    public ImageView backButton;
    public ProgressBar bottomProgressBar;
    public ProgressBar loadingProgressBar;
    public TextView titleTextView;
    public ImageView thumbImageView;
    public ImageView coverImageView;
    public ImageView tinyBackImageView;
    protected static Timer DISSMISS_CONTROL_VIEW_TIMER;
    protected DismissControlViewTimerTask mDismissControlViewTimerTask;
    protected static JCBuriedPointStandard JC_BURIED_POINT_STANDARD;
    protected Dialog mProgressDialog;
    protected ProgressBar mDialogProgressBar;
    protected TextView mDialogSeekTime;
    protected TextView mDialogTotalTime;
    protected ImageView mDialogIcon;
    protected Dialog mVolumeDialog;
    protected ProgressBar mDialogVolumeProgressBar;

    public JCVideoPlayerStandard(Context context) {
        super(context);
    }

    public JCVideoPlayerStandard(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.bottomProgressBar = (ProgressBar)this.findViewById(R.id.bottom_progressbar);
        this.titleTextView = (TextView)this.findViewById(R.id.title);
        this.backButton = (ImageView)this.findViewById(R.id.back);
        this.thumbImageView = (ImageView)this.findViewById(R.id.thumb);
        this.coverImageView = (ImageView)this.findViewById(R.id.cover);
        this.loadingProgressBar = (ProgressBar)this.findViewById(R.id.loading);
        this.tinyBackImageView = (ImageView)this.findViewById(R.id.back_tiny);
        this.thumbImageView.setOnClickListener((View.OnClickListener)this);
        this.backButton.setOnClickListener((View.OnClickListener)this);
        this.tinyBackImageView.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public boolean setUp(String url, int screen, Object ... objects) {
        if (objects.length == 0) {
            return false;
        }
        if (super.setUp(url, screen, objects)) {
            this.titleTextView.setText((CharSequence)objects[0].toString());
            if (this.mCurrentScreen == 1) {
                this.fullscreenButton.setImageResource(R.drawable.jc_shrink);
                this.backButton.setVisibility(0);
                this.tinyBackImageView.setVisibility(4);
            } else if (this.mCurrentScreen == 0) {
                this.fullscreenButton.setImageResource(R.drawable.jc_enlarge);
                this.backButton.setVisibility(8);
                this.tinyBackImageView.setVisibility(4);
            } else if (this.mCurrentScreen == 2) {
                this.tinyBackImageView.setVisibility(0);
                this.setAllControlsVisible(4, 4, 4, 4, 4, 4, 4);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getLayoutId() {
        return R.layout.jc_layout_standard;
    }

    @Override
    public void setUiWitStateAndScreen(int state) {
        super.setUiWitStateAndScreen(state);
        switch (this.mCurrentState) {
            case 0: {
                this.changeUiToNormal();
                break;
            }
            case 1: {
                this.changeUiToPrepareingShow();
                this.startDismissControlViewTimer();
                break;
            }
            case 2: {
                this.changeUiToPlayingShow();
                this.startDismissControlViewTimer();
                break;
            }
            case 5: {
                this.changeUiToPauseShow();
                this.cancelDismissControlViewTimer();
                break;
            }
            case 7: {
                this.changeUiToError();
                break;
            }
            case 6: {
                this.changeUiToCompleteShow();
                this.cancelDismissControlViewTimer();
                this.bottomProgressBar.setProgress(100);
                break;
            }
            case 3: {
                this.changeUiToPlayingBufferingShow();
            }
        }
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                    if (this.mChangePosition) {
                        int duration = this.getDuration();
                        int progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.bottomProgressBar.setProgress(progress);
                    }
                    if (this.mChangePosition || this.mChangeVolume) break;
                    this.onClickUiToggle();
                }
            }
        } else if (id2 == R.id.progress) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelDismissControlViewTimer();
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                }
            }
        }
        return super.onTouch(v, event);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int i = v.getId();
        if (i == R.id.thumb) {
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.mCurrentState == 0) {
                if (!(this.mUrl.startsWith("file") || JCUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
                    this.showWifiDialog();
                    return;
                }
                this.startPlayLocic();
            } else if (this.mCurrentState == 6) {
                this.onClickUiToggle();
            }
        } else if (i == R.id.surface_container) {
            if (JC_BURIED_POINT_STANDARD == null || this.isCurrentMediaListener()) {
                // empty if block
            }
            this.startDismissControlViewTimer();
        } else if (i == R.id.back) {
            JCVideoPlayerStandard.backPress();
        } else if (i == R.id.back_tiny) {
            JCVideoPlayerStandard.backPress();
        }
    }

    @Override
    public void showWifiDialog() {
        super.showWifiDialog();
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setMessage((CharSequence)this.getResources().getString(R.string.tips_not_wifi));
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_confirm), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                JCVideoPlayerStandard.this.startPlayLocic();
                JCVideoPlayer.WIFI_TIP_DIALOG_SHOWED = true;
            }
        });
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
        super.onStartTrackingTouch(seekBar);
        this.cancelDismissControlViewTimer();
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        super.onStopTrackingTouch(seekBar);
        this.startDismissControlViewTimer();
    }

    private void startPlayLocic() {
        if (JC_BURIED_POINT_STANDARD != null) {
            JC_BURIED_POINT_STANDARD.onClickStartThumb(this.mUrl, this.mObjects);
        }
        this.prepareVideo();
        this.startDismissControlViewTimer();
    }

    private void onClickUiToggle() {
        if (this.mCurrentState == 1) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPrepareingClear();
            } else {
                this.changeUiToPrepareingShow();
            }
        } else if (this.mCurrentState == 2) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPlayingClear();
            } else {
                this.changeUiToPlayingShow();
            }
        } else if (this.mCurrentState == 5) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPauseClear();
            } else {
                this.changeUiToPauseShow();
            }
        } else if (this.mCurrentState == 6) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToCompleteClear();
            } else {
                this.changeUiToCompleteShow();
            }
        } else if (this.mCurrentState == 3) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPlayingBufferingClear();
            } else {
                this.changeUiToPlayingBufferingShow();
            }
        }
    }

    @Override
    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        super.setProgressAndTime(progress, secProgress, currentTime, totalTime);
        if (progress != 0) {
            this.bottomProgressBar.setProgress(progress);
        }
        if (secProgress != 0) {
            this.bottomProgressBar.setSecondaryProgress(secProgress);
        }
    }

    @Override
    protected void resetProgressAndTime() {
        super.resetProgressAndTime();
        this.bottomProgressBar.setProgress(0);
        this.bottomProgressBar.setSecondaryProgress(0);
    }

    private void changeUiToNormal() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(0, 4, 0, 4, 0, 0, 4);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisible(0, 4, 0, 4, 0, 0, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    private void changeUiToPrepareingShow() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(0, 0, 4, 0, 4, 0, 4);
                break;
            }
            case 1: {
                this.setAllControlsVisible(0, 0, 4, 0, 4, 0, 4);
                break;
            }
        }
    }

    private void changeUiToPrepareingClear() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(4, 4, 4, 0, 4, 0, 4);
                break;
            }
            case 1: {
                this.setAllControlsVisible(4, 4, 4, 0, 4, 0, 4);
                break;
            }
        }
    }

    private void changeUiToPlayingShow() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    private void changeUiToPlayingClear() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(4, 4, 0, 4, 4, 4, 4);
                break;
            }
            case 1: {
                this.setAllControlsVisible(4, 4, 0, 4, 4, 4, 4);
                break;
            }
        }
    }

    private void changeUiToPauseShow() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    private void changeUiToPauseClear() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(4, 0, 4, 4, 4, 4, 4);
                break;
            }
            case 1: {
                this.setAllControlsVisible(4, 0, 4, 4, 4, 4, 4);
                break;
            }
        }
    }

    private void changeUiToPlayingBufferingShow() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(0, 0, 4, 0, 4, 4, 4);
                break;
            }
            case 1: {
                this.setAllControlsVisible(0, 0, 4, 0, 4, 4, 4);
                break;
            }
        }
    }

    private void changeUiToPlayingBufferingClear() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(4, 4, 4, 0, 4, 4, 0);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisible(4, 4, 4, 0, 4, 4, 0);
                this.updateStartImage();
                break;
            }
        }
    }

    private void changeUiToCompleteShow() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(0, 0, 0, 4, 0, 4, 4);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisible(0, 0, 0, 4, 0, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    private void changeUiToCompleteClear() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(4, 4, 0, 4, 0, 4, 0);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisible(4, 4, 0, 4, 0, 4, 0);
                this.updateStartImage();
                break;
            }
        }
    }

    private void changeUiToError() {
        switch (this.mCurrentScreen) {
            case 0: {
                this.setAllControlsVisible(4, 4, 0, 4, 4, 0, 4);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisible(4, 4, 0, 4, 4, 0, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    private void setAllControlsVisible(int topCon, int bottomCon, int startBtn, int loadingPro, int thumbImg, int coverImg, int bottomPro) {
        this.topContainer.setVisibility(topCon);
        this.bottomContainer.setVisibility(bottomCon);
        this.startButton.setVisibility(startBtn);
        this.loadingProgressBar.setVisibility(loadingPro);
        this.thumbImageView.setVisibility(thumbImg);
        this.coverImageView.setVisibility(coverImg);
        this.bottomProgressBar.setVisibility(bottomPro);
    }

    private void updateStartImage() {
        if (this.mCurrentState == 2) {
            this.startButton.setImageResource(R.drawable.jc_click_pause_selector);
        } else if (this.mCurrentState == 7) {
            this.startButton.setImageResource(R.drawable.jc_click_error_selector);
        } else {
            this.startButton.setImageResource(R.drawable.jc_click_play_selector);
        }
    }

    @Override
    protected void showProgressDialog(float deltaX, String seekTime, int seekTimePosition, String totalTime, int totalTimeDuration) {
        super.showProgressDialog(deltaX, seekTime, seekTimePosition, totalTime, totalTimeDuration);
        if (this.mProgressDialog == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jc_progress_dialog, null);
            this.mDialogProgressBar = (ProgressBar)localView.findViewById(R.id.duration_progressbar);
            this.mDialogSeekTime = (TextView)localView.findViewById(R.id.tv_current);
            this.mDialogTotalTime = (TextView)localView.findViewById(R.id.tv_duration);
            this.mDialogIcon = (ImageView)localView.findViewById(R.id.duration_image_tip);
            this.mProgressDialog = new Dialog(this.getContext(), R.style.jc_style_dialog_progress);
            this.mProgressDialog.setContentView(localView);
            this.mProgressDialog.getWindow().addFlags(8);
            this.mProgressDialog.getWindow().addFlags(32);
            this.mProgressDialog.getWindow().addFlags(16);
            this.mProgressDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mProgressDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 49;
            localLayoutParams.y = this.getResources().getDimensionPixelOffset(R.dimen.jc_progress_dialog_margin_top);
            this.mProgressDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mProgressDialog.isShowing()) {
            this.mProgressDialog.show();
        }
        this.mDialogSeekTime.setText((CharSequence)seekTime);
        this.mDialogTotalTime.setText((CharSequence)(" / " + totalTime));
        this.mDialogProgressBar.setProgress(seekTimePosition * 100 / totalTimeDuration);
        if (deltaX > 0.0f) {
            this.mDialogIcon.setBackgroundResource(R.drawable.jc_forward_icon);
        } else {
            this.mDialogIcon.setBackgroundResource(R.drawable.jc_backward_icon);
        }
    }

    @Override
    protected void dismissProgressDialog() {
        super.dismissProgressDialog();
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    @Override
    protected void showVolumDialog(float deltaY, int volumePercent) {
        super.showVolumDialog(deltaY, volumePercent);
        if (this.mVolumeDialog == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jc_volume_dialog, null);
            this.mDialogVolumeProgressBar = (ProgressBar)localView.findViewById(R.id.volume_progressbar);
            this.mVolumeDialog = new Dialog(this.getContext(), R.style.jc_style_dialog_progress);
            this.mVolumeDialog.setContentView(localView);
            this.mVolumeDialog.getWindow().addFlags(8);
            this.mVolumeDialog.getWindow().addFlags(32);
            this.mVolumeDialog.getWindow().addFlags(16);
            this.mVolumeDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mVolumeDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 19;
            localLayoutParams.x = this.getContext().getResources().getDimensionPixelOffset(R.dimen.jc_volume_dialog_margin_left);
            this.mVolumeDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mVolumeDialog.isShowing()) {
            this.mVolumeDialog.show();
        }
        this.mDialogVolumeProgressBar.setProgress(volumePercent);
    }

    @Override
    protected void dismissVolumDialog() {
        super.dismissVolumDialog();
        if (this.mVolumeDialog != null) {
            this.mVolumeDialog.dismiss();
        }
    }

    private void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        DISSMISS_CONTROL_VIEW_TIMER = new Timer();
        this.mDismissControlViewTimerTask = new DismissControlViewTimerTask();
        DISSMISS_CONTROL_VIEW_TIMER.schedule((TimerTask)this.mDismissControlViewTimerTask, 2500L);
    }

    private void cancelDismissControlViewTimer() {
        if (DISSMISS_CONTROL_VIEW_TIMER != null) {
            DISSMISS_CONTROL_VIEW_TIMER.cancel();
        }
        if (this.mDismissControlViewTimerTask != null) {
            this.mDismissControlViewTimerTask.cancel();
        }
    }

    protected class DismissControlViewTimerTask
    extends TimerTask {
        protected DismissControlViewTimerTask() {
        }

        @Override
        public void run() {
            if (JCVideoPlayerStandard.this.mCurrentState != 0 && JCVideoPlayerStandard.this.mCurrentState != 7 && JCVideoPlayerStandard.this.mCurrentState != 6 && JCVideoPlayerStandard.this.getContext() != null && JCVideoPlayerStandard.this.getContext() instanceof Activity) {
                ((Activity)JCVideoPlayerStandard.this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        JCVideoPlayerStandard.this.bottomContainer.setVisibility(4);
                        JCVideoPlayerStandard.this.topContainer.setVisibility(4);
                        JCVideoPlayerStandard.this.bottomProgressBar.setVisibility(0);
                        JCVideoPlayerStandard.this.startButton.setVisibility(4);
                    }
                });
            }
        }
    }
}

