/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import fm.jiecao.jcvideoplayer_lib.JCBuriedPoint;
import fm.jiecao.jcvideoplayer_lib.JCFullScreenActivity;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.JCResizeTextureView;
import fm.jiecao.jcvideoplayer_lib.JCUtils;
import fm.jiecao.jcvideoplayer_lib.R;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class JCVideoPlayer
extends FrameLayout
implements View.OnClickListener,
View.OnTouchListener,
SeekBar.OnSeekBarChangeListener,
JCMediaManager.JCMediaPlayerListener,
TextureView.SurfaceTextureListener {
    public static final String TAG = "JieCaoVideoPlayer";
    protected int mCurrentState = -1;
    protected static final int CURRENT_STATE_PREPAREING = 0;
    protected static final int CURRENT_STATE_PAUSE = 1;
    protected static final int CURRENT_STATE_PLAYING = 2;
    protected static final int CURRENT_STATE_OVER = 3;
    protected static final int CURRENT_STATE_NORMAL = 4;
    protected static final int CURRENT_STATE_ERROR = 5;
    protected boolean mTouchingProgressBar = false;
    protected boolean mIfCurrentIsFullscreen = false;
    protected boolean mIfFullscreenIsDirectly = false;
    protected static boolean IF_FULLSCREEN_FROM_NORMAL = false;
    public static boolean IF_RELEASE_WHEN_ON_PAUSE = true;
    protected static long CLICK_QUIT_FULLSCREEN_TIME = 0L;
    public static final int FULL_SCREEN_NORMAL_DELAY = 1000;
    public ImageView startButton;
    public SeekBar progressBar;
    public ImageView fullscreenButton;
    public TextView currentTimeTextView;
    public TextView totalTimeTextView;
    public ViewGroup textureViewContainer;
    public ViewGroup topContainer;
    public ViewGroup bottomContainer;
    public JCResizeTextureView textureView;
    public Surface mSurface;
    protected String mUrl;
    protected Object[] mObjects;
    protected Map<String, String> mMapHeadData = new HashMap<String, String>();
    protected boolean mLooping = false;
    protected static Timer UPDATE_PROGRESS_TIMER;
    protected static JCBuriedPoint JC_BURIED_POINT;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected AudioManager mAudioManager;
    protected int mThreshold = 80;
    protected float mDownX;
    protected float mDownY;
    protected boolean mChangeVolume = false;
    protected boolean mChangePosition = false;
    protected int mDownPosition;
    protected int mDownVolume;
    protected Dialog mProgressDialog;
    protected ProgressBar mDialogProgressBar;
    protected TextView mDialogCurrentTime;
    protected TextView mDialogTotalTime;
    protected ImageView mDialogIcon;
    protected int mResultTimePosition;
    protected Dialog mVolumeDialog;
    protected ProgressBar mDialogVolumeProgressBar;

    public JCVideoPlayer(Context context) {
        super(context);
        this.init(context);
    }

    public JCVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    protected void init(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.startButton = (ImageView)this.findViewById(R.id.start);
        this.fullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.progressBar = (SeekBar)this.findViewById(R.id.progress);
        this.currentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.totalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.bottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.textureViewContainer = (RelativeLayout)this.findViewById(R.id.surface_container);
        this.topContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.startButton.setOnClickListener((View.OnClickListener)this);
        this.fullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.bottomContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.progressBar.setOnTouchListener((View.OnTouchListener)this);
        this.textureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.mScreenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
    }

    public abstract int getLayoutId();

    protected static void setJcBuriedPoint(JCBuriedPoint jcBuriedPoint) {
        JC_BURIED_POINT = jcBuriedPoint;
    }

    public boolean setUp(String url, Object ... objects) {
        if (JCMediaManager.instance().listener == this && System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 1000L) {
            return false;
        }
        this.mCurrentState = 4;
        this.mUrl = url;
        this.mObjects = objects;
        this.setStateAndUi(4);
        return true;
    }

    public boolean setUp(String url, Map<String, String> mapHeadData, Object ... objects) {
        if (this.setUp(url, objects)) {
            this.mMapHeadData.clear();
            this.mMapHeadData.putAll(mapHeadData);
            return true;
        }
        return false;
    }

    public void setLoop(boolean looping) {
        this.mLooping = looping;
    }

    protected void setStateAndUi(int state) {
        this.mCurrentState = state;
        switch (this.mCurrentState) {
            case 4: {
                if (JCMediaManager.instance().listener != this) break;
                JCMediaManager.instance().releaseMediaPlayer();
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                this.startProgressTimer();
                break;
            }
            case 1: {
                this.startProgressTimer();
                break;
            }
            case 5: {
                if (JCMediaManager.instance().listener != this) break;
                JCMediaManager.instance().releaseMediaPlayer();
                this.onCompletion();
            }
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start) {
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"No mUrl", (int)0).show();
                return;
            }
            if (this.mCurrentState == 4 || this.mCurrentState == 5) {
                if (JC_BURIED_POINT != null && this.mCurrentState == 4) {
                    JC_BURIED_POINT.onClickStartIcon(this.mUrl, this.mObjects);
                } else if (JC_BURIED_POINT != null) {
                    JC_BURIED_POINT.onClickStartError(this.mUrl, this.mObjects);
                }
                this.prepareVideo();
            } else if (this.mCurrentState == 2) {
                Log.d((String)TAG, (String)("pauseVideo [" + this.hashCode() + "] "));
                JCMediaManager.instance().mediaPlayer.pause();
                this.setStateAndUi(1);
                if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                    if (this.mIfCurrentIsFullscreen) {
                        JC_BURIED_POINT.onClickStopFullscreen(this.mUrl, this.mObjects);
                    } else {
                        JC_BURIED_POINT.onClickStop(this.mUrl, this.mObjects);
                    }
                }
            } else if (this.mCurrentState == 1) {
                if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                    if (this.mIfCurrentIsFullscreen) {
                        JC_BURIED_POINT.onClickResumeFullscreen(this.mUrl, this.mObjects);
                    } else {
                        JC_BURIED_POINT.onClickResume(this.mUrl, this.mObjects);
                    }
                }
                JCMediaManager.instance().mediaPlayer.start();
                this.setStateAndUi(2);
            }
        } else if (i == R.id.fullscreen) {
            if (this.mIfCurrentIsFullscreen) {
                this.backFullscreen();
            } else {
                Log.d((String)TAG, (String)("toFullscreenActivity [" + this.hashCode() + "] "));
                if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                    JC_BURIED_POINT.onEnterFullscreen(this.mUrl, this.mObjects);
                }
                JCMediaManager.instance().setDisplay(null);
                JCMediaManager.instance().lastListener = this;
                JCMediaManager.instance().listener = null;
                IF_FULLSCREEN_FROM_NORMAL = true;
                IF_RELEASE_WHEN_ON_PAUSE = false;
                JCFullScreenActivity.startActivityFromNormal(this.getContext(), this.mCurrentState, this.mUrl, this.getClass(), this.mObjects);
            }
        } else if (i == R.id.surface_container && this.mCurrentState == 5) {
            if (JC_BURIED_POINT != null) {
                JC_BURIED_POINT.onClickStartError(this.mUrl, this.mObjects);
            }
            this.prepareVideo();
        }
    }

    protected void prepareVideo() {
        Log.d((String)TAG, (String)("prepareVideo [" + this.hashCode() + "] "));
        if (JCMediaManager.instance().listener != null) {
            JCMediaManager.instance().listener.onCompletion();
        }
        JCMediaManager.instance().listener = this;
        this.addSurfaceView();
        JCMediaManager.instance().prepareToPlay(this.mUrl, this.mMapHeadData, this.mLooping);
        this.setStateAndUi(0);
    }

    protected void addSurfaceView() {
        Log.i((String)TAG, (String)("addSurfaceView [" + this.hashCode() + "] "));
        if (this.textureViewContainer.getChildCount() > 0) {
            this.textureViewContainer.removeAllViews();
        }
        this.textureView = new JCResizeTextureView(this.getContext());
        this.textureView.setSurfaceTextureListener(this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.textureViewContainer.addView((View)this.textureView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        JCMediaManager.instance().setDisplay(this.mSurface);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    this.mTouchingProgressBar = true;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mChangeVolume = false;
                    this.mChangePosition = false;
                    this.cancelProgressTimer();
                    break;
                }
                case 2: {
                    float deltaX = x - this.mDownX;
                    float deltaY = y - this.mDownY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if (this.mIfCurrentIsFullscreen && !this.mChangePosition && !this.mChangeVolume && (absDeltaX > (float)this.mThreshold || absDeltaY > (float)this.mThreshold)) {
                        if (absDeltaX >= (float)this.mThreshold) {
                            this.mChangePosition = true;
                            this.mDownPosition = this.getCurrentPositionWhenPlaying();
                            if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                                JC_BURIED_POINT.onTouchScreenSeekPosition(this.mUrl, this.mObjects);
                            }
                        } else {
                            this.mChangeVolume = true;
                            this.mDownVolume = this.mAudioManager.getStreamVolume(3);
                            if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                                JC_BURIED_POINT.onTouchScreenSeekVolume(this.mUrl, this.mObjects);
                            }
                        }
                    }
                    if (this.mChangePosition) {
                        this.showProgressDialog(deltaX);
                    }
                    if (!this.mChangeVolume) break;
                    this.showVolumDialog(-deltaY);
                    break;
                }
                case 1: {
                    this.mTouchingProgressBar = false;
                    if (this.mProgressDialog != null) {
                        this.mProgressDialog.dismiss();
                    }
                    if (this.mVolumeDialog != null) {
                        this.mVolumeDialog.dismiss();
                    }
                    if (this.mChangePosition) {
                        JCMediaManager.instance().mediaPlayer.seekTo(this.mResultTimePosition);
                        int duration = this.getDuration();
                        int progress = this.mResultTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.progressBar.setProgress(progress);
                    }
                    this.startProgressTimer();
                    if (JC_BURIED_POINT == null || JCMediaManager.instance().listener != this) break;
                    if (this.mIfCurrentIsFullscreen) {
                        JC_BURIED_POINT.onClickSeekbarFullscreen(this.mUrl, this.mObjects);
                        break;
                    }
                    JC_BURIED_POINT.onClickSeekbar(this.mUrl, this.mObjects);
                }
            }
        } else if (id2 == R.id.progress) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelProgressTimer();
                    for (ViewParent vpdown = this.getParent(); vpdown != null; vpdown = vpdown.getParent()) {
                        vpdown.requestDisallowInterceptTouchEvent(true);
                    }
                    break;
                }
                case 1: {
                    this.startProgressTimer();
                    for (ViewParent vpup = this.getParent(); vpup != null; vpup = vpup.getParent()) {
                        vpup.requestDisallowInterceptTouchEvent(false);
                    }
                    break;
                }
            }
        }
        return false;
    }

    protected void showProgressDialog(float deltaX) {
        if (this.mProgressDialog == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jc_progress_dialog, null);
            this.mDialogProgressBar = (ProgressBar)localView.findViewById(R.id.duration_progressbar);
            this.mDialogCurrentTime = (TextView)localView.findViewById(R.id.tv_current);
            this.mDialogTotalTime = (TextView)localView.findViewById(R.id.tv_duration);
            this.mDialogIcon = (ImageView)localView.findViewById(R.id.duration_image_tip);
            this.mProgressDialog = new Dialog(this.getContext(), R.style.jc_style_dialog_progress);
            this.mProgressDialog.setContentView(localView);
            this.mProgressDialog.getWindow().addFlags(8);
            this.mProgressDialog.getWindow().addFlags(32);
            this.mProgressDialog.getWindow().addFlags(16);
            this.mProgressDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mProgressDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 49;
            localLayoutParams.y = this.getResources().getDimensionPixelOffset(R.dimen.jc_progress_dialog_margin_top);
            this.mProgressDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mProgressDialog.isShowing()) {
            this.mProgressDialog.show();
        }
        int totalTime = this.getDuration();
        this.mResultTimePosition = (int)((float)this.mDownPosition + deltaX * (float)totalTime / (float)this.mScreenWidth);
        this.mDialogCurrentTime.setText((CharSequence)JCUtils.stringForTime(this.mResultTimePosition));
        this.mDialogTotalTime.setText((CharSequence)(" / " + JCUtils.stringForTime(totalTime) + ""));
        this.mDialogProgressBar.setProgress(this.mResultTimePosition * 100 / totalTime);
        if (deltaX > 0.0f) {
            this.mDialogIcon.setBackgroundResource(R.drawable.jc_forward_icon);
        } else {
            this.mDialogIcon.setBackgroundResource(R.drawable.jc_backward_icon);
        }
    }

    protected void showVolumDialog(float deltaY) {
        if (this.mVolumeDialog == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jc_volume_dialog, null);
            this.mDialogVolumeProgressBar = (ProgressBar)localView.findViewById(R.id.volume_progressbar);
            this.mVolumeDialog = new Dialog(this.getContext(), R.style.jc_style_dialog_progress);
            this.mVolumeDialog.setContentView(localView);
            this.mVolumeDialog.getWindow().addFlags(8);
            this.mVolumeDialog.getWindow().addFlags(32);
            this.mVolumeDialog.getWindow().addFlags(16);
            this.mVolumeDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mVolumeDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 19;
            localLayoutParams.x = this.getContext().getResources().getDimensionPixelOffset(R.dimen.jc_volume_dialog_margin_left);
            this.mVolumeDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mVolumeDialog.isShowing()) {
            this.mVolumeDialog.show();
        }
        int max = this.mAudioManager.getStreamMaxVolume(3);
        int deltaV = (int)((float)max * deltaY * 3.0f / (float)this.mScreenHeight);
        this.mAudioManager.setStreamVolume(3, this.mDownVolume + deltaV, 0);
        int transformatVolume = (int)((float)(this.mDownVolume * 100 / max) + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
        this.mDialogVolumeProgressBar.setProgress(transformatVolume);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (fromUser) {
            int time = progress * this.getDuration() / 100;
            JCMediaManager.instance().mediaPlayer.seekTo(time);
            Log.d((String)TAG, (String)("seekTo " + time + " [" + this.hashCode() + "] "));
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    @Override
    public void onPrepared() {
        if (this.mCurrentState != 0) {
            return;
        }
        JCMediaManager.instance().mediaPlayer.start();
        this.startProgressTimer();
        this.setStateAndUi(2);
    }

    @Override
    public void onAutoCompletion() {
        if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
            if (this.mIfCurrentIsFullscreen) {
                JC_BURIED_POINT.onAutoCompleteFullscreen(this.mUrl, this.mObjects);
            } else {
                JC_BURIED_POINT.onAutoComplete(this.mUrl, this.mObjects);
            }
        }
        this.onCompletion();
    }

    @Override
    public void onCompletion() {
        this.cancelProgressTimer();
        this.resetProgressAndTime();
        this.setStateAndUi(4);
        if (this.textureViewContainer.getChildCount() > 0) {
            this.textureViewContainer.removeAllViews();
        }
        this.finishFullscreenActivity();
        if (IF_FULLSCREEN_FROM_NORMAL) {
            IF_FULLSCREEN_FROM_NORMAL = false;
            JCMediaManager.instance().lastListener.onCompletion();
        }
        JCMediaManager.instance().listener = null;
        JCMediaManager.instance().lastListener = null;
    }

    @Override
    public void onBufferingUpdate(int percent) {
        if (this.mCurrentState != 4 && this.mCurrentState != 0) {
            this.setTextAndProgress(percent);
        }
    }

    @Override
    public void onSeekComplete() {
    }

    @Override
    public void onError(int what, int extra) {
        Log.e((String)TAG, (String)("onError " + what + " - " + extra + " [" + this.hashCode() + "] "));
        if (what != 38 && what != -38) {
            this.setStateAndUi(5);
        }
    }

    @Override
    public void onInfo(int what, int extra) {
        Log.i((String)TAG, (String)("onInfo what - " + what + " extra - " + extra));
        if (what == 701) {
            this.onMediaInfoBuffering(true);
            Log.i((String)TAG, (String)"MEDIA_INFO_BUFFERING_START");
        } else if (what == 702) {
            this.onMediaInfoBuffering(false);
            Log.i((String)TAG, (String)"MEDIA_INFO_BUFFERING_END");
        }
    }

    protected void onMediaInfoBuffering(boolean statues) {
    }

    @Override
    public void onVideoSizeChanged() {
        int mVideoWidth = JCMediaManager.instance().currentVideoWidth;
        int mVideoHeight = JCMediaManager.instance().currentVideoHeight;
        if (mVideoWidth != 0 && mVideoHeight != 0) {
            this.textureView.requestLayout();
        }
    }

    @Override
    public void onBackFullscreen() {
        this.mCurrentState = JCMediaManager.instance().lastState;
        this.setStateAndUi(this.mCurrentState);
    }

    protected void startProgressTimer() {
        this.cancelProgressTimer();
        UPDATE_PROGRESS_TIMER = new Timer();
        UPDATE_PROGRESS_TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JCVideoPlayer.this.getContext() != null && JCVideoPlayer.this.getContext() instanceof Activity) {
                    ((Activity)JCVideoPlayer.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (JCVideoPlayer.this.mCurrentState == 2 || JCVideoPlayer.this.mCurrentState == 1) {
                                JCVideoPlayer.this.setTextAndProgress(0);
                            }
                        }
                    });
                }
            }
        }, 0L, 300L);
    }

    protected void cancelProgressTimer() {
        if (UPDATE_PROGRESS_TIMER != null) {
            UPDATE_PROGRESS_TIMER.cancel();
        }
    }

    protected int getCurrentPositionWhenPlaying() {
        int position = 0;
        if (this.mCurrentState == 2 || this.mCurrentState == 1) {
            try {
                position = JCMediaManager.instance().mediaPlayer.getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return position;
            }
        }
        return position;
    }

    protected int getDuration() {
        int duration = 0;
        try {
            duration = JCMediaManager.instance().mediaPlayer.getDuration();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    protected void setTextAndProgress(int secProgress) {
        int position = this.getCurrentPositionWhenPlaying();
        int duration = this.getDuration();
        int progress = position * 100 / (duration == 0 ? 1 : duration);
        this.setProgressAndTime(progress, secProgress, position, duration);
    }

    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        if (!this.mTouchingProgressBar && progress != 0) {
            this.progressBar.setProgress(progress);
        }
        if (secProgress != 0) {
            this.progressBar.setSecondaryProgress(secProgress);
        }
        this.currentTimeTextView.setText((CharSequence)JCUtils.stringForTime(currentTime));
        this.totalTimeTextView.setText((CharSequence)JCUtils.stringForTime(totalTime));
    }

    protected void resetProgressAndTime() {
        this.progressBar.setProgress(0);
        this.progressBar.setSecondaryProgress(0);
        this.currentTimeTextView.setText((CharSequence)JCUtils.stringForTime(0));
        this.totalTimeTextView.setText((CharSequence)JCUtils.stringForTime(0));
    }

    protected void quitFullScreenGoToNormal() {
        Log.i((String)TAG, (String)("quitFullScreenGoToNormal [" + this.hashCode() + "] "));
        if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
            JC_BURIED_POINT.onQuitFullscreen(this.mUrl, this.mObjects);
        }
        JCMediaManager.instance().setDisplay(null);
        JCMediaManager.instance().listener = JCMediaManager.instance().lastListener;
        JCMediaManager.instance().lastListener = null;
        JCMediaManager.instance().lastState = this.mCurrentState;
        JCMediaManager.instance().listener.onBackFullscreen();
        this.finishFullscreenActivity();
    }

    protected void finishFullscreenActivity() {
        if (this.getContext() instanceof JCFullScreenActivity) {
            Log.i((String)TAG, (String)("finishFullscreenActivity [" + this.hashCode() + "] "));
            ((JCFullScreenActivity)this.getContext()).finish();
        }
    }

    public void backFullscreen() {
        Log.d((String)TAG, (String)("quitFullscreen [" + this.hashCode() + "] "));
        IF_FULLSCREEN_FROM_NORMAL = false;
        if (this.mIfFullscreenIsDirectly) {
            JCMediaManager.instance().mediaPlayer.stop();
            this.finishFullscreenActivity();
        } else {
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            IF_RELEASE_WHEN_ON_PAUSE = false;
            this.quitFullScreenGoToNormal();
        }
    }

    public static void releaseAllVideos() {
        if (IF_RELEASE_WHEN_ON_PAUSE) {
            Log.i((String)TAG, (String)"releaseAllVideos");
            JCMediaManager.instance().releaseMediaPlayer();
            if (JCMediaManager.instance().listener != null) {
                JCMediaManager.instance().listener.onCompletion();
            }
        } else {
            IF_RELEASE_WHEN_ON_PAUSE = true;
        }
    }

    public void release() {
        if (this.mCurrentState != 4) {
            Log.i((String)TAG, (String)("release [" + this.hashCode() + "]"));
            JCVideoPlayer.releaseAllVideos();
        }
    }
}

