/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import fm.jiecao.jcvideoplayer_lib.JCBuriedPointStandard;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayer;
import fm.jiecao.jcvideoplayer_lib.R;
import java.util.Timer;
import java.util.TimerTask;

public class JCVideoPlayerStandard
extends JCVideoPlayer {
    public ImageView backButton;
    public ProgressBar bottomProgressBar;
    public ProgressBar loadingProgressBar;
    public TextView titleTextView;
    public ImageView thumbImageView;
    public ImageView coverImageView;
    protected static Timer DISSMISS_CONTROL_VIEW_TIMER;
    protected static JCBuriedPointStandard JC_BURIED_POINT_STANDARD;

    public JCVideoPlayerStandard(Context context) {
        super(context);
    }

    public JCVideoPlayerStandard(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.bottomProgressBar = (ProgressBar)this.findViewById(R.id.bottom_progressbar);
        this.titleTextView = (TextView)this.findViewById(R.id.title);
        this.backButton = (ImageView)this.findViewById(R.id.back);
        this.thumbImageView = (ImageView)this.findViewById(R.id.thumb);
        this.coverImageView = (ImageView)this.findViewById(R.id.cover);
        this.loadingProgressBar = (ProgressBar)this.findViewById(R.id.loading);
        this.thumbImageView.setOnClickListener((View.OnClickListener)this);
        this.backButton.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public boolean setUp(String url, Object ... objects) {
        if (objects.length == 0) {
            return false;
        }
        if (super.setUp(url, objects)) {
            this.titleTextView.setText((CharSequence)objects[0].toString());
            if (this.mIfCurrentIsFullscreen) {
                this.fullscreenButton.setImageResource(R.drawable.jc_shrink);
            } else {
                this.fullscreenButton.setImageResource(R.drawable.jc_enlarge);
                this.backButton.setVisibility(8);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getLayoutId() {
        return R.layout.jc_layout_standard;
    }

    @Override
    protected void setStateAndUi(int state) {
        super.setStateAndUi(state);
        switch (this.mCurrentState) {
            case 4: {
                this.changeUiToNormal();
                break;
            }
            case 0: {
                this.changeUiToShowUiPrepareing();
                this.startDismissControlViewTimer();
                break;
            }
            case 2: {
                this.changeUiToShowUiPlaying();
                this.startDismissControlViewTimer();
                break;
            }
            case 1: {
                this.changeUiToShowUiPause();
                this.cancelDismissControlViewTimer();
                break;
            }
            case 5: {
                this.changeUiToError();
            }
        }
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelDismissControlViewTimer();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                    if (this.mChangePosition) {
                        int duration = this.getDuration();
                        int progress = this.mResultTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.bottomProgressBar.setProgress(progress);
                    }
                    if (this.mChangePosition || this.mChangeVolume) break;
                    this.onClickUiToggle();
                }
            }
        } else if (id2 == R.id.progress) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelDismissControlViewTimer();
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                }
            }
        }
        return super.onTouch(v, event);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int i = v.getId();
        if (i == R.id.thumb) {
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"No mUrl", (int)0).show();
                return;
            }
            if (this.mCurrentState == 4) {
                if (JC_BURIED_POINT_STANDARD != null) {
                    JC_BURIED_POINT_STANDARD.onClickStartThumb(this.mUrl, this.mObjects);
                }
                this.prepareVideo();
                this.startDismissControlViewTimer();
            }
        } else if (i == R.id.surface_container) {
            if (JC_BURIED_POINT_STANDARD != null && JCMediaManager.instance().listener == this) {
                if (this.mIfCurrentIsFullscreen) {
                    JC_BURIED_POINT_STANDARD.onClickBlankFullscreen(this.mUrl, this.mObjects);
                } else {
                    JC_BURIED_POINT_STANDARD.onClickBlank(this.mUrl, this.mObjects);
                }
            }
            this.startDismissControlViewTimer();
        } else if (i == R.id.back) {
            this.backFullscreen();
        }
    }

    private void onClickUiToggle() {
        if (this.mCurrentState == 0) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToClearUiPrepareing();
            } else {
                this.changeUiToShowUiPrepareing();
            }
        } else if (this.mCurrentState == 2) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToClearUiPlaying();
            } else {
                this.changeUiToShowUiPlaying();
            }
        } else if (this.mCurrentState == 1) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToClearUiPause();
            } else {
                this.changeUiToShowUiPause();
            }
        }
    }

    @Override
    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        super.setProgressAndTime(progress, secProgress, currentTime, totalTime);
        if (progress != 0) {
            this.bottomProgressBar.setProgress(progress);
        }
        if (secProgress != 0) {
            this.bottomProgressBar.setSecondaryProgress(secProgress);
        }
    }

    @Override
    protected void resetProgressAndTime() {
        super.resetProgressAndTime();
        this.bottomProgressBar.setProgress(0);
        this.bottomProgressBar.setSecondaryProgress(0);
    }

    private void changeUiToNormal() {
        this.topContainer.setVisibility(0);
        this.bottomContainer.setVisibility(4);
        this.startButton.setVisibility(0);
        this.loadingProgressBar.setVisibility(4);
        this.thumbImageView.setVisibility(0);
        this.coverImageView.setVisibility(0);
        this.bottomProgressBar.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToShowUiPrepareing() {
        this.topContainer.setVisibility(0);
        this.bottomContainer.setVisibility(0);
        this.startButton.setVisibility(4);
        this.loadingProgressBar.setVisibility(0);
        this.thumbImageView.setVisibility(4);
        this.coverImageView.setVisibility(0);
        this.bottomProgressBar.setVisibility(4);
    }

    private void changeUiToClearUiPrepareing() {
        this.topContainer.setVisibility(4);
        this.bottomContainer.setVisibility(4);
        this.startButton.setVisibility(4);
        this.thumbImageView.setVisibility(4);
        this.bottomProgressBar.setVisibility(4);
        this.coverImageView.setVisibility(0);
    }

    private void changeUiToShowUiPlaying() {
        this.topContainer.setVisibility(0);
        this.bottomContainer.setVisibility(0);
        this.startButton.setVisibility(0);
        this.loadingProgressBar.setVisibility(4);
        this.thumbImageView.setVisibility(4);
        this.coverImageView.setVisibility(4);
        this.bottomProgressBar.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToClearUiPlaying() {
        this.changeUiToClearUi();
        this.bottomProgressBar.setVisibility(0);
    }

    private void changeUiToShowUiPause() {
        this.topContainer.setVisibility(0);
        this.bottomContainer.setVisibility(0);
        this.startButton.setVisibility(0);
        this.loadingProgressBar.setVisibility(4);
        this.thumbImageView.setVisibility(4);
        this.coverImageView.setVisibility(4);
        this.bottomProgressBar.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToClearUiPause() {
        this.changeUiToClearUi();
        this.bottomProgressBar.setVisibility(0);
    }

    private void changeUiToClearUi() {
        this.topContainer.setVisibility(4);
        this.bottomContainer.setVisibility(4);
        this.startButton.setVisibility(4);
        this.loadingProgressBar.setVisibility(4);
        this.thumbImageView.setVisibility(4);
        this.coverImageView.setVisibility(4);
        this.bottomProgressBar.setVisibility(4);
    }

    private void changeUiToError() {
        this.topContainer.setVisibility(4);
        this.bottomContainer.setVisibility(4);
        this.startButton.setVisibility(0);
        this.loadingProgressBar.setVisibility(4);
        this.thumbImageView.setVisibility(4);
        this.coverImageView.setVisibility(0);
        this.bottomProgressBar.setVisibility(4);
        this.updateStartImage();
    }

    private void updateStartImage() {
        if (this.mCurrentState == 2) {
            this.startButton.setImageResource(R.drawable.jc_click_pause_selector);
        } else if (this.mCurrentState == 5) {
            this.startButton.setImageResource(R.drawable.jc_click_error_selector);
        } else {
            this.startButton.setImageResource(R.drawable.jc_click_play_selector);
        }
    }

    private void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        DISSMISS_CONTROL_VIEW_TIMER = new Timer();
        DISSMISS_CONTROL_VIEW_TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JCVideoPlayerStandard.this.getContext() != null && JCVideoPlayerStandard.this.getContext() instanceof Activity) {
                    ((Activity)JCVideoPlayerStandard.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (JCVideoPlayerStandard.this.mCurrentState != 4 && JCVideoPlayerStandard.this.mCurrentState != 5) {
                                JCVideoPlayerStandard.this.bottomContainer.setVisibility(4);
                                JCVideoPlayerStandard.this.topContainer.setVisibility(4);
                                JCVideoPlayerStandard.this.bottomProgressBar.setVisibility(0);
                                JCVideoPlayerStandard.this.startButton.setVisibility(4);
                            }
                        }
                    });
                }
            }
        }, 2500L);
    }

    private void cancelDismissControlViewTimer() {
        if (DISSMISS_CONTROL_VIEW_TIMER != null) {
            DISSMISS_CONTROL_VIEW_TIMER.cancel();
        }
    }

    public static void setJcBuriedPointStandard(JCBuriedPointStandard jcBuriedPointStandard) {
        JC_BURIED_POINT_STANDARD = jcBuriedPointStandard;
        JCVideoPlayer.setJcBuriedPoint(jcBuriedPointStandard);
    }

    @Override
    public void onCompletion() {
        super.onCompletion();
        this.cancelDismissControlViewTimer();
    }
}

