/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import fm.jiecao.jcvideoplayer_lib.JCBuriedPointStandard;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayer;
import fm.jiecao.jcvideoplayer_lib.R;
import java.util.Timer;
import java.util.TimerTask;

public class JCVideoPlayerStandard
extends JCVideoPlayer {
    public ImageView ivBack;
    public ProgressBar pbBottom;
    public ProgressBar pbLoading;
    public TextView tvTitle;
    public ImageView ivThumb;
    public ImageView ivCover;
    protected static Timer mDismissControlViewTimer;
    protected static JCBuriedPointStandard jc_BuriedPointStandard;

    public JCVideoPlayerStandard(Context context) {
        super(context);
    }

    public JCVideoPlayerStandard(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.pbBottom = (ProgressBar)this.findViewById(R.id.bottom_progressbar);
        this.tvTitle = (TextView)this.findViewById(R.id.title);
        this.ivBack = (ImageView)this.findViewById(R.id.back);
        this.ivThumb = (ImageView)this.findViewById(R.id.thumb);
        this.ivCover = (ImageView)this.findViewById(R.id.cover);
        this.pbLoading = (ProgressBar)this.findViewById(R.id.loading);
        this.ivThumb.setOnClickListener((View.OnClickListener)this);
        this.ivBack.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void setUp(String url, Object ... objects) {
        if (JCMediaManager.instance().listener == this && System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 1000L) {
            return;
        }
        if (objects.length == 0) {
            return;
        }
        super.setUp(url, objects);
        this.tvTitle.setText((CharSequence)objects[0].toString());
        if (this.IF_CURRENT_IS_FULLSCREEN) {
            this.ivFullScreen.setImageResource(R.drawable.jc_shrink);
        } else {
            this.ivFullScreen.setImageResource(R.drawable.jc_enlarge);
            this.ivBack.setVisibility(8);
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.jc_layout_standard;
    }

    @Override
    public void setStateAndUi(int state) {
        super.setStateAndUi(state);
        switch (this.CURRENT_STATE) {
            case 4: {
                this.changeUiToNormal();
                break;
            }
            case 0: {
                this.changeUiToShowUiPrepareing();
                this.startDismissControlViewTimer();
                break;
            }
            case 2: {
                this.changeUiToShowUiPlaying();
                this.startDismissControlViewTimer();
                break;
            }
            case 1: {
                this.changeUiToShowUiPause();
                this.cancelDismissControlViewTimer();
                break;
            }
            case 5: {
                this.changeUiToError();
            }
        }
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelDismissControlViewTimer();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                    if (this.changePosition) {
                        int duration = JCMediaManager.instance().mediaPlayer.getDuration();
                        int progress = this.resultTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.pbBottom.setProgress(progress);
                    }
                    if (this.changePosition || this.changeVolume) break;
                    this.onClickUiToggle();
                }
            }
        } else if (id2 == R.id.progress) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelDismissControlViewTimer();
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                }
            }
        }
        return super.onTouch(v, event);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int i = v.getId();
        if (i == R.id.thumb) {
            if (TextUtils.isEmpty((CharSequence)this.url)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"No url", (int)0).show();
                return;
            }
            if (this.CURRENT_STATE == 4) {
                if (jc_BuriedPointStandard != null) {
                    jc_BuriedPointStandard.onClickStartThumb(this.url, this.objects);
                }
                this.prepareVideo();
                this.startDismissControlViewTimer();
            }
        } else if (i == R.id.surface_container) {
            if (jc_BuriedPointStandard != null && JCMediaManager.instance().listener == this) {
                if (this.IF_CURRENT_IS_FULLSCREEN) {
                    jc_BuriedPointStandard.onClickBlankFullscreen(this.url, this.objects);
                } else {
                    jc_BuriedPointStandard.onClickBlank(this.url, this.objects);
                }
            }
            this.startDismissControlViewTimer();
        } else if (i == R.id.back) {
            this.backFullscreen();
        }
    }

    private void onClickUiToggle() {
        if (this.CURRENT_STATE == 0) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.changeUiToClearUiPrepareing();
            } else {
                this.changeUiToShowUiPrepareing();
            }
        } else if (this.CURRENT_STATE == 2) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.changeUiToClearUiPlaying();
            } else {
                this.changeUiToShowUiPlaying();
            }
        } else if (this.CURRENT_STATE == 1) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.changeUiToClearUiPause();
            } else {
                this.changeUiToShowUiPause();
            }
        }
    }

    @Override
    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        super.setProgressAndTime(progress, secProgress, currentTime, totalTime);
        if (progress != 0) {
            this.pbBottom.setProgress(progress);
        }
        if (secProgress != 0) {
            this.pbBottom.setSecondaryProgress(secProgress);
        }
    }

    @Override
    protected void resetProgressAndTime() {
        super.resetProgressAndTime();
        this.pbBottom.setProgress(0);
        this.pbBottom.setSecondaryProgress(0);
    }

    private void changeUiToNormal() {
        this.llTopContainer.setVisibility(0);
        this.llBottomControl.setVisibility(4);
        this.ivStart.setVisibility(0);
        this.pbLoading.setVisibility(4);
        this.ivThumb.setVisibility(0);
        this.ivCover.setVisibility(0);
        this.pbBottom.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToShowUiPrepareing() {
        this.llTopContainer.setVisibility(0);
        this.llBottomControl.setVisibility(0);
        this.ivStart.setVisibility(4);
        this.pbLoading.setVisibility(0);
        this.ivThumb.setVisibility(4);
        this.ivCover.setVisibility(0);
        this.pbBottom.setVisibility(4);
    }

    private void changeUiToClearUiPrepareing() {
        this.llTopContainer.setVisibility(4);
        this.llBottomControl.setVisibility(4);
        this.ivStart.setVisibility(4);
        this.ivThumb.setVisibility(4);
        this.pbBottom.setVisibility(4);
        this.ivCover.setVisibility(0);
    }

    private void changeUiToShowUiPlaying() {
        this.llTopContainer.setVisibility(0);
        this.llBottomControl.setVisibility(0);
        this.ivStart.setVisibility(0);
        this.pbLoading.setVisibility(4);
        this.ivThumb.setVisibility(4);
        this.ivCover.setVisibility(4);
        this.pbBottom.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToClearUiPlaying() {
        this.changeUiToClearUi();
        this.pbBottom.setVisibility(0);
    }

    private void changeUiToShowUiPause() {
        this.llTopContainer.setVisibility(0);
        this.llBottomControl.setVisibility(0);
        this.ivStart.setVisibility(0);
        this.pbLoading.setVisibility(4);
        this.ivThumb.setVisibility(4);
        this.ivCover.setVisibility(4);
        this.pbBottom.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToClearUiPause() {
        this.changeUiToClearUi();
        this.pbBottom.setVisibility(0);
    }

    private void changeUiToClearUi() {
        this.llTopContainer.setVisibility(4);
        this.llBottomControl.setVisibility(4);
        this.ivStart.setVisibility(4);
        this.pbLoading.setVisibility(4);
        this.ivThumb.setVisibility(4);
        this.ivCover.setVisibility(4);
        this.pbBottom.setVisibility(4);
    }

    private void changeUiToError() {
        this.llTopContainer.setVisibility(4);
        this.llBottomControl.setVisibility(4);
        this.ivStart.setVisibility(0);
        this.pbLoading.setVisibility(4);
        this.ivThumb.setVisibility(4);
        this.ivCover.setVisibility(0);
        this.pbBottom.setVisibility(4);
        this.updateStartImage();
    }

    private void updateStartImage() {
        if (this.CURRENT_STATE == 2) {
            this.ivStart.setImageResource(R.drawable.jc_click_pause_selector);
        } else if (this.CURRENT_STATE == 5) {
            this.ivStart.setImageResource(R.drawable.jc_click_error_selector);
        } else {
            this.ivStart.setImageResource(R.drawable.jc_click_play_selector);
        }
    }

    private void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        mDismissControlViewTimer = new Timer();
        mDismissControlViewTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JCVideoPlayerStandard.this.getContext() != null && JCVideoPlayerStandard.this.getContext() instanceof Activity) {
                    ((Activity)JCVideoPlayerStandard.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (JCVideoPlayerStandard.this.CURRENT_STATE != 4 && JCVideoPlayerStandard.this.CURRENT_STATE != 5) {
                                JCVideoPlayerStandard.this.llBottomControl.setVisibility(4);
                                JCVideoPlayerStandard.this.llTopContainer.setVisibility(4);
                                JCVideoPlayerStandard.this.pbBottom.setVisibility(0);
                                JCVideoPlayerStandard.this.ivStart.setVisibility(4);
                            }
                        }
                    });
                }
            }
        }, 2500L);
    }

    private void cancelDismissControlViewTimer() {
        if (mDismissControlViewTimer != null) {
            mDismissControlViewTimer.cancel();
        }
    }

    public static void setJcBuriedPointStandard(JCBuriedPointStandard jcBuriedPointStandard) {
        jc_BuriedPointStandard = jcBuriedPointStandard;
        JCVideoPlayer.setJcBuriedPoint(jcBuriedPointStandard);
    }

    @Override
    public void onCompletion() {
        super.onCompletion();
        this.cancelDismissControlViewTimer();
    }
}

