/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.media.AudioManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import fm.jiecao.jcvideoplayer_lib.JCBuriedPoint;
import fm.jiecao.jcvideoplayer_lib.JCFullScreenActivity;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.JCResizeSurfaceView;
import fm.jiecao.jcvideoplayer_lib.JCUtils;
import fm.jiecao.jcvideoplayer_lib.R;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class JCVideoPlayer
extends FrameLayout
implements View.OnClickListener,
View.OnTouchListener,
SeekBar.OnSeekBarChangeListener,
SurfaceHolder.Callback,
JCMediaManager.JCMediaPlayerListener {
    public static final String TAG = "JCVideoPlayer";
    public int CURRENT_STATE = -1;
    public static final int CURRENT_STATE_PREPAREING = 0;
    public static final int CURRENT_STATE_PAUSE = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_OVER = 3;
    public static final int CURRENT_STATE_NORMAL = 4;
    public static final int CURRENT_STATE_ERROR = 5;
    protected boolean touchingProgressBar = false;
    public boolean IF_CURRENT_IS_FULLSCREEN = false;
    public boolean IF_FULLSCREEN_IS_DIRECTLY = false;
    protected static boolean IF_FULLSCREEN_FROM_NORMAL = false;
    public static boolean IF_RELEASE_WHEN_ON_PAUSE = true;
    protected static long CLICK_QUIT_FULLSCREEN_TIME = 0L;
    public static final int FULL_SCREEN_NORMAL_DELAY = 1000;
    public ImageView ivStart;
    public SeekBar skProgress;
    public ImageView ivFullScreen;
    public TextView tvTimeCurrent;
    public TextView tvTimeTotal;
    public ViewGroup rlSurfaceContainer;
    public ViewGroup llTopContainer;
    public ViewGroup llBottomControl;
    public JCResizeSurfaceView surfaceView;
    public SurfaceHolder surfaceHolder;
    public String url;
    public Object[] objects;
    public Map<String, String> mapHeadData = new HashMap<String, String>();
    public static Timer mUpdateProgressTimer;
    protected static JCBuriedPoint JC_BURIED_POINT;
    protected int screenWidth;
    protected int screenHeight;
    protected AudioManager mAudioManager;
    protected int threshold = 80;
    protected float downX;
    protected float downY;
    protected boolean changeVolume = false;
    protected boolean changePosition = false;
    protected int downPosition;
    protected int downVolume;
    public Dialog dlgProgress;
    public ProgressBar dlgProgressProgressBar;
    public TextView dlgProgressCurrent;
    public TextView dlgProgressTotal;
    public ImageView dlgProgressIcon;
    protected int resultTimePosition;
    public Dialog dlgVolume;
    public ProgressBar dlgVolumeProgressBar;

    public JCVideoPlayer(Context context) {
        super(context);
        this.init(context);
    }

    public JCVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    protected void init(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.ivStart = (ImageView)this.findViewById(R.id.start);
        this.ivFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.skProgress = (SeekBar)this.findViewById(R.id.progress);
        this.tvTimeCurrent = (TextView)this.findViewById(R.id.current);
        this.tvTimeTotal = (TextView)this.findViewById(R.id.total);
        this.llBottomControl = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.rlSurfaceContainer = (RelativeLayout)this.findViewById(R.id.surface_container);
        this.llTopContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.ivStart.setOnClickListener((View.OnClickListener)this);
        this.ivFullScreen.setOnClickListener((View.OnClickListener)this);
        this.skProgress.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.llBottomControl.setOnClickListener((View.OnClickListener)this);
        this.rlSurfaceContainer.setOnClickListener((View.OnClickListener)this);
        this.skProgress.setOnTouchListener((View.OnTouchListener)this);
        this.rlSurfaceContainer.setOnTouchListener((View.OnTouchListener)this);
        this.screenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        this.screenHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
    }

    public abstract int getLayoutId();

    protected static void setJcBuriedPoint(JCBuriedPoint jcBuriedPoint) {
        JC_BURIED_POINT = jcBuriedPoint;
    }

    public void setUp(String url, Object ... objects) {
        if (JCMediaManager.instance().listener == this && System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 1000L) {
            return;
        }
        this.CURRENT_STATE = 4;
        this.url = url;
        this.objects = objects;
        this.setStateAndUi(4);
    }

    public void setUp(String url, Map<String, String> mapHeadData, Object ... objects) {
        if (JCMediaManager.instance().listener == this && System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 1000L) {
            return;
        }
        this.setUp(url, objects);
        this.mapHeadData.clear();
        this.mapHeadData.putAll(mapHeadData);
    }

    protected void setStateAndUi(int state) {
        this.CURRENT_STATE = state;
        switch (this.CURRENT_STATE) {
            case 4: {
                if (JCMediaManager.instance().listener != this) break;
                JCMediaManager.instance().mediaPlayer.release();
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                this.startProgressTimer();
                break;
            }
            case 1: {
                this.startProgressTimer();
                break;
            }
            case 5: {
                JCMediaManager.instance().mediaPlayer.release();
            }
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start) {
            if (TextUtils.isEmpty((CharSequence)this.url)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"No url", (int)0).show();
                return;
            }
            if (this.CURRENT_STATE == 4 || this.CURRENT_STATE == 5) {
                if (JC_BURIED_POINT != null && this.CURRENT_STATE == 4) {
                    JC_BURIED_POINT.onClickStartIcon(this.url, this.objects);
                } else if (JC_BURIED_POINT != null) {
                    JC_BURIED_POINT.onClickStartError(this.url, this.objects);
                }
                this.prepareVideo();
            } else if (this.CURRENT_STATE == 2) {
                JCMediaManager.instance().mediaPlayer.pause();
                this.setStateAndUi(1);
                if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                    if (this.IF_CURRENT_IS_FULLSCREEN) {
                        JC_BURIED_POINT.onClickStopFullscreen(this.url, this.objects);
                    } else {
                        JC_BURIED_POINT.onClickStop(this.url, this.objects);
                    }
                }
            } else if (this.CURRENT_STATE == 1) {
                if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                    if (this.IF_CURRENT_IS_FULLSCREEN) {
                        JC_BURIED_POINT.onClickResumeFullscreen(this.url, this.objects);
                    } else {
                        JC_BURIED_POINT.onClickResume(this.url, this.objects);
                    }
                }
                JCMediaManager.instance().mediaPlayer.start();
                this.setStateAndUi(2);
            }
        } else if (i == R.id.fullscreen) {
            if (this.IF_CURRENT_IS_FULLSCREEN) {
                this.backFullscreen();
            } else {
                if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                    JC_BURIED_POINT.onEnterFullscreen(this.url, this.objects);
                }
                JCMediaManager.instance().mediaPlayer.setDisplay(null);
                JCMediaManager.instance().lastListener = this;
                JCMediaManager.instance().listener = null;
                IF_FULLSCREEN_FROM_NORMAL = true;
                IF_RELEASE_WHEN_ON_PAUSE = false;
                JCFullScreenActivity.toActivityFromNormal(this.getContext(), this.CURRENT_STATE, this.url, this.getClass(), this.objects);
            }
        } else if (i == R.id.surface_container && this.CURRENT_STATE == 5) {
            if (JC_BURIED_POINT != null) {
                JC_BURIED_POINT.onClickStartError(this.url, this.objects);
            }
            this.prepareVideo();
        }
    }

    protected void prepareVideo() {
        if (JCMediaManager.instance().listener != null) {
            JCMediaManager.instance().listener.onCompletion();
        }
        JCMediaManager.instance().listener = this;
        this.addSurfaceView();
        JCMediaManager.instance().prepareToPlay(this.getContext(), this.url, this.mapHeadData);
        this.setStateAndUi(0);
    }

    public void addSurfaceView() {
        if (this.rlSurfaceContainer.getChildCount() > 0) {
            this.rlSurfaceContainer.removeAllViews();
        }
        this.surfaceView = new JCResizeSurfaceView(this.getContext());
        this.surfaceHolder = this.surfaceView.getHolder();
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.rlSurfaceContainer.addView((View)this.surfaceView, (ViewGroup.LayoutParams)layoutParams);
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    this.touchingProgressBar = true;
                    this.downX = x;
                    this.downY = y;
                    this.changeVolume = false;
                    this.changePosition = false;
                    this.cancelProgressTimer();
                    break;
                }
                case 2: {
                    float deltaX = x - this.downX;
                    float deltaY = y - this.downY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if (this.IF_CURRENT_IS_FULLSCREEN && !this.changePosition && !this.changeVolume && (absDeltaX > (float)this.threshold || absDeltaY > (float)this.threshold)) {
                        if (absDeltaX >= (float)this.threshold) {
                            this.changePosition = true;
                            this.downPosition = this.getCurrentPositionWhenPlaying();
                            if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                                JC_BURIED_POINT.onTouchScreenSeekPosition(this.url, this.objects);
                            }
                        } else {
                            this.changeVolume = true;
                            this.downVolume = this.mAudioManager.getStreamVolume(3);
                            if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
                                JC_BURIED_POINT.onTouchScreenSeekVolume(this.url, this.objects);
                            }
                        }
                    }
                    if (this.changePosition) {
                        this.showProgressDialog(deltaX);
                    }
                    if (!this.changeVolume) break;
                    this.showVolumDialog(-deltaY);
                    break;
                }
                case 1: {
                    this.touchingProgressBar = false;
                    if (this.dlgProgress != null) {
                        this.dlgProgress.dismiss();
                    }
                    if (this.dlgVolume != null) {
                        this.dlgVolume.dismiss();
                    }
                    if (this.changePosition) {
                        JCMediaManager.instance().mediaPlayer.seekTo(this.resultTimePosition);
                        int duration = JCMediaManager.instance().mediaPlayer.getDuration();
                        int progress = this.resultTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.skProgress.setProgress(progress);
                    }
                    this.startProgressTimer();
                    if (JC_BURIED_POINT == null || JCMediaManager.instance().listener != this) break;
                    if (this.IF_CURRENT_IS_FULLSCREEN) {
                        JC_BURIED_POINT.onClickSeekbarFullscreen(this.url, this.objects);
                        break;
                    }
                    JC_BURIED_POINT.onClickSeekbar(this.url, this.objects);
                }
            }
        } else if (id2 == R.id.progress) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelProgressTimer();
                    for (ViewParent vpdown = this.getParent(); vpdown != null; vpdown = vpdown.getParent()) {
                        vpdown.requestDisallowInterceptTouchEvent(true);
                    }
                    break;
                }
                case 1: {
                    this.startProgressTimer();
                    for (ViewParent vpup = this.getParent(); vpup != null; vpup = vpup.getParent()) {
                        vpup.requestDisallowInterceptTouchEvent(false);
                    }
                    break;
                }
            }
        }
        return false;
    }

    private void showProgressDialog(float deltaX) {
        if (this.dlgProgress == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jc_progress_dialog, null);
            this.dlgProgressProgressBar = (ProgressBar)localView.findViewById(R.id.duration_progressbar);
            this.dlgProgressCurrent = (TextView)localView.findViewById(R.id.tv_current);
            this.dlgProgressTotal = (TextView)localView.findViewById(R.id.tv_duration);
            this.dlgProgressIcon = (ImageView)localView.findViewById(R.id.duration_image_tip);
            this.dlgProgress = new Dialog(this.getContext(), R.style.jc_style_dialog_progress);
            this.dlgProgress.setContentView(localView);
            this.dlgProgress.getWindow().addFlags(8);
            this.dlgProgress.getWindow().addFlags(32);
            this.dlgProgress.getWindow().addFlags(16);
            this.dlgProgress.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.dlgProgress.getWindow().getAttributes();
            localLayoutParams.gravity = 49;
            localLayoutParams.y = this.getResources().getDimensionPixelOffset(R.dimen.jc_progress_dialog_margin_top);
            this.dlgProgress.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.dlgProgress.isShowing()) {
            this.dlgProgress.show();
        }
        int totalTime = JCMediaManager.instance().mediaPlayer.getDuration();
        this.resultTimePosition = (int)((float)this.downPosition + deltaX * (float)totalTime / (float)this.screenWidth);
        this.dlgProgressCurrent.setText((CharSequence)JCUtils.stringForTime(this.resultTimePosition));
        this.dlgProgressTotal.setText((CharSequence)(" / " + JCUtils.stringForTime(totalTime) + ""));
        this.dlgProgressProgressBar.setProgress(this.resultTimePosition * 100 / totalTime);
        if (deltaX > 0.0f) {
            this.dlgProgressIcon.setBackgroundResource(R.drawable.jc_forward_icon);
        } else {
            this.dlgProgressIcon.setBackgroundResource(R.drawable.jc_backward_icon);
        }
    }

    private void showVolumDialog(float deltaY) {
        if (this.dlgVolume == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jc_volume_dialog, null);
            this.dlgVolumeProgressBar = (ProgressBar)localView.findViewById(R.id.volume_progressbar);
            this.dlgVolume = new Dialog(this.getContext(), R.style.jc_style_dialog_progress);
            this.dlgVolume.setContentView(localView);
            this.dlgVolume.getWindow().addFlags(8);
            this.dlgVolume.getWindow().addFlags(32);
            this.dlgVolume.getWindow().addFlags(16);
            this.dlgVolume.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.dlgVolume.getWindow().getAttributes();
            localLayoutParams.gravity = 19;
            localLayoutParams.x = this.getContext().getResources().getDimensionPixelOffset(R.dimen.jc_volume_dialog_margin_left);
            this.dlgVolume.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.dlgVolume.isShowing()) {
            this.dlgVolume.show();
        }
        int max = this.mAudioManager.getStreamMaxVolume(3);
        int deltaV = (int)((float)max * deltaY * 3.0f / (float)this.screenHeight);
        this.mAudioManager.setStreamVolume(3, this.downVolume + deltaV, 0);
        int transformatVolume = (int)((float)(this.downVolume * 100 / max) + deltaY * 3.0f * 100.0f / (float)this.screenHeight);
        this.dlgVolumeProgressBar.setProgress(transformatVolume);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (fromUser) {
            int time = progress * JCMediaManager.instance().mediaPlayer.getDuration() / 100;
            JCMediaManager.instance().mediaPlayer.seekTo(time);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.setDisplayCaseFailed();
    }

    private void setDisplayCaseFailed() {
        try {
            JCMediaManager.instance().mediaPlayer.setDisplay(this.surfaceHolder);
        }
        catch (IllegalArgumentException e) {
            Log.i((String)TAG, (String)"recreate surfaceview from IllegalArgumentException");
            this.addSurfaceView();
            e.printStackTrace();
        }
        catch (IllegalStateException e1) {
            Log.i((String)TAG, (String)"recreate surfaceview from IllegalStateException");
            this.addSurfaceView();
            e1.printStackTrace();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    @Override
    public void onPrepared() {
        if (this.CURRENT_STATE != 0) {
            return;
        }
        JCMediaManager.instance().mediaPlayer.start();
        this.startProgressTimer();
        this.setStateAndUi(2);
    }

    @Override
    public void onAutoCompletion() {
        if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
            if (this.IF_CURRENT_IS_FULLSCREEN) {
                JC_BURIED_POINT.onAutoCompleteFullscreen(this.url, this.objects);
            } else {
                JC_BURIED_POINT.onAutoComplete(this.url, this.objects);
            }
        }
        this.onCompletion();
    }

    @Override
    public void onCompletion() {
        this.cancelProgressTimer();
        this.resetProgressAndTime();
        this.setStateAndUi(4);
        if (this.rlSurfaceContainer.getChildCount() > 0) {
            this.rlSurfaceContainer.removeAllViews();
        }
        this.finishMyFullscreen();
        if (IF_FULLSCREEN_FROM_NORMAL) {
            IF_FULLSCREEN_FROM_NORMAL = false;
            JCMediaManager.instance().lastListener.onCompletion();
        }
    }

    @Override
    public void onBufferingUpdate(int percent) {
        if (this.CURRENT_STATE != 4 && this.CURRENT_STATE != 0) {
            this.setTextAndProgress(percent);
        }
    }

    @Override
    public void onSeekComplete() {
    }

    @Override
    public void onError(int what, int extra) {
        if (what != 38 && what != -38) {
            this.setStateAndUi(5);
        }
    }

    @Override
    public void onVideoSizeChanged() {
        int mVideoWidth = JCMediaManager.instance().currentVideoWidth;
        int mVideoHeight = JCMediaManager.instance().currentVideoHeight;
        if (mVideoWidth != 0 && mVideoHeight != 0) {
            this.surfaceHolder.setFixedSize(mVideoWidth, mVideoHeight);
            this.surfaceView.requestLayout();
        }
    }

    @Override
    public void onBackFullscreen() {
        this.CURRENT_STATE = JCMediaManager.instance().lastState;
        this.setStateAndUi(this.CURRENT_STATE);
    }

    protected void startProgressTimer() {
        this.cancelProgressTimer();
        mUpdateProgressTimer = new Timer();
        mUpdateProgressTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JCVideoPlayer.this.getContext() != null && JCVideoPlayer.this.getContext() instanceof Activity) {
                    ((Activity)JCVideoPlayer.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (JCVideoPlayer.this.CURRENT_STATE == 2 || JCVideoPlayer.this.CURRENT_STATE == 1) {
                                JCVideoPlayer.this.setTextAndProgress(0);
                            }
                        }
                    });
                }
            }
        }, 0L, 300L);
    }

    protected void cancelProgressTimer() {
        if (mUpdateProgressTimer != null) {
            mUpdateProgressTimer.cancel();
        }
    }

    protected int getCurrentPositionWhenPlaying() {
        int position = 0;
        if (this.CURRENT_STATE == 2 || this.CURRENT_STATE == 1) {
            position = JCMediaManager.instance().mediaPlayer.getCurrentPosition();
        }
        return position;
    }

    protected void setTextAndProgress(int secProgress) {
        int position = this.getCurrentPositionWhenPlaying();
        int duration = JCMediaManager.instance().mediaPlayer.getDuration();
        int progress = position * 100 / (duration == 0 ? 1 : duration);
        this.setProgressAndTime(progress, secProgress, position, duration);
    }

    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        if (!this.touchingProgressBar && progress != 0) {
            this.skProgress.setProgress(progress);
        }
        if (secProgress != 0) {
            this.skProgress.setSecondaryProgress(secProgress);
        }
        this.tvTimeCurrent.setText((CharSequence)JCUtils.stringForTime(currentTime));
        this.tvTimeTotal.setText((CharSequence)JCUtils.stringForTime(totalTime));
    }

    protected void resetProgressAndTime() {
        this.skProgress.setProgress(0);
        this.skProgress.setSecondaryProgress(0);
        this.tvTimeCurrent.setText((CharSequence)JCUtils.stringForTime(0));
        this.tvTimeTotal.setText((CharSequence)JCUtils.stringForTime(0));
    }

    protected void quitFullScreenGoToNormal() {
        if (JC_BURIED_POINT != null && JCMediaManager.instance().listener == this) {
            JC_BURIED_POINT.onQuitFullscreen(this.url, this.objects);
        }
        JCMediaManager.instance().mediaPlayer.setDisplay(null);
        JCMediaManager.instance().listener = JCMediaManager.instance().lastListener;
        JCMediaManager.instance().lastState = this.CURRENT_STATE;
        JCMediaManager.instance().listener.onBackFullscreen();
        this.finishMyFullscreen();
    }

    protected void finishMyFullscreen() {
        if (this.getContext() instanceof JCFullScreenActivity) {
            ((JCFullScreenActivity)this.getContext()).finish();
        }
    }

    public void backFullscreen() {
        if (this.IF_FULLSCREEN_IS_DIRECTLY) {
            JCMediaManager.instance().mediaPlayer.stop();
            this.finishMyFullscreen();
        } else {
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            IF_RELEASE_WHEN_ON_PAUSE = false;
            this.quitFullScreenGoToNormal();
        }
    }

    public static void releaseAllVideos() {
        if (IF_RELEASE_WHEN_ON_PAUSE) {
            JCMediaManager.instance().mediaPlayer.release();
            if (JCMediaManager.instance().listener != null) {
                JCMediaManager.instance().listener.onCompletion();
            }
        } else {
            IF_RELEASE_WHEN_ON_PAUSE = true;
        }
    }

    public void release() {
        if (this.CURRENT_STATE != 4) {
            JCVideoPlayer.releaseAllVideos();
        }
    }
}

