/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import java.io.IOException;
import java.util.Map;

public class JCMediaManager
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnVideoSizeChangedListener {
    public MediaPlayer mediaPlayer = new MediaPlayer();
    private static JCMediaManager jcMediaManager;
    public int currentVideoWidth = 0;
    public int currentVideoHeight = 0;
    public JCMediaPlayerListener listener;
    public JCMediaPlayerListener lastListener;
    public int lastState;

    public static JCMediaManager intance() {
        if (jcMediaManager == null) {
            jcMediaManager = new JCMediaManager();
        }
        return jcMediaManager;
    }

    public void prepareToPlay(Context context, String url, Map<String, String> mapHeadData) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        try {
            this.currentVideoWidth = 0;
            this.currentVideoHeight = 0;
            this.mediaPlayer.release();
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setDataSource(context, Uri.parse((String)url), mapHeadData);
            this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.mediaPlayer.setScreenOnWhilePlaying(true);
            this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
            this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onPrepared(MediaPlayer mp) {
        if (this.listener != null) {
            this.listener.onPrepared();
        }
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.listener != null) {
            this.listener.onAutoCompletion();
        }
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        if (this.listener != null) {
            this.listener.onBufferingUpdate(percent);
        }
    }

    public void onSeekComplete(MediaPlayer mp) {
        if (this.listener != null) {
            this.listener.onSeekComplete();
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        if (this.listener != null) {
            this.listener.onError(what, extra);
        }
        return true;
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        this.currentVideoWidth = mp.getVideoWidth();
        this.currentVideoHeight = mp.getVideoHeight();
        if (this.listener != null) {
            this.listener.onVideoSizeChanged();
        }
    }

    static interface JCMediaPlayerListener {
        public void onPrepared();

        public void onAutoCompletion();

        public void onCompletion();

        public void onBufferingUpdate(int var1);

        public void onSeekComplete();

        public void onError(int var1, int var2);

        public void onVideoSizeChanged();

        public void onBackFullscreen();
    }
}

