/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import de.greenrobot.event.EventBus;
import fm.jiecao.jcvideoplayer_lib.VideoEvents;
import java.io.IOException;

class JCMediaManager
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnVideoSizeChangedListener {
    public MediaPlayer mediaPlayer = new MediaPlayer();
    private static JCMediaManager jcMediaManager;
    public String uuid = "";
    private String prev_uuid = "";
    public int currentVideoWidth = 0;
    public int currentVideoHeight = 0;

    public static JCMediaManager intance() {
        if (jcMediaManager == null) {
            jcMediaManager = new JCMediaManager();
        }
        return jcMediaManager;
    }

    public void prepareToPlay(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        try {
            this.mediaPlayer.release();
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setDataSource(context, Uri.parse((String)url));
            this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
            this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onPrepared(MediaPlayer mp) {
        EventBus.getDefault().post((Object)new VideoEvents().setType(366004));
    }

    public void onCompletion(MediaPlayer mp) {
        EventBus.getDefault().post((Object)new VideoEvents().setType(366007));
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        VideoEvents videoEvents = new VideoEvents().setType(366008);
        videoEvents.obj = percent;
        EventBus.getDefault().post((Object)videoEvents);
    }

    public void onSeekComplete(MediaPlayer mp) {
        EventBus.getDefault().post((Object)new VideoEvents().setType(366009));
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        return true;
    }

    public void setUuid(String uuid) {
        Log.i((String)"uuid::", (String)("0 " + uuid + " prevuuid " + this.prev_uuid));
        this.uuid = uuid;
        Log.i((String)"uuid::", (String)("1 " + uuid + " prevuuid " + this.prev_uuid));
    }

    public void backUpUuid() {
        this.prev_uuid = this.uuid;
    }

    public void revertUuid() {
        this.uuid = this.prev_uuid;
        this.prev_uuid = "";
        Log.i((String)"uuid::", (String)("2 " + this.uuid + " prevuuid " + this.prev_uuid));
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        this.currentVideoWidth = mp.getVideoWidth();
        this.currentVideoHeight = mp.getVideoHeight();
        EventBus.getDefault().post((Object)new VideoEvents().setType(366010));
    }

    public void clearWidthAndHeight() {
        this.currentVideoWidth = 0;
        this.currentVideoHeight = 0;
    }
}

