/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.nostra13.universalimageloader.core.ImageLoader;
import de.greenrobot.event.EventBus;
import fm.jiecao.jcvideoplayer_lib.FullScreenActivity;
import fm.jiecao.jcvideoplayer_lib.JCMediaPlayer;
import fm.jiecao.jcvideoplayer_lib.R;
import fm.jiecao.jcvideoplayer_lib.ResizeSurfaceView;
import fm.jiecao.jcvideoplayer_lib.Utils;
import fm.jiecao.jcvideoplayer_lib.VideoEvents;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class JCVideoPlayer
extends FrameLayout
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
SurfaceHolder.Callback,
View.OnTouchListener {
    ImageView ivStart;
    ProgressBar pbLoading;
    ProgressBar pbBottom;
    ImageView ivFullScreen;
    SeekBar sbProgress;
    TextView tvTimeCurrent;
    TextView tvTimeTotal;
    ResizeSurfaceView surfaceView;
    SurfaceHolder surfaceHolder;
    LinearLayout llBottomControl;
    TextView tvTitle;
    ImageView ivBack;
    ImageView ivThumb;
    RelativeLayout rlParent;
    LinearLayout llTitleContainer;
    ImageView ivCover;
    private String url;
    private String thumb;
    private String title;
    private boolean ifFullScreen = false;
    public String uuid = UUID.randomUUID().toString();
    public boolean ifShowTitle = false;
    public int CURRENT_STATE = -1;
    public static final int CURRENT_STATE_PREPAREING = 0;
    public static final int CURRENT_STATE_PAUSE = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_OVER = 3;
    public static final int CURRENT_STATE_NORMAL = 4;
    private View.OnTouchListener mSeekbarOnTouchListener;
    private static Timer mDismissControlViewTimer;
    private static Timer mUpdateProgressTimer;
    private static long clickfullscreentime;
    private static final int FULL_SCREEN_NORMAL_DELAY = 5000;
    private boolean touchingProgressBar = false;
    boolean isFromFullScreenBackHere = false;
    boolean isClickFullscreen = false;

    public JCVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        View.inflate((Context)context, (int)R.layout.video_control_view, (ViewGroup)this);
        this.ivStart = (ImageView)this.findViewById(R.id.start);
        this.pbLoading = (ProgressBar)this.findViewById(R.id.loading);
        this.pbBottom = (ProgressBar)this.findViewById(R.id.bottom_progressbar);
        this.ivFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.sbProgress = (SeekBar)this.findViewById(R.id.progress);
        this.tvTimeCurrent = (TextView)this.findViewById(R.id.current);
        this.tvTimeTotal = (TextView)this.findViewById(R.id.total);
        this.surfaceView = (ResizeSurfaceView)this.findViewById(R.id.surfaceView);
        this.llBottomControl = (LinearLayout)this.findViewById(R.id.bottom_control);
        this.tvTitle = (TextView)this.findViewById(R.id.title);
        this.ivBack = (ImageView)this.findViewById(R.id.back);
        this.ivThumb = (ImageView)this.findViewById(R.id.thumb);
        this.rlParent = (RelativeLayout)this.findViewById(R.id.parentview);
        this.llTitleContainer = (LinearLayout)this.findViewById(R.id.title_container);
        this.ivCover = (ImageView)this.findViewById(R.id.cover);
        this.surfaceHolder = this.surfaceView.getHolder();
        this.ivStart.setOnClickListener((View.OnClickListener)this);
        this.ivThumb.setOnClickListener((View.OnClickListener)this);
        this.ivFullScreen.setOnClickListener((View.OnClickListener)this);
        this.sbProgress.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.surfaceView.setOnClickListener(this);
        this.llBottomControl.setOnClickListener((View.OnClickListener)this);
        this.rlParent.setOnClickListener((View.OnClickListener)this);
        this.ivBack.setOnClickListener((View.OnClickListener)this);
        this.sbProgress.setOnTouchListener((View.OnTouchListener)this);
    }

    public void setUp(String url, String thumb, String title) {
        this.setUp(url, thumb, title, true);
    }

    public void setUp(String url, String thumb, String title, boolean ifShowTitle) {
        this.setIfShowTitle(ifShowTitle);
        if (System.currentTimeMillis() - clickfullscreentime < 5000L) {
            return;
        }
        this.url = url;
        this.thumb = thumb;
        this.title = title;
        this.ifFullScreen = false;
        if (this.ifFullScreen) {
            this.ivFullScreen.setImageResource(R.drawable.shrink_video);
        } else {
            this.ivFullScreen.setImageResource(R.drawable.enlarge_video);
            this.ivBack.setVisibility(8);
        }
        this.tvTitle.setText((CharSequence)title);
        this.ivThumb.setVisibility(0);
        this.ivStart.setVisibility(0);
        this.llBottomControl.setVisibility(4);
        this.pbBottom.setVisibility(0);
        ImageLoader.getInstance().displayImage(thumb, this.ivThumb, Utils.getDefaultDisplayImageOption());
        this.CURRENT_STATE = 4;
        this.setTitleVisibility(0);
        if (this.uuid.equals(JCMediaPlayer.intance().uuid)) {
            JCMediaPlayer.intance().mediaPlayer.stop();
        }
    }

    public void setUpForFullscreen(String url, String thumb, String title) {
        this.url = url;
        this.thumb = thumb;
        this.title = title;
        this.ifFullScreen = true;
        if (this.ifFullScreen) {
            this.ivFullScreen.setImageResource(R.drawable.shrink_video);
        } else {
            this.ivFullScreen.setImageResource(R.drawable.enlarge_video);
        }
        this.tvTitle.setText((CharSequence)title);
        this.ivThumb.setVisibility(0);
        this.ivStart.setVisibility(0);
        this.llBottomControl.setVisibility(4);
        this.pbBottom.setVisibility(0);
        this.CURRENT_STATE = 4;
        this.setTitleVisibility(0);
    }

    public void setState(int state) {
        this.CURRENT_STATE = state;
        if (this.CURRENT_STATE == 0) {
            this.ivStart.setVisibility(4);
            this.ivThumb.setVisibility(4);
            this.pbLoading.setVisibility(0);
            this.ivCover.setVisibility(0);
            this.setProgressAndTime(0, 0, 0);
            this.setProgressBuffered(0);
        } else if (this.CURRENT_STATE == 2) {
            this.updateStartImage();
            this.ivStart.setVisibility(0);
            this.llBottomControl.setVisibility(0);
            this.pbBottom.setVisibility(4);
            this.setTitleVisibility(0);
            this.ivThumb.setVisibility(4);
            this.ivCover.setVisibility(4);
            this.pbLoading.setVisibility(4);
        } else if (this.CURRENT_STATE == 1) {
            this.updateStartImage();
            this.ivStart.setVisibility(0);
            this.llBottomControl.setVisibility(0);
            this.pbBottom.setVisibility(4);
            this.setTitleVisibility(0);
            this.ivThumb.setVisibility(4);
            this.ivCover.setVisibility(4);
        } else if (this.CURRENT_STATE == 4) {
            if (this.uuid.equals(JCMediaPlayer.intance().uuid)) {
                JCMediaPlayer.intance().mediaPlayer.stop();
            }
            this.ivStart.setVisibility(0);
            this.ivThumb.setVisibility(0);
            this.llBottomControl.setVisibility(4);
            this.pbBottom.setVisibility(0);
            this.ivCover.setVisibility(0);
            this.setTitleVisibility(0);
            this.updateStartImage();
            this.cancelDismissControlViewTimer();
            this.cancelProgressTimer();
        }
    }

    public void onEventMainThread(VideoEvents videoEvents) {
        if (videoEvents.type == 366007) {
            this.cancelProgressTimer();
            this.ivStart.setImageResource(R.drawable.click_video_play_selector);
            this.ivThumb.setVisibility(0);
            this.ivStart.setVisibility(0);
            this.CURRENT_STATE = 4;
            this.setKeepScreenOn(false);
            this.sendPointEvent(this.ifFullScreen ? 367011 : 367010);
        }
        if (!JCMediaPlayer.intance().uuid.equals(this.uuid)) {
            if (videoEvents.type == 366001 && this.CURRENT_STATE != 4) {
                this.setState(4);
            }
            return;
        }
        if (videoEvents.type == 366004) {
            if (this.CURRENT_STATE != 0) {
                return;
            }
            JCMediaPlayer.intance().mediaPlayer.setDisplay(this.surfaceHolder);
            JCMediaPlayer.intance().mediaPlayer.start();
            this.pbLoading.setVisibility(4);
            this.ivCover.setVisibility(4);
            this.llBottomControl.setVisibility(0);
            this.pbBottom.setVisibility(4);
            this.CURRENT_STATE = 2;
            this.startDismissControlViewTimer();
            this.startProgressTimer();
        } else if (videoEvents.type == 366008) {
            if (this.CURRENT_STATE != 4 || this.CURRENT_STATE != 0) {
                int percent = Integer.valueOf(videoEvents.obj.toString());
                this.setProgressBuffered(percent);
            }
        } else if (videoEvents.type == 366011) {
            if (this.CURRENT_STATE != 4 || this.CURRENT_STATE != 0) {
                this.setProgressAndTimeFromTimer();
            }
        } else if (videoEvents.type == 366006) {
            if (this.isClickFullscreen) {
                this.isFromFullScreenBackHere = true;
                this.isClickFullscreen = false;
                int prev_state = Integer.valueOf(videoEvents.obj.toString());
                this.setState(prev_state);
            }
        } else if (videoEvents.type == 366005) {
            if (this.isFromFullScreenBackHere) {
                JCMediaPlayer.intance().mediaPlayer.setDisplay(this.surfaceHolder);
                this.stopToFullscreenOrQuitFullscreenShowDisplay();
                this.isFromFullScreenBackHere = false;
                this.startDismissControlViewTimer();
            }
        } else if (videoEvents.type == 366010) {
            int mVideoWidth = JCMediaPlayer.intance().currentVideoWidth;
            int mVideoHeight = JCMediaPlayer.intance().currentVideoHeight;
            if (mVideoWidth != 0 && mVideoHeight != 0) {
                this.surfaceHolder.setFixedSize(mVideoWidth, mVideoHeight);
                this.surfaceView.requestLayout();
            }
        } else if (videoEvents.type == 366009) {
            this.pbLoading.setVisibility(4);
            Log.i((String)"JCVideoPlayer", (String)"seek compile");
        }
    }

    private void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        mDismissControlViewTimer = new Timer();
        mDismissControlViewTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JCVideoPlayer.this.uuid.equals(JCMediaPlayer.intance().uuid) && JCVideoPlayer.this.getContext() != null && JCVideoPlayer.this.getContext() instanceof Activity) {
                    ((Activity)JCVideoPlayer.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            JCVideoPlayer.this.dismissControlView();
                        }
                    });
                }
            }
        }, 2500L);
    }

    private void dismissControlView() {
        this.llBottomControl.setVisibility(4);
        this.pbBottom.setVisibility(0);
        this.setTitleVisibility(4);
        this.ivStart.setVisibility(4);
    }

    private void cancelDismissControlViewTimer() {
        if (mDismissControlViewTimer != null) {
            mDismissControlViewTimer.cancel();
        }
    }

    private void onClickToggleClear() {
        if (this.CURRENT_STATE == 0) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.llBottomControl.setVisibility(4);
                this.pbBottom.setVisibility(0);
                this.setTitleVisibility(4);
            } else {
                this.llBottomControl.setVisibility(0);
                this.pbBottom.setVisibility(4);
                this.setTitleVisibility(0);
            }
            this.ivStart.setVisibility(4);
            this.pbLoading.setVisibility(0);
        } else if (this.CURRENT_STATE == 2) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.llBottomControl.setVisibility(4);
                this.pbBottom.setVisibility(0);
                this.setTitleVisibility(4);
                this.ivStart.setVisibility(4);
            } else {
                this.updateStartImage();
                this.ivStart.setVisibility(0);
                this.llBottomControl.setVisibility(0);
                this.pbBottom.setVisibility(4);
                this.setTitleVisibility(0);
            }
            this.pbLoading.setVisibility(4);
        } else if (this.CURRENT_STATE == 1) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.llBottomControl.setVisibility(4);
                this.pbBottom.setVisibility(0);
                this.setTitleVisibility(4);
                this.ivStart.setVisibility(4);
            } else {
                this.updateStartImage();
                this.ivStart.setVisibility(0);
                this.llBottomControl.setVisibility(0);
                this.pbBottom.setVisibility(4);
                this.setTitleVisibility(0);
            }
            this.pbLoading.setVisibility(4);
        }
    }

    private void startProgressTimer() {
        this.cancelProgressTimer();
        mUpdateProgressTimer = new Timer();
        mUpdateProgressTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JCVideoPlayer.this.getContext() != null && JCVideoPlayer.this.getContext() instanceof Activity) {
                    ((Activity)JCVideoPlayer.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            VideoEvents videoEvents = new VideoEvents().setType(366011);
                            EventBus.getDefault().post((Object)videoEvents);
                        }
                    });
                }
            }
        }, 0L, 300L);
        Log.i((String)"update buffer", (String)"updatebuffer:: start");
    }

    private void cancelProgressTimer() {
        if (this.uuid.equals(JCMediaPlayer.intance().uuid) && mUpdateProgressTimer != null) {
            mUpdateProgressTimer.cancel();
            Log.i((String)"update buffer", (String)"updatebuffer:: cancel");
        }
    }

    public void setIfShowTitle(boolean ifShowTitle) {
        this.ifShowTitle = ifShowTitle;
    }

    private void setTitleVisibility(int visable) {
        if (this.ifShowTitle) {
            this.llTitleContainer.setVisibility(visable);
        } else if (this.ifFullScreen) {
            this.llTitleContainer.setVisibility(visable);
        } else {
            this.llTitleContainer.setVisibility(4);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start || i == R.id.thumb) {
            if (TextUtils.isEmpty((CharSequence)this.url)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u89c6\u9891\u5730\u5740\u4e3a\u7a7a", (int)0).show();
                return;
            }
            if (this.CURRENT_STATE == 4) {
                JCMediaPlayer.intance().clearWidthAndHeight();
                this.CURRENT_STATE = 0;
                this.ivStart.setVisibility(4);
                this.ivThumb.setVisibility(4);
                this.pbLoading.setVisibility(0);
                this.ivCover.setVisibility(0);
                this.setProgressAndTime(0, 0, 0);
                this.setProgressBuffered(0);
                JCMediaPlayer.intance().prepareToPlay(this.getContext(), this.url);
                JCMediaPlayer.intance().setUuid(this.uuid);
                VideoEvents videoEvents = new VideoEvents().setType(366001);
                videoEvents.obj = this.uuid;
                EventBus.getDefault().post((Object)videoEvents);
                this.surfaceView.requestLayout();
                this.setKeepScreenOn(true);
                this.sendPointEvent(i == R.id.start ? 367001 : 367002);
            } else if (this.CURRENT_STATE == 2) {
                this.CURRENT_STATE = 1;
                this.ivThumb.setVisibility(4);
                this.ivCover.setVisibility(4);
                JCMediaPlayer.intance().mediaPlayer.pause();
                this.updateStartImage();
                this.setKeepScreenOn(false);
                this.cancelDismissControlViewTimer();
                this.sendPointEvent(this.ifFullScreen ? 367004 : 367003);
            } else if (this.CURRENT_STATE == 1) {
                this.CURRENT_STATE = 2;
                this.ivThumb.setVisibility(4);
                this.ivCover.setVisibility(4);
                JCMediaPlayer.intance().mediaPlayer.start();
                this.updateStartImage();
                this.setKeepScreenOn(true);
                this.startDismissControlViewTimer();
                this.sendPointEvent(this.ifFullScreen ? 367005 : 367014);
            }
        } else if (i == R.id.fullscreen) {
            if (this.ifFullScreen) {
                this.quitFullScreen();
            } else {
                JCMediaPlayer.intance().mediaPlayer.pause();
                JCMediaPlayer.intance().mediaPlayer.setDisplay(null);
                JCMediaPlayer.intance().backUpUuid();
                this.isClickFullscreen = true;
                FullScreenActivity.toActivity(this.getContext(), this.CURRENT_STATE, this.url, this.thumb, this.title);
                this.sendPointEvent(367012);
            }
            clickfullscreentime = System.currentTimeMillis();
        } else if (i == R.id.surfaceView || i == R.id.parentview) {
            this.onClickToggleClear();
            this.startDismissControlViewTimer();
            this.sendPointEvent(this.ifFullScreen ? 367007 : 367006);
        } else if (i != R.id.bottom_control && i == R.id.back) {
            this.quitFullScreen();
        }
    }

    private void updateStartImage() {
        if (this.CURRENT_STATE == 2) {
            this.ivStart.setImageResource(R.drawable.click_video_pause_selector);
        } else {
            this.ivStart.setImageResource(R.drawable.click_video_play_selector);
        }
    }

    private void setProgressBuffered(int secProgress) {
        if (secProgress >= 0) {
            this.sbProgress.setSecondaryProgress(secProgress);
            this.pbBottom.setSecondaryProgress(secProgress);
        }
    }

    private void setProgressAndTimeFromTimer() {
        int position = JCMediaPlayer.intance().mediaPlayer.getCurrentPosition();
        int duration = JCMediaPlayer.intance().mediaPlayer.getDuration();
        int progress = position * 100 / duration;
        this.setProgressAndTime(progress, position, duration);
    }

    private void setProgressAndTime(int progress, int currentTime, int totalTime) {
        if (!this.touchingProgressBar) {
            this.sbProgress.setProgress(progress);
            this.pbBottom.setProgress(progress);
        }
        this.tvTimeCurrent.setText((CharSequence)Utils.stringForTime(currentTime));
        this.tvTimeTotal.setText((CharSequence)Utils.stringForTime(totalTime));
    }

    public void release() {
        if (System.currentTimeMillis() - clickfullscreentime < 5000L) {
            return;
        }
        this.setState(4);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (fromUser) {
            int time = progress * JCMediaPlayer.intance().mediaPlayer.getDuration() / 100;
            JCMediaPlayer.intance().mediaPlayer.seekTo(time);
            this.pbLoading.setVisibility(0);
            this.ivStart.setVisibility(4);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister((Object)this);
        if (this.uuid.equals(JCMediaPlayer.intance().uuid)) {
            JCMediaPlayer.intance().mediaPlayer.stop();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void quitFullScreen() {
        FullScreenActivity.manualQuit = true;
        clickfullscreentime = System.currentTimeMillis();
        JCMediaPlayer.intance().mediaPlayer.pause();
        JCMediaPlayer.intance().mediaPlayer.setDisplay(null);
        JCMediaPlayer.intance().revertUuid();
        VideoEvents videoEvents = new VideoEvents().setType(366006);
        videoEvents.obj = this.CURRENT_STATE;
        EventBus.getDefault().post((Object)videoEvents);
        this.sendPointEvent(367013);
    }

    private void stopToFullscreenOrQuitFullscreenShowDisplay() {
        if (this.CURRENT_STATE == 1) {
            JCMediaPlayer.intance().mediaPlayer.start();
            this.CURRENT_STATE = 2;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ((Activity)JCVideoPlayer.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            JCMediaPlayer.intance().mediaPlayer.pause();
                            JCVideoPlayer.this.CURRENT_STATE = 1;
                        }
                    });
                }
            }).start();
            this.surfaceView.requestLayout();
        } else if (this.CURRENT_STATE == 2) {
            JCMediaPlayer.intance().mediaPlayer.start();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        EventBus.getDefault().post((Object)new VideoEvents().setType(366005));
        if (this.ifFullScreen) {
            JCMediaPlayer.intance().mediaPlayer.setDisplay(this.surfaceHolder);
            this.stopToFullscreenOrQuitFullscreenShowDisplay();
        }
        if (this.CURRENT_STATE != 4) {
            this.startDismissControlViewTimer();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public static void releaseAllVideo() {
        JCMediaPlayer.intance().mediaPlayer.stop();
        JCMediaPlayer.intance().setUuid("");
        JCMediaPlayer.intance().setUuid("");
        EventBus.getDefault().post((Object)new VideoEvents().setType(366007));
    }

    @Deprecated
    public void setStartListener(View.OnClickListener onClickListener) {
        if (onClickListener != null) {
            this.ivStart.setOnClickListener(onClickListener);
            this.ivThumb.setOnClickListener(onClickListener);
        } else {
            this.ivStart.setOnClickListener((View.OnClickListener)this);
            this.ivThumb.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void sendPointEvent(int type) {
        VideoEvents videoEvents = new VideoEvents();
        videoEvents.setType(type);
        videoEvents.obj = this.title;
        EventBus.getDefault().post((Object)videoEvents);
    }

    public void setSeekbarOnTouchListener(View.OnTouchListener listener) {
        this.mSeekbarOnTouchListener = listener;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touchingProgressBar = true;
                this.cancelDismissControlViewTimer();
                this.cancelProgressTimer();
                break;
            }
            case 1: {
                this.touchingProgressBar = false;
                this.startDismissControlViewTimer();
                this.startProgressTimer();
                this.sendPointEvent(this.ifFullScreen ? 367009 : 367008);
            }
        }
        if (this.mSeekbarOnTouchListener != null) {
            this.mSeekbarOnTouchListener.onTouch(v, event);
        }
        return false;
    }
}

