/*
 * Decompiled with CFR 0.152.
 */
package fm.jiecao.jcvideoplayer_lib;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import de.greenrobot.event.EventBus;
import fm.jiecao.jcvideoplayer_lib.JCFullScreenActivity;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.R;
import fm.jiecao.jcvideoplayer_lib.ResizeSurfaceView;
import fm.jiecao.jcvideoplayer_lib.Skin;
import fm.jiecao.jcvideoplayer_lib.Utils;
import fm.jiecao.jcvideoplayer_lib.VideoEvents;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class JCVideoPlayer
extends FrameLayout
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
SurfaceHolder.Callback,
View.OnTouchListener {
    public ImageView ivStart;
    ProgressBar pbLoading;
    ProgressBar pbBottom;
    ImageView ivFullScreen;
    SeekBar skProgress;
    TextView tvTimeCurrent;
    TextView tvTimeTotal;
    ResizeSurfaceView surfaceView;
    SurfaceHolder surfaceHolder;
    TextView tvTitle;
    ImageView ivBack;
    public ImageView ivThumb;
    RelativeLayout rlParent;
    LinearLayout llTitleContainer;
    LinearLayout llBottomControl;
    ImageView ivCover;
    private String url;
    private String title;
    private boolean ifFullScreen = false;
    public String uuid = UUID.randomUUID().toString();
    private boolean ifShowTitle = false;
    private boolean ifMp3 = false;
    private int enlargRecId = 0;
    private int shrinkRecId = 0;
    private int surfaceId;
    public static Skin globleSkin;
    private Skin skin;
    public int CURRENT_STATE = -1;
    public static final int CURRENT_STATE_PREPAREING = 0;
    public static final int CURRENT_STATE_PAUSE = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_OVER = 3;
    public static final int CURRENT_STATE_NORMAL = 4;
    private View.OnTouchListener mSeekbarOnTouchListener;
    private static Timer mDismissControlViewTimer;
    private static Timer mUpdateProgressTimer;
    private static long clickfullscreentime;
    private static final int FULL_SCREEN_NORMAL_DELAY = 5000;
    private boolean touchingProgressBar = false;
    private static boolean isFromFullScreenBackHere;
    static boolean isClickFullscreen;
    private static ImageView.ScaleType speScalType;

    public JCVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        View.inflate((Context)context, (int)R.layout.video_control_view, (ViewGroup)this);
        this.ivStart = (ImageView)this.findViewById(R.id.start);
        this.pbLoading = (ProgressBar)this.findViewById(R.id.loading);
        this.pbBottom = (ProgressBar)this.findViewById(R.id.bottom_progressbar);
        this.ivFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.skProgress = (SeekBar)this.findViewById(R.id.progress);
        this.tvTimeCurrent = (TextView)this.findViewById(R.id.current);
        this.tvTimeTotal = (TextView)this.findViewById(R.id.total);
        this.llBottomControl = (LinearLayout)this.findViewById(R.id.bottom_control);
        this.tvTitle = (TextView)this.findViewById(R.id.title);
        this.ivBack = (ImageView)this.findViewById(R.id.back);
        this.ivThumb = (ImageView)this.findViewById(R.id.thumb);
        this.rlParent = (RelativeLayout)this.findViewById(R.id.parentview);
        this.llTitleContainer = (LinearLayout)this.findViewById(R.id.title_container);
        this.ivCover = (ImageView)this.findViewById(R.id.cover);
        this.ivStart.setOnClickListener((View.OnClickListener)this);
        this.ivThumb.setOnClickListener((View.OnClickListener)this);
        this.ivFullScreen.setOnClickListener((View.OnClickListener)this);
        this.skProgress.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.llBottomControl.setOnClickListener((View.OnClickListener)this);
        this.rlParent.setOnClickListener((View.OnClickListener)this);
        this.ivBack.setOnClickListener((View.OnClickListener)this);
        this.skProgress.setOnTouchListener((View.OnTouchListener)this);
        if (speScalType != null) {
            this.ivThumb.setScaleType(speScalType);
        }
    }

    public void setUp(String url, String title) {
        this.setUp(url, title, true);
    }

    public void setUp(String url, String title, boolean ifShowTitle) {
        this.setSkin();
        this.ifShowTitle = ifShowTitle;
        if (System.currentTimeMillis() - clickfullscreentime < 5000L) {
            return;
        }
        this.url = url;
        this.title = title;
        this.ifFullScreen = false;
        this.CURRENT_STATE = 4;
        if (this.ifFullScreen) {
            this.ivFullScreen.setImageResource(this.enlargRecId == 0 ? R.drawable.shrink_video : this.enlargRecId);
        } else {
            this.ivFullScreen.setImageResource(this.shrinkRecId == 0 ? R.drawable.enlarge_video : this.shrinkRecId);
            this.ivBack.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)url) && url.contains(".mp3")) {
            this.ifMp3 = true;
            this.ivFullScreen.setVisibility(8);
        }
        this.tvTitle.setText((CharSequence)title);
        this.changeUiToNormal();
        if (this.uuid.equals(JCMediaManager.intance().uuid)) {
            JCMediaManager.intance().mediaPlayer.stop();
        }
    }

    public void setUpForFullscreen(String url, String title) {
        this.setSkin();
        this.url = url;
        this.title = title;
        this.ifShowTitle = true;
        this.ifFullScreen = true;
        this.CURRENT_STATE = 4;
        if (this.ifFullScreen) {
            this.ivFullScreen.setImageResource(this.shrinkRecId == 0 ? R.drawable.shrink_video : this.shrinkRecId);
        } else {
            this.ivFullScreen.setImageResource(this.enlargRecId == 0 ? R.drawable.enlarge_video : this.enlargRecId);
        }
        this.tvTitle.setText((CharSequence)title);
        if (!TextUtils.isEmpty((CharSequence)url) && url.contains(".mp3")) {
            this.ifMp3 = true;
        }
        this.addSurfaceView();
        this.changeUiToNormal();
    }

    public void setState(int state) {
        this.CURRENT_STATE = state;
        if (this.CURRENT_STATE == 0) {
            this.changeUiToShowUiPrepareing();
            this.setProgressAndTime(0, 0, 0);
            this.setProgressBuffered(0);
        } else if (this.CURRENT_STATE == 2) {
            this.changeUiToShowUiPlaying();
        } else if (this.CURRENT_STATE == 1) {
            this.changeUiToShowUiPause();
        } else if (this.CURRENT_STATE == 4) {
            if (this.uuid.equals(JCMediaManager.intance().uuid)) {
                JCMediaManager.intance().mediaPlayer.stop();
            }
            this.changeUiToNormal();
            this.cancelDismissControlViewTimer();
            this.cancelProgressTimer();
        }
    }

    public void onEventMainThread(VideoEvents videoEvents) {
        if (videoEvents.type == 366007) {
            this.CURRENT_STATE = 4;
            this.cancelProgressTimer();
            this.setKeepScreenOn(false);
            this.changeUiToNormal();
            if (JCMediaManager.intance().uuid.equals(this.uuid)) {
                this.sendPointEvent(this.ifFullScreen ? 367011 : 367010);
            }
        }
        if (!JCMediaManager.intance().uuid.equals(this.uuid)) {
            if (videoEvents.type == 366001 && this.CURRENT_STATE != 4) {
                this.setState(4);
            }
            return;
        }
        if (videoEvents.type == 366004) {
            if (this.CURRENT_STATE != 0) {
                return;
            }
            JCMediaManager.intance().mediaPlayer.setDisplay(this.surfaceHolder);
            JCMediaManager.intance().mediaPlayer.start();
            this.CURRENT_STATE = 2;
            this.changeUiToShowUiPlaying();
            this.ivStart.setVisibility(4);
            this.startDismissControlViewTimer();
            this.startProgressTimer();
        } else if (videoEvents.type == 366008) {
            if (this.CURRENT_STATE != 4 || this.CURRENT_STATE != 0) {
                int percent = Integer.valueOf(videoEvents.obj.toString());
                this.setProgressBuffered(percent);
            }
        } else if (videoEvents.type == 366011) {
            if (this.CURRENT_STATE != 4 || this.CURRENT_STATE != 0) {
                this.setProgressAndTimeFromTimer();
            }
        } else if (videoEvents.type == 366006) {
            if (isClickFullscreen) {
                isFromFullScreenBackHere = true;
                isClickFullscreen = false;
                int prev_state = Integer.valueOf(videoEvents.obj.toString());
                this.setState(prev_state);
            }
        } else if (videoEvents.type == 366005) {
            if (isFromFullScreenBackHere) {
                JCMediaManager.intance().mediaPlayer.setDisplay(this.surfaceHolder);
                this.stopToFullscreenOrQuitFullscreenShowDisplay();
                isFromFullScreenBackHere = false;
                this.startDismissControlViewTimer();
            }
        } else if (videoEvents.type == 366010) {
            int mVideoWidth = JCMediaManager.intance().currentVideoWidth;
            int mVideoHeight = JCMediaManager.intance().currentVideoHeight;
            if (mVideoWidth != 0 && mVideoHeight != 0) {
                this.surfaceHolder.setFixedSize(mVideoWidth, mVideoHeight);
                this.surfaceView.requestLayout();
            }
        } else if (videoEvents.type == 366009) {
            this.pbLoading.setVisibility(4);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start || i == R.id.thumb) {
            if (TextUtils.isEmpty((CharSequence)this.url)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u89c6\u9891\u5730\u5740\u4e3a\u7a7a", (int)0).show();
                return;
            }
            if (i == R.id.thumb && this.CURRENT_STATE != 4) {
                this.onClickUiToggle();
                return;
            }
            if (this.CURRENT_STATE == 4) {
                this.addSurfaceView();
                JCMediaManager.intance().clearWidthAndHeight();
                this.CURRENT_STATE = 0;
                this.changeUiToShowUiPrepareing();
                this.llBottomControl.setVisibility(4);
                this.llTitleContainer.setVisibility(4);
                this.setProgressAndTime(0, 0, 0);
                this.setProgressBuffered(0);
                JCMediaManager.intance().prepareToPlay(this.getContext(), this.url);
                JCMediaManager.intance().setUuid(this.uuid);
                Log.i((String)"JCVideoPlayer", (String)"play video");
                VideoEvents videoEvents = new VideoEvents().setType(366001);
                videoEvents.obj = this.uuid;
                EventBus.getDefault().post((Object)videoEvents);
                this.surfaceView.requestLayout();
                this.setKeepScreenOn(true);
                this.sendPointEvent(i == R.id.start ? 367001 : 367002);
            } else if (this.CURRENT_STATE == 2) {
                this.CURRENT_STATE = 1;
                this.changeUiToShowUiPause();
                JCMediaManager.intance().mediaPlayer.pause();
                Log.i((String)"JCVideoPlayer", (String)"pause video");
                this.setKeepScreenOn(false);
                this.cancelDismissControlViewTimer();
                this.sendPointEvent(this.ifFullScreen ? 367004 : 367003);
            } else if (this.CURRENT_STATE == 1) {
                this.CURRENT_STATE = 2;
                this.changeUiToShowUiPlaying();
                JCMediaManager.intance().mediaPlayer.start();
                Log.i((String)"JCVideoPlayer", (String)"go on video");
                this.setKeepScreenOn(true);
                this.startDismissControlViewTimer();
                this.sendPointEvent(this.ifFullScreen ? 367005 : 367014);
            }
        } else if (i == R.id.fullscreen) {
            if (this.ifFullScreen) {
                this.quitFullScreen();
            } else {
                JCFullScreenActivity.skin = this.skin;
                JCMediaManager.intance().mediaPlayer.pause();
                JCMediaManager.intance().mediaPlayer.setDisplay(null);
                JCMediaManager.intance().backUpUuid();
                isClickFullscreen = true;
                JCFullScreenActivity.toActivityFromNormal(this.getContext(), this.CURRENT_STATE, this.url, this.title);
                this.sendPointEvent(367012);
            }
            clickfullscreentime = System.currentTimeMillis();
        } else if (i == this.surfaceId || i == R.id.parentview) {
            this.onClickUiToggle();
            this.startDismissControlViewTimer();
            this.sendPointEvent(this.ifFullScreen ? 367007 : 367006);
        } else if (i != R.id.bottom_control && i == R.id.back) {
            this.quitFullScreen();
        }
    }

    private void addSurfaceView() {
        if (this.rlParent.getChildAt(0) instanceof ResizeSurfaceView) {
            this.rlParent.removeViewAt(0);
        }
        this.surfaceView = new ResizeSurfaceView(this.getContext());
        this.surfaceId = this.surfaceView.getId();
        this.surfaceHolder = this.surfaceView.getHolder();
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.surfaceView.setOnClickListener(this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.rlParent.addView((View)this.surfaceView, 0, (ViewGroup.LayoutParams)layoutParams);
    }

    private void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        mDismissControlViewTimer = new Timer();
        mDismissControlViewTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JCVideoPlayer.this.uuid.equals(JCMediaManager.intance().uuid) && JCVideoPlayer.this.getContext() != null && JCVideoPlayer.this.getContext() instanceof Activity) {
                    ((Activity)JCVideoPlayer.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            JCVideoPlayer.this.llBottomControl.setVisibility(4);
                            JCVideoPlayer.this.pbBottom.setVisibility(0);
                            JCVideoPlayer.this.setTitleVisibility(4);
                            JCVideoPlayer.this.ivStart.setVisibility(4);
                        }
                    });
                }
            }
        }, 2500L);
    }

    private void cancelDismissControlViewTimer() {
        if (mDismissControlViewTimer != null) {
            mDismissControlViewTimer.cancel();
        }
    }

    private void onClickUiToggle() {
        if (this.CURRENT_STATE == 0) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.changeUiToClearUiPrepareing();
            } else {
                this.changeUiToShowUiPrepareing();
            }
        } else if (this.CURRENT_STATE == 2) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.changeUiToClearUiPlaying();
            } else {
                this.changeUiToShowUiPlaying();
            }
        } else if (this.CURRENT_STATE == 1) {
            if (this.llBottomControl.getVisibility() == 0) {
                this.changeUiToClearUiPause();
            } else {
                this.changeUiToShowUiPause();
            }
        }
    }

    private void changeUiToNormal() {
        this.setTitleVisibility(0);
        this.llBottomControl.setVisibility(4);
        this.ivStart.setVisibility(0);
        this.pbLoading.setVisibility(4);
        this.setThumbVisibility(0);
        this.ivCover.setVisibility(0);
        this.pbBottom.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToShowUiPrepareing() {
        this.setTitleVisibility(0);
        this.llBottomControl.setVisibility(0);
        this.ivStart.setVisibility(4);
        this.pbLoading.setVisibility(0);
        this.setThumbVisibility(4);
        this.ivCover.setVisibility(0);
        this.pbBottom.setVisibility(4);
    }

    private void changeUiToClearUiPrepareing() {
        this.changeUiToClearUi();
        this.pbLoading.setVisibility(0);
    }

    private void changeUiToShowUiPlaying() {
        this.setTitleVisibility(0);
        this.llBottomControl.setVisibility(0);
        this.ivStart.setVisibility(0);
        this.pbLoading.setVisibility(4);
        this.setThumbVisibility(4);
        this.ivCover.setVisibility(4);
        this.pbBottom.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToClearUiPlaying() {
        this.changeUiToClearUi();
        this.pbBottom.setVisibility(0);
    }

    private void changeUiToShowUiPause() {
        this.setTitleVisibility(0);
        this.llBottomControl.setVisibility(0);
        this.ivStart.setVisibility(0);
        this.pbLoading.setVisibility(4);
        this.setThumbVisibility(4);
        this.ivCover.setVisibility(4);
        this.pbBottom.setVisibility(4);
        this.updateStartImage();
    }

    private void changeUiToClearUiPause() {
        this.changeUiToClearUi();
        this.pbBottom.setVisibility(0);
    }

    private void changeUiToClearUi() {
        this.setTitleVisibility(4);
        this.llBottomControl.setVisibility(4);
        this.ivStart.setVisibility(4);
        this.pbLoading.setVisibility(4);
        this.setThumbVisibility(4);
        this.ivCover.setVisibility(4);
        this.pbBottom.setVisibility(4);
    }

    private void startProgressTimer() {
        this.cancelProgressTimer();
        mUpdateProgressTimer = new Timer();
        mUpdateProgressTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JCVideoPlayer.this.getContext() != null && JCVideoPlayer.this.getContext() instanceof Activity) {
                    ((Activity)JCVideoPlayer.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            VideoEvents videoEvents = new VideoEvents().setType(366011);
                            EventBus.getDefault().post((Object)videoEvents);
                        }
                    });
                }
            }
        }, 0L, 300L);
    }

    private void cancelProgressTimer() {
        if (this.uuid.equals(JCMediaManager.intance().uuid) && mUpdateProgressTimer != null) {
            mUpdateProgressTimer.cancel();
        }
    }

    private void setTitleVisibility(int visable) {
        if (this.ifShowTitle) {
            this.llTitleContainer.setVisibility(visable);
        } else if (this.ifFullScreen) {
            this.llTitleContainer.setVisibility(visable);
        } else {
            this.llTitleContainer.setVisibility(4);
        }
    }

    private void setThumbVisibility(int visable) {
        if (this.ifMp3) {
            this.ivThumb.setVisibility(0);
        } else {
            this.ivThumb.setVisibility(visable);
        }
    }

    private void updateStartImage() {
        if (this.CURRENT_STATE == 2) {
            this.ivStart.setImageResource(R.drawable.click_video_pause_selector);
        } else {
            this.ivStart.setImageResource(R.drawable.click_video_play_selector);
        }
    }

    private void setProgressBuffered(int secProgress) {
        if (secProgress >= 0) {
            this.skProgress.setSecondaryProgress(secProgress);
            this.pbBottom.setSecondaryProgress(secProgress);
        }
    }

    private void setProgressAndTimeFromTimer() {
        int position = JCMediaManager.intance().mediaPlayer.getCurrentPosition();
        int duration = JCMediaManager.intance().mediaPlayer.getDuration();
        int progress = position * 100 / (duration == 0 ? 1 : duration);
        this.setProgressAndTime(progress, position, duration);
    }

    private void setProgressAndTime(int progress, int currentTime, int totalTime) {
        if (!this.touchingProgressBar) {
            this.skProgress.setProgress(progress);
            this.pbBottom.setProgress(progress);
        }
        this.tvTimeCurrent.setText((CharSequence)Utils.stringForTime(currentTime));
        this.tvTimeTotal.setText((CharSequence)Utils.stringForTime(totalTime));
    }

    public void release() {
        if (System.currentTimeMillis() - clickfullscreentime < 5000L) {
            return;
        }
        this.setState(4);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (fromUser) {
            int time = progress * JCMediaManager.intance().mediaPlayer.getDuration() / 100;
            JCMediaManager.intance().mediaPlayer.seekTo(time);
            this.pbLoading.setVisibility(0);
            this.ivStart.setVisibility(4);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister((Object)this);
        if (this.uuid.equals(JCMediaManager.intance().uuid)) {
            JCMediaManager.intance().mediaPlayer.stop();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void quitFullScreen() {
        JCFullScreenActivity.manualQuit = true;
        clickfullscreentime = System.currentTimeMillis();
        JCMediaManager.intance().mediaPlayer.pause();
        JCMediaManager.intance().mediaPlayer.setDisplay(null);
        JCMediaManager.intance().revertUuid();
        VideoEvents videoEvents = new VideoEvents().setType(366006);
        videoEvents.obj = this.CURRENT_STATE;
        EventBus.getDefault().post((Object)videoEvents);
        this.sendPointEvent(367013);
    }

    private void stopToFullscreenOrQuitFullscreenShowDisplay() {
        if (this.CURRENT_STATE == 1) {
            JCMediaManager.intance().mediaPlayer.start();
            this.CURRENT_STATE = 2;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ((Activity)JCVideoPlayer.this.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            JCMediaManager.intance().mediaPlayer.pause();
                            JCVideoPlayer.this.CURRENT_STATE = 1;
                        }
                    });
                }
            }).start();
            this.surfaceView.requestLayout();
        } else if (this.CURRENT_STATE == 2) {
            JCMediaManager.intance().mediaPlayer.start();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        EventBus.getDefault().post((Object)new VideoEvents().setType(366005));
        if (this.ifFullScreen) {
            JCMediaManager.intance().mediaPlayer.setDisplay(this.surfaceHolder);
            this.stopToFullscreenOrQuitFullscreenShowDisplay();
        }
        if (this.CURRENT_STATE != 4) {
            this.startDismissControlViewTimer();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public static void releaseAllVideos() {
        if (!isClickFullscreen) {
            JCMediaManager.intance().mediaPlayer.stop();
            JCMediaManager.intance().setUuid("");
            JCMediaManager.intance().setUuid("");
            EventBus.getDefault().post((Object)new VideoEvents().setType(366007));
            if (mUpdateProgressTimer != null) {
                mUpdateProgressTimer.cancel();
            }
        }
    }

    @Deprecated
    public void setStartListener(View.OnClickListener onClickListener) {
        if (onClickListener != null) {
            this.ivStart.setOnClickListener(onClickListener);
            this.ivThumb.setOnClickListener(onClickListener);
        } else {
            this.ivStart.setOnClickListener((View.OnClickListener)this);
            this.ivThumb.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void sendPointEvent(int type) {
        VideoEvents videoEvents = new VideoEvents();
        videoEvents.setType(type);
        videoEvents.obj = this.title;
        videoEvents.obj1 = this.url;
        EventBus.getDefault().post((Object)videoEvents);
    }

    public void setSeekbarOnTouchListener(View.OnTouchListener listener) {
        this.mSeekbarOnTouchListener = listener;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touchingProgressBar = true;
                this.cancelDismissControlViewTimer();
                this.cancelProgressTimer();
                break;
            }
            case 1: {
                this.touchingProgressBar = false;
                this.startDismissControlViewTimer();
                this.startProgressTimer();
                this.sendPointEvent(this.ifFullScreen ? 367009 : 367008);
            }
        }
        if (this.mSeekbarOnTouchListener != null) {
            this.mSeekbarOnTouchListener.onTouch(v, event);
        }
        return false;
    }

    public static void setThumbImageViewScalType(ImageView.ScaleType thumbScaleType) {
        speScalType = thumbScaleType;
    }

    public void setSkin(int titleColor, int timeColor, int seekDrawable, int bottomControlBackground, int enlargRecId, int shrinkRecId) {
        this.skin = new Skin(titleColor, timeColor, seekDrawable, bottomControlBackground, enlargRecId, shrinkRecId);
    }

    public static void setGlobleSkin(int titleColor, int timeColor, int seekDrawable, int bottomControlBackground, int enlargRecId, int shrinkRecId) {
        globleSkin = new Skin(titleColor, timeColor, seekDrawable, bottomControlBackground, enlargRecId, shrinkRecId);
    }

    @Deprecated
    public static void toFullscreenActivity(Context context, String url, String title) {
        JCFullScreenActivity.toActivity(context, url, title);
    }

    private void setSkin() {
        if (this.skin != null) {
            this.setSkin(this.skin);
        } else if (globleSkin != null) {
            this.setSkin(globleSkin);
        }
    }

    private void setSkin(Skin skin) {
        ColorStateList timeCsl;
        ColorStateList titleCsl;
        Resources resource = this.getContext().getResources();
        if (skin.titleColor != 0 && (titleCsl = resource.getColorStateList(skin.titleColor)) != null) {
            this.tvTitle.setTextColor(titleCsl);
        }
        if (skin.timeColor != 0 && (timeCsl = resource.getColorStateList(skin.timeColor)) != null) {
            this.tvTimeCurrent.setTextColor(timeCsl);
            this.tvTimeTotal.setTextColor(timeCsl);
        }
        if (skin.seekDrawable != 0) {
            Drawable bg = resource.getDrawable(skin.seekDrawable);
            Rect bounds = this.skProgress.getProgressDrawable().getBounds();
            this.skProgress.setProgressDrawable(bg);
            this.skProgress.getProgressDrawable().setBounds(bounds);
            this.pbBottom.setProgressDrawable(resource.getDrawable(skin.seekDrawable));
        }
        if (skin.bottomControlBackground != 0) {
            this.llBottomControl.setBackgroundColor(resource.getColor(skin.bottomControlBackground));
        }
        this.enlargRecId = skin.enlargRecId;
        this.shrinkRecId = skin.shrinkRecId;
    }

    static {
        isFromFullScreenBackHere = false;
        isClickFullscreen = false;
        speScalType = null;
    }
}

