/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.jboss.weld.util.reflection.GenericArrayTypeImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

public class TypeResolver {
    private final Map<TypeVariable<?>, Type> resolvedTypeVariables;

    public TypeResolver(Map<TypeVariable<?>, Type> resolvedTypeVariables) {
        this.resolvedTypeVariables = resolvedTypeVariables;
    }

    public Type resolveType(TypeVariable<?> variable) {
        Type resolvedType = this.resolvedTypeVariables.get(variable);
        if (resolvedType == null) {
            return variable;
        }
        return resolvedType;
    }

    public Type resolveType(ParameterizedType type2) {
        Type[] unresolvedTypeArguments = type2.getActualTypeArguments();
        boolean modified = false;
        Type[] resolvedTypeArguments = new Type[unresolvedTypeArguments.length];
        for (int i = 0; i < unresolvedTypeArguments.length; ++i) {
            Type resolvedType = unresolvedTypeArguments[i];
            if (resolvedType instanceof TypeVariable) {
                resolvedType = this.resolveType((TypeVariable)resolvedType);
            }
            if (resolvedType instanceof ParameterizedType) {
                resolvedType = this.resolveType((ParameterizedType)resolvedType);
            }
            resolvedTypeArguments[i] = resolvedType;
            if (unresolvedTypeArguments[i] == resolvedType) continue;
            modified = true;
        }
        if (modified) {
            return new ParameterizedTypeImpl(type2.getRawType(), resolvedTypeArguments, type2.getOwnerType());
        }
        return type2;
    }

    public Type resolveType(GenericArrayType type2) {
        Type genericComponentType;
        Type resolvedType = genericComponentType = type2.getGenericComponentType();
        if (genericComponentType instanceof TypeVariable) {
            resolvedType = this.resolveType((TypeVariable)genericComponentType);
        }
        if (genericComponentType instanceof ParameterizedType) {
            resolvedType = this.resolveType((ParameterizedType)genericComponentType);
        }
        if (genericComponentType instanceof GenericArrayType) {
            resolvedType = this.resolveType((GenericArrayType)genericComponentType);
        }
        if (resolvedType instanceof Class) {
            Class componentClass = (Class)resolvedType;
            return Array.newInstance(componentClass, 0).getClass();
        }
        if (resolvedType == genericComponentType) {
            return type2;
        }
        return new GenericArrayTypeImpl(resolvedType);
    }

    public Type resolveType(Type type2) {
        if (type2 instanceof ParameterizedType) {
            return this.resolveType((ParameterizedType)type2);
        }
        if (type2 instanceof TypeVariable) {
            return this.resolveType((TypeVariable)type2);
        }
        if (type2 instanceof GenericArrayType) {
            return this.resolveType((GenericArrayType)type2);
        }
        return type2;
    }

    public Map<TypeVariable<?>, Type> getResolvedTypeVariables() {
        return this.resolvedTypeVariables;
    }
}

