/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.weld.probe.IOUtils;
import org.jboss.weld.probe.JsonDataProvider;
import org.jboss.weld.probe.Queries;

enum Resource {
    DEPLOYMENT("/deployment", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.append(resp, jsonDataProvider.receiveDeployment());
        }
    }),
    BEANS("/beans", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.append(resp, jsonDataProvider.receiveBeans(this.getPage(req), this.getPageSize(req), req.getParameter("filters"), req.getParameter("representation")));
        }
    }),
    BEAN("/beans/{.+}", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.appendFound(resp, jsonDataProvider.receiveBean(resourcePathParts[1], Boolean.valueOf(req.getParameter("transientDependencies")), Boolean.valueOf(req.getParameter("transientDependents"))));
        }
    }),
    BEAN_INSTANCE("/beans/{.+}/instance", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.appendFound(resp, jsonDataProvider.receiveBeanInstance(resourcePathParts[1]));
        }
    }),
    OBSERVERS("/observers", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.append(resp, jsonDataProvider.receiveObservers(this.getPage(req), this.getPageSize(req), req.getParameter("filters")));
        }
    }),
    OBSERVER("/observers/{.+}", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.appendFound(resp, jsonDataProvider.receiveObserver(resourcePathParts[1]));
        }
    }),
    CONTEXTS("/contexts", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.append(resp, jsonDataProvider.receiveContexts());
        }
    }),
    CONTEXT("/contexts/{[a-zA-Z_0]+}", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.appendFound(resp, jsonDataProvider.receiveContext(resourcePathParts[1]));
        }
    }),
    INVOCATIONS("/invocations", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.append(resp, jsonDataProvider.receiveInvocations(this.getPage(req), this.getPageSize(req), req.getParameter("filters")));
        }

        @Override
        protected void delete(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.append(resp, jsonDataProvider.clearInvocations());
        }
    }),
    INVOCATION("/invocations/{.+}", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.appendFound(resp, jsonDataProvider.receiveInvocation(resourcePathParts[1]));
        }
    }),
    EVENTS("/events", new Handler(){

        @Override
        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.append(resp, jsonDataProvider.receiveEvents(this.getPage(req), this.getPageSize(req), req.getParameter("filters")));
        }

        @Override
        protected void delete(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.append(resp, jsonDataProvider.clearEvents());
        }
    }),
    CLIENT_RESOURCE("/client/{[a-zA-Z_0-9-]+\\.\\w+}", new Handler(){

        @Override
        protected void handle(HttpMethod method, JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            if (!HttpMethod.GET.equals((Object)method)) {
                resp.sendError(405);
                return;
            }
            String resourceName = "/META-INF/client/" + (resourcePathParts.length == 0 ? "probe.html" : resourcePathParts[resourcePathParts.length - 1]);
            String contentType = Resource.detectContentType(resourceName);
            12.setHeaders(resp, contentType);
            if (Resource.isCachableContentType(contentType)) {
                resp.setHeader("Cache-Control", "max-age=86400");
            }
            if (Resource.isTextBasedContenType(contentType)) {
                String content = IOUtils.getResourceAsString(resourceName);
                if (content == null) {
                    resp.sendError(404);
                    return;
                }
                content = content.replace("${contextPath}", req.getServletContext().getContextPath() + "/weld-probe" + "/");
                resp.getWriter().append(content);
            } else if (!IOUtils.writeResource(resourceName, resp.getOutputStream())) {
                resp.sendError(404);
            }
        }
    });

    private final String[] parts;
    private final Handler handler;

    private Resource(String path, Handler handler) {
        this.parts = Resource.splitPath(path);
        this.handler = handler;
    }

    protected void handle(HttpMethod method, JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handler.handle(method, jsonDataProvider, resourcePathParts, req, resp);
    }

    boolean matches(String[] resourcePathParts) {
        if (resourcePathParts.length != this.parts.length) {
            return false;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            if (!(Resource.isParam(this.parts[i]) ? !resourcePathParts[i].matches(this.parts[i].substring(1, this.parts[i].length() - 1)) : !this.parts[i].equals(resourcePathParts[i]))) continue;
            return false;
        }
        return true;
    }

    String[] getParts() {
        return this.parts;
    }

    static boolean isParam(String part) {
        return part.startsWith("{") && part.endsWith("}");
    }

    static String[] splitPath(String path) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder builder = null;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (builder == null) continue;
                parts.add(builder.toString());
                builder = null;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(c);
        }
        if (builder != null) {
            parts.add(builder.toString());
        }
        return parts.toArray(new String[parts.size()]);
    }

    static String detectContentType(String resourceName) {
        if (resourceName.endsWith("html")) {
            return "text/html";
        }
        if (resourceName.endsWith("css")) {
            return "text/css";
        }
        if (resourceName.endsWith("js")) {
            return "text/javascript";
        }
        if (resourceName.endsWith("png")) {
            return "image/png";
        }
        if (resourceName.endsWith("ttf") || resourceName.endsWith("otf")) {
            return "application/font-sfnt";
        }
        if (resourceName.endsWith("eot")) {
            return "application/vnd.ms-fontobject";
        }
        if (resourceName.endsWith("woff")) {
            return "application/font-woff";
        }
        if (resourceName.endsWith("svg")) {
            return "image/svg+xml";
        }
        if (resourceName.endsWith("ico")) {
            return " image/x-icon";
        }
        return "text/plain";
    }

    static boolean isCachableContentType(String contentType) {
        return "text/css".equals(contentType) || "text/javascript".equals(contentType) || " image/x-icon".equals(contentType) || "image/png".equals(contentType) || "image/svg+xml".equals(contentType);
    }

    static boolean isTextBasedContenType(String contentType) {
        return !"image/png".equals(contentType) && !" image/x-icon".equals(contentType) && !"application/font-sfnt".equals(contentType) && !"application/font-woff".equals(contentType) && !"application/vnd.ms-fontobject".equals(contentType);
    }

    static enum Representation {
        SIMPLE,
        BASIC,
        FULL;


        static Representation from(String value) {
            for (Representation representation : Representation.values()) {
                if (!representation.toString().equalsIgnoreCase(value)) continue;
                return representation;
            }
            return null;
        }
    }

    static enum HttpMethod {
        GET,
        POST,
        DELETE,
        OPTIONS;


        static HttpMethod from(String method) {
            for (HttpMethod httpMethod : HttpMethod.values()) {
                if (!httpMethod.toString().equalsIgnoreCase(method)) continue;
                return httpMethod;
            }
            return null;
        }
    }

    static abstract class Handler {
        Handler() {
        }

        protected void handle(HttpMethod method, JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Handler.setHeaders(resp, this.getContentType());
            switch (method) {
                case GET: {
                    this.get(jsonDataProvider, resourcePathParts, req, resp);
                    break;
                }
                case POST: {
                    this.post(jsonDataProvider, resourcePathParts, req, resp);
                    break;
                }
                case DELETE: {
                    this.delete(jsonDataProvider, resourcePathParts, req, resp);
                    break;
                }
                case OPTIONS: {
                    this.options(jsonDataProvider, resourcePathParts, req, resp);
                    break;
                }
                default: {
                    resp.sendError(405);
                }
            }
        }

        protected void get(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.sendError(405);
        }

        protected void post(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.sendError(405);
        }

        protected void delete(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.sendError(405);
        }

        protected void options(JsonDataProvider jsonDataProvider, String[] resourcePathParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Handler.setCorsHeaders(resp);
        }

        protected void append(HttpServletResponse resp, String content) throws IOException {
            resp.getWriter().append(content);
        }

        protected void appendFound(HttpServletResponse resp, String content) throws IOException {
            if (content != null) {
                resp.getWriter().append(content);
            } else {
                resp.sendError(404);
            }
        }

        protected int getPage(HttpServletRequest req) {
            String pageParam = req.getParameter("page");
            if (pageParam == null) {
                return 1;
            }
            try {
                return Integer.valueOf(pageParam);
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }

        protected int getPageSize(HttpServletRequest req) {
            String pageSizeParam = req.getParameter("pageSize");
            if (pageSizeParam == null) {
                return 50;
            }
            try {
                int result = Integer.valueOf(pageSizeParam);
                return result > 0 ? result : 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        protected <E, T extends Queries.Filters<E>> T initFilters(HttpServletRequest req, T filters) {
            return Queries.initFilters(req.getParameter("filters"), filters);
        }

        protected String getContentType() {
            return "application/json";
        }

        static void setHeaders(HttpServletResponse resp, String contentType) {
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType(contentType);
            Handler.setCorsHeaders(resp);
        }

        static void setCorsHeaders(HttpServletResponse resp) {
            resp.setHeader("Access-Control-Allow-Origin", "*");
            resp.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE");
        }
    }
}

