/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import javax.transaction.Synchronization;
import org.jboss.weld.event.Status;

public class TransactionSynchronizedRunnable
implements Synchronization {
    private final Status desiredStatus;
    private final Runnable task;
    private final boolean before;

    public TransactionSynchronizedRunnable(Runnable task, boolean before) {
        this(task, Status.ALL, before);
    }

    public TransactionSynchronizedRunnable(Runnable task, Status desiredStatus) {
        this(task, desiredStatus, false);
    }

    private TransactionSynchronizedRunnable(Runnable task, Status desiredStatus, boolean before) {
        this.task = task;
        this.desiredStatus = desiredStatus;
        this.before = before;
    }

    @Override
    public void afterCompletion(int status) {
        if (!this.before && (this.desiredStatus == Status.SUCCESS && status == 3 || this.desiredStatus == Status.FAILURE && status != 3 || this.desiredStatus == Status.ALL)) {
            this.task.run();
        }
    }

    @Override
    public void beforeCompletion() {
        if (this.before) {
            this.task.run();
        }
    }
}

