/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.core.StandardContext;
import org.glassfish.web.ha.authenticator.HASessionData;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;
import org.glassfish.web.ha.session.management.HAStoreBase;

public class HASingleSignOnEntry
extends SingleSignOnEntry {
    private static final Logger logger = HAStoreBase._logger;
    protected long maxIdleTime;
    protected JavaEEIOUtils ioUtils;
    protected HASingleSignOnEntryMetadata metadata = null;

    public HASingleSignOnEntry() {
        this(null, null, null, null, null, 0L, 0L, 0L, null);
    }

    public HASingleSignOnEntry(Container container, HASingleSignOnEntryMetadata m, JavaEEIOUtils ioUtils) {
        this(m.getId(), null, m.getAuthType(), m.getUserName(), m.getRealmName(), m.getLastAccessTime(), m.getMaxIdleTime(), m.getVersion(), ioUtils);
        this.principal = this.parsePrincipal(m);
        this.metadata.principalBytes = m.getPrincipalBytes() == null ? null : (byte[])m.getPrincipalBytes().clone();
        for (HASessionData data : m.getHASessionDataSet()) {
            StandardContext context = (StandardContext)container.findChild(data.getContextPath());
            Session session = null;
            try {
                session = context.getManager().findSession(data.getSessionId());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot find the session: " + data.getSessionId(), ex);
            }
            if (session == null) continue;
            this.sessions.put(data.getSessionId(), session);
        }
        logger.log(Level.FINER, "Loaded HA SSO entry from metadata. Principal: {}", this.principal);
    }

    public HASingleSignOnEntry(String id, Principal principal, String authType, String username, String realmName, long lastAccessTime, long maxIdleTime, long version, JavaEEIOUtils ioUtils) {
        super(id, version, principal, authType, username, realmName);
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
        this.ioUtils = ioUtils;
        this.metadata = new HASingleSignOnEntryMetadata(id, version, this.convertToByteArray(principal), authType, username, realmName, lastAccessTime, maxIdleTime);
        logger.log(Level.FINER, "Created HA SSO entry. Principal: {}", this.principal);
    }

    public HASingleSignOnEntryMetadata getMetadata() {
        return this.metadata;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        boolean result = super.addSession(sso, session);
        if (result) {
            this.metadata.addHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
        }
        return result;
    }

    @Override
    public synchronized void removeSession(Session session) {
        super.removeSession(session);
        this.metadata.removeHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        super.setLastAccessTime(lastAccessTime);
        this.metadata.setLastAccessTime(lastAccessTime);
    }

    @Override
    public long incrementAndGetVersion() {
        long ver = super.incrementAndGetVersion();
        this.metadata.setVersion(ver);
        return ver;
    }

    private byte[] convertToByteArray(Principal obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new BufferedOutputStream(baos);
            oos = this.ioUtils.createObjectOutputStream(bos, true);
            oos.writeObject(obj);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not convert principal to byte array", ex);
        }
        finally {
            this.closeSilently(baos);
            this.closeSilently(bos);
            this.closeSilently(oos);
        }
    }

    private Principal parsePrincipal(HASingleSignOnEntryMetadata m) {
        ByteArrayInputStream bais = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(m.getPrincipalBytes());
            bis = new BufferedInputStream(bais);
            ois = this.ioUtils.createObjectInputStream(bis, true, this.getClass().getClassLoader());
            Principal principal = (Principal)ois.readObject();
            this.closeSilently(bais);
            this.closeSilently(bis);
            this.closeSilently(ois);
            return principal;
        }
        catch (Exception ex) {
            try {
                throw new IllegalStateException("Could not parse principal from HA-SSO Metadata", ex);
            }
            catch (Throwable throwable) {
                this.closeSilently(bais);
                this.closeSilently(bis);
                this.closeSilently(ois);
                throw throwable;
            }
        }
    }

    private void closeSilently(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

