/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EmbeddedWebEntityResolver
implements EntityResolver,
PostConstruct {
    @Inject
    ServerContext serverContext;
    private File dtdDir;
    public static final Map<String, String> knownDTDs = new HashMap<String, String>();

    @Override
    public void postConstruct() {
        if (this.serverContext != null) {
            File root = this.serverContext.getInstallRoot();
            File libRoot = new File(root, "lib");
            this.dtdDir = new File(libRoot, "dtds");
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource resolvedEntity = this.__resolveEntity(publicId, systemId);
        if (resolvedEntity == null) {
            InputStream stream;
            String fileName = knownDTDs.get(publicId);
            URL url = this.getClass().getResource("/dtds/" + fileName);
            InputStream inputStream = stream = url != null ? url.openStream() : null;
            if (stream != null) {
                resolvedEntity = new InputSource(stream);
                resolvedEntity.setSystemId(url.toString());
            }
        }
        return resolvedEntity;
    }

    public InputSource __resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        File dtd;
        String fileName = knownDTDs.get(publicId);
        if (fileName != null && this.dtdDir != null && (dtd = new File(this.dtdDir, fileName)).exists()) {
            return new InputSource(dtd.toURI().toString());
        }
        return null;
    }

    static {
        knownDTDs.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "web-jsptaglibrary_1_1.dtd");
        knownDTDs.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "web-jsptaglibrary_1_2.dtd");
        knownDTDs.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
        knownDTDs.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
    }
}

