/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.util;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;

@Service
public class BindableResourcesHelper {
    @Inject
    ServiceLocator habitat;
    @Inject
    private ServerEnvironment environment;
    private static final String DOMAIN = "domain";
    @LogMessagesResourceBundle
    public static final String LOGMESSAGE_RESOURCE = "org.glassfish.resourcebase.resources.LogMessages";
    @LoggerInfo(subsystem="RESOURCE", description="Nucleus Resource", publish=true)
    public static final String LOGGER = "javax.enterprise.resources.util";
    private final Logger _logger = Logger.getLogger("javax.enterprise.resources.util", "org.glassfish.resourcebase.resources.LogMessages");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BindableResourcesHelper.class);
    private Server server;

    public boolean resourceExists(String jndiName, String target) {
        boolean exists = false;
        Domain domain = this.habitat.getService(Domain.class, new Annotation[0]);
        if (target.equals(DOMAIN)) {
            exists = true;
        } else if (this.habitat.getService(ConfigBeansUtilities.class, new Annotation[0]).getServerNamed(target) != null) {
            Server server = this.habitat.getService(ConfigBeansUtilities.class, new Annotation[0]).getServerNamed(target);
            exists = server.isResourceRefExists(jndiName);
        } else if (domain.getClusterNamed(target) != null) {
            Cluster cluster = domain.getClusterNamed(target);
            exists = cluster.isResourceRefExists(jndiName);
        } else {
            for (Config config : domain.getConfigs().getConfig()) {
                if (!config.getName().equals(target)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public ResourceStatus validateBindableResourceForDuplicates(Resources resources, String jndiName, boolean validateResourceRef, String target, Class<? extends BindableResource> resourceTypeToValidate) {
        BindableResource duplicateResource = ResourceUtil.getBindableResourceByName(resources, jndiName);
        if (duplicateResource != null) {
            String msg = validateResourceRef && this.getResourceByClass(duplicateResource).equals(resourceTypeToValidate) ? (target.equals(DOMAIN) ? localStrings.getLocalString("duplicate.resource.found", "A {0} by name {1} already exists.", this.getResourceTypeName(duplicateResource), jndiName) : (this.habitat.getService(org.glassfish.resourcebase.resources.admin.cli.ResourceUtil.class, new Annotation[0]).getTargetsReferringResourceRef(jndiName).contains(target) ? localStrings.getLocalString("duplicate.resource.found.in.target", "A {0} by name {1} already exists with resource-ref in target {2}.", this.getResourceTypeName(duplicateResource), jndiName, target) : localStrings.getLocalString("duplicate.resource.need.to.create.resource.ref", "A {0} named {1} already exists. If you are trying to create the existing resourceconfiguration in target {2}, please use 'create-resource-ref' command (or create resource-ref using admin console).", this.getResourceTypeName(duplicateResource), jndiName, target))) : localStrings.getLocalString("duplicate.resource.found", "A {0} by name {1} already exists.", this.getResourceTypeName(duplicateResource), jndiName);
            return new ResourceStatus(1, msg, true);
        }
        return new ResourceStatus(0, "Validation Successful");
    }

    public Class getResourceByClass(BindableResource resource) {
        Class<?>[] interfaces;
        Class<BindableResource> type2 = BindableResource.class;
        if (Proxy.isProxyClass(resource.getClass()) && (interfaces = resource.getClass().getInterfaces()) != null) {
            for (Class<?> clz : interfaces) {
                if (!BindableResource.class.isAssignableFrom(clz)) continue;
                return clz;
            }
        }
        return type2;
    }

    public String getResourceTypeName(BindableResource resource) {
        String type2 = "Resource";
        Class resourceType = this.getResourceByClass(resource);
        if (resourceType != null) {
            type2 = resourceType.getSimpleName();
        }
        return type2;
    }

    public boolean isBindableResourceEnabled(BindableResource br) {
        boolean resourceRefEnabled = false;
        ResourceRef ref = this.getServer().getResourceRef(br.getJndiName());
        if (ref != null) {
            resourceRefEnabled = Boolean.valueOf(ref.getEnabled());
        } else if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
        }
        boolean resourceEnabled = Boolean.valueOf(br.getEnabled());
        return resourceEnabled && resourceRefEnabled;
    }

    private Server getServer() {
        if (this.server == null) {
            this.server = this.habitat.getService(Domain.class, new Annotation[0]).getServerNamed(this.environment.getInstanceName());
        }
        return this.server;
    }
}

