/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import java.util.Iterator;
import java.util.Set;
import org.glassfish.pfl.basic.func.UnaryFunction;
import org.glassfish.pfl.objectweb.asm.ClassAdapter;
import org.glassfish.pfl.objectweb.asm.ClassReader;
import org.glassfish.pfl.objectweb.asm.ClassVisitor;
import org.glassfish.pfl.objectweb.asm.tree.ClassNode;
import org.glassfish.pfl.tf.spi.EnhancedClassData;
import org.glassfish.pfl.tf.spi.EnhancedClassDataASMImpl;
import org.glassfish.pfl.tf.spi.TimingPointType;
import org.glassfish.pfl.tf.spi.TraceEnhancementException;
import org.glassfish.pfl.tf.spi.Util;
import org.glassfish.pfl.tf.timer.spi.TimerFactoryBuilder;
import org.glassfish.pfl.tf.timer.spi.TimingInfoProcessor;
import org.glassfish.pfl.tf.tools.enhancer.ClassEnhancer;
import org.glassfish.pfl.tf.tools.enhancer.ClassTracer;
import org.glassfish.pfl.tf.tools.enhancer.EnhanceTool;

public class Transformer
implements UnaryFunction<byte[], byte[]> {
    private final Util util;
    private final EnhanceTool.ProcessingMode mode;
    private final TimingInfoProcessor tip;
    private final Set<String> annotationNames;
    private EnhancedClassData ecd = null;

    Transformer(Util util2, EnhanceTool.ProcessingMode mode, TimingInfoProcessor tip, Set<String> anames) {
        this.util = util2;
        this.mode = mode;
        this.tip = tip;
        this.annotationNames = anames;
    }

    private boolean hasAccess(int access, int flag) {
        return (access & flag) == flag;
    }

    private String getSuffix(String str) {
        String result = str;
        int index = str.lastIndexOf(47);
        if (index >= 0) {
            result = result.substring(index + 1);
        }
        return result;
    }

    private void processTimers() {
        Iterator<String> descriptions = this.ecd.getDescriptions().iterator();
        Iterator<String> names = this.ecd.getTimingPointNames().iterator();
        Iterator<TimingPointType> tpts = this.ecd.getTimingPointTypes().iterator();
        Iterator<String> groups = this.ecd.getMethodMMAnnotationName().iterator();
        Set<String> classAnnoNames = this.ecd.getAnnotationToHolderName().keySet();
        while (descriptions.hasNext()) {
            String desc = descriptions.next();
            String name = names.next();
            TimingPointType tpt = tpts.next();
            String group2 = groups.next();
            if (tpt == TimingPointType.NONE) continue;
            String cname = this.getSuffix(this.ecd.getClassName());
            String timerName = TimerFactoryBuilder.getTimerName(cname, name);
            this.tip.addTimer(timerName, desc);
            if (group2 == null) {
                for (String str : classAnnoNames) {
                    this.tip.containedIn(timerName, this.getSuffix(str));
                }
                continue;
            }
            this.tip.containedIn(timerName, this.getSuffix(group2));
        }
    }

    @Override
    public byte[] evaluate(byte[] arg) {
        ClassNode cn = new ClassNode();
        ClassReader cr = new ClassReader(arg);
        cr.accept(cn, 4);
        if (this.util.hasAccess(cn.access, 8192) || this.util.hasAccess(cn.access, 512)) {
            return null;
        }
        try {
            this.ecd = new EnhancedClassDataASMImpl(this.util, this.annotationNames, cn);
            if (!this.ecd.isTracedClass()) {
                return null;
            }
            this.processTimers();
            byte[] phase1 = null;
            if (this.mode == EnhanceTool.ProcessingMode.UpdateSchemas || this.mode == EnhanceTool.ProcessingMode.TraceEnhance) {
                phase1 = this.util.transform(false, arg, new UnaryFunction<ClassVisitor, ClassAdapter>(){

                    @Override
                    public ClassAdapter evaluate(ClassVisitor arg) {
                        return new ClassEnhancer(Transformer.this.util, Transformer.this.ecd, arg);
                    }
                });
            }
            if (this.mode == EnhanceTool.ProcessingMode.TraceEnhance) {
                byte[] phase2 = this.util.transform(this.util.getDebug(), phase1, new UnaryFunction<ClassVisitor, ClassAdapter>(){

                    @Override
                    public ClassAdapter evaluate(ClassVisitor arg) {
                        return new ClassTracer(Transformer.this.util, Transformer.this.ecd, arg);
                    }
                });
                return phase2;
            }
            return phase1;
        }
        catch (TraceEnhancementException exc) {
            if (this.util.getDebug()) {
                this.util.info(1, "Could not enhance file: " + exc);
            }
            return null;
        }
    }
}

