/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.bootstrap.HK2Populator;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.internal.data.ApplicationClassLoadingPostProcessor;
import org.glassfish.internal.data.ApplicationDescriptorFileFinder;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.config.TransactionFailure;

public class ApplicationInfo
extends ModuleInfo {
    public static final String APP_SERVICE_LOCATOR_PREFIX = "JavaEEApp.";
    private final Collection<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private final LinkedList<ModuleInfo> reversedModules = new LinkedList();
    private final ReadableArchive source;
    private final Map<String, Object> transientAppMetaData = new HashMap<String, Object>();
    private String libraries;
    private boolean isJavaEEApp = false;
    private ClassLoader appClassLoader;
    private boolean isLoaded = false;
    private ServiceLocator appServiceLocator;
    private DeploymentFailedListener deploymentFailedListener;
    private static final String APPLICATION_LOADER_FILES = "META-INF/hk2-locator/application";
    private static final String WEB_LOADER_FILES = "hk2-locator/application";

    public ApplicationInfo(Events events, ReadableArchive source, String name) {
        super(events, name, new LinkedHashSet<EngineRef>(), null);
        this.source = source;
    }

    private void createServiceLocator() {
        String locatorName = APP_SERVICE_LOCATOR_PREFIX + this.name;
        ServiceLocatorFactory slf = ServiceLocatorFactory.getInstance();
        if (slf.find(locatorName) != null) {
            slf.destroy(locatorName);
        }
        this.appServiceLocator = slf.create(locatorName);
        this.deploymentFailedListener = new DeploymentFailedListener(this.source);
        this.events.register(this.deploymentFailedListener);
    }

    private void disposeServiceLocator() {
        if (this.deploymentFailedListener != null) {
            this.events.unregister(this.deploymentFailedListener);
            this.deploymentFailedListener = null;
        }
        if (this.appServiceLocator != null) {
            ServiceLocatorFactory.getInstance().destroy(this.appServiceLocator);
            this.appServiceLocator = null;
        }
    }

    public void add(EngineRef ref) {
        this.engines.add(ref);
        this.reversedEngines.addFirst(ref);
    }

    public void addTransientAppMetaData(String metaDataKey, Object metaDataValue) {
        if (metaDataValue != null) {
            this.transientAppMetaData.put(metaDataKey, metaDataValue);
        }
    }

    public <T> T getTransientAppMetaData(String key, Class<T> metadataType) {
        Object metaDataValue = this.transientAppMetaData.get(key);
        if (metaDataValue != null) {
            return metadataType.cast(metaDataValue);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLibraries() {
        return this.libraries;
    }

    public void setLibraries(String libraries) {
        this.libraries = libraries;
    }

    public ClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    public void setAppClassLoader(ClassLoader cLoader) {
        this.appClassLoader = cLoader;
    }

    public ServiceLocator getAppServiceLocator() {
        return this.appServiceLocator;
    }

    public boolean isJavaEEApp() {
        return this.isJavaEEApp;
    }

    public void setIsJavaEEApp(List<EngineInfo> engineInfos) {
        for (EngineInfo engineInfo : engineInfos) {
            Sniffer sniffer = engineInfo.getSniffer();
            if (!sniffer.isJavaEE()) continue;
            this.isJavaEEApp = true;
            break;
        }
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public Collection<ModuleInfo> getModuleInfos() {
        return this.modules;
    }

    @Override
    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineRef ref : this.engines) {
            sniffers.add(ref.getContainerInfo().getSniffer());
        }
        for (ModuleInfo module : this.modules) {
            sniffers.addAll(module.getSniffers());
        }
        return sniffers;
    }

    public <T extends Container> Collection<EngineRef> getEngineRefsForContainer(Class<T> type2) {
        LinkedHashSet<EngineRef> refs = new LinkedHashSet<EngineRef>();
        for (ModuleInfo info : this.modules) {
            EngineRef ref = null;
            try {
                ref = info.getEngineRefForContainer(type2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs;
    }

    protected ExtendedDeploymentContext getSubContext(ModuleInfo info, ExtendedDeploymentContext context) {
        return context;
    }

    @Override
    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        Logger logger2 = context.getLogger();
        if (this.isLoaded) {
            logger2.fine("Application is already loaded.");
            return;
        }
        context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
        DeploymentTracing tracing = context.getModuleMetaData(DeploymentTracing.class);
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.LOAD);
        }
        super.load(context, tracker);
        this.appClassLoader = context.getClassLoader();
        for (ModuleInfo module : this.modules) {
            if (tracing != null) {
                tracing.addModuleMark(DeploymentTracing.ModuleMark.LOAD, module.getName());
            }
            module.load(this.getSubContext(module, context), tracker);
            if (tracing == null) continue;
            tracing.addModuleMark(DeploymentTracing.ModuleMark.LOADED, module.getName());
        }
        this.populateApplicationServiceLocator();
        this.isLoaded = true;
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.LOAD_EVENTS);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.APPLICATION_LOADED, this), false);
        }
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.LOADED);
        }
    }

    public void start(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        DeploymentTracing tracing = context.getModuleMetaData(DeploymentTracing.class);
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.START);
        }
        super.start(context, tracker);
        for (ModuleInfo module : this.getModuleInfos()) {
            if (tracing != null) {
                tracing.addModuleMark(DeploymentTracing.ModuleMark.START, module.getName());
            }
            module.start(this.getSubContext(module, context), tracker);
            if (tracing == null) continue;
            tracing.addModuleMark(DeploymentTracing.ModuleMark.STARTED, module.getName());
        }
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.START_EVENTS);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.APPLICATION_STARTED, this), false);
        }
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.STARTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(ExtendedDeploymentContext context, Logger logger2) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appClassLoader);
            context.setClassLoader(this.appClassLoader);
            super.stop(context, logger2);
            for (ModuleInfo module : this.reversedModules) {
                module.stop(this.getSubContext(module, context), logger2);
            }
            if (this.events != null) {
                this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.APPLICATION_STOPPED, this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload(ExtendedDeploymentContext context) {
        Logger logger2 = context.getLogger();
        if (!this.isLoaded) {
            logger2.fine("Application is already unloaded.");
            return;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appClassLoader);
            context.setClassLoader(this.appClassLoader);
            super.unload(context);
            for (ModuleInfo module : this.reversedModules) {
                module.unload(this.getSubContext(module, context));
            }
            this.isLoaded = false;
            if (this.events != null) {
                this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.APPLICATION_UNLOADED, this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            context.setClassLoader(null);
        }
    }

    @Override
    public boolean suspend(Logger logger2) {
        boolean isSuccess = super.suspend(logger2);
        for (ModuleInfo module : this.reversedModules) {
            if (module.suspend(logger2)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public boolean resume(Logger logger2) {
        boolean isSuccess = super.resume(logger2);
        for (ModuleInfo module : this.modules) {
            if (module.resume(logger2)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public void clean(ExtendedDeploymentContext context) throws Exception {
        super.clean(context);
        for (ModuleInfo info : this.reversedModules) {
            info.clean(this.getSubContext(info, context));
            info = null;
        }
        if (this.appClassLoader != null) {
            try {
                if (this.appServiceLocator != null) {
                    this.appServiceLocator.preDestroy(this.appClassLoader);
                }
            }
            catch (Exception i$) {
                // empty catch block
            }
            try {
                ((PreDestroy)PreDestroy.class.cast(this.appClassLoader)).preDestroy();
            }
            catch (Exception i$) {
                // empty catch block
            }
            this.appClassLoader = null;
        }
        for (ModuleInfo module : this.getModuleInfos()) {
            if (module.getClassLoaders() == null) continue;
            for (ClassLoader cloader : module.getClassLoaders()) {
                try {
                    ((PreDestroy)PreDestroy.class.cast(cloader)).preDestroy();
                }
                catch (Exception exception) {}
            }
            module.cleanClassLoaders();
        }
        this.disposeServiceLocator();
        if (this.events != null) {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.APPLICATION_CLEANED, context), false);
        }
    }

    public void save(Application app) throws TransactionFailure, PropertyVetoException {
        for (EngineRef ref : this.engines) {
            Engine engine = app.createChild(Engine.class);
            app.getEngine().add(engine);
            ref.save(engine);
        }
        for (ModuleInfo module : this.modules) {
            Module modConfig = app.getModule(module.getName());
            if (modConfig == null) {
                modConfig = app.createChild(Module.class);
                modConfig.setName(module.getName());
                app.getModule().add(modConfig);
            }
            module.save(modConfig);
        }
    }

    public void addModule(ModuleInfo info) {
        this.modules.add(info);
        this.reversedModules.addFirst(info);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    private void populateApplicationServiceLocator() throws IOException {
        this.createServiceLocator();
        ServiceLoader<PopulatorPostProcessor> postProcessors = ServiceLoader.load(PopulatorPostProcessor.class, this.appClassLoader);
        LinkedList<PopulatorPostProcessor> allProcessors = new LinkedList<PopulatorPostProcessor>();
        for (PopulatorPostProcessor postProcessor : postProcessors) {
            allProcessors.add(postProcessor);
        }
        allProcessors.addLast(new ApplicationClassLoadingPostProcessor(this.appClassLoader));
        HK2Populator.populate(this.appServiceLocator, new ApplicationDescriptorFileFinder(this.appClassLoader, APPLICATION_LOADER_FILES), allProcessors);
        HashSet<ClassLoader> treatedLoaders = new HashSet<ClassLoader>();
        treatedLoaders.add(this.appClassLoader);
        for (ModuleInfo module : this.modules) {
            ClassLoader moduleClassLoader = module.getModuleClassLoader();
            if (moduleClassLoader == null || treatedLoaders.contains(moduleClassLoader)) continue;
            treatedLoaders.add(moduleClassLoader);
            allProcessors.removeLast();
            allProcessors.addLast(new ApplicationClassLoadingPostProcessor(moduleClassLoader));
            HK2Populator.populate(this.appServiceLocator, new ApplicationDescriptorFileFinder(moduleClassLoader, WEB_LOADER_FILES), allProcessors);
        }
    }

    private class DeploymentFailedListener
    implements EventListener {
        private final ReadableArchive archive;

        private DeploymentFailedListener(ReadableArchive archive) {
            this.archive = archive;
        }

        @Override
        public void event(@RestrictTo(value="Deployment_Failed") EventListener.Event event) {
            if (!event.is(Deployment.DEPLOYMENT_FAILURE)) {
                return;
            }
            DeploymentContext dc = Deployment.DEPLOYMENT_FAILURE.getHook(event);
            if (!this.archive.equals(dc.getSource())) {
                return;
            }
            ApplicationInfo.this.disposeServiceLocator();
        }
    }
}

